{
          
                
              The DoorKit!
              
             
The BBS Door Development Kit By The People - For The People!

              
            
               ͻ ͻ ͻ    ͻ ͻ
                    ˼ ͹ ͼ ͹     ͻ
                   ͼ          ͼ ͼ


  About The MaxModem File Transfer Protocol:
  
  MaxModem is an error correcting file transfer protocol that was originally
  written by myself using the Async-Professional communications library. TDK
  didn't originally have any way to do comport BlockRead/BlockWrite which is
  why it took me until TDK v2.10 to get MaxModem implemented. The procedures
  for comport BlockRead/BlockWrite really aren't applicable to regular doors,
  so they've only been included in this unit.

  MaxModem uses special BIOS hooked timing routines, and a customized delay
  procedure. The DELAY procedure in Pascal's CRT unit isn't accurate and has
  a habit of exiting prematurely on faster CPUs. The MyDelay procedure used
  in this unit calibrates itself to the CPU to overcome this problem. Other
  timing routines are hooked into the system clock counting clock tics which
  also contributes to the timing accuracy from one CPU to another.

  Due to the extremely relaxed timing scheme used in MaxModem, it works very
  well over telnet connections. Zmodem does work over a telnet connection,
  but not very well, especially with the Windows TCP/IP stack. I don't know
  for sure why not, but some people say it has something to do with Windows
  using an unusually small network packet size. Don't ask me, I'm not one of
  those network gurus that sits and analyzes packets, that's just what I've
  been told. All I can say is that MaxModem's timing routines are much more
  relaxed than Zmodem, so it's less succeptible to over-runs and timeouts.

  MaxModem uses 1024 byte data blocks and 32 bit CRC checking. The structure
  of the protocol packets are extremely compact and simple. Every time there
  is a block read from a file, MaxModem sends:

  -The size of the data block read (2 bytes, a WORD, <= 1024)
  -The CRC32 value of the data block (4 bytes, a LONGINT)
  -The actual data block itself (an ARRAY[1..1024] OF BYTE)

  The receiver kicks back an ACK or a NAK so the sender knows if there is an
  error on the receiver's end. If there's a NAK, then we send the packet to
  the remote again and wait for another ACK or NAK. MaxModem will only send
  the packet 8 times before it aborts the file transfer. MaxModem also looks
  for a CAN (CTRL-X, ASCII #24) which indicates the receiver has aborted.

  There isn't any crash recovery in MaxModem, if a file transfer fails, that
  file is always sent from scratch again. The reason for this is because the
  MaxModem protocol is meant to be extremely compact from its packet size to
  the protocol source code itself. Since the protocol was originally written
  to work over extremely lousy telnet connections, all of those spiffy bells
  and whistles found in Zmodem had to be eliminated.

  I doubt that this protocol is going to set any new trends as far as telnet
  goes, and that's not even my intention anyway. About the only reason that
  I even bothered writing this is so I could add some kind of file transfer
  capabilities to TDK which would allow a person to add automatic resource
  update routines to their MAX Graphics doors. You can still call a protocol
  driver like PDrive or DSZ/GSZ to send resources with Zmodem, but with this
  unit, you can now keep all of your file transfer routines internal.

  Besides the protocol itself, you will also find some other routines in the
  unit that may prove useful, such as the windowing & progress bar routines
  used as well as the comport BlockRead/BlockWrite procedures. Go ahead and
  cut/copy/paste things out of here if you have a use for them, just be sure
  you don't modify this unit itself or MAXterm may not work with it.

  NOTE: Be sure you look at SEND.PAS and RECV.PAS for usage examples...}

{$I DEFINES.INC}
UNIT MAXMODEM;

INTERFACE

TYPE File_Queue  = ARRAY[1..800] OF STRING[80]; {File queue storage strings}

VAR
  FileQueue      : ^File_Queue; {Ye old pointer array, the file queue}
  FilesInQueue   : WORD;        {This is the number of files in queue}
  WorkPath       : STRING;      {This is the file download path}
  Cancelled      : BOOLEAN;     {Was the transfer cancelled [Y/N]}

PROCEDURE AddToFileQueue(FName : STRING);
{^ Use this procedure to add files to the upload queue}
PROCEDURE EmptyFileQueue;
{^ This procedure is called automatically after the SendMaxModem procedure
   exits. But, there may be times where you will want to clear the queue
   manually, so make sure you use this. If you don't, you will lose about
   64K of conventional memory because of a pointer not getting disposed.}
PROCEDURE SendMaxModem;
{^ Pretty obvious, this procedure sends the files in the queue.}
PROCEDURE ReceiveMaxModem;
{^ Once again, pretty obvious - this procedure receives files.}

IMPLEMENTATION

USES CRT,TDK_VARS,CRCUNIT,COMM,fastio,strproc,logs,files,emulate,ecomm,misc;

TYPE EventTimer  = RECORD
     StartTics   : LONGINT;
     ExpireTics  : LONGINT;
     END;

TYPE File_Header = RECORD
     FileName    : STRING[12];
     FileSize    : LONGINT;
     FileCrc     : STRING[8];
     END;

CONST
  TicsPerDay     = 1573040;
  ProtoDelay     = 550;
  RetryDelay     = 550;

VAR
  Header         : File_Header;
  AckTimer       : EventTimer;
  Buffer         : ARRAY[1..1024] OF BYTE;
  Sending        : BOOLEAN;
  QueueNumber    : WORD;
  TotalSent      : LONGINT;
  FileErrors     : LONGINT;
  TotalErrors    : LONGINT;

{}
PROCEDURE OutTextXY(X,Y,F,B : BYTE; S : STRING);
BEGIN
  iogotoxy(x,y);
  iotextcolor(f,b,false);
  ioWrite(S);
END;
{}
PROCEDURE InvertedBox(x1,y1,x2,y2 : BYTE);
VAR
  Loop : BYTE;
  Temp : STRING;
BEGIN
  Temp := '' + srepeat('',x2 - x1 - 1);
  OutTextXY(x1,y1,0,1,Temp);
  OutTextXY(x2,y1,9,1,'');
  FOR Loop := y1 + 1 TO y2 - 1 DO BEGIN
    OutTextXY(x1,Loop,0,1,'');
    OutTextXY(x2,Loop,9,1,'');
  END;
  Temp := srepeat('',x2 - x1 - 1) + '';
  OutTextXY(x1,y2,0,1,'');
  OutTextXY(x1 + 1,y2,9,1,Temp);
END;
{}
PROCEDURE WindowShadow(x1,y1,x2,y2 : WORD);
VAR
  X    : WORD;
  Y    : WORD;
  Loop : WORD;
BEGIN
  X := ((y2 * 160) + (x1 * 2)) + 1;
  FOR Loop := x1 TO x2 DO BEGIN
    Mem[SegB800 : X] := 8;
    INC(X,2);
  END;
  Y := ((y1 * 160) + ((x2) * 2)) + 1;
  FOR Loop := y1 TO y2 DO BEGIN
    Mem[SegB800 : Y] := 8;
    INC(Y,160);
  END;
END;
{}
PROCEDURE DrawWindow(x1,y1,x2,y2 : BYTE; Title : STRING);
VAR
  Temp : STRING;
  Loop : BYTE;
BEGIN
  FILLCHAR(Temp,SIZEOF(Temp),#32);
  MOVE(Title[1],Temp[2],LENGTH(Title));
  Temp[0] := CHR(x2 - x1 + 1);
  OutTextXY(x1,y1,15,3,Temp);
  WindowShadow(x1,y1,x2,y2);
  Temp := '' + srepeat('',x2 - x1 - 1);
  OutTextXY(x1,y1 + 1,9,1,Temp);
  OutTextXY(x2,y1 + 1,0,1,'');
  FOR Loop := y1 + 2 TO y2 - 1 DO BEGIN
    OutTextXY(x1,Loop,9,1,'' + srepeat(' ',x2 - x1 - 1));
    OutTextXY(x2,Loop,0,1,'');
  END;
  Temp := srepeat('',x2 - x1 - 1) + '';
  OutTextXY(x1,y2,9,1,'');
  OutTextXY(x1 + 1,y2,0,1,Temp);
END;
{}
PROCEDURE ClearProgress;
BEGIN
  OutTextXY(27,15,1,0,'');
END;
{}
PROCEDURE UpdateStatus(Msg : STRING);
BEGIN
  OutTextXY(31,13,14,1,PadRight(Msg,' ',34));
END;
{}
PROCEDURE WindowStatus(Starting : BOOLEAN);
CONST
  Progress : STRING[30] = '';
VAR
  Work     : WORD;
  Temp     : STRING;
BEGIN
  IF Starting THEN BEGIN
    IF Sending THEN DrawWindow(18,7,65,17,'Sending File(s)')
               ELSE DrawWindow(18,7,65,17,'Receiving File(s)');
    InvertedBox(25,14,58,16);
    ClearProgress;
    OutTextXY(20,9,11,1, 'File Name:                  In Queue:');
    OutTextXY(20,10,11,1,'File Size:                  Queue ##:');
    OutTextXY(20,11,11,1,' File CRC:                  File Err:');
    IF Sending THEN OutTextXY(20,12,11,1,'     Sent:                 Total Err:')
               ELSE OutTextXY(20,12,11,1,'     Rcvd:                 Total Err:');
    OutTextXY(20,13,11,1,'   Status:');
  END ELSE BEGIN
   {Column #1 Data}
    OutTextXY(31,9,15,1,PadRight(upstr(Header.FileName),' ',12));
    OutTextXY(31,10,15,1,PadRight(st(Header.FileSize),' ',9));
    OutTextXY(31,11,15,1,PadRight(Header.FileCRC,' ',8));
    OutTextXY(31,12,15,1,PadRight(st(TotalSent),' ',7));
   {Column #2 Data}
    OutTextXY(58,9,15,1,st(FilesInQueue));
    OutTextXY(58,10,15,1,st(QueueNumber));
    OutTextXY(58,11,15,1,PadRight(st(FileErrors),' ',7));
    OutTextXY(58,12,15,1,PadRight(st(TotalErrors),' ',7));
    IF Header.FileSize > 0 THEN BEGIN
      Work := TRUNC((TotalSent / Header.FileSize) * 30);
      IF (Work > 0) AND (Work < 31) THEN BEGIN
        MOVE(Progress[1],Temp[1],Work);
        Temp[0] := CHR(Work);
        OutTextXY(27,15,9,0,Temp);
      END ELSE ClearProgress;
    END;
  END;
END;
{}
PROCEDURE NewTimer(VAR ET : EventTimer; Tics : LONGINT);
BEGIN
  IF Tics > TicsPerDay THEN Tics := TicsPerDay;
  WITH ET DO BEGIN
    StartTics  := BiosTics^;
    ExpireTics := StartTics + Tics;
  END;
END;
{}
FUNCTION TimerExpired(ET : EventTimer) : BOOLEAN;
VAR
  CurTics : LONGINT;
BEGIN
  TimerExpired := TRUE;
  WITH ET DO BEGIN
    CurTics := BiosTics^;
    IF CurTics > ExpireTics THEN EXIT;
    IF (CurTics < StartTics) AND ((CurTics + TicsPerDay) > ExpireTics) THEN EXIT;
  END;
  TimerExpired := FALSE;
END;
{}
PROCEDURE BlockWritePort(VAR Block; BlockLen : WORD; VAR BytesWritten : WORD);
TYPE CharArray = ARRAY[0..MaxInt] OF CHAR;
VAR
  X : WORD;
BEGIN
  BytesWritten := 0;
  X            := 0;
  IF (BlockLen = 0) OR (Cnocarrier) THEN EXIT;
  NewTimer(AckTimer,ProtoDelay);
  REPEAT
    eputchar(CharArray(Block)[X]);
    INC(X);
  UNTIL (X = BlockLen) OR (TimerExpired(AckTimer));
  BytesWritten := X;
END;
{}
PROCEDURE BlockReadPort(VAR Block; ExpectedLen : WORD; VAR ReceivedLen : WORD);
TYPE CharArray = ARRAY[0..MaxInt] OF CHAR;
VAR
  Finished : BOOLEAN;
  Cnt      : WORD;
  Ch       : CHAR;
BEGIN
  ReceivedLen := 0;
  Cnt         := 0;
  Finished    := FALSE;
  IF (ExpectedLen = 0) OR (cnocarrier) THEN EXIT;
  NewTimer(AckTimer,ProtoDelay);
  REPEAT
    IF NOT echarready THEN mtimeslice ELSE BEGIN
      egetchar(Ch);
      CharArray(Block)[Cnt] := Ch;
      INC(Cnt);
      IF (ExpectedLen <> 0) AND (Cnt >= ExpectedLen) THEN Finished := TRUE;
    END;
  UNTIL (Finished) OR (TimerExpired(AckTimer));
  ReceivedLen := Cnt;
END;
{}
FUNCTION GotAck : BOOLEAN;
VAR
  Ch : CHAR;
BEGIN
  Ch     := #0;
  GotAck := FALSE;
  NewTimer(AckTimer,ProtoDelay);
  REPEAT
    IF echarready THEN egetchar(Ch) ELSE BEGIN
      mtimeslice;
      IF cnocarrier THEN EXIT;
    END;
  UNTIL (Ch IN [#6,#21,#24]) OR (TimerExpired(AckTimer));
  IF Ch = #6 THEN GotAck := TRUE ELSE
  IF Ch = #24 THEN BEGIN
    logwrite('Protocol Aborted Remotely');
    Cancelled := TRUE;
  END;
END;
{}
FUNCTION SendFile(FName : STRING) : BOOLEAN;
VAR
  F         : FILE;
  Ch        : CHAR;
  Crc       : LONGINT;
  Loop      : WORD;
  BytesRead : WORD;
  BytesSent : WORD;
  BlockErr  : BYTE;
LABEL         DoItAgain;
FUNCTION SendFileHeader : BOOLEAN;
BEGIN
  UpdateStatus('Sending File Header');
  SendFileHeader := FALSE;
  BlockWritePort(Header,26,BytesSent);
  IF GotAck THEN SendFileHeader := TRUE;
END;
BEGIN
  SendFile   := FALSE;
  TotalSent  := 0;
  FileErrors := 0;
  IF NOT fexists(FName) THEN EXIT;
  FILLCHAR(Header,26,0);
  WITH Header DO BEGIN
    FileName := GetFileName(FName);
    FileSize := ffilesize(FName);
    FileCrc  := upstr(FileToCRC(FName));
  END;
  IF NOT SendFileHeader THEN EXIT;
  WindowStatus(FALSE);
  UpdateStatus('Sending File Data');
  ASSIGN(F,FName);
  RESET(F,1);
  REPEAT
    FILLCHAR(Buffer,SIZEOF(Buffer),0);
    BLOCKREAD(F,Buffer,SIZEOF(Buffer),BytesRead);
    BlockErr := 0;
    Crc      := $FFFFFFFF;
    FOR Loop := 1 TO BytesRead DO Crc := Crc_32_Tab[BYTE(Crc XOR LONGINT(Buffer[Loop]))] XOR ((Crc SHR 8) AND $00FFFFFF);
   {$IFDEF DebugOn}
    OutTextXY(1,1,14,0,'Block Size: ' + PadRight(st(BytesRead),' ',4));
    OutTextXY(1,2,14,0,' Block CRC: ' + upstr(CrcString(Crc)));
   {$ENDIF}
    DoItAgain :
    IF KEYPRESSED THEN BEGIN
      Ch := READKEY;
      IF Ch = #0 THEN Ch := READKEY;
      IF Ch IN [#24,#27] THEN BEGIN
        UpdateStatus('Protocol Aborted');
        logwrite('Protocol Aborted Locally');
        MyDelay(ProtoDelay);
        eflushinbuffer;
        eflushoutbuffer;
        MyDelay(ProtoDelay);
        FOR Loop := 1 TO 5 DO eputchar(#24);
        CLOSE(F);
        EXIT;
      END;
    END;
    BlockWritePort(BytesRead,2,BytesSent);      {Block Size}
    BlockWritePort(Crc,4,BytesSent);            {Block Crc}
    BlockWritePort(Buffer,BytesRead,BytesSent); {Block Data}
    IF NOT (GotAck) THEN BEGIN
      IF Cancelled THEN BEGIN
        UpdateStatus('Protocol Aborted');
        MyDelay(ProtoDelay);
        CLOSE(F);
        EXIT;
      END;
      UpdateStatus('Receiver Not Responding');
      MyDelay(RetryDelay);
      INC(TotalErrors);
      INC(FileErrors);
      INC(BlockErr);
      IF BlockErr = 8 THEN BEGIN
        UpdateStatus('Aborting - Too Many Errors');
        logwrite('Aborting - Too Many Errors');
        MyDelay(ProtoDelay);
        eflushinbuffer;
        eflushoutbuffer;
        MyDelay(ProtoDelay);
        FOR Loop := 1 TO 5 DO eputchar(#24);
        CLOSE(F);
        EXIT;
      END;
      GOTO DoItAgain;
    END ELSE BEGIN
      UpdateStatus('Sending File Data');
      INC(TotalSent,BytesRead);
    END;
    WindowStatus(FALSE);
  UNTIL EOF(F);
  CLOSE(F);
  UpdateStatus('File Transmit Complete');
  MyDelay(ProtoDelay);
  logwrite('Sent: ' + upstr(Header.FileName) + ' - File Errors: ' + st(FileErrors));
  SendFile := TRUE;
END;
{}
FUNCTION ReceiveFile : BOOLEAN;
VAR
  F         : FILE;
  Ch        : CHAR;
  GotBytes  : LONGINT;
  Crc       : LONGINT;
  Crc2      : LONGINT;
  BytesSent : WORD;
  Expected  : WORD;
  Loop      : WORD;
  BlockErr  : BYTE;
LABEL         Abort;
FUNCTION GetFileHeader : BOOLEAN;
BEGIN
  UpdateStatus('Getting File Header');
  BlockReadPort(Header,26,BytesSent);
  eputchar(#6);
  GetFileHeader := TRUE;
END;
BEGIN
  ReceiveFile := FALSE;
  FileErrors  := 0;
  TotalSent   := 0;
  GotBytes    := 0;
  FILLCHAR(Header,SIZEOF(Header),0);
  IF NOT GetFileHeader THEN EXIT;
  WindowStatus(FALSE);
  UpdateStatus('Receiving File Data');
  ASSIGN(F,WorkPath + Header.FileName);
  REWRITE(F,1);
  REPEAT
    IF KEYPRESSED THEN BEGIN
      Ch := READKEY;
      IF Ch = #0 THEN Ch := READKEY;
      IF Ch IN [#24,#27] THEN BEGIN
        UpdateStatus('Protocol Aborted');
        logwrite('Protocol Aborted Locally');
        MyDelay(ProtoDelay);
        eflushinbuffer;
        eflushoutbuffer;
        MyDelay(ProtoDelay);
        FOR Loop := 1 TO 5 DO eputchar(#24);
        CLOSE(F);
        ERASE(F);
        EXIT;
      END;
    END;
    BlockErr := 0;
    BlockReadPort(Expected,2,BytesSent);      {Block Size}
    BlockReadPort(Crc,4,BytesSent);           {Block Crc}
    BlockReadPort(Buffer,Expected,BytesSent); {Block Data}
   {$IFDEF DebugOn}
    OutTextXY(1,1,14,0,'Block Size: ' + PadRight(st(Expected),' ',4));
    OutTextXY(1,2,14,0,' Block CRC: ' + upstr(CrcString(Crc)));
   {$ENDIF}
    IF Expected = BytesSent THEN BEGIN
      Crc2 := $FFFFFFFF;
      FOR Loop := 1 TO Expected DO Crc2 := Crc_32_Tab[BYTE(Crc2 XOR LONGINT(Buffer[Loop]))] XOR ((Crc2 SHR 8) AND $00FFFFFF);
      IF Crc2 = Crc THEN BEGIN
        UpdateStatus('Receiving File Data');
        eputchar(#6);
        INC(GotBytes,Expected);
        INC(TotalSent,Expected);
        BLOCKWRITE(F,Buffer,Expected);
      END ELSE BEGIN
        UpdateStatus('Block CRC Error Detected');
        eflushinbuffer;
        eputchar(#21);
        MyDelay(RetryDelay);
        INC(TotalErrors);
        INC(FileErrors);
        INC(BlockErr);
        IF BlockErr = 8 THEN BEGIN
          UpdateStatus('Aborting - Too Many Errors');
          MyDelay(ProtoDelay);
          eflushinbuffer;
          eflushoutbuffer;
          MyDelay(ProtoDelay);
          FOR Loop := 1 TO 5 DO eputchar(#24);
          CLOSE(F);
          ERASE(F);
          EXIT;
        END;
      END;
    END ELSE BEGIN
      UpdateStatus('Block Size Error Detected');
      eflushinbuffer;
      eputchar(#21);
      MyDelay(RetryDelay);
      INC(TotalErrors);
      INC(FileErrors);
      INC(BlockErr);
      IF BlockErr = 8 THEN BEGIN
        UpdateStatus('Aborting - Too Many Errors');
        logwrite('Aborting - Too Many Errors');
        MyDelay(ProtoDelay);
        eflushinbuffer;
        eflushoutbuffer;
        MyDelay(ProtoDelay);
        FOR Loop := 1 TO 5 DO eputchar(#24);
        CLOSE(F);
        ERASE(F);
        EXIT;
      END;
    END;
    mtimeslice;
    WindowStatus(FALSE);
  UNTIL (GotBytes >= Header.FileSize);
  CLOSE(F);
  IF upstr(FileToCRC(WorkPath + Header.FileName)) <> Header.FileCrc THEN BEGIN
    UpdateStatus('File CRC Check Failed');
    logwrite('File CRC Check Failed');
    FOR Loop := 1 TO 5 DO eputchar(#24);
    ERASE(F);
    EXIT;
  END;
  UpdateStatus('File Receive Complete');
  MyDelay(ProtoDelay);
  logwrite('Received: ' + upstr(Header.FileName) + ' - File Errors: ' + st(FileErrors));
  ReceiveFile := TRUE;
END;
{}
PROCEDURE AddToFileQueue(FName : STRING);
BEGIN
  IF FileQueue = NIL THEN BEGIN
    FilesInQueue := 0;
    NEW(FileQueue);
    FILLCHAR(FileQueue^,SIZEOF(FileQueue^),0);
  END;
  IF fexists(FName) THEN BEGIN
    INC(FilesInQueue);
    FileQueue^[FilesInQueue] := upstr(FName);
  END;
END;
{}
PROCEDURE EmptyFileQueue;
BEGIN
  IF FileQueue <> NIL THEN BEGIN
    DISPOSE(FileQueue);
    FilesInQueue := 0;
    FileQueue    := NIL;
  END;
END;
{}
PROCEDURE SendMaxModem;
VAR
  Ch        : CHAR;
  BytesSent : WORD;
  Count     : WORD;
BEGIN
  IF (FilesInQueue = 0) OR (FileQueue = NIL) THEN EXIT;
  Sending   := TRUE;
  Cancelled := FALSE;
  emuScreentoansi(3);
  {HideCursor;}
  WindowStatus(TRUE);
 {NOTE: MAXterm looks for a 'rm<CR>' to auto start the MaxModem download,
        MAXterm kicks back a few <CR>s when it's ready to receive files...}
  eputchar(#1); eputchar('r'); eputchar('m'); eputchar(#13);
  NewTimer(AckTimer,ProtoDelay);
  REPEAT mtimeslice UNTIL (echarready) OR (TimerExpired(AckTimer));
  IF echarready THEN WHILE echarready DO BEGIN
    MyDelay(10);
    egetchar(Ch);
  END ELSE BEGIN
    UpdateStatus('Receiver Not Responding');
    logwrite('Receiver Not Responding');
    MyDelay(ProtoDelay);
    eflushinbuffer;
    eflushoutbuffer;
    MyDelay(ProtoDelay);
    FOR Count := 1 TO 5 DO eputchar(#24);
    emuansitoscreen(3);

    EXIT;
  END;
  UpdateStatus('Initializing Protocol');
  BlockWritePort(FilesInQueue,2,BytesSent);
  IF NOT GotAck THEN BEGIN
    emuansitoscreen(3);

    EXIT;
  END;
  Count := 1;
  REPEAT
    QueueNumber := Count;
    IF NOT SendFile(FileQueue^[Count]) THEN Count := 800;
    INC(Count);
  UNTIL Count > FilesInQueue;
  EmptyFileQueue;
  FILLCHAR(Header,SIZEOF(Header),0);
  QueueNumber := 0;
  TotalSent   := 0;
  ClearProgress;
  UpdateStatus('All Done');
  WindowStatus(False);
  MyDelay(1000);
  emuansitoscreen(3);
  {ShowCursor;}
  logwrite('Total File Transmit Errors: ' + st(TotalErrors));
  logwrite('File Transmit Complete');
END;
{}
PROCEDURE ReceiveMaxModem;
VAR
  Ch        : CHAR;
  BytesSent : WORD;
  Count     : WORD;
BEGIN
  Sending   := FALSE;
  Cancelled := FALSE;
  emuscreentoansi(4);
{  HideCursor;}
  WindowStatus(TRUE);
 {Send a few carriage returns to the sender as a receiver ready signal}
  eputchar(#13); eputchar(#13); eputchar(#13);
  MyDelay(ProtoDelay);
  UpdateStatus('Initializing Protocol');
  BlockReadPort(FilesInQueue,2,BytesSent);
  eputchar(#6);
  IF (FilesInQueue < 1) OR (FilesInQueue > 800) THEN BEGIN
    emuansitoscreen(4);

    EXIT;
  END;
  Count := 1;
  REPEAT
    QueueNumber := Count;
    IF NOT ReceiveFile THEN Count := 800;
    INC(Count);
  UNTIL Count > FilesInQueue;
  EmptyFileQueue;
  FILLCHAR(Header,SIZEOF(Header),0);
  QueueNumber := 0;
  TotalSent   := 0;
  ClearProgress;
  UpdateStatus('All Done');
  WindowStatus(False);
  MyDelay(1000);
  emuansitoscreen(4);
{  ShowCursor;}
  logwrite('Total File Reception Errors: ' + st(TotalErrors));
  logwrite('File Reception Complete');
END;
{}
BEGIN
  Sending      := TRUE;
  Cancelled    := FALSE;
  FileQueue    := NIL;
  FilesInQueue := 0;
  TotalErrors  := 0;
  FileErrors   := 0;
  WorkPath     := '';
END.
