{$IFDEF OVERLAY} {$O+} {$ENDIF}
unit Users;

interface

uses Global{$IFDEF LINUX}, linux{$ENDIF};

procedure userAdd(var U : tUserRec);
procedure userCheckIndex;
procedure userConfiguration(app : Boolean);
function  userLoad(var U : tUserRec) : Boolean;
procedure userLogonInit;
procedure userPassword;
procedure userPrelogonInit;
{procedure userReset;}
procedure userSave(var U : tUserRec);
function  userSearch(var U : tUserRec; DelToo : Boolean;nick:boolean) : Boolean;
function  userPartialSearch(var U : tUserRec; DelToo : Boolean) : Boolean;
procedure userShowList;

var
  userCfg : array['A'..'Z'] of Char;

implementation

uses
   Output, Input, StrProc, ShowFile, Files, Misc, Logs, DateTime,mudmisc,filesort,news;

procedure userShowList;
var Ans : Boolean; F : file of tUserRec; U : ^tUserRec; N : Word;
begin
   oclrscr;
   owrite('Sorting please wait...');
   odnln(1);
   fsSortusersScores;
   Assign(F,'users.tmp');
   {$I-}
   Reset(F);
   {$I+}
   if ioResult <> 0 then Exit;
   logWrite('Displayed user ranking');
   New(U);
   Ans := (sfGetTextFile(txUserLtop,ftTopLine) <> '') and
          (sfGetTextFile(txUserLmid,ftNormal) <> '') and
          (sfGetTextFile(txUserLbot,ftNormal) <> '');
   PausePos := 1;
{   PauseAbort := False;}
   if Ans then
   begin
      sfShowTextFile(txUserLtop,ftTopLine);
      sfGotoPos(1);
      oUpPause(ansiRows-1);
      sfLoadRepeat(txUserLmid);
   end else
   begin
      oSetCol(colInfo);
      oCWriteLn('|U4 Num   Username                 Location              Calls  Baud    Access');
      oSetCol(colBorder);
      oWriteLn(sRepeat('',79));
      oUpPause(3);
   end;
   N := 0;
   while (not HangUp){ and (not PauseAbort)} and (not Eof(F)) do
   begin
      Read(F,U^);
      Inc(N);
      if u^.Deleted then begin end else
      if u^.username='Joe' then begin end else
      if Ans then
      begin
         sfStr[1]  := St(U^.Number);
         sfStr[2]  := U^.UserName;
{         sfStr[3]  := U^.RealName;}
{         sfStr[4]  := U^.LastCall;
         sfStr[5]  := St(U^.TotalCalls);
         sfStr[6]  := St(U^.SL);
         sfStr[7]  := St(U^.DSL);  }
{         sfStr[4]  := U^.Usernote;}
         sfStr[9]  := U^.Location;
{         sfStr[10] := mBaudString(U^.Baudrate);}
{         sfStr[11] := (U^.Sex);}
if u^.sex then sfstr[6] := 'Male' else sfstr[6] := 'Female';
         sfstr[10] := st(u^.xp);
{         sfStr[12] := mAreaCode(U^.PhoneNum);}
         sfShowRepeat(ftUserList);
         if oWhereX <> 1 then oDnLn(1);
         oUpPause(1);
      end else
      begin
         oCWriteLn('|U1'+
                   ' '+Resize(St(N),5)+
                   ' '+Resize(U^.Username,24)+
                   ' '+Resize((U^.Location),21));
         oUpPause(1);
      end;
   end;
   sfKillRepeat;
   Close(F);
   if Ans then
   begin
      sfShowTextFile(txUserLbot,ftNormal);
      oUpPause(ansiRows);
   end else
   begin
      oSetCol(colBorder);
      oWriteLn(sRepeat('',79));
      oUpPause(1);
   end;
   PausePos := 0;
   Dispose(U);
end;

procedure userSave(var U : tUserRec);
var F : file; Fi : file; Idx : tUserIndexRec;
begin
   if U.Number < 1 then Exit;
   Assign(F,Cfg^.pathData+fileUsers);
   {$I-}
   Reset(F,SizeOf(tUserRec));
   {$I+}
   if ioResult <> 0 then userAdd(U) else
   begin
      FillChar(Idx,SizeOf(Idx),0);
      Idx.Username := U.Username;
      Idx.Realname := U.Realname;
      Idx.Deleted  := U.deleted;
      Seek(F,U.Number-1);
      BlockWrite(F,U,1);
      Close(F);
      Assign(F,cfg^.pathdata+'user2.dat');
      reset(f,sizeof(tuserrec2));
      seek(f,U.number-1);
      blockwrite(F,user2^,1);
      close(f);
      Assign(Fi,Cfg^.pathData+fileUserIndex);
      {$I-}
      Reset(Fi,SizeOf(tUserIndexRec));
      {$I+}
      if ioResult = 0 then
      begin
         Seek(Fi,U.Number-1);
         BlockWrite(Fi,Idx,1);
         Close(Fi);
      end;
   end;
end;

function userLoad(var U : tUserRec) : Boolean;
var {$IFDEF LINUX} f:longint; {$ELSE} F : file;{$ENDIF}
begin
   userLoad := False;
   if U.Number < 1 then Exit;
{$IFDEF LINUX}
   {f := fdopen (fileusers, open_rdonly);}
{   if f <> 0 then Exit;}
   fdSeek(file_user_1,(u.Number-1) * sizeof (tuserrec), seek_set);
   userload := fdRead(File_user_1,user^,sizeof (tuserrec)) = sizeof (tuserrec);
{   fdClose(F);
   f := fdopen ('user2.dat', open_rdonly);
   if f <> 0 then Exit;}
   fdSeek(File_user_2,(u.Number-1) * sizeof (tuserrec2), seek_set);
   userload := fdRead(File_user_2,user2^,sizeof (tuserrec2)) = sizeof (tuserrec2);
{   fdClose(F);}
{$ELSE}
{   Assign(F,Cfg^.pathData+fileUsers);}
(*   {$I-}*)
{   Reset(F,SizeOf(tUserRec));}
(*   {$I+}*)
{   if ioResult <> 0 then Exit;
   numUsers := FileSize(F);}
   Seek(File_user_1,U.Number-1);
   {$I-}
   Read(File_user_1,User^);
   {$I+}
   userLoad := ioResult = 0;
{   Close(F);}

{   Assign(F,cfg^.pathdata+'user2.dat');}
(*   {$I-}*)
{   Reset(F,SizeOf(tUserRec2));}
(*   {$I+}*)
{   if ioResult <> 0 then Exit;}
   Seek(File_user_2,U.Number-1);
   {$I-}
   Read(File_user_2,User2^);
   {$I+}
   userLoad := ioResult = 0;
{   Close(F);}
{$ENDIF}
end;

procedure userAdd(var U : tUserRec);
var F : file of tUserRec; Fi : file of tUserIndexRec;
    N : Word; T : tUserRec; Done : Boolean; Idx : tUserIndexRec;
    f4: file of tuserrec2; t2:tuserrec2;
    n2:word;
begin
   Assign(F,Cfg^.pathData+fileUsers);
   {$I-}
   Reset(F);
   {$I+}
   if ioResult <> 0 then
   begin
      U.Number := 1;
      Rewrite(F);
   end else
   begin
      N := 0;
      Done := False;
      while not Done do
      begin
         Read(F,T);
         Inc(N,1);
         Done := (Eof(F)) or (t.Deleted);
      end;
      U.Number := N;
      if not Eof(F) then Seek(F,N-1) else U.Number := N+1;
   end;
   Write(F,U);
   numUsers := FileSize(F);
   Close(F);
   fillchar(user2^,sizeof(user2^),0);
   Assign(F4,Cfg^.pathData+'user2.dat');
   {$I-}
   Reset(F4);
   {$I+}
   if ioResult <> 0 then
   begin
      U.Number := 1;
      Rewrite(F4);
   end else
   begin
      N2 := 0;
      Done := False;
      while not Done do
      begin
         Read(F4,T2);
         Inc(N2,1);
         Done := (Eof(F4)) or (t2.Deleted);
      end;
      User2^.Number := N;
      if not Eof(F4) then Seek(F4,N-1) else User2^.Number := N2+1;
   end;
   Write(F4,User2^);
   Close(F4);

   FillChar(Idx,SizeOf(Idx),0);
   Idx.Username := U.Username;
   Idx.Realname := U.Realname;
   Idx.Deleted  := U.deleted;
   Assign(Fi,Cfg^.pathData+fileUserIndex);
   {$I-}
   Reset(Fi);
   {$I+}
   if ioResult <> 0 then Rewrite(Fi) else Seek(Fi,U.Number-1);
   Write(Fi,Idx);
   Close(Fi);
   if (user^.username <> 'Joe') then
     writenews(user^.username+' name has been heard lately!','global');
end;

function userSearch(var U : tUserRec; DelToo : Boolean; nick:boolean) : Boolean;
var F : file; T : tUserIndexRec; S : String;
    Un, N : Integer;
begin
   userSearch := False;
   Assign(F,Cfg^.pathData+fileUserIndex);
   {$I-}
   Reset(F,SizeOf(tUserIndexRec));
   {$I+}
   if ioResult <> 0 then Exit;
   if nick then
   S := UpStr(U.Username) else s:= upstr(U.realname);
   U.Number := 0;
   N := 0;
   Un := strToInt(S);
   if (Un > numUsers) or (Un < 1) then Un := 0;
   while (not Eof(F)) and (U.Number = 0) do
   begin
      BlockRead(F,T,1);
      Inc(N,1);
      if nick then

begin if ((S = UpStr(T.UserName)) and ((not T.Deleted) or (DelToo)))
                   then U.Number := N; end else
      if ((S = UpStr(T.Realname)) and ((not T.Deleted) or (DelToo)))
         then U.Number := N;

   end;
   numUsers := FileSize(F);
   Close(F);
   if u.number = 0 then usersearch:=false else begin usersearch:=true; user^.number:=u.number; end;

end;

function userPartialSearch(var U : tUserRec; DelToo : Boolean) : Boolean;
var F : file; T : tUserIndexRec; S : String;
    Un, N : Integer;
begin
   userPartialSearch := False;
{   if (UpStr(U.UserName) = 'ALL') or (UpStr(U.RealName) = 'ALL') then exit;}
   Assign(F,Cfg^.pathData+fileUserIndex);
   {$I-}
   Reset(F,SizeOf(tUserIndexRec));
   {$I+}
   if ioResult <> 0 then Exit;
   S := UpStr(U.Username);
   U.Number := 0;
   N := 0;
   Un := strToInt(S);
   if (Un > numUsers) or (Un < 1) then Un := 0;
   while (not Eof(F)) and (U.Number = 0) do
   begin
      BlockRead(F,T,1);
      Inc(N,1);
      if (pos(S,UpStr(T.UserName)) > 0) and ((not T.Deleted) or (DelToo)) then
         begin;
         oStr(strCode(mStr(strDidYouMeanUser),1,T.UserName));
         if iYesNo(true) then U.Number := N;
         end else
      if (pos(S,UpStr(T.RealName)) > 0) and ((not T.Deleted) or (DelToo)) then
         begin;
         oStr(strCode(mStr(strDidYouMeanUser),1,T.RealName));
         if iYesNo(true) then U.Number := N;
         end;
   end;
   numUsers := FileSize(F);
   Close(F);
   userPartialSearch := U.Number <> 0;
end;


procedure userRebuildIndex;
var F : file of tUserIndexRec; uF : file of tUserRec; U : ^tUserRec;
    Idx : tUserIndexRec;
begin
   Assign(F,Cfg^.pathData+fileUserIndex);
   Assign(uF,Cfg^.pathData+fileUsers);
   {$I-}
   Reset(uF);
   {$I+}
   if ioResult <> 0 then Exit;
   numUsers := FileSize(uF);
   {$I-}
   Rewrite(F);
   {$I+}
   if ioResult <> 0 then Exit;

   New(U);
   while not Eof(uF) do
   begin
      Read(uF,U^);
      FillChar(Idx,SizeOf(Idx),0);
      Idx.Username := U^.Username;
      Idx.Realname := U^.Realname;
      Idx.Deleted  := U^.deleted;
      Write(F,Idx);
   end;

   Close(F);
   Close(uF);
   Dispose(U);
end;

procedure userCheckIndex;
{$IFNDEF LINUX}
var F : file of tUserIndexRec; uF : file of tUserRec; uS, iS : LongInt; Ok : Boolean;
{$ENDIF}
begin
{$IFNDEF LINUX}
   Assign(F,Cfg^.pathData+fileUserIndex);
   Assign(uF,Cfg^.pathData+fileUsers);
   {$I-}
   Reset(uF);
   {$I+}
   if ioResult <> 0 then Exit;
   uS := FileSize(uF);
   numUsers := uS;
   Close(uF);
   {$I-}
   Reset(F);
   {$I+}
   if ioResult <> 0 then Ok := False else
   begin
      Ok := True;
      iS := FileSize(F);
      Close(F);
   end;
   if (not Ok) or (iS <> uS) then userRebuildIndex;
{$ENDIF}
end;

procedure userPrelogonInit;
begin
   with User^ do
   begin
      Number := 0;
      UserName := 'Unknown';
      RealName := 'Unknown';
      Location := 'No Where';
      UserNote := 'None';
      Sex := true;
      race:=0;
      subrace:=0;
      AutoSigLns := 0;
      FillChar(AutoSig,SizeOf(AutoSig),0);
      Posts := 0;
      Email := 0;
  hitpoints := 1;
  saveplace := 1;
  str := 0;
  int := 0;
  con := 0;
  dex := 0;
  cha := 0;
  wis := 0;
  com := 0;
  deleted:=false;
      emailwaiting:=0;
      FillChar(Reserved,SizeOf(Reserved),0);
   end;
  end;

procedure userLogonInit;
begin
   if (User^.LastCall <> dtDateString) then
     begin;
     end;
   begin
      User^.LastCall := dtDateString;
      userSave(User^);
   end;
   timeEvent := 0;
   timeExtra := 0;
   timeFree  := 0;
   dtGetDateTime(TimeOn);
   PausePos := 0;
   mandMsg := False;
   emailTag := 0;
   readTag := 0;
   useTag := False;
   fLibraryInstall;
end;

procedure userConfiguration(app : Boolean);
var Ans: boolean; Ch, aCh : Char; aPos, emu, dl, al: Byte; ucDone : Boolean;
    D, A : String; U : tUserRec;
 function ucActualKey : Char;
 var C, K : Char;
 begin
    C := #0;
    for K := 'A' to 'Z' do if userCfg[K] = Ch then C := K;
    ucActualKey := C;
 end;
 procedure ucShow(S : String);
 begin
    if sfGotoPos(aPos) then oCWrite(S);
 end;
begin
   ucDone := False;
   U := User^;
   FillChar(userCfg,SizeOf(userCfg),0);
   if App then Ans := sfShowTextfile(txNewConfig,ftUserConfig) else
               Ans := sfShowTextfile(txUserConfig,ftUserConfig);
   if not Ans then exit;
   if sfGotoPos(4) then  oWrite(U.Location);
   if sfGotoPos(6) then  oCWrite(U.UserNote);
   if sfGotoPos(13) then oWrite(mEmulation(U));
 D := 'n/a';
 {  if tLibOpen then A := textLib^.Author else} A := 'n/a';
   dl := Length(NoColor(d));
   al := Length(NoColor(a));
   if sfGotoPos(14) then oCWrite(D);
   if sfGotoPos(maxPos-2) then oCWrite(A);
   if emuRIP then emu := 3 else
   if emuAvatar then emu := 2 else
                     emu := 1;
   repeat
      sfGotoPos(maxPos-1);
      oWrite(' '#8);
      Ch := UpCase(iReadKey);
      if (HangUp) or (Ch in [#13,#27]) then ucDone := True;
      if (app) and (Ch = #27) then Ch := #13;
      if Ch = #27 then oWrite('Quit') else
      if Ch = #13 then oWrite('Done') else oWriteChar(Ch);
      aCh := ucActualKey;
      aPos := Ord(aCh)-64;
      if (aCh <> #0) and (extKey = #0) then
      begin
         sfGotoPos(aPos);
         oSetCol(colInfoHi);
         case aCh of
           'A' : begin
{                S := iReadString(U.Password,inUpper,chNormal,rsMin,20);
                if Length(S) >= 4 then U.Password := S;
                ucShow(U.Password);}
             end;
           'B' : begin
{                if mStdPhone(U.PhoneNum) then U.PhoneNum := iReadPhone(U.PhoneNum) else
                                              U.PhoneNum := iReadString(U.PhoneNum,inUpper,chNormal,rsMin,13);
                ucShow(U.PhoneNum);}
             end;
           'C' : begin
{                S := iReadDate(U.BirthDate);
                if dtValidDate(S) then U.BirthDate := S;
                ucShow(U.BirthDate);}
             end;
           'D' : begin
{                U.Location := iReadString(st(U.Location),inNormal,chNormal,rsMin,40);
                ucShow(U.Location);}
             end;
           'E' : begin
{                U.Address := iReadString(U.Address,inMixed,chNormal,rsMin,36);
                ucShow(U.Address);}
             end;
           'F' : begin
                U.UserNote := iReadString(U.UserNote,inNormal,chNormal,rsMin,40);
                ucShow(U.UserNote);
             end;
           'G' : begin
{                N := strToInt(iReadString(St(U.PageLength),inUpper,chNumeric,'',3));
                if (N >= 5) and (N <= 500) then U.PageLength := N;
                ucShow(St(U.PageLength));}
             end;
           'H' : begin
{                B := not (acYesNoBar in U.acFlag);
                if B then U.acFlag := U.acFlag+[acYesNoBar] else
                          U.acFlag := U.acFlag-[acYesNoBar];
                ucShow(Resize(B2St(B),3));}
             end;
           'I' : begin
{                B := not (acExpert in U.acFlag);
                if B then U.acFlag := U.acFlag+[acExpert] else
                          U.acFlag := U.acFlag-[acExpert];
                ucShow(Resize(B2St(B),3));}
             end;
           'J' : begin
{                B := not (acHotKey in U.acFlag);
                if B then U.acFlag := U.acFlag+[acHotKey] else
                          U.acFlag := U.acFlag-[acHotKey];
                ucShow(Resize(B2St(B),3));                }
             end;
           'K' : begin
{                B := not (acPause in U.acFlag);
                if B then U.acFlag := U.acFlag+[acPause] else
                          U.acFlag := U.acFlag-[acPause];
                ucShow(Resize(B2St(B),3));}
             end;
           'L' : begin
{                B := not (acQuote in U.acFlag);
                if B then U.acFlag := U.acFlag+[acQuote] else
                          U.acFlag := U.acFlag-[acQuote];
                ucShow(Resize(B2St(B),3));}
             end;
           'M' : begin
(*                inc(emu);
{                if (not cfg^.SupportRIP) and (emu = 3) then emu := 4;
                if (not cfg^.SupportTextFX) and (emu > 3) then emu := 1;}
                if emu > 4 then emu := 1;
                case emu of
                   1 : begin {U.acFlag := U.acFlag+[acAnsi]-[acRIP,acAvatar];   }
                             emuTextFX := false; end;
                   2 : begin {U.acFlag := U.acFlag+[acAnsi,acAvatar]-[acRIP];  }
                             emuTextFX := false; end;
                   3 : begin {U.acFlag := U.acFlag+[acAnsi,acRIP]-[acAvatar]; }
                             emuTextFX := false; end;
                   4 : begin {U.acFlag := U.acFlag+[acAnsi]-[acRIP,acAvatar];}
                             emuTextFX := true; end;
                end;
                ucShow(strResizeNc(mEmulation(U),6));*)
             end;
           'N' : begin end;
           {if (Cfg^.useTextLibs) and (numLib > 0) then begin
                if User^.textLib >= numLib then User^.textLib := 1 else
                   Inc(User^.textLib);
                fLibraryInstall;
                ucShow(strEnlarge(textLib^.Desc,dl));
                dl := Length(NoColor(textLib^.Desc));
                aPos := maxPos-2;
                ucShow(strEnlarge(textLib^.Author,al));
                al := Length(NoColor(textLib^.Author));
             end; }
           'O' : begin
{                U.zipCode := iReadString(U.zipCode,inUpper,chNormal,rsMin,10);
                ucShow(U.zipCode);}
             end;
         end;
      end;
   until ucDone;
   sfGotoPos(maxPos);
   if (not HangUp) and (Ch = #13) then
   begin
{      U.textLib := User^.textLib;}
      User^ := U;
      userSave(User^);
   end else
{   if lib <> User^.textLib then
   begin
      User^.textLib := lib;
      fLibraryInstall;
   end;}
end;

procedure userPassword;
begin
end;

end.
