{
 $Id$
}
{*****************************************************************************
 *
 * Process:  Update history file and check for duplicates
 *
 *****************************************************************************
 * Copyright (C) 1991-2008
 *
 * Vincent Coen / Ron Huiskes / Others        FIDO:   2:250/1
 * Applewood
 * Epping Road
 * Roydon, Essex, CM19 5DA
 * United Kingdom
 *
 * This file is part of FileMgr.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * FileMgr is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with FileMgr; see the file COPYING.  If not, write to the Free
 * Software Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 *****************************************************************************}

Unit Fm_Dup;

Interface

Uses Dos, Crt,
     S_String, F_File, Fm_Struct;


Procedure Add_To_History ( history:historytype );
Function  Is_Dup (filename:string; area:string; grp:byte; crcstr, size:longint;
           checkarea,checkgroup,checkcrc,checksize,fuzzydup:boolean ) : LongInt;

Implementation


Procedure Add_To_History(history:historytype);
Var
  Count : Word;
Begin
  {$i-} Reset(HF,1); {$I+}
  If ioresult <> 0 then writeln('Cannot add file to history database?!') else
    begin
      Seek (HF, FileSize(HF));
      BlockWrite (HF, HISTORY, sizeof(history), count);
      Close(HF);
    end;
End;

Function Is_Dup (filename:string; area:string; grp:byte; crcstr, size:longint;
           checkarea,checkgroup,checkcrc,checksize,fuzzydup:boolean ) : LongInt;
Var Al    : Array[1..50] of HistoryType;
    Found : Boolean;
    Count : Word;
    X     : Word;
    HBak  : HistoryType;
Begin
  Reset(HF,1);

  if length(filename) > 15 then filename := first(15,filename);
  Filename := Upper(filename);
  Found := False;

  Repeat
    BlockRead(Hf,Al,Sizeof(Al),Count);
    If count > 0 then Count := Count div sizeof(historytype);
    For X := 1 to Count do
      If (file_split(3,Upper(Al[x].name)) = file_split(3,Filename)) then
        Begin
          Found := True;
          HBak := Al[x];

          if not fuzzydup then
            begin
              If (file_split(3,Upper(Al[x].name)) <> file_split(3,Filename)) then
                found := false;

              If checkcrc then
                If al[x].crc_32 <> crcstr then found := false;

              If CheckSize then
                If al[x].size <> size then found := false;
            end else
            begin {wel fuzzydup}
              found := true;
            end;

          If CheckGroup then
            If Al[x].group <> grp then found := false;

          If checkarea then
            If al[x].tag <> area then found := false;

        End;
  Until Found or (Count = 0);

  Close(HF);
  If found then
    Begin
      Is_Dup := Hbak.dt;
      history := hbak;
    End Else Is_Dup := 0;
End;



End.

