{
 $Id$
}
 {*****************************************************************************
 *
 *  Purpose: Run scheduler
 *
 *****************************************************************************
 * Copyright (C) 1991-2008
 *
 * Vincent Coen / Ron Huiskes / Others        FIDO:   2:250/1
 * Applewood
 * Epping Road
 * Roydon, Essex, CM19 5DA
 * United Kingdom
 *
 * This file is part of FileMgr.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * FileMgr is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with FileMgr; see the file COPYING.  If not, write to the Free
 * Software Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 *****************************************************************************}


Unit Fm_Sched;   {scheduler}

{$O+}

Interface

Uses
  dos, crosslib, s_string, f_file,
  fm_struct, fm_basic, fm_proc, fm_log, fm_exec, nw_msg, nw_tpl;

Procedure Schedule;

Implementation

type
 ScheduleRec = Record
   Kind         : ScheduleType;                { hatch, report, exec or post }

   MsgBaseId    : Char;           { the msgbase id: hudson, squize, fido etc }
   MsgBaseIdStr : String[80];               { board number + path of msgbase }
   Status       : MsgStatusType;                   { tearline + echo/netmail }
   MaxSize      : Byte;                                { maximum msgtxt size }

   MsgTo,                                                  { message to name }
   MsgFrom      : String[35];                            { message from name }
   MsgAttr      : MsgAttribSet;               { attrib bits: crash, hold etc }
   Aka          : Byte;                              { aka (fromnode) to use }
   ToNode       : NodeType;                     { to node address if netmail }

   Freq         : FrequencyType;                                 { frequency }
   Next         : LongInt;                                      { next event }
   Day          : Byte;                        { sunday = 1, monday = 2, etc }

   Grps         : BooleanSet;
   Mask         : String[60];
   Tag          : String[20];
   Magic        : String[20];
   Line         : Array[1..3] of String[76];

   Inactive     : Boolean;
   NotUsed      : Array[1..9] of Byte;
 End;

var
  Scfile        : File of ScheduleRec;                         { schedule.fm }
  SC            : ScheduleRec;                                 { schedule.fm }


Procedure Schedule;
Var
  ScInx   : Byte;
  Dt      : DateTime;
  Wd      : Word;
  Sr      : Searchrec;
  Tmp     : Text;
  Done    : Boolean;
  Prg,
  Par     : String[127];
  Hatches : Boolean;
  rtmp, LTmp    : String;
  Valcode : Integer;
  dummy, az : Word;
  tel, x  : word;

Procedure Report;
Var
  grpinx,
  z : word;
  Gcnt,
  Acnt  : Byte;
  Ch    : Byte;
  i, x  : integer;
Begin
  Gcnt := 0;
  for GrpInx := 1 to 255 do
    begin
      if sc.grps[grpinx] then
        begin
          { for each specified group }
          Seek (GF,0);
          GROUP.groupnr := 0;
          while (not EOF(GF)) and (GROUP.groupnr <> grpinx) do Read (GF, GROUP);
          if GROUP.groupnr = grpinx then
            begin
              Inc (gCnt);
              ACnt := 0;
              DoStringLn('['+int_to_Str(GROUP.groupnr)+'] '+GROUP.groupName);
              for x := 1 to Areaidx do
                begin
                  { find area(s) }
                  if AFXt^[x].Grp = GROUP.groupnr then
                    begin
                      Inc (aCnt);
                      GetArea(X);
                      DoStringLn('    '+expand(AFXt^[x].TAG,16)+AREA.Name);
                      if AREA.ExportNr > 0 then
                        begin
                          for I := 1 to AREA.ExportNr do
                            begin
                              if big_messagetext(0,setup.maxmsgsize) then
                                Begin
                                  DoStringLn(#13+#13+'[continued in next message]'+#13);
                                  DoStringln(#13+'--- '+msgtearline); {tagline}
                                  DoStringLn(  Orig_Line('Automatically created at '+setup.systemname,sc.aka) +#13);
                                  If not Save_Message then
                                    NotifyCr(2,'Error saving message.') Else
                                  Init_Message (sc.msgbaseid+sc.msgbaseidstr,true,sc.aka,sc.status,
                                    sc.tonode,SETUP.Address[sc.AKA],'FileMgr '+version,sc.msgto,
                                    'Network connection list report');
                                  If open_message then
                                    Begin
                                      Set_Attrib(sc.msgattr,sc.msgbaseid);
                                      DoStringLn(#13+'[continued from previous message]'+#13);
                                    End Else NotifyCr(2,'Error opening message.');
                                End;
                              DoString('      '+Expand(Node2Str(sfxt^[I].A),16));
                              z := 1;
                              While (z <= Nodeidx) and (not NodeEQ(NFXt^[z].Address,
                              sfxt^[I].A)) do Inc(z);
                              if z <= Nodeidx then
                                begin
                                  Seek (NF, NFXt^[z].NodeRec);
                                  blockRead (NF, NODE,sizeof(node));
                                  doStringLn(NODE.SysopName);
                                end else doStringLn('Sysop');
                            end;
                        end;
                    end;
                end;
              if aCnt > 0 then
                DoStringLn(#13'    total of '+int_to_str(Acnt)+' area(s).'#13) else
                  DoStringLn('    group has no areas'#13);
            End;
        End;
    End;
  DoStringLn('A total of '+int_to_str(Gcnt)+' groups.'#13#13);
End;

Begin
  WriteLogCR (6,'SCHEDULE');
  hatches := false;

  Assign (SCfile, SystemPath + 'SCHEDULE.FM');
  {$I-} Reset (SCfile); {$I+}
  If IOresult > 0 then
    Begin
      Writelogcr(2,'Cannot find '+systempath+'SCHEDULE.FM');
      Exit;
    End;

  Scinx := 0;
  While not eof(scfile) do
   Begin
     {$I-} read(scfile,sc); {$I+}
     If ioresult <> 0 then
       Begin
         NotifyCR(1,'Error reading SCHEDULE.FM file');
         Exit;
       End;

     inc(scinx);

     FillChar (DT, SizeOf(DT), 0);
     With DT do GetDate (Year, Month, Day, WD);
     If (sc.Next <= GetUnixDate(DT)) and not sc.inactive then { qualified? }
       Begin
         Done      := False;                                     { qualified! }
         case sc.Kind of
          SC_Exec    : if sc.Line[1] <> '' then
                       begin
                         NotifyCR(7,'Executing '''+sc.line[1]+sc.line[2]+'''');
                         Prg := sc.line[1]+sc.line[2];
                         If pos(' ',Prg) <> 0 then
                           Begin
                             par := last(length(prg)-pos(' ',prg),prg);
                             prg := first( pos(' ',prg)-1 ,prg);
                           End Else
                             par := '';
                         ValCode := fmexec (Prg, Par,setup.swapmethode, $ffff, false, setup.showswapping);
                         if ValCode > 0 then
                           begin
                             case ValCode of
                               $00..$FF : NotifyCR (2,'Commandline returns errorlevel '+int_to_str(ValCode));
                               else NotifyCR       (2,ExecError(ValCode)+' ($'+int_to_str(ValCode)+')');
                             end;
                           end else Done := True;
                       end;
          sc_hatch   : begin
                         notifyCR (7,'AutoHatch in area ' + sc.tag);
                         done := true;
                         az := 1;
                         while (az <= areaidx) and (afxt^[az].tag <> sc.tag) do inc(az);
                         if az <= areaidx then
                           begin
                             getarea(az);

                             ltmp := sc.mask;
                             ltmp := replace('#','?',ltmp);
                             ltmp := replace('@','?',ltmp);

                             findfirst (ltmp, $0, sr);
                             while doserror=0 do
                               begin
                                 if filematch(sr.name, file_split(2,sc.mask)) then
                                   begin
                                     fillchar (info, sizeof(info), 0);
                                     with info do
                                       begin
                                         tag         := sc.tag;
                                         magic       := sc.magic;
                                         filepath    := file_split(1,sc.mask);
                                         status      := [local];
                                         filespec    := sr.name;
                                         from        := setup.address[area.aka];
                                         origin      := from;
                                         size        := sr.size;
                                         date        := sr.time;

                                         if sc.line[2] <> '' then
                                          replaces := sc.line[2];

                                         FillChar (DT, SizeOf(DT), 0);
                                         With DT do GetDate(Year, Month, Day, dummy);
                                         INFO.Release := GetUnixDate(DT);
                                         INFO.Forwar := INFO.Release;

                                         assign(tplfile,'FM_DESC.#$#');
                                         rewrite(tplfile);
                                         writeln(tplfile,sc.line[1]);
                                         close(tplfile);

                                         assign(tplfile,'FM_DESC2.#$#');
                                         rewrite(tplfile);

                                         fillchar(ann,sizeof(ann),0);
                                         with ann do
                                           begin
                                             Name   := sr.name;
                                             Replaces  := info.replaces;
                                             Area  := info.tag;
                                             Desc  := sc.line[1];
                                             LCount := 0;
                                             Magic  := info.magic;
                                             Date := info.date;
                                             Size  := info.size;
                                             Origin := info.origin;
                                             From := info.from;
                                           end;
                                         Convert_Tpl( 'FM_DESC.#$#', ann, true, 0, '');

                                         close(tplfile);
                                         delete_file('FM_DESC.#$#');
                                         reset(tplfile);
                                         while not eof(tplfile) do
                                            begin
                                              readln(tplfile,rtmp);
                                              info.description := info.description + rtmp;
                                              move(rtmp[1],info.longdesc,length(rtmp));
                                              inc(longcount,length(rtmp));
                                            end;
                                         close(tplfile);
                                         erase(tplfile);
                                       end;
                                     hatches := true;

                                     assign (pf, systempath+'PROCESS.FM');
                                     {$i-} reset (pf); {$i-}
                                     if ioresult > 0 then rewrite (pf);
                                     seek (pf, filesize(pf));
                                     write (pf, info);
                                     close (pf);
                                   end;
                                 findnext (sr);
                               end;
                           end else
                           begin
                             notifyCR (7,'');
                             notifyCR (2,'Unknown area ''' + sc.tag + '''');
                             done := false;
                           end;
                       end;
          SC_Report  : begin
                         tel := 0;
                         for x := 1 to 255 do
                           if sc.grps[x] then inc(tel);
                         if tel > 0 {grps} then
                           Begin
                             Notify(7,'Creating report for '+sc.msgto);
                             If net in sc.status then
                               NotifyCR(7,', ('+Node2Str(sc.Tonode)+') ('+AttribStr(sc.msgAttr)+')') else
                                 NotifyCR(7,'');

                             Init_Message (sc.msgbaseid+sc.msgbaseidstr,true,sc.aka,sc.status,
                                           sc.tonode,SETUP.Address[sc.AKA],'FileMgr '+version,sc.msgto,
                                           'Network connection list report');
                             If open_message then
                               Begin
                                 Set_Attrib(sc.msgattr,sc.msgbaseid);

                                 DoStringLn('Hello '+extractwords(1,1,sc.msgto)+','+#13);
                                 DoStringLn('The following is a list of active areas on this system, ');
                                 DoStringLn('with the addresses of the linked systems of each area.'+#13);
                                 Report;
                                 DoStringLn('Regards,'#13'  '+SETUP.SysopName+#13);
                                 DoStringln(#13+'--- '+msgtearline); {tagline}
                                 DoStringLn(  Orig_Line('Automatically created at '+setup.systemname,sc.aka) +#13);
                                 If not Save_Message then
                                   NotifyCr(2,'Error saving message.') Else
                                     Done := True;

                               End Else NotifyCR(2,'Error creating message.');
                           End Else NotifyCR(2,'No groups specified. Report suspended.');
                       End;
          SC_Post    : Begin
                         Notify(7,'Creating msg for '+sc.msgTo);
                         If net in sc.status then
                           NotifyCR(7,', ('+Node2Str(sc.Tonode)+') ('+AttribStr(sc.msgAttr)+')') else
                             NotifyCR(7,'');

                         If ((sc.line[2] <> '') and exist(sc.line[2])) or (sc.line[2] ='') then
                           Begin
                             Init_Message (sc.msgbaseid+sc.msgbaseidstr,true,sc.aka,sc.status,sc.tonode,
                                        SETUP.Address[sc.AKA],sc.msgfrom,sc.msgto,sc.line[1]);
                             If open_message then
                               Begin
                                 Set_Attrib(sc.msgattr,sc.msgbaseid);

                                 If sc.line[2] <> '' then  {msgbody}
                                   Begin
                                     Assign (TMP, sc.line[2]);
                                     {$I-} Reset(TMP); {$I+}
                                     If IOresult = 0 then
                                       Begin
                                         While not eof(TMP) do
                                           Begin
                                             Readln(Tmp,Ltmp);
                                             DoStringLn(LTmp);
                                           End;
                                         Close (TMP);
                                       End Else NotifyCr(2,'Cannot locate msgbody '+sc.line[2]);
                                   End;

                                 DoStringln(#13+'--- '+msgtearline); {tagline}
                                 DoStringLn(  Orig_Line('Automatically created at '+setup.systemname,sc.aka));
                                 If not Save_Message then
                                   NotifyCr(2,'Error saving message.') Else
                                     Done := True;
                               End Else NotifyCR(2,'Error creating message.');
                           End Else Notifycr(2,'Cannot locate msgbody '+sc.line[2]);
                       End;
          End; {case}

          If done then
            Begin
              sc.Next := NextDate (sc.next+(60*60*24), sc.Freq, sc.Day);
            End;

          Seek(scfile,scinx-1);
          Write(scfile,sc);

        End; {qualified}
      End; { eof(scfile) }

  Close(scfile);

  If Hatches then    { if hatches are made, process them }
    Begin
      Assign (PF, SystemPath + 'PROCESS.FM');
      {$I-} Reset (PF); {$I+}
      If IOresult = 0 then
        Begin

          Assign(Pfnew,systempath+'PROCESS.NEW');
          {$I-} reset(pfnew); {$I+}
          If ioresult <> 0 then rewrite(pfnew);
          Seek(pfnew,filesize(pfnew));

          While not EOF(PF) do
            Begin
              Read (PF, INFO);

              If Date_Past (datestring(info.forwar)) then
                ProcessFile Else Write(pfnew,info);
            End;

          Close (PF);
          Erase (Pf);
          Close (Pfnew);
          Rename(pfnew,systempath+'PROCESS.FM');
          If file_size(systempath+'PROCESS.FM') = 0 then delete_file(systempath+'PROCESS.FM');

        End Else NotifyCR (2,'Error opening PROCESS.FM');
        If exist(systempath+'FMSYSTMP.#$') then sendsysopmsg('Areas created');

    End;
End;


End.
