 {
 $Id$
}

 Unit M_Window;

 {*****************************************************************************
 *
 * Purpose ...............: Frontdoor / Novel style menus
 *
 *****************************************************************************
 * Copyright (C) 1991-2008
 *
 * Vincent Coen / Ron Huiskes / Others        FIDO:   2:250/1
 * Applewood
 * Epping Road
 * Roydon, Essex, CM19 5DA
 * United Kingdom
 *
 * This file is part of FileMgr.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * FileMgr is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with FileMgr; see the file COPYING.  If not, write to the Free
 * Software Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 *****************************************************************************}

 {++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  +         - Unit to produce Frontdoor/Novell look-a-like menus -           +
  +                                                                          +
  +    Version 1.8                                                           +
  +    DD. 3 februari 1995                                                   +
  +                                                                          +
  ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

  { new in 1.4: Added users Help Hook, when f1 is pressed in read
                procedures

    new in 1.5: Added arraysta in select_window procedure to point to the
                element to start with.

                Changed Arrayl var in same procedure so that length
                is real length instead of length+1 in previous versions.

    new in 1.6: Select_window now returns a word instead of a byte.

    new in 1.7: Added users Control-Z hook (when control-z is pressed)
                and control-I hook
                Added a read_password procedure, which is identical with
                the read_string procedure, except returning 's on screen...

    new in 1.8: Added f2hook

   }


INTERFACE

Uses  Dos, Crt,
      F_Fast, S_Screen, S_String;

{-----------------------------------------------------------------------------}

Type
  ArrayStr  = String[80]; {array containing selection must be of type ArrayStr}

  Windowrec = Record
     X1 : Byte;                                            {window coordinates}
     X2 : Byte;
     Y1 : Byte;
     Y2 : Byte;
     St : ArrayStr;                                            {name of window}
     C1 : Array[1..80] of byte;          {INTERNAL: background original shadow}
     C2 : Array[1..80] of byte;
     C3 : Array[1..80] of byte;
     Active : Boolean;
  End;

  Class   = ( C_None,
              C_All,
              C_Chars,
              C_Numbers,
              C_Real,
              C_Integer,
              C_Phone,
              C_File,
              C_Date);

  CurMov  = (Ignore,   { Ignore status        }
             ShowOnly, { No editing           }
             Accept,   { Accepted string      }
             Next,     { Goto next field      }
             Stay,     { Stay at this field   }
             Up,       { Up arrow pressed     }
             Down      { Down arrow pressed   } );


  EscapeSet  = Set of Char;

Var
  MWin : Array[0..8] of Windowrec;         {maximum of 8 overlapping windows}
                                                   {Mwin[0] is used internally}
  Cursor : CurMov;       {contains cursor movement (if any) on read procedures}

  Menushow : boolean;                   {internal used var in pullmenu command}

  Insert : Boolean;                                       {state of insert key}

  kl1,kl2,
  kl3,kl4,
  kl5     : byte; {wordt gevuld met kleur nummers ivm kleur/monochrome scherm}


{ --- userhooks: --- }

  ChooseHook : Procedure(Which:Byte);
                             {will be called everytime a new topic is selected}
  WaitHook   : Procedure;
                   {will be called everytime when prg is waiting on keypressed}

  HelpHook   : Procedure;  { will be called when f1 (help?) is pressed }
  F2Hook     : Procedure(Which:Byte);  { will be called when f2 is pressed }
  CtrlZHook  : Procedure;  { will be called when ctrl-z is pressed }
  CtrlIHook  : Procedure;  { will be called when ctrl-i is pressed }

{-----------------------------------------------------------------------------}

{--- available procedures: ---}

Procedure Dummy1(which:byte);
Procedure Dummy2;

Procedure Create_Window( M : Integer );                      {m = windownumber}
Procedure Remove_Window( M : Integer );

Function  Select_Window( M,
                         ArrayCnt,                 {hoeveel elementen in array}
                         ArrayL    : Integer;          {hoelang is elk element}
                         ArrayPtr  : Pointer;                {pointer to array}
                         ArraySta  : Integer;        {start with which element}
                         More      : Boolean) : Word; {'more' arrows in window}

Procedure Read_String ( X, Y,                                 {screen position}
                        Len, MaxLen : Byte;   {screenlength, max string length}
                    VAR Edit        : String;              {the string to edit}
                        Accept      : Class );          {which chars to accept}

Procedure Read_Password ( X, Y,                               {screen position}
                        Len, MaxLen : Byte;   {screenlength, max string length}
                    VAR Edit        : String;              {the string to edit}
                        Accept      : Class );          {which chars to accept}

Procedure Read_Integer( X, Y,                                 {screen position}
                        Len, MaxLen : Byte;   {screenlength, max string length}
                    VAR Edit        : LongInt );          {the integer to edit}

Procedure Read_Yesno( X, Y          : Byte;                   {screen position}
                  VAR Edit          : Boolean;                 {boolean yes/no}
                      Len           : Byte );                   { screenlength}

Function Pull_Menu( ArrayPtr:Pointer;                   {pointer to menu array}
                    ArrayCnt:Integer;              {hoeveel elementen in array}
                    Starting:Integer               {start at which arraynumber}
                              ) : Integer;      {returns selected array number}

Function AskWindow(Str1,Str2,Str3:String; Chars:Escapeset) : Char;

{-----------------------------------------------------------------------------}

IMPLEMENTATION

Type
   MemHandle = Record
                 Offs,Seg : Word;
              End;

   StringPtr   = ^ArrayStr;

Const
   C_NumbersChars    = '0123456789';
   C_CharsChars      = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
   C_OthersChars     = '!"$%^&*()_+=-][{]#~@'':;?/>.<,|\ ';
   C_PhoneChars      = '-,()'+C_NumbersChars;
   C_NoneChars       = '';
   C_AllChars        = C_CharsChars+C_NumbersChars+C_OthersChars;
   C_FileChars       = C_CharsChars+C_NumbersChars+'!"$%^&*()_+=-~@/.:\?#';
   C_RealChars       = C_NumbersChars+'+-E.';
   C_IntegerChars    = C_NumbersChars+'+-';
   C_DateChars       = C_NumbersChars+'-/.';

{$F+}
Procedure Dummy1(which:byte);
Begin
End;

Procedure Dummy2;
Begin
End;
{$F-}


Function AskWindow(Str1,Str2,Str3:String; Chars:Escapeset) : Char;
Var
  Len : Byte;
  Ch  : Char;
Begin
  Len := Length(Str1);
  If Length(Str2) > Len then Len := Length(Str2);
  If Length(Str3) > Len then Len := Length(Str3);
  If Odd(len) then
    Len := (Len+1) Div 2 Else
      Len := Len Div 2;
  If Len < 12 then Len := 12;

  Shadow := True;
  Mkwin(40-len,10,40+len+1,14,0,7,1);

  WriteAt(41-(length(str1) div 2),11,0,7,Str1);
  WriteAt(41-(length(str2) div 2),12,0,7,Str2);
  WriteAt(41-(length(str3) div 2),13,0,7,Str3);

  Repeat
    Ch := Readkey;
  Until Ch in Chars;

  RmWin;
  Shadow := False;
  AskWindow := Ch;
End;

Procedure Create_Window ( M : integer );
{--------------------------------------}
Var
  Ch   : Char;
  X,Y  : Integer;
  Mbak : Integer;
Begin
  If m > 6 then
    begin
      write(#7,'Maximum windows reached');
      halt;
    end;
  If (M > 1) or ((m = 1) and mwin[0].active) then  {vorige window van rand veranderen}
    Begin
      For x := mwin[m-1].x1+1 to mwin[m-1].y1-1 do Writeat(x,mwin[m-1].x2,kl3,0,'');
      For x := mwin[m-1].x1+1 to mwin[m-1].y1-1 do
       begin
         ch := getscreenchar(x,mwin[m-1].y2);
         Writeat(x,mwin[m-1].y2,kl3,0,ch);
       end;
      For x := mwin[m-1].x2+1 to mwin[m-1].y2-1 do Writeat(mwin[m-1].x1,x,kl3,0,'');
      For x := mwin[m-1].x2+1 to mwin[m-1].y2-1 do Writeat(mwin[m-1].y1,x,kl3,0,'');
      Writeat(mwin[m-1].x1,mwin[m-1].x2,kl3,0,'');
      Writeat(mwin[m-1].y1,mwin[m-1].x2,kl3,0,'');
      Writeat(mwin[m-1].x1,mwin[m-1].y2,kl3,0,'');
      Writeat(mwin[m-1].y1,mwin[m-1].y2,kl3,0,'');
    End;

  for x := 1 to 80 do
    begin
      mwin[m].c1[x] := 0;
      mwin[m].c2[x] := 0;
      mwin[m].c3[x] := 0;
    end;

  if not mwin[m].active then
    begin
      mwin[m].active := true;
      MkWin(mwin[m].x1, mwin[m].x2, mwin[m].y1, mwin[m].y2, 11,0,4);
    end;

  Writeat(mwin[m].y1-length(mwin[m].st),mwin[m].x2,14,1,mwin[m].st);

  If mwin[m].y1 < 80 then
    Begin
      For X := mwin[m].x2+1 to mwin[m].y2 do
        Begin
          Ch := getscreenchar(mwin[m].y1+1,x);
          mwin[M].C1[x] := getscreenattr(mwin[m].y1+1,x);
          Writeat(mwin[m].y1+1,x,8,0,ch);
          If mwin[m].y1 < 79 then
            Begin
              Ch := getscreenchar(mwin[m].y1+2,x);
              mwin[M].C2[x] := getscreenattr(mwin[m].y1+2,x);
              Writeat(mwin[m].y1+2,x,8,0,ch);
            End;
        End;
    End;

  If mwin[m].y2 < 25 then
    Begin
      Y := mwin[m].y1+2;
      If Y > 80 then Y := 80;
      For X := mwin[m].x1+2 to y do
        Begin
          Ch := GetScreenChar(x,mwin[m].y2+1);
          mwin[M].C3[x] := getscreenattr(x,mwin[m].y2+1);
          Writeat(x,mwin[m].y2+1,8,0,ch);
        End;
    End;
End;


Procedure Remove_Window ( M : Integer );
{--------------------------------------}
Var
  X,Y : Integer;
  Ch  : char;
Begin;
  RmWin;
  mwin[m].active := false;

  If mwin[m].y1 < 80 then
    Begin
      For X := mwin[m].x2+1 to mwin[m].y2 do
        Begin
          Ch := getscreenchar(mwin[m].y1+1,x);
          Writeat(mwin[m].y1+1,x, (mwin[m].c1[x] and $0f) , ((mwin[m].c1[x] and $70) shr 4) , ch);
          If mwin[m].y1 < 79 then
            Begin
              Ch := getscreenchar(mwin[m].y1+2,x);
              Writeat(mwin[m].y1+2,x, (mwin[m].c2[x] and $0f) , ((mwin[m].c2[x] and $70) shr 4) , ch);
            End;
        End;
    End;

  If mwin[m].y2 < 25 then
    Begin
      y := mwin[m].y1+2;
      if y > 80 then y := 80;
      For X := mwin[m].x1+2 to y do
        Begin
          Ch := GetScreenChar(x,mwin[m].y2+1);
          Writeat(x,mwin[m].y2+1, (mwin[m].c3[x] and $0f) , ((mwin[m].c3[x] and $70) shr 4) , ch);
        End;
    End;

  {vorige window van rand veranderen}
  If (M > 1) or ((m = 1) and mwin[0].active) then
    Begin
      For x := mwin[m-1].x1+1 to mwin[m-1].y1-1 do
        Begin
          Ch := Getscreenchar(x,mwin[m-1].x2);
          If Ch = '' then Writeat(x,mwin[m-1].x2,11,0,'');
        End;
      For x := mwin[m-1].x1+1 to mwin[m-1].y1-1 do
        Begin
          Ch := Getscreenchar(x,mwin[m-1].y2);
          Writeat(x,mwin[m-1].y2,11,0,ch);
        End;
      For x := mwin[m-1].x2+1 to mwin[m-1].y2-1 do Writeat(mwin[m-1].x1,x,11,0,'');
      For x := mwin[m-1].x2+1 to mwin[m-1].y2-1 do Writeat(mwin[m-1].y1,x,11,0,'');
      Writeat(mwin[m-1].y1-length(mwin[m-1].st),mwin[m-1].x2,14,1,mwin[m-1].st);
      Writeat(mwin[m-1].x1,mwin[m-1].x2,11,0,'');
      Writeat(mwin[m-1].y1,mwin[m-1].x2,11,0,'');
      Writeat(mwin[m-1].x1,mwin[m-1].y2,11,0,'');
      Writeat(mwin[m-1].y1,mwin[m-1].y2,11,0,'');
    End;
End;



Function Select_Window(M,ArrayCnt,Arrayl:Integer;Arrayptr:Pointer;ArraySta:Integer;More:Boolean):Word;
{----------------------------------------------------------------------------------------------------}
Var
  Hfd   : Integer;
  Tel   : Integer;
  Sel   : Integer;
  Ch    : Char;
  Start : Pointer;
  Temp  : String;

  Function GetElement(X:Integer):String;
  Var
    Y    : Integer;
    Tmp  : String;
    Stop : Boolean;
  Begin
    Tmp := '';  Y := 0;  Stop := False;
    ArrayPtr := Start;
    Repeat
      Inc(Y);
      If Y = X then
       Begin
         Tmp := StringPtr(ArrayPtr)^;
         Stop := True;
      End;
      Inc(MemHandle(ArrayPtr).Offs,Arrayl+1);
    Until (Y = ArrayCnt) or Stop;
    GetElement := Tmp;
  End;


  Procedure WriteThem( Fir, Sel : Integer);
  Var
    X, Y : Integer;
    Tmp  : String;
    Len  : Byte;
  Begin
    Len := mwin[m].y1 - mwin[m].x1;
    Y := Mwin[M].Y2- 1 - Mwin[M].X2;
    For X := 1 to Y do
     Begin
       Tmp := Expand(GetElement(Fir+X-1),Arrayl);
       If X = Sel then
         Writeat(Mwin[M].X1+1,Mwin[M].X2+X,kl4,kl5,' '+first(len-3,Tmp)+' ') Else
            Writeat(Mwin[M].X1+1,Mwin[M].X2+X,7,0,' '+first(len-3,Tmp)+' ');
     End;
  End;


Begin
  If not mwin[m].active then Create_Window(M);
  Sel := ArraySta;
  If Sel > Mwin[m].y2-1-mwin[m].x2 then
   Begin
     Hfd := Sel-(Mwin[m].y2-1-mwin[m].x2)+1;
     Sel := (Sel-Hfd)+1;
   End Else Hfd := 1;

  Ch := #0;
  Start := ArrayPtr;

  While not (Ch in [#27,#13]) do
   Begin
     WriteThem(Hfd,Sel);
     Choosehook(Hfd+Sel-1);

     If More then
       Begin
         Temp := ' ';
         If Hfd > 1 then Temp := Temp + Chr(24) Else Temp := Temp + ' ';
         If Hfd+Mwin[m].Y2-1-Mwin[M].X2-1 < ArrayCnt then
           Temp := Temp + Chr(25) Else Temp := Temp + ' ';
         Temp := Temp + ' More ';
         Writeat(Mwin[M].Y1-12,Mwin[M].Y2,11,0,Temp);
       End;

     While not keypressed do WaitHook;

     Ch := Readkey;
     Case Ch of
       #9  : ctrlihook;
       #26 : ctrlzhook;

       #0 : Begin
              Ch := Readkey;
              Case Ch of
               #59 : helphook;
               #60 : f2hook(sel);
               #72 : {up}   Dec(Sel);
               #80 : {down} Inc(Sel);
               #73 : {pgup} Begin
                              If Sel > 1 then Sel := 1 Else Dec(Hfd,mwin[m].y2-1-mwin[m].x2);
                              If Hfd < 1 then Hfd := 1;
                            End;
               #81 : {pgdn} Begin
                              If Sel < Mwin[m].y2-1-mwin[m].x2 then
                                Sel := Mwin[m].y2-1-mwin[m].x2
                                  Else Inc(Hfd,Mwin[m].y2-1-mwin[m].x2);
                              If Hfd+mwin[m].y2-1-mwin[m].x2-1 > ArrayCnt then Hfd := ArrayCnt-Sel+1;
                            End;
               #71 : {home} Begin Sel := 1; Hfd := 1; End;
               #79 : {end}  Begin Sel := Mwin[m].y2-1-mwin[m].x2; Hfd := ArrayCnt-Sel+1; End;
              End;
            End;
     End;

    If Sel > (Mwin[m].y2-1-mwin[m].x2) then
     If Hfd+(Mwin[m].y2-1-mwin[m].x2-1) < ArrayCnt then
       Begin Inc(Hfd); Dec(sel); End Else
         Dec(Sel,(Mwin[m].y2-1-mwin[m].x2));

    If Sel < 1 then
     If Hfd > 1 then
       Begin Sel := 1; Dec(Hfd); End Else
         Sel := (Mwin[m].y2-1-mwin[m].x2);

    If Sel > ArrayCnt then Sel := ArrayCnt;
   End;

  If Ch = #27 then
    Begin
      Choosehook(0);
      Select_Window := 0;
    End Else
      Select_Window := Hfd+Sel-1;
End;



Function ReadKeyboard(Var Key : Char):Boolean;
Var
 Stop : Boolean;
Begin
  ReadKeyBoard:=True;
  Stop:=False;
  Repeat
    WaitHook;
    If KeyPressed Then
      Begin
        Key:=ReadKey;
        If Key=#00 Then
          Key:=ReadKey Else
           ReadKeyBoard:=False;
        Stop:=True;
      End;
  Until Stop;
End;


Procedure ReadLine(     X,Y        : Byte;    { ScreenPosition          }
                        Len,MaxLen : Byte;    { Screenlen, max length   }
                    Var Edit       : String;  { The line to edit        }
                        Accept     : Class;   { Which chars to accept   }
                    Var Curs       : CurMov;  { Cursor Movement         }
                    Var Insert     : Boolean; { Ins. status             }
                        Color      : Byte;    { Edit color              }
                        Password   : Boolean  { If invisible / password }
                  );

Type
   EditRec = Record
               Len  : Byte;
               Line : Array[1..255] Of Char;
              End;

Var Erec          : EditRec;
    WinStart      : Byte;
    CurrPos       : Byte;
    Key           : Char;
    Stop          : Boolean;
    Win           : String[80];
    AcceptChars   : String;
    z, C          : Byte;
    start         : boolean;

Procedure Disp(ERec : EditRec);
Var
  OldAttr : Byte;
  P       : Byte;
Begin
  Cursor_Off;
  GotoXy(X,Y);
  Move(Erec.Line[WinStart],Win[1],Len);
  Win[0]:=Chr(Len);
  OldAttr:=TextAttr;
  TextAttr:=Color;
  For P := 1 to Len do
    If Win[p] <> #176 then
      Begin
        If password then write('') else Write(Win[p])
      End Else
      Begin
        Textcolor(0);
        Write(Win[p]);
        TextAttr := Color;
      End;
  TextAttr:=OldAttr;
  GotoXy(X+CurrPos-WinStart,Y);
  If Insert Then Cursor_Half Else Cursor_On;
End;

Procedure MoveRight;
Begin
  start := false;
  If CurrPos=(Erec.Len+1) Then Exit;
  If CurrPos=(WinStart+Len-1) Then
    Begin
      Inc(WinStart);
      Inc(CurrPos);
    End Else Inc(CurrPos);
End;

Procedure MoveLeft;
Begin
  start := false;
  If CurrPos=1 Then Exit;
  If (CurrPos=WinStart) Then
    Begin
      Dec(WinStart);
      Dec(CurrPos);
    End Else Dec(CurrPos);
End;


Begin
  FillChar(Erec,SizeOf(ERec),#176);
  winstart := 1;
  Move(Edit,ERec,Length(Edit)+1);
  currpos := 1;
  Stop:=False;
  start := true;

Case Accept Of
 C_None    : AcceptChars := C_NoneChars;
 C_All     : Begin
             AcceptChars := C_AllChars;
             For C:=127 to 255 Do
               AcceptChars:=AcceptChars+Chr(C);
             For C:= 1 to 31 Do
                     AcceptChars:=AcceptChars+Chr(C);
             End;
 C_Chars   : AcceptChars := C_CharsChars;
 C_Numbers : AcceptChars := C_NumbersChars;
 C_Real    : AcceptChars := C_RealChars;
 C_Integer : AcceptChars := C_IntegerChars;
 C_Phone   : AcceptChars := C_PhoneChars;
 C_File    : AcceptChars := C_FileChars;
 C_Date    : AcceptChars := C_DateChars;
End; {Case}

If Insert
   Then Cursor_Half
   Else Cursor_On;

Repeat
  Disp(ERec);
  Case ReadKeyBoard(Key) Of
  True  : Begin
          Case Key Of
           #59    : HelpHook; {f1}
           #60    : f2hook(0); {f2}
           #61    : Begin    {f3}
                    FillChar(Erec,SizeOf(Erec),#176);
                    Move(Edit,Erec,Length(Edit)+1);
                    CurrPos:=1;
                    WinStart:=1;
                    End;
           #82    : Begin    {ins key}
                    start := false;
                    If Curs<>ShowOnly
                       Then Begin
                            Insert:=Not Insert;
                            If Insert
                               Then Cursor_Half
                               Else Cursor_On;
                            End;
                    End;
           #83    : Begin    {del key}
                    start := false;
                    If (Curs<>ShowOnly) And
                       (Erec.Len>0)     And
                       (CurrPos<=Erec.Len)
                       Then Begin
                            Move( Erec.Line[CurrPos+1],
                                  Erec.Line[CurrPos],
                                  Erec.Len-CurrPos+1);
                            Erec.Line[Erec.Len]:=#176;
                            Dec(Erec.Len);
                            End;
                    End;
           #75    : If Curs<>ShowOnly
                       Then MoveLeft;
           #77    : If Curs<>ShowOnly
                       Then MoveRight;
           #72{up}: Begin
                    start := false;
                    If Curs<>Ignore Then
                      Begin
                        Move(ERec,Edit,ERec.Len+1);
                        Curs:=Up;
                        Stop:=True;
                      End;
                    End;
           #80    : Begin
                    start := false;
                    If Curs<>Ignore
                       Then Begin
                            Move(ERec,Edit,ERec.Len+1);
                            Curs:=Down;
                            Stop:=True;
                            End;
                    End;
           #79    : Begin   {endkey}
                    start := false;
                    If Curs<>ShowOnly
                       Then Begin
                            If Erec.Len<MaxLen
                               Then CurrPos:=ERec.Len+1
                               Else CurrPos:=ERec.Len;
                            If CurrPos>Len
                               Then WinStart:=CurrPos-Len+1;
                            End;
                    End;
           #117   : Begin {ctrl-end}
                      start := false;
                      for z := currpos to 255 do
                        erec.line[z] := #176;
                      erec.len := currpos-1;
                    End;
           #71    : Begin  {homek}
                    start := false;
                    If Curs<>ShowOnly
                       Then Begin
                            WinStart:=1;
                            CurrPos:=1;
                            End;
                    End;
          End; {Case}
          End; {True}

  False : Begin
          Case Key Of
           #8     : Begin
                    If (Curs<>ShowOnly) And
                       (Erec.Len>0) And (CurrPos>1)
                       Then Begin
                            If (CurrPos<=Erec.Len)
                               Then Move( Erec.Line[CurrPos],
                                          Erec.Line[CurrPos-1],
                                          Erec.Len-CurrPos+1);
                            Erec.Line[Erec.Len]:=#176;
                            Dec(Erec.Len);
                            Dec(CurrPos);
                            if currpos < winstart then
                              begin
                                dec(winstart);
                                moveright;
                              end;
                            End;
                    End;
           #9     : CtrlIhook;
           #13    : Begin   {cr}
                    Move(ERec,Edit,ERec.Len+1);
                    If Curs<>Ignore
                       Then Curs:=Next;
                    Stop:=True;
                    End;
           #25    : Begin {ctrl-y}
                      start := false;
                      FillChar(Erec,SizeOf(ERec),#176);
                      erec.len := 0;
                      currpos := 1;
                    End;
           #26    : CtrlZHook;
           #27    : Begin  {esc}
                    If Curs<>Ignore
                       Then Curs:=Stay;
                    Stop:=True;
                    End;
           #10    : {} ; {control-enter}
           Else     Begin
                    If Pos(UpCase(Key),AcceptChars)>0
                       Then Begin
                            If start then
                              begin
                                start := false;
                                FillChar(Erec,SizeOf(ERec),#176);
                                erec.len := 0;
                              end;
                            If (CurrPos>Erec.Len) Or Insert
                               Then Begin
                                    If (ERec.Len+1)<=MaxLen
                                       Then Begin
                                            Move( Erec.Line[CurrPos],
                                                  Erec.Line[CurrPos+1],
                                                  ERec.Len-CurrPos+1);
                                            Erec.Line[CurrPos]:=Key;
                                            Inc(Erec.Len);
                                            If CurrPos<MaxLen
                                               Then MoveRight;
                                            End;
                                    End
                               Else Begin
                                    If Erec.Len<=MaxLen
                                       Then Begin
                                            Erec.Line[CurrPos]:=Key;
                                            If CurrPos<MaxLen
                                               Then MoveRight;
                                            End;
                                    End;
                            End
                       Else Write(#7);
                    End;
          End; {Case}
          End; {False}
 End;
Until Stop;
Color:=TextAttr;
Disp(Erec);
cursor_off;
End;



Procedure Read_Yesno( X, Y          : Byte;                   {screen position}
                  VAR Edit          : Boolean;
                      Len           : Byte );                    {screenlength}
Var
    Key           : Char;
    Stop          : Boolean;
    Textold       : Byte;
    X1            : Integer;
Begin
  Stop := False;
  Textold := textattr;
  If Insert Then Cursor_Half Else Cursor_On;
  Repeat
    GotoXy(X,y);
    TextAttr := 33;
    If Edit then Write('Yes') Else Write('No');
    Textcolor(0);
    If edit then For X1 := 4 to Len do Write('') else
                 For X1 := 3 to Len do Write('');
    If Edit then Gotoxy(x+3,y) else Gotoxy(x+2,y);
    Case ReadKeyBoard(Key) Of
    True  : Begin
          Case Key Of
           #59    : Helphook;
           #60    : f2hook(0);
           #72{up}: Begin
                    If Cursor<>Ignore Then
                      Begin
                        Cursor:=Up;
                        Stop:=True;
                      End;
                    End;
           #80    : Begin
                    If Cursor<>Ignore Then
                                  Begin
                        Cursor:=Down;
                        Stop:=True;
                      End;
                    End;
          End; {Case}
          End; {True}
    False : Begin
          Case Key Of
           'y', 'Y'   : Edit := True;
           'n', 'N'   : Edit := False;
           #8, #13,
           #32    : Begin   {cr}
                      if edit then edit := false else edit := true;
                      If Key = #13 then
                                    begin
                                       If Cursor<>Ignore Then Cursor:=Next;
                           Stop:=True;
                                    end;
                    End;
           #9     : CtrlIHook;
           #26    : CtrlZHook;
           #27    : Begin  {esc}
                    If Cursor<>Ignore Then Cursor:=Stay;
                    Stop:=True;
                    End;
          End; {Case}
          End; {False}
   End;
  Until Stop;
  Textattr := Textold;
  GotoXy(X,y);
  If Edit then Write('Yes') Else Write('No ');
  For X1 := 4 to Len do Write(' ');
  Cursor_Off;
End;

Procedure Read_String ( X, Y,                                 {screen position}
                        Len, MaxLen : Byte;   {screenlength, max string length}
                    VAR Edit        : String;              {the string to edit}
                        Accept      : Class );          {which chars to accept}
Begin
  ReadLine(X,Y,Len,MaxLen,Edit,Accept,Cursor,Insert,33,false);
End;

Procedure Read_Password ( X, Y,                               {screen position}
                        Len, MaxLen : Byte;   {screenlength, max string length}
                    VAR Edit        : String;              {the string to edit}
                        Accept      : Class );          {which chars to accept}
Begin
  ReadLine(X,Y,Len,MaxLen,Edit,Accept,Cursor,Insert,33,true);
End;



Procedure Read_Integer( X, Y,                                 {screen position}
                        Len, MaxLen : Byte;   {screenlength, max string length}
                    VAR Edit        : LongInt );          {the integer to edit}
Var
  EditBak : String;
Begin
  EditBak := Int_to_str(Edit);
  ReadLine(X,Y,Len,MaxLen,EditBak,c_numbers,Cursor,Insert,33,false);
  Edit := Str_to_Long(Editbak);
End;



Function Pull_Menu( ArrayPtr:Pointer; ArrayCnt:Integer; Starting:Integer )
  : Integer;
{----------------------------------------------------------------------------}
Var
  X         : Integer;
  Start     : Pointer;
  Select    : Integer;
  BSelect   : Integer;
  YSelect   : Integer;
  BYSelect  : Integer;
  Ch        : Char;
  X_Menu    : Integer;
Type
  StringPtr = ^ArrayStr;

  Function GetElement(X:Integer):String;
  Var
    Y    : Integer;
    Tmp  : String;
    Stop : Boolean;
  Begin
    Tmp := '';  Y := 0;  Stop := False; ArrayPtr := Start;
    Repeat
      Inc(Y);
      If Y = X then
       Begin
         Tmp := StringPtr(ArrayPtr)^;
         Stop := True;
      End;
      Inc(MemHandle(ArrayPtr).Offs,81);
    Until (Y = ArrayCnt) or Stop;
    GetElement := Tmp;
  End;

  Function MenuItems : Integer;
  Var
    X,Y : Integer;
  Begin
    Y := 0;
    For X := 1 to ArrayCnt do If First(1,GetElement(X)) = '|' then Inc(Y);
    MenuItems := Y;
  End;

  Procedure PutMenu( Select:Integer );
  Var
    Len,X,Y,Z,Sel : Integer;
    Tus : Integer;
  Begin
    Y := 0; Sel := 0; Tus := 2;
    For X := 1 to ArrayCnt do {lengte uitrekenen}
      If First(1,GetElement(x)) = '|' then Inc(Y,Length(getelement(x))+2);
    Z := (79-y) div 2;
    if Z < 1 then z := 2;
    if y > 79 then tus := 1;

    For X := 1 to ArrayCnt do
      Begin
        If First(1,GetElement(X)) = '|' then
          Begin
            Inc(Sel);
            If Sel = Select then
              Begin Writeat(Z,1,0,3,Last(Length(GetElement(x))-1,GetElement(x))); X_Menu := Z; End Else
               Writeat(Z,1,7,0,Last(length(getelement(x))-1,Getelement(x)));
            inc(z,length(getelement(x))+tus)
          End;
      End;
  End;

  Function Main_in_array( Select : Integer ) : Integer;
  Var
    X,Y : Integer;
    Stop : Boolean;
  Begin
    X := 1; Y := 0; Stop := False;
    While (x <= ArrayCnt) and not stop do
     Begin
       If First(1,Getelement(x)) = '|' then inc(y);
       stop := y = select;
       inc(x);
     End;
    Main_In_Array := x-1;
  End;

  Function Array_in_main( Select : Integer ) : Integer;
  Var
    X,z : Integer;
    Stop : Boolean;
  Begin
    X := 1; Stop := False; z := 0;
    While (x <= ArrayCnt) and not stop do
     Begin
       If First(1,Getelement(x)) = '|' then inc(z);
       stop := x = select;
       inc(x);
     End;
    Array_In_Main := z;
  End;


  Function Array_in_sub( Select : Integer ) : Integer;
  Var
    X,z : Integer;
    Stop : Boolean;
  Begin
    X := 1; Stop := False; z := 0;
    While (x <= ArrayCnt) and not stop do
     Begin
       If (First(1,Getelement(x)) = '|') and (x <> arraycnt) then
         z := 0 else inc(z);
       stop := x = select;
       inc(x);
     End;
    Array_In_sub := z;
  End;


  Function Max_Length( Select : Integer ) : Integer;
  Var
    X,Y : Integer;
    Stop : Boolean;
  Begin
    Y := 0; Stop := False;
    X := Main_in_array(select)+1;
    While (X <= ArrayCnt) and not stop do
     Begin
       if length(getelement(x)) > y then y := length(getelement(x));
       if (x+1 > arraycnt) or (first(1,getelement(x+1)) = '|') then stop := true;
       inc(x);
     End;
    Max_Length := y;
  End;

  Function Max_Options( Select : Integer ) : Integer;
  Var
    X,Y  : Integer;
    Stop : Boolean;
  Begin
    Y := 0; Stop := False;
    X := Main_in_array(select);
    While (X <= ArrayCnt) and not stop do
     Begin
       if (x+1 > arraycnt) or (first(1,getelement(x+1)) = '|') then stop := true;
       inc(x); inc(y);
     End;
    Max_Options := y-1;
  End;

  Procedure Create_Options( Select : Integer );
  Var
    X,Y, Tel : Integer;
    Stop : Boolean;
  Begin
    if (yselect < 1) and (max_options(Select) <> 0) then yselect := 1;
    if yselect > max_options(select)+1 then yselect := max_options(select)+1;
    Y := 3; Stop := False; Tel := 1;
    X := Main_in_array(select)+1;
    While (X <= ArrayCnt) and not stop do
     Begin
       if (x+1 > arraycnt) or (first(1,getelement(x+1)) = '|') then stop := true;
       if first(1,getelement(x)) = '|' then exit;
       if tel = yselect then
         writeat(x_menu+1,y,kl4,kl5,getelement(x)) else
           writeat(X_Menu+1,y,7,0,getelement(x));
       inc(x); inc(y); Inc(tel);
     End;
  End;

  Procedure PutPull ( Select : Integer );
  Var
    X, y: Integer;
  Begin
    If Menushow then Remove_window(0);
    Y := 0;
    X := Main_in_array(select);
    While (x+y+1 <= ArrayCnt) and (First(1,GetElement(x+y+1)) <> '|') do
      Inc(Y);                              {aantal menupunten in selected menu}
    If Y = 0 then Exit;
    With Mwin[0] do
      Begin
        X1 := X_Menu;
        X2 := 2;
        Y1 := Max_length(select)+X_Menu+1;
        Y2 := Y+3;
        St := '';
      End;

    if mwin[0].y1 > 80 then
      begin
        mwin[0].x1 := x_menu-(mwin[0].y1-79);
        mwin[0].y1 := mwin[0].y1-(mwin[0].y1-79);
        x_menu := mwin[0].x1;
      end;

    if not mwin[0].active then Create_Window(0);
    Menushow := True;
  End;

Begin
  Start := ArrayPtr;
  Select := Array_in_Main(Starting);
  YSelect := Array_in_sub(Starting);
  Byselect := Yselect;
  Bselect := 0;
  Ch := #0;

  While (Ch <> #13) and (Ch <> #27) do
    Begin
      If Bselect <> select then Begin Putmenu(select); PutPull(Select); Create_Options(Select); End;
      If BYSelect <> Yselect then Create_Options(select);
      BSelect := Select;
      BYSelect := Yselect;

      If max_options(select) > 0 then ChooseHook(main_in_array(select)+yselect)
        else choosehook(main_in_array(Select));

      while not keypressed do waithook;
      Ch := Readkey;
      Case Ch of
        #0  : Begin
                Ch := Readkey;
                Case Ch of
                  #59 : HelpHook;
                  #60 : F2hook(select);
                  #77 : {right} Begin inc(select); if select > menuitems then select := 1; yselect := 1; End;
                  #75 : {left}  Begin dec(Select); if select < 1 then select := menuitems; yselect := 1; End;
                  #80 : {down}  Begin Inc(Yselect); if Yselect > max_options(select) then yselect := 1; End;
                  #72 : {up}    Begin Dec(Yselect); if yselect < 1 then yselect := max_options(select); end;
                  #73 : {pgup}  Begin Yselect := 1; End;
                  #81 : {pgdw}  Begin Yselect := Max_Options(select); End;
                End;
              End;
        #9  : CtrlIHook;
        #26 : CtrlZHook;
      End;
   End;

  If ch = #27 then Pull_Menu := 0
    else
     begin
       Pull_Menu := MAin_In_Array(Select);
       If max_options(select) > 0 then
         Pull_Menu := Main_in_array(select)+Yselect;
     end;
End;


Procedure Init;
Var
  X : integer;
Begin
{  Cursor_Off; }
{  Init_Copyright; }
  Insert := false;
  Cursor := Accept;
  menushow := false;

  kl1 := 8;
  kl2 := 0;
  kl3 := 1;
  kl4 := 1;
  kl5 := 7;
  if mono then
    begin
       kl1 := 0; kl2 := 3; kl3 := 3; kl4 := 0; kl5 := 7;
    end;

  For X := 0 to 6 do Mwin[x].active := false;
End;


{----------}

BEGIN
 Init;

 ChooseHook := Dummy1;
 WaitHook := Dummy2;
 HelpHook := Dummy2;
 f2hook := dummy1;
 CtrlIHook := Dummy2;
 CtrlZHook := Dummy2;
 Insert := True;
END.
