PAGE  80,132
TITLE ISPATH Character Classification Routines, Ver 6.20

; ISPATH.ASM - IsPath
;  Copyright (c) 1989-1991 James H. LeMay, All rights reserved.

DATA    SEGMENT WORD PUBLIC
        EXTRN   ChrClass:  BYTE
DATA    ENDS

CODE    SEGMENT WORD PUBLIC
        ASSUME  CS:CODE,DS:DATA
        PUBLIC  IsPath

File    EQU  01000000b
C       EQU  BYTE  PTR SS:[di+4]

; IsPath - Returns true if Char is IsDOS and not '*' or '?'.
; function IsPath (C: char): boolean;

IsPath       PROC FAR
       mov   di,sp            ; Set up stack base
       xor   ax,ax            ; Assume false
       mov   bx,ax            ; Set BX=0
       add   bl,C             ; Get character
       js    ExIs2            ; Exit if >128
       test  ChrClass[bx],File; Is it a File char?
       jnz   J1               ;   yes, set true
       cmp   bl,'\'           ; C='\'?
       je    J1               ;   yes, set true
       cmp   bl,':'           ; C=':'?
       jne   ExIs2            ;   no, leave false
J1:    inc   ax               ;   yes, set true
ExIs2: ret   2                ; Clear parameter
IsPath       ENDP

CODE   ENDS

       END
