PAGE  80,132
TITLE REPMOVSB  Fast Move Algorithm for bytes, Ver 6.20

; REPMOVSB.ASM - RepMovsB
;  Copyright (c) 1989-1991 James H. LeMay, All rights reserved.
; Algorithm moves bytes by a word at a time.  Self-aligning for
; alignment sensitive computers like the 8088, 8086, and 80386.
; Uses 25 bytes.

CODE    SEGMENT WORD PUBLIC
        ASSUME  CS:CODE
        PUBLIC  RepMovsB

; RepMovsB - moves and array of bytes by the fastest possible method.
; Used as a local routine for other STRS routines.  Assumes:
;   - Source and Dest are loaded
;   - CX has the byte count
;   - DF is set to increment

RepMovsB     PROC NEAR
       cmp   cx,12            ; At least 12 bytes?
       jae   Wrds             ;  yes, move words
       rep   movsb            ; Move bytes
       ret                    ; Return to call
; -- To speed up transfers at least line up the DI offset --
       EVEN                   ; Align for speed
Wrds:  test  di,1             ; DI even?
       jz    Evn              ;   yes, start with words
       movsb                  ;   no, move odd byte
       dec   cx               ; Decrement the count
; -- Now transfer by words --
       EVEN                   ; Align for speed
Evn:   shr   cx,1             ; Bytes -> Words
       rep   movsw            ; Move contents by words
       adc   cl,cl            ; Add in odd byte
       rep   movsb            ; Move remaining byte
       ret                    ; Return to call
RepMovsB     ENDP

CODE   ENDS

       END
