PAGE  80,132
TITLE STRCAT  String Append Routine, Ver 6.20

; STRCAT.ASM - StrCat/StrCatL
;  Copyright (c) 1989-1991 James H. LeMay, All rights reserved.
; Like Concat, this procedure appends one string to the end of S
; with a maximum length limit.  This greatly speeds up concatination.
; Usually the SizeOf function is used for MaxLen, or 255 can be used if
; there is no concern.

CODE    SEGMENT WORD PUBLIC
        ASSUME  CS:CODE
        PUBLIC  StrCat, StrCatL
        EXTRN   RepMovsB: NEAR

Dest         EQU     DWORD PTR [bp+12]
S            EQU     DWORD PTR [bp+8]
MaxLen       EQU     BYTE  PTR [bp+6]

; StrCat - Appends one string with another.  Similar to Concat, but 3 times
; faster.  StrCatL is an alternative identifier to distinguish it from the
; same named procedure in TP for Windows for ASCIIZ strings.
; procedure StrCat (VAR Dest: string; S: string; MaxLen: byte);

StrCat       PROC FAR
StrCatL      PROC FAR
       push  bp               ; Save Pascal's BP
       mov   bp,sp            ; Set up stack base
       push  ds               ; Save Pascal's DS
; -- Get S string length --
       xor   ax,ax            ; Set AX=0
       lds   si,S             ; Point to S string
       cld                    ; Set DF to increment
       lodsb                  ; Load S[0] in AL
       mov   cx,ax            ; Save length in CX
       jcxz  Exit             ; Quit if null string
; -- Get Dest string length --
       les   di,Dest          ; Point to dest string
       mov   bx,di            ; Copy offset in BX
       mov   al,es:[di]       ; Get length
       mov   dx,ax            ; Save in DX
       add   bx,ax            ; Calc last char offset in BX
; -- Get MaxLen --
       mov   al,MaxLen        ; Get MaxLen
       sub   dx,ax            ; S Length-MaxLen (DX = -MaxCatLen)
       jge   Exit             ; Nothing to do.
       add   dx,cx            ; Calc CatLen - MaxCatLen
       jge   Trunc            ; Jump if >=0
       add   ax,dx            ; Calc Dest Length
       jmp   SHORT All        ; Append all
Trunc: add   cx,dx            ; Truncate concat
All:   stosb                  ; Save length
       mov   di,bx            ; Point to S[Length]
       inc   di               ; S[Length+1]
; -- Append string --
       call  RepMovsB         ; Do fast copy of bytes
Exit:  pop   ds               ; Restore Pascal's DS
       pop   bp               ; Restore Pascal's BP
       ret   10               ; Clear all parameters
StrCatL      ENDP
StrCat       ENDP

CODE   ENDS

       END
