PAGE  80,132
TITLE STRPOSL  String Count and Position Routines, Ver 6.20

; STRPOSL.ASM - StrPosL, StrQty
;  Copyright (c) 1989-1991 James H. LeMay, All rights reserved.


CODE    SEGMENT WORD PUBLIC
        ASSUME  CS:CODE
        PUBLIC  StrPosL, StrQty

; StrSrch - This is the actual engine to search out string given a find
; string.

S            EQU     DWORD PTR [bp+di+12]
Find         EQU     DWORD PTR [bp+di+8]
Nth          EQU     BYTE  PTR [bp+8]

; AH: FirstCX   AL: First char
; BX: Scratch
; CH: 0         CL: Compare length
; DH: 0         DL: N ocurrrences
; BP: Find[0]-1

StrSrch      PROC  NEAR
       push  bp               ; Save Pascal's BP
       mov   bp,sp            ; Set up stack base
       push  ds               ; Save Pascal's DS
; -- Check Qty and Nth for zero --
       xor   ax,ax            ; Set AX=0
       cwd                    ; Set DX=0
       test  di,di            ; Qty routine?
       jz    Qty              ;   yes, pass Nth retrieval
       add   dl,Nth           ; Get Nth and test flag zero
       jz    Exit3            ;   Exit if 0
; -- Test Find length --
Qty:   lds   si,Find          ; Point to Find string
       cld                    ; Set DF to increment
       lodsb                  ; Get Find length
       dec   ax               ; Find[0]-1, Find=''?
       js    Exit1            ;   yes, exit
; -- Get S length --
       les   di,S             ; Point to dest string
       mov   bp,ax            ; Save in BP       (BP=Find[0]-1)
       mov   al,es:[di]       ; Get S length
       mov   cx,ax            ; Set count
       sub   cx,bp            ; Chars to scan in CL
       jbe   Exit1            ; Exit if Find[0]-1>=S[0]
       mov   ah,cl            ; Save initial count
       inc   di               ; Point to S[1]
       lodsb                  ; Get first Find char
; -- Check if just one char --
       test  bp,bp            ; Find[0]-1=0? ( 1 char? )
       jz    L2               ;   yes, scan for char
; -- Scan for Find --
       EVEN                   ; Align for speed
L0:    repne scasb            ; Try to match first char
       jne   Exit1            ; None found
       mov   bx,cx            ; Save count remaining
       mov   cx,bp            ; Set Find scan length
       repe  cmpsb            ; Strings equal?
       xchg  cx,bx            ;   (Swap counts)
       je    L1               ;   yes, a match found
                              ;   no, scan again
; -- Readjust for no match --
       jcxz  Exit1            ; All Finds were not found
       sub   bx,bp            ; Number of chars compared (neg)
       add   si,bx            ; Reset SI
       add   di,bx            ; Reset DI
       jmp   SHORT L0         ; Continue to next pos
; -- Readjust for match found --
L1:    dec   dx               ; Decrement occurrrence
       je    Exit2            ; Exit if Nth reached
       sub   si,bp            ; Reset SI
       sub   cx,bp            ; Jump past last find
       ja    L0               ; Continue if more chars

; -- Report results --
Exit1: mov   ah,cl            ; Set AH=CL to get result 0
Exit2: mov   al,ah            ; Get original count in AL
       sub   al,cl            ; Subtract chars scanned
Exit3: pop   ds               ; Restore Pascal's DS
       pop   bp               ; Restore Pascal's BP
       ret                    ; Return to call

; -- Special scan for just one char --
       EVEN                   ; Align for speed
L2:    repne scasb            ; Scan
       jne   Exit1            ; Not found
       dec   dl               ; Adjust count
       jnz   L2               ; Loop if not finished
       jmp   SHORT Exit2      ; Found position
StrSrch      ENDP


; StrPosL - Position of Nth occurrence of Find.
; This routine finds the position of Nth occurrence a given substring.
; function StrPosL (S,Find: string; Nth: byte): byte;

StrPosL      PROC FAR
       mov   di,2             ; Set stack offset 2
       call  StrSrch          ; Do search
       ret   10               ; Clear all parameters
StrPosL      ENDP


; StrQty - Total quantity of Finds in a string.
; This routine counts the occurrences a given Find string.
; function StrQty (S,Find: string): byte;

StrQty       PROC FAR
       xor   di,di            ; Set stack offset 0
       call  StrSrch          ; Do search
       xchg  ax,dx            ; Get result in AL
       neg   al               ; Change sign
       ret   8                ; Clear all parameters
StrQty       ENDP


CODE   ENDS

       END
