PAGE  80,132
TITLE STRREV  String Reverse Chars Routine, Ver 6.20

; STRREV.ASM - StrRev
;  Copyright (c) 1989-1991 James H. LeMay, All rights reserved.
; This routine operates on a string to reverse the order of the characters
; in the string.


CODE    SEGMENT WORD PUBLIC
        ASSUME  CS:CODE
        PUBLIC  StrRev

S            EQU     DWORD PTR ss:[bx+4]

; StrRev - Reverses all characters in the string.
; procedure StrRev (VAR S: string);

StrRev       PROC FAR
       mov   bx,sp            ; Set up stack base
       mov   dx,ds            ; Save Pascal's DS
       lds   si,S             ; Point to source string
       mov   di,si            ; Save for destination
       cld                    ; Set DF to increment
       lodsb                  ; Get length
       xchg  ax,cx            ; Save in CX
       xor   ch,ch            ; Zero extend CL
       add   di,cx            ; Offset at last char
       shr   cx,1             ; Cut count in half
       jz    Exit             ; Quit if string <=1 chars
       EVEN                   ; Align for speed
L1:    lodsb                  ; Get left char
       xchg  al,[di]          ; Exchange left and right char
       mov   [si-1],al        ; Save new left char
       dec   di               ; Decrement right offset
       loop  L1               ; Do full string
Exit:  mov   ds,dx            ; Restore Pascal's DS
       ret   4                ; Clear all parameters
StrRev       ENDP

CODE   ENDS

       END
