(*****************************************************************************)
(*>                                                                         <*)
(*>  SYSOP2H .PAS -  Written by Eric Oman                                   <*)
(*>                                                                         <*)
(*>  SysOp functions: System Configuration Editor -- "H" command.           <*)
(*>                                                                         <*)
(*>                                                                         <*)
(*****************************************************************************)
{$A+,B+,D-,E+,F+,I+,L+,N-,O+,R-,S+,V-}
unit sysop2h;

interface

uses
  crt, dos, overlay,
  common;

procedure pomisc1;

implementation


procedure pomisc1;
var c:char;
    b:byte;
    abort,next,done,changed:boolean;
    s:astr;
   j:integer;
begin
  done:=FALSE;
  repeat
    with systat do begin
      cls;
      sprint(' ^4[ ^9Miscellaneous Configuration ^4]');
      nl;
      abort:=FALSE;
      printacr(#3#5'['+#3#3+'A'+#3#5+']. System StartOut Menu       : '+allstartmenu,abort,next);
      printacr(#3#5'['+#3#3+'B'+#3#5+']. SysOp Chat ColorFilter     : '+chatcfilter1,abort,next);
      printacr(#3#5'['+#3#3+'C'+#3#5+']. User Chat ColorFilter      : '+chatcfilter2,abort,next);
      printacr(#3#5'['+#3#3+'D'+#3#5+']. Default Bulletin File       : '+bulletprefix,abort,next);
      printacr(#3#5'['+#3#3+'E'+#3#5+']. Days before user is deleted : '+(cstr(purgedays)),abort,next);
      printacr(#3#5'['+#3#3+'F'+#3#5+']. Caller number pre-set       : '+(cstr(callernum)),abort,next);
      printacr(#3#5'['+#3#3+'G'+#3#5+']. Calls before pw is changed  : '+(cstr(pwdays)),abort,next);
      printacr(#3#5'['+#3#3+'H'+#3#5+']. This line is node           : '+(cstr(res1[1])),abort,next);
      printacr(#3#5'['+#3#3+'I'+#3#5+']. Post call ratio             : '+mln(aonoff(fbi,'Yes','No'),16),abort,next);
      nl;
      prt('Enter selection (A-I) [Q]uit : '); onek(c,'QABCDEFGHI'^M);
      nl;
      case c of
        'Q':done:=TRUE;
        'H':begin
        nl;
        sprint(#3#7+'This line is node. (1 or 2, 0 for no multi-node support at all)');
        prt(': ');
        ini(b);
        if not(badini) then res1[1]:=b;
        end;
        'E':begin
        nl;
        sprint(#3#7+'Number of days of user inactivity before user is deleted.');
        prt(': ');
        ini(b);
        if not(badini) then purgedays:=b;
        end;
        'A'..'D':begin
                   print('Enter new:');
                   case c of
                     'A':inputwn(allstartmenu,8,changed);
                     'B':inputwn(chatcfilter1,12,changed);
                     'C':inputwn(chatcfilter2,12,changed);
                     'D':inputwn(bulletprefix,8,changed);
               end;
         end;
       'F':begin
                nl;
                sprompt(#3#4+'Caller Number : ');
                input(s,11);
                j:=value(s);
                if (j<>0) then systat.callernum:=j;
              end;
       'G':begin
        nl;
        sprint(#3#7+'Number of calls before password change.');
        prt(': ');
        ini(b);
        if not(badini) then pwdays:=b;
        end;
       'I':begin
            nl;
            systat.fbi:=pynq('Use Post/Call Ratio (No)? ');
           end;
   end;
end;
until ((done) or (hangup));
end;

end.
