/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.router;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.XMLElement;
import net.jxta.exception.PeerGroupException;
import net.jxta.id.ID;
import net.jxta.impl.endpoint.EndpointUtils;
import net.jxta.impl.util.LRUCache;
import net.jxta.logging.Logging;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.platform.Module;
import net.jxta.protocol.AccessPointAdvertisement;
import net.jxta.protocol.ConfigParams;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.RouteAdvertisement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RouteCM
implements Module {
    private static final transient Logger LOG = Logger.getLogger(RouteCM.class.getName());
    public static final long DEFAULT_EXPIRATION = 1200000L;
    public static final boolean USE_CM_DEFAULT = true;
    private boolean useCM = false;
    private boolean useCMConfig = true;
    private PeerGroup group = null;
    private LRUCache<ID, RouteAdvertisement> lruCache = new LRUCache(100);

    RouteCM() {
    }

    @Override
    public void init(PeerGroup group, ID assignedID, Advertisement impl) throws PeerGroupException {
        Enumeration param;
        ModuleImplAdvertisement implAdvertisement = (ModuleImplAdvertisement)impl;
        ConfigParams confAdv = group.getConfigAdvertisement();
        XMLElement paramBlock = null;
        if (confAdv != null) {
            paramBlock = (XMLElement)((Object)confAdv.getServiceParam(assignedID));
        }
        if (paramBlock != null && (param = paramBlock.getChildren("useCM")).hasMoreElements()) {
            this.useCMConfig = Boolean.getBoolean(((XMLElement)param.nextElement()).getTextValue());
        }
        this.group = group;
        if (Logging.SHOW_CONFIG && LOG.isLoggable(Level.CONFIG)) {
            StringBuilder configInfo = new StringBuilder("Configuring Router Transport Resolver : " + assignedID);
            if (implAdvertisement != null) {
                configInfo.append("\n\tImplementation :");
                configInfo.append("\n\t\tModule Spec ID: ").append(implAdvertisement.getModuleSpecID());
                configInfo.append("\n\t\tImpl Description : ").append(implAdvertisement.getDescription());
                configInfo.append("\n\t\tImpl URI : ").append(implAdvertisement.getUri());
                configInfo.append("\n\t\tImpl Code : ").append(implAdvertisement.getCode());
            }
            configInfo.append("\n\tGroup Params :");
            configInfo.append("\n\t\tGroup : ").append(group.getPeerGroupName());
            configInfo.append("\n\t\tGroup ID : ").append(group.getPeerGroupID());
            configInfo.append("\n\t\tPeer ID : ").append(group.getPeerID());
            configInfo.append("\n\tConfiguration :");
            configInfo.append("\n\t\tUse Route CM : ").append(this.useCMConfig);
            LOG.config(configInfo.toString());
        }
    }

    @Override
    public int startApp(String[] arg) {
        this.useCM = this.useCMConfig;
        return 0;
    }

    @Override
    public void stopApp() {
        this.useCM = false;
    }

    boolean useRouteCM() {
        return this.useCM;
    }

    void enableRouteCM(boolean enable) {
        this.useCM = enable;
    }

    protected Iterator<RouteAdvertisement> getRouteAdv(ID peerID) {
        Advertisement adv;
        Enumeration<Advertisement> advs;
        ArrayList<RouteAdvertisement> result;
        DiscoveryService discovery;
        block12: {
            String peerIDStr;
            block11: {
                if (!this.useCM) {
                    return Collections.emptyList().iterator();
                }
                discovery = this.group.getDiscoveryService();
                if (null == discovery) {
                    return Collections.emptyList().iterator();
                }
                peerIDStr = peerID.toString();
                result = new ArrayList<RouteAdvertisement>(2);
                if (this.lruCache.contains(peerID)) {
                    result.add(this.lruCache.get(peerID));
                    return result.iterator();
                }
                advs = null;
                try {
                    advs = discovery.getLocalAdvertisements(2, "DstPID", peerIDStr);
                }
                catch (IOException failed) {
                    if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block11;
                    LOG.log(Level.WARNING, "Failed discovering routes for " + peerIDStr, failed);
                }
            }
            while (null != advs && advs.hasMoreElements()) {
                RouteAdvertisement route;
                adv = advs.nextElement();
                if (!(adv instanceof RouteAdvertisement) || result.contains(route = (RouteAdvertisement)adv)) continue;
                result.add(route);
            }
            advs = null;
            try {
                advs = discovery.getLocalAdvertisements(0, "PID", peerIDStr);
            }
            catch (IOException failed) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block12;
                LOG.log(Level.WARNING, "Failed discovering peer advertisements for " + peerIDStr, failed);
            }
        }
        while (null != advs && advs.hasMoreElements()) {
            RouteAdvertisement route;
            block13: {
                PeerAdvertisement padv;
                adv = advs.nextElement();
                if (!(adv instanceof PeerAdvertisement) || result.contains(route = EndpointUtils.extractRouteAdv(padv = (PeerAdvertisement)adv))) continue;
                try {
                    discovery.publish(route, 1200000L, 1200000L);
                }
                catch (IOException failed) {
                    if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block13;
                    LOG.log(Level.WARNING, "Failed publishing route", failed);
                }
            }
            result.add(route);
        }
        return result.iterator();
    }

    protected void createRoute(RouteAdvertisement route) {
        block13: {
            if (!this.useCM) {
                return;
            }
            DiscoveryService discovery = this.group.getDiscoveryService();
            if (null == discovery) {
                return;
            }
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("try to publish route ");
            }
            try {
                RouteAdvertisement newRoute = (RouteAdvertisement)AdvertisementFactory.newAdvertisement(RouteAdvertisement.getAdvertisementType());
                PeerID pId = route.getDestPeerID();
                String realPeerID = pId.toString();
                Enumeration<Advertisement> advs = discovery.getLocalAdvertisements(2, "DstPID", realPeerID);
                if (!advs.hasMoreElements()) {
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("could not find a route advertisement " + realPeerID);
                    }
                    return;
                }
                Advertisement adv = advs.nextElement();
                if (adv instanceof RouteAdvertisement) {
                    RouteAdvertisement dest = (RouteAdvertisement)adv;
                    newRoute.setDest(dest.getDest());
                }
                Vector<AccessPointAdvertisement> newHops = new Vector<AccessPointAdvertisement>();
                Enumeration<AccessPointAdvertisement> e = route.getHops();
                while (e.hasMoreElements()) {
                    AccessPointAdvertisement ap = e.nextElement();
                    realPeerID = ap.getPeerID().toString();
                    advs = discovery.getLocalAdvertisements(2, "DstPID", realPeerID);
                    if (!advs.hasMoreElements()) {
                        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                            LOG.fine("could not find a route advertisement for hop " + realPeerID);
                        }
                        return;
                    }
                    adv = advs.nextElement();
                    if (!(adv instanceof RouteAdvertisement)) continue;
                    newHops.add(((RouteAdvertisement)adv).getDest());
                }
                if (newHops.isEmpty()) {
                    return;
                }
                newRoute.setHops(newHops);
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("publishing new route \n" + newRoute.display());
                }
                this.lruCache.put(route.getDestPeerID(), route);
                discovery.publish(newRoute, 1200000L, 1200000L);
            }
            catch (Exception ex) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block13;
                LOG.log(Level.WARNING, "error publishing route" + route.display(), ex);
            }
        }
    }

    protected void publishRoute(RouteAdvertisement route) {
        block6: {
            if (!this.useCM) {
                return;
            }
            DiscoveryService discovery = this.group.getDiscoveryService();
            if (null == discovery) {
                return;
            }
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Publishing route for " + route.getDestPeerID());
            }
            if (!this.lruCache.contains(route.getDestPeerID())) {
                try {
                    discovery.publish(route, 1200000L, 1200000L);
                }
                catch (Exception ex) {
                    if (!Logging.SHOW_SEVERE || !LOG.isLoggable(Level.SEVERE)) break block6;
                    LOG.log(Level.SEVERE, "error publishing route adv \n" + route, ex);
                }
            }
        }
        this.lruCache.put(route.getDestPeerID(), route);
    }

    protected void flushRoute(ID peerID) {
        Advertisement adv;
        Enumeration<Advertisement> advs;
        String peerIDStr;
        DiscoveryService discovery;
        block13: {
            block12: {
                if (!this.useCM) {
                    return;
                }
                discovery = this.group.getDiscoveryService();
                if (null == discovery) {
                    return;
                }
                peerIDStr = peerID.toString();
                advs = null;
                try {
                    advs = discovery.getLocalAdvertisements(2, "DstPID", peerIDStr);
                }
                catch (IOException failed) {
                    if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block12;
                    LOG.log(Level.WARNING, "Failure recovering route advertisements.", failed);
                }
            }
            while (null != advs && advs.hasMoreElements()) {
                adv = advs.nextElement();
                if (!(adv instanceof RouteAdvertisement)) continue;
                try {
                    discovery.flushAdvertisement(adv);
                    if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) continue;
                    LOG.fine("removed RouteAdvertisement for " + peerIDStr);
                }
                catch (IOException ex) {}
            }
            advs = null;
            try {
                advs = discovery.getLocalAdvertisements(0, "PID", peerIDStr);
            }
            catch (IOException failed) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block13;
                LOG.log(Level.WARNING, "Failed discovering peer advertisements for " + peerIDStr, failed);
            }
        }
        while (null != advs && advs.hasMoreElements()) {
            adv = advs.nextElement();
            if (!(adv instanceof PeerAdvertisement)) continue;
            try {
                discovery.flushAdvertisement(adv);
                if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("removed PeerAdvertisement for " + peerIDStr);
            }
            catch (IOException ex) {}
        }
        this.lruCache.remove(peerID);
    }

    protected boolean updateRoute(RouteAdvertisement route) {
        block6: {
            if (!this.useCM) {
                return false;
            }
            DiscoveryService discovery = this.group.getDiscoveryService();
            if (null == discovery) {
                return true;
            }
            try {
                String realPeerID = route.getDestPeerID().toString();
                Enumeration<Advertisement> advs = discovery.getLocalAdvertisements(2, "DstPID", realPeerID);
                if (advs.hasMoreElements()) {
                    RouteAdvertisement oldRouteAdv;
                    Advertisement adv = advs.nextElement();
                    if (adv instanceof RouteAdvertisement && !route.equals(oldRouteAdv = (RouteAdvertisement)adv)) {
                        discovery.publish(route, 1200000L, 1200000L);
                        this.lruCache.put(route.getDestPeerID(), route);
                        return true;
                    }
                    break block6;
                }
                discovery.publish(route, 1200000L, 1200000L);
                this.lruCache.put(route.getDestPeerID(), route);
                return true;
            }
            catch (Exception e) {
                if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.WARNING)) break block6;
                LOG.log(Level.WARNING, "  failure to publish route advertisement response", e);
            }
        }
        return false;
    }
}

