/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Attribute;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.XMLElement;
import net.jxta.id.IDFactory;
import net.jxta.logging.Logging;
import net.jxta.platform.ModuleSpecID;
import net.jxta.protocol.ModuleSpecAdvertisement;
import net.jxta.protocol.PipeAdvertisement;

public class ModuleSpecAdv
extends ModuleSpecAdvertisement {
    private static final Logger LOG = Logger.getLogger(ModuleSpecAdv.class.getName());
    private static final String idTag = "MSID";
    private static final String nameTag = "Name";
    private static final String creatorTag = "Crtr";
    private static final String uriTag = "SURI";
    private static final String versTag = "Vers";
    private static final String descTag = "Desc";
    private static final String paramTag = "Parm";
    private static final String proxyIdTag = "Proxy";
    private static final String authIdTag = "Auth";
    private static final String[] fields = new String[]{"Name", "MSID"};

    private ModuleSpecAdv() {
    }

    private ModuleSpecAdv(XMLElement doc) {
        String doctype = doc.getName();
        String typedoctype = "";
        Attribute itsType = doc.getAttribute("type");
        if (null != itsType) {
            typedoctype = itsType.getValue();
        }
        if (!doctype.equals(ModuleSpecAdv.getAdvertisementType()) && !ModuleSpecAdv.getAdvertisementType().equals(typedoctype)) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + doc.getName());
        }
        Enumeration elements = doc.getChildren();
        while (elements.hasMoreElements()) {
            XMLElement elem = (XMLElement)elements.nextElement();
            if (this.handleElement(elem) || !Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) continue;
            LOG.fine("Unhandled Element: " + elem.toString());
        }
        if (null == this.getModuleSpecID()) {
            throw new IllegalArgumentException("Module Spec Advertisement did not contain a module spec id.");
        }
    }

    public String getAdvType() {
        return ModuleSpecAdv.getAdvertisementType();
    }

    protected boolean handleElement(Element raw) {
        if (super.handleElement(raw)) {
            return true;
        }
        XMLElement elem = (XMLElement)raw;
        String nm = elem.getName();
        if (nm.equals(nameTag)) {
            this.setName(elem.getTextValue());
            return true;
        }
        if (nm.equals(descTag)) {
            this.setDesc(elem);
            return true;
        }
        if (nm.equals(idTag)) {
            try {
                URI specID = new URI(elem.getTextValue());
                this.setModuleSpecID((ModuleSpecID)IDFactory.fromURI(specID));
            }
            catch (URISyntaxException badID) {
                throw new IllegalArgumentException("Bad msid in advertisement");
            }
            catch (ClassCastException badID) {
                throw new IllegalArgumentException("Unusable msid in advertisement");
            }
            return true;
        }
        if (nm.equals(creatorTag)) {
            this.setCreator(elem.getTextValue());
            return true;
        }
        if (nm.equals(uriTag)) {
            this.setSpecURI(elem.getTextValue());
            return true;
        }
        if (nm.equals(versTag)) {
            this.setVersion(elem.getTextValue());
            return true;
        }
        if (nm.equals(paramTag)) {
            this.setParam(elem);
            return true;
        }
        if (nm.equals(proxyIdTag)) {
            try {
                URI spID = new URI(elem.getTextValue());
                this.setProxySpecID((ModuleSpecID)IDFactory.fromURI(spID));
            }
            catch (URISyntaxException badID) {
                throw new IllegalArgumentException("Bad proxy spec id in advertisement");
            }
            catch (ClassCastException badID) {
                throw new IllegalArgumentException("Unusable proxy spec id in advertisement");
            }
            return true;
        }
        if (nm.equals(authIdTag)) {
            try {
                URI spID = new URI(elem.getTextValue());
                this.setAuthSpecID((ModuleSpecID)IDFactory.fromURI(spID));
            }
            catch (URISyntaxException badID) {
                throw new IllegalArgumentException("Bad auth spec id in advertisement");
            }
            catch (ClassCastException badID) {
                throw new IllegalArgumentException("Unusable auth spec id in advertisement");
            }
            return true;
        }
        if (nm.equals(PipeAdvertisement.getAdvertisementType())) {
            try {
                PipeAdvertisement pipeAdv = (PipeAdvertisement)AdvertisementFactory.newAdvertisement(elem);
                this.setPipeAdvertisement(pipeAdv);
            }
            catch (ClassCastException wrongAdv) {
                throw new IllegalArgumentException("Bad pipe advertisement in advertisement");
            }
            return true;
        }
        return false;
    }

    public Document getDocument(MimeMediaType encodeAs) {
        ModuleSpecID tmpId;
        StructuredDocument desc;
        if (null == this.getModuleSpecID()) {
            throw new IllegalStateException("Module Spec Advertisement did not contain a module spec id.");
        }
        StructuredDocument adv = (StructuredDocument)super.getDocument(encodeAs);
        Object e = adv.createElement(idTag, this.getModuleSpecID().toString());
        adv.appendChild(e);
        if (null != this.getName()) {
            e = adv.createElement(nameTag, this.getName());
            adv.appendChild(e);
        }
        if ((desc = this.getDesc()) != null) {
            StructuredDocumentUtils.copyElements(adv, adv, desc);
        }
        e = adv.createElement(creatorTag, this.getCreator());
        adv.appendChild(e);
        e = adv.createElement(uriTag, this.getSpecURI());
        adv.appendChild(e);
        e = adv.createElement(versTag, this.getVersion());
        adv.appendChild(e);
        PipeAdvertisement pipeAdv = this.getPipeAdvertisement();
        if (pipeAdv != null) {
            StructuredTextDocument advDoc = (StructuredTextDocument)pipeAdv.getDocument(encodeAs);
            StructuredDocumentUtils.copyElements(adv, adv, advDoc);
        }
        if ((tmpId = this.getProxySpecID()) != null) {
            e = adv.createElement(proxyIdTag, tmpId.toString());
            adv.appendChild(e);
        }
        if ((tmpId = this.getAuthSpecID()) != null) {
            e = adv.createElement(authIdTag, tmpId.toString());
            adv.appendChild(e);
        }
        if ((e = this.getParamPriv()) != null) {
            StructuredDocumentUtils.copyElements(adv, adv, e, paramTag);
        }
        return adv;
    }

    public String[] getIndexFields() {
        return fields;
    }

    public static class Instantiator
    implements AdvertisementFactory.Instantiator {
        public String getAdvertisementType() {
            return ModuleSpecAdv.getAdvertisementType();
        }

        public Advertisement newInstance() {
            return new ModuleSpecAdv();
        }

        public Advertisement newInstance(Element root) {
            if (!XMLElement.class.isInstance(root)) {
                throw new IllegalArgumentException(this.getClass().getName() + " only supports XLMElement");
            }
            return new ModuleSpecAdv((XMLElement)root);
        }
    }
}

