/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.rendezvous.rpv;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.XMLDocument;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointListener;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.TextDocumentMessageElement;
import net.jxta.impl.rendezvous.rpv.PeerView;
import net.jxta.impl.util.ACLSeedingManager;
import net.jxta.impl.util.TimeUtils;
import net.jxta.logging.Logging;
import net.jxta.peergroup.PeerGroup;
import net.jxta.pipe.OutputPipe;
import net.jxta.pipe.PipeService;
import net.jxta.protocol.PipeAdvertisement;
import net.jxta.protocol.RdvAdvertisement;
import net.jxta.protocol.RouteAdvertisement;

public class PeerviewSeedingManager
extends ACLSeedingManager
implements EndpointListener {
    private static final transient Logger LOG = Logger.getLogger(PeerviewSeedingManager.class.getName());
    protected static final long MINIMUM_PEERVIEW_REFRESH_INTERVAL = 60000L;
    protected static final long STANDARD_PEERVIEW_REFRESH_INTERVAL = 1200000L;
    protected Set<RouteAdvertisement> peerview = new HashSet<RouteAdvertisement>();
    protected long nextPeerViewRefresh = 0L;
    protected int unsuccessfulProbes = 0;
    protected final PeerGroup advGroup;
    protected final PeerGroup group;
    protected final String name;
    protected final PipeAdvertisement advPipeAdv;

    public PeerviewSeedingManager(URI aclLocation, PeerGroup group, PeerGroup advGroup, String name) {
        super(aclLocation);
        this.group = group;
        this.advGroup = advGroup;
        this.name = name;
        this.advPipeAdv = PeerView.makeWirePipeAdvertisement(advGroup, group, name);
        group.getEndpointService().addIncomingMessageListener(this, "PeerView", group.getPeerGroupID().getUniqueValue().toString());
    }

    public void stop() {
        this.group.getEndpointService().removeIncomingMessageListener("PeerView", this.group.getPeerGroupID().getUniqueValue().toString());
    }

    public void addSeed(RouteAdvertisement seed) {
        this.peerview.add(seed);
    }

    public URI[] getActiveSeedURIs() {
        throw new UnsupportedOperationException("Not supported.");
    }

    public synchronized RouteAdvertisement[] getActiveSeedRoutes() {
        this.refreshActiveSeeds();
        ArrayList<RouteAdvertisement> result = new ArrayList<RouteAdvertisement>();
        for (RouteAdvertisement anRA : this.peerview) {
            result.add(anRA.clone());
        }
        return result.toArray(new RouteAdvertisement[result.size()]);
    }

    public synchronized boolean isAcceptablePeer(RouteAdvertisement radv) {
        boolean acceptable = this.peerview.contains(radv);
        return acceptable && super.isAcceptablePeer(radv);
    }

    protected void refreshActiveSeeds() {
        block5: {
            if (TimeUtils.timeNow() < this.nextPeerViewRefresh) {
                return;
            }
            this.peerview.clear();
            Message message = this.makeMessage();
            try {
                long untilNextRefresh;
                PipeService pipes = this.advGroup.getPipeService();
                OutputPipe output = pipes.createOutputPipe(this.advPipeAdv, 30000L);
                output.send(message);
                output.close();
                if (this.peerview.isEmpty()) {
                    ++this.unsuccessfulProbes;
                    untilNextRefresh = Math.min((long)this.unsuccessfulProbes * 60000L, 1200000L);
                } else {
                    untilNextRefresh = 1200000L;
                }
                this.nextPeerViewRefresh = TimeUtils.toAbsoluteTimeMillis(untilNextRefresh);
            }
            catch (IOException failed) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block5;
                LOG.log(Level.WARNING, "Failed sending " + message + ".", failed);
            }
        }
    }

    private Message makeMessage() {
        Message msg = new Message();
        msg.addMessageElement("jxta", PeerView.EDGE_ELEMENT);
        RdvAdvertisement radv = PeerView.createRdvAdvertisement(this.group.getPeerAdvertisement(), this.name);
        XMLDocument doc = (XMLDocument)radv.getDocument(MimeMediaType.XMLUTF8);
        TextDocumentMessageElement msge = new TextDocumentMessageElement("PeerView.PeerAdv", doc, null);
        msg.addMessageElement("jxta", msge);
        return msg;
    }

    public synchronized void processIncomingMessage(Message msg, EndpointAddress srcAddr, EndpointAddress dstAddr) {
        boolean isFromEdge;
        RdvAdvertisement radv;
        MessageElement me;
        boolean isResponse;
        block24: {
            Advertisement adv;
            isResponse = false;
            me = msg.getMessageElement("jxta", "PeerView.PeerAdv");
            if (me == null) {
                me = msg.getMessageElement("jxta", "PeerView.PeerAdv.Response");
                if (me == null) {
                    if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                        LOG.warning("Discarding damaged " + msg + ".");
                    }
                    return;
                }
                isResponse = true;
            }
            try {
                XMLDocument asDoc = (XMLDocument)StructuredDocumentFactory.newStructuredDocument(me);
                adv = AdvertisementFactory.newAdvertisement(asDoc);
            }
            catch (RuntimeException failed) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.log(Level.WARNING, "Failed building rdv advertisement from message element", failed);
                }
                return;
            }
            catch (IOException failed) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.log(Level.WARNING, "Failed building rdv advertisement from message element", failed);
                }
                return;
            }
            if (!(adv instanceof RdvAdvertisement)) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("Response does not contain radv (" + adv.getAdvertisementType() + ")");
                }
                return;
            }
            radv = (RdvAdvertisement)adv;
            if (null == radv.getRouteAdv()) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("Radv does not contain route");
                }
                return;
            }
            me = msg.getMessageElement("jxta", "PeerView.SrcRouteAdv");
            if (me != null) {
                try {
                    XMLDocument asDoc = (XMLDocument)StructuredDocumentFactory.newStructuredDocument(me);
                    Advertisement routeAdv = AdvertisementFactory.newAdvertisement(asDoc);
                    if (!(routeAdv instanceof RouteAdvertisement)) {
                        if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                            LOG.warning("Advertisement is not a RouteAdvertisement");
                        }
                    } else {
                        RouteAdvertisement rdvRouteAdv = radv.getRouteAdv().clone();
                        RouteAdvertisement.stichRoute(rdvRouteAdv, (RouteAdvertisement)routeAdv);
                        radv.setRouteAdv(rdvRouteAdv);
                    }
                }
                catch (RuntimeException failed) {
                    if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                        LOG.log(Level.WARNING, "Failed building route adv from message element", failed);
                    }
                }
                catch (IOException failed) {
                    if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block24;
                    LOG.log(Level.WARNING, "Failed building route adv from message element", failed);
                }
            }
        }
        me = null;
        if (this.group.getPeerID().equals(radv.getPeerID())) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Received a PeerView message about self. Discard.");
            }
            return;
        }
        boolean isFailure = msg.getMessageElement("jxta", "PeerView.Failure") != null;
        boolean isCached = msg.getMessageElement("jxta", "PeerView.Cached") != null;
        boolean bl = isFromEdge = msg.getMessageElement("jxta", "PeerView.EdgePeer") != null;
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            String srcPeer = srcAddr.toString();
            LOG.fine("[" + this.group.getPeerGroupID() + "] Received a" + (isCached ? " cached" : "") + (isResponse ? " response" : "") + (isFailure ? " failure" : "") + " message (" + msg.toString() + ")" + (isFromEdge ? " from edge" : "") + " regarding \"" + radv.getName() + "\" from " + srcPeer);
        }
        if (!isResponse || isFailure || isCached || isFromEdge) {
            return;
        }
        this.peerview.add(radv.getRouteAdv());
    }
}

