/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.TextElement;
import net.jxta.document.XMLDocument;
import net.jxta.id.IDFactory;
import net.jxta.impl.peergroup.StdPeerGroup;
import net.jxta.impl.peergroup.StdPeerGroupParamAdv;
import net.jxta.peergroup.PeerGroup;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.platform.ModuleClassID;
import net.jxta.platform.ModuleSpecID;
import net.jxta.protocol.ModuleClassAdvertisement;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.protocol.ModuleSpecAdvertisement;
import net.jxta.protocol.PipeAdvertisement;

public class AdvCooker {
    private static ModuleClassID buildModuleClassID(String uri) throws URISyntaxException {
        return (ModuleClassID)IDFactory.fromURI(new URI(uri));
    }

    private static ModuleSpecID buildModuleSpecID(String uri) throws URISyntaxException {
        return (ModuleSpecID)IDFactory.fromURI(new URI(uri));
    }

    public static ModuleClassAdvertisement buildModuleClassAdvertisement(ModuleClassID mcid, String serviceName, String serviceDescription) {
        ModuleClassAdvertisement mcadv = (ModuleClassAdvertisement)AdvertisementFactory.newAdvertisement(ModuleClassAdvertisement.getAdvertisementType());
        mcadv.setName(serviceName);
        mcadv.setDescription(serviceDescription);
        mcadv.setModuleClassID(mcid);
        return mcadv;
    }

    public static ModuleSpecAdvertisement buildModuleSpecAdvertisement(ModuleSpecID msid, String moduleSpecName, String moduleSpecDescription) {
        return AdvCooker.buildModuleSpecAdvertisement(msid, moduleSpecName, moduleSpecDescription, null, null, null, null, null, null, null);
    }

    public static ModuleSpecAdvertisement buildModuleSpecAdvertisement(ModuleSpecID msid, String moduleSpecName, String moduleSpecDescription, String creator, String version, String specURI) {
        return AdvCooker.buildModuleSpecAdvertisement(msid, moduleSpecName, moduleSpecDescription, creator, version, specURI, null, null, null, null);
    }

    public static ModuleSpecAdvertisement buildModuleSpecAdvertisement(ModuleSpecID msid, String moduleSpecName, String moduleSpecDescription, String creator, String version, String specURI, PipeAdvertisement pipeAdv, ModuleSpecID proxySpecID, ModuleSpecID authorizationSpecID, StructuredDocument param) {
        ModuleSpecAdvertisement msadv = (ModuleSpecAdvertisement)AdvertisementFactory.newAdvertisement(ModuleSpecAdvertisement.getAdvertisementType());
        msadv.setModuleSpecID(msid);
        msadv.setName(moduleSpecName);
        msadv.setDescription(moduleSpecDescription);
        msadv.setCreator(creator == null ? "jxta.org" : creator);
        msadv.setVersion(version == null ? "Version 2.0" : version);
        msadv.setSpecURI(specURI == null ? "http://www.jxta.org/" + moduleSpecName : specURI);
        if (pipeAdv != null) {
            msadv.setPipeAdvertisement(pipeAdv);
        }
        if (proxySpecID != null) {
            msadv.setProxySpecID(proxySpecID);
        }
        if (authorizationSpecID != null) {
            msadv.setAuthSpecID(authorizationSpecID);
        }
        if (param != null) {
            msadv.setParam(param);
        }
        return msadv;
    }

    public static XMLDocument buildCompat() {
        try {
            PeerGroup wpg = PeerGroup.globalRegistry.lookupInstance(PeerGroupID.worldPeerGroupID);
            ModuleImplAdvertisement implAdv = wpg.getAllPurposePeerGroupImplAdvertisement();
            wpg.unref();
            XMLDocument compat = (XMLDocument)implAdv.getCompat();
            return compat;
        }
        catch (Exception e) {
            return AdvCooker.buildCompat("JDK1.4.1", "V2.0 Ref Impl");
        }
    }

    public static XMLDocument buildCompat(String efmt, String bind) {
        XMLDocument doc = (XMLDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, "Comp");
        Object e = doc.createElement("Efmt", efmt);
        doc.appendChild(e);
        e = doc.createElement("Bind", bind);
        doc.appendChild(e);
        return doc;
    }

    public static ModuleImplAdvertisement buildModuleImplAdvertisement(ModuleSpecID msid, String code, Element compat) {
        ModuleImplAdvertisement miadv = (ModuleImplAdvertisement)AdvertisementFactory.newAdvertisement(ModuleImplAdvertisement.getAdvertisementType());
        miadv.setCompat(compat);
        miadv.setModuleSpecID(msid);
        miadv.setCode(code);
        miadv.setDescription(code + " Module, J2SE Implementation");
        miadv.setProvider("jxta.org");
        miadv.setUri("http://download.jxta.org");
        return miadv;
    }

    public static ModuleImplAdvertisement buildModuleImplAdvertisement(ModuleSpecID msid, String code, Element compat, String description, String provider, String uri) {
        ModuleImplAdvertisement miadv = AdvCooker.buildModuleImplAdvertisement(msid, code, compat);
        miadv.setDescription(description);
        miadv.setProvider(provider);
        miadv.setUri(uri);
        return miadv;
    }

    public static ModuleImplAdvertisement buildPeerGroupImplAdvertisement(StdPeerGroup parent, ModuleSpecID newGroupModuleSpecID, String newDescription, Map newServices) throws Exception {
        Object newApps = null;
        Object newProtos = null;
        AdvCooker.typeCheckKeys(newServices);
        AdvCooker.typeCheckValues(newServices);
        ModuleImplAdvertisement implAdv = parent.getAllPurposePeerGroupImplAdvertisement();
        implAdv.setDescription(newDescription);
        implAdv.setModuleSpecID(newGroupModuleSpecID);
        TextElement paramElement = (TextElement)((Object)implAdv.getParam());
        StdPeerGroupParamAdv paramAdv = new StdPeerGroupParamAdv(paramElement);
        Map services = paramAdv.getServices();
        AdvCooker.typeCheckKeys(services);
        services = AdvCooker.mergeTables(services, newServices);
        paramAdv.setServices(services);
        paramElement = (TextElement)((Object)paramAdv.getDocument(MimeMediaType.XMLUTF8));
        implAdv.setParam(paramElement);
        return implAdv;
    }

    public static ModuleImplAdvertisement buildPeerGroupImplAdvertisement(PeerGroup parent, ModuleSpecID newGroupModuleSpecID, String newDescription, Map newServices, Map newApps) throws Exception {
        Object newProtos = null;
        AdvCooker.typeCheckKeys(newServices);
        AdvCooker.typeCheckValues(newServices);
        AdvCooker.typeCheckKeys(newApps);
        AdvCooker.typeCheckValues(newApps);
        ModuleImplAdvertisement implAdv = parent.getAllPurposePeerGroupImplAdvertisement();
        implAdv.setDescription(newDescription);
        implAdv.setModuleSpecID(newGroupModuleSpecID);
        TextElement paramElement = (TextElement)((Object)implAdv.getParam());
        StdPeerGroupParamAdv paramAdv = new StdPeerGroupParamAdv(paramElement);
        Map services = paramAdv.getServices();
        AdvCooker.typeCheckKeys(services);
        services = AdvCooker.mergeTables(services, newServices);
        paramAdv.setServices(services);
        Map apps = paramAdv.getApps();
        AdvCooker.typeCheckKeys(apps);
        apps = AdvCooker.mergeTables(apps, newApps);
        paramAdv.setApps(apps);
        paramElement = (TextElement)((Object)paramAdv.getDocument(MimeMediaType.XMLUTF8));
        implAdv.setParam(paramElement);
        return implAdv;
    }

    public static ModuleImplAdvertisement buildPeerGroupImplAdvertisement(PeerGroup parent, ModuleSpecID newGroupModuleSpecID, String newDescription, Map newServices, Map newApps, Map newProtos) throws Exception {
        AdvCooker.typeCheckKeys(newServices);
        AdvCooker.typeCheckValues(newServices);
        AdvCooker.typeCheckKeys(newApps);
        AdvCooker.typeCheckValues(newApps);
        AdvCooker.typeCheckKeys(newProtos);
        AdvCooker.typeCheckValues(newProtos);
        ModuleImplAdvertisement implAdv = parent.getAllPurposePeerGroupImplAdvertisement();
        implAdv.setDescription(newDescription);
        implAdv.setModuleSpecID(newGroupModuleSpecID);
        TextElement paramElement = (TextElement)((Object)implAdv.getParam());
        StdPeerGroupParamAdv paramAdv = new StdPeerGroupParamAdv(paramElement);
        Map services = paramAdv.getServices();
        AdvCooker.typeCheckKeys(services);
        services = AdvCooker.mergeTables(services, newServices);
        paramAdv.setServices(services);
        Map apps = paramAdv.getApps();
        AdvCooker.typeCheckKeys(apps);
        apps = AdvCooker.mergeTables(apps, newApps);
        paramAdv.setApps(newApps);
        Map<ModuleClassID, Object> protos = paramAdv.getProtos();
        AdvCooker.typeCheckKeys(protos);
        apps = AdvCooker.mergeTables(protos, newProtos);
        paramAdv.setProtos(newProtos);
        paramElement = (TextElement)((Object)paramAdv.getDocument(MimeMediaType.XMLUTF8));
        implAdv.setParam(paramElement);
        return implAdv;
    }

    public static void typeCheckValues(Map moduleTable) {
        String badVal = "Module table value not a ModuleImplAdvertisement ";
        Iterator keys = moduleTable.keySet().iterator();
        while (keys.hasNext()) {
            Object value = moduleTable.get(keys.next());
            boolean legalValue = value instanceof ModuleImplAdvertisement;
            if (legalValue) continue;
            throw new IllegalArgumentException(badVal + value);
        }
    }

    public static void typeCheckKeys(Map moduleTable) {
        String badKey = "Module table key not a ModuleClassID ";
        for (Object key : moduleTable.keySet()) {
            boolean legalKey = key instanceof ModuleClassID;
            if (legalKey) continue;
            throw new IllegalArgumentException(badKey + key);
        }
    }

    private static Map mergeTables(Map oldServices, Map newServices) {
        HashMap mergedServices = new HashMap(oldServices);
        for (ModuleClassID key : newServices.keySet()) {
            for (ModuleClassID oldkey : oldServices.keySet()) {
                if (!oldkey.isOfSameBaseClass(key)) continue;
                mergedServices.remove(oldkey);
            }
            mergedServices.put(key, newServices.get(key));
        }
        return mergedServices;
    }
}

