/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.socket;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.SocketTimeoutException;
import java.util.LinkedList;
import java.util.Queue;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.StringMessageElement;
import net.jxta.socket.JxtaSocket;

class JxtaSocketInputStream
extends InputStream {
    protected static final MessageElement QUEUE_END = new StringMessageElement("Terminal", "Terminal", null);
    private long timeout = 60000L;
    private final JxtaSocket socket;
    protected final Queue<MessageElement> queue;
    protected final int queueSize;
    private InputStream currentMsgStream = null;

    JxtaSocketInputStream(JxtaSocket socket, int queueSize) {
        this.socket = socket;
        this.queueSize = queueSize;
        this.queue = new LinkedList<MessageElement>();
    }

    public synchronized int available() throws IOException {
        InputStream in = this.getCurrentStream(false);
        int result = in != null ? in.available() : 0;
        return result;
    }

    public synchronized int read() throws IOException {
        byte[] b = new byte[1];
        int result = 0;
        while (0 == result) {
            result = this.read(b, 0, 1);
        }
        if (-1 != result) {
            result = b[0];
        }
        return result;
    }

    public synchronized int read(byte[] b, int off, int len) throws IOException {
        int result;
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        while (true) {
            result = -1;
            InputStream in = this.getCurrentStream(true);
            if (null == in) {
                return -1;
            }
            result = in.read(b, off, len);
            if (0 == result) continue;
            if (result != -1) break;
            this.closeCurrentStream();
        }
        return result;
    }

    public synchronized void close() {
        this.queue.clear();
        this.closeCurrentStream();
        this.queue.offer(QUEUE_END);
        this.notify();
    }

    synchronized void softClose() {
        this.queue.offer(QUEUE_END);
        this.notify();
    }

    private InputStream getCurrentStream(boolean block) throws IOException {
        if (this.currentMsgStream == null) {
            long pollUntil;
            if (QUEUE_END == this.queue.peek()) {
                return null;
            }
            MessageElement me = null;
            long l = pollUntil = Long.MAX_VALUE == this.timeout ? Long.MAX_VALUE : System.currentTimeMillis() + this.timeout;
            while (pollUntil >= System.currentTimeMillis()) {
                try {
                    me = this.queue.poll();
                    if (null != me) break;
                    long sleepFor = pollUntil - System.currentTimeMillis();
                    if (sleepFor <= 0L) continue;
                    this.wait(sleepFor);
                }
                catch (InterruptedException woken) {
                    InterruptedIOException incomplete = new InterruptedIOException("Interrupted waiting for data.");
                    incomplete.initCause(woken);
                    incomplete.bytesTransferred = 0;
                    throw incomplete;
                }
            }
            if (block && null == me) {
                throw new SocketTimeoutException("Socket timeout during read.");
            }
            if (me != null) {
                this.currentMsgStream = me.getStream();
            }
        }
        return this.currentMsgStream;
    }

    private void closeCurrentStream() {
        if (this.currentMsgStream != null) {
            try {
                this.currentMsgStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.currentMsgStream = null;
        }
    }

    synchronized void enqueue(MessageElement element2) {
        if (this.queue.contains(QUEUE_END)) {
            return;
        }
        if (this.queue.size() < this.queueSize) {
            this.queue.offer(element2);
        }
        this.notify();
    }

    long getTimeout() {
        if (this.timeout < Long.MAX_VALUE) {
            return this.timeout;
        }
        return 0L;
    }

    void setTimeout(long timeout) {
        if (timeout < 0L) {
            throw new IllegalArgumentException("Negative timeout not allowed.");
        }
        if (0L == timeout) {
            timeout = Long.MAX_VALUE;
        }
        this.timeout = timeout;
    }
}

