/*
 * $Id:DefaultConfigContext.java 456 2008-01-05 21:56:57Z andreamedeghini $
 *
 * JAME is a Java real-time multi-thread fractal graphics platform
 * Copyright (C) 2001, 2008 Andrea Medeghini
 * andreamedeghini@users.sf.net
 * http://jame.sourceforge.net
 * http://sourceforge.net/projects/jame
 * http://jame.dev.java.net
 * http://jugbrescia.dev.java.net
 *
 * This file is part of JAME.
 *
 * JAME is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JAME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JAME.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package net.sf.jame.core.config;

/**
 * Default implementation of a configuration context.
 * 
 * @author Andrea Medeghini
 */
public class DefaultConfigContext implements ConfigContext {
	private ConfigContext context;
	private long timestamp;

	/**
	 * Constructs a new context.
	 */
	public DefaultConfigContext() {
		updateTimestamp();
	}

	/**
	 * @see net.sf.jame.core.config.ConfigContext#getTimestamp()
	 */
	public long getTimestamp() {
		return timestamp;
	}

	/**
	 * @see net.sf.jame.core.config.ConfigContext#updateTimestamp()
	 */
	public void updateTimestamp() {
		timestamp = System.currentTimeMillis();
		if (context != null) {
			context.updateTimestamp();
		}
	}

	/**
	 * @see net.sf.jame.core.config.ConfigContext#setParentConfigContext(net.sf.jame.core.config.ConfigContext)
	 */
	public void setParentConfigContext(final ConfigContext context) {
		this.context = context;
	}
}
