/*
 * $Id:SingleConfigElement.java 456 2008-01-05 21:56:57Z andreamedeghini $
 *
 * JAME is a Java real-time multi-thread fractal graphics platform
 * Copyright (C) 2001, 2008 Andrea Medeghini
 * andreamedeghini@users.sf.net
 * http://jame.sourceforge.net
 * http://sourceforge.net/projects/jame
 * http://jame.dev.java.net
 * http://jugbrescia.dev.java.net
 *
 * This file is part of JAME.
 *
 * JAME is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JAME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JAME.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package net.sf.jame.core.config;

/**
 * Value element.
 * 
 * @author Andrea Medeghini
 */
public class SingleConfigElement<T extends ConfigElement> extends ValueConfigElement<T> {
	private static final long serialVersionUID = 1L;

	/**
	 * Constructs a new element.
	 */
	public SingleConfigElement(final String configElementId) {
		super(configElementId);
	}

	/**
	 * @see net.sf.jame.core.config.AbstractConfigElement#setContext(net.sf.jame.core.config.ConfigContext)
	 */
	@Override
	public void setContext(final ConfigContext context) {
		super.setContext(context);
		if (getValue() != null) {
			getValue().setContext(context);
		}
	}

	/**
	 * Ses the value.
	 * 
	 * @param value the value to set.
	 */
	@Override
	public void setValue(final T value) {
		if (value != null) {
			if (checkContext()) {
				value.setContext(getContext());
			}
		}
		super.setValue(value);
	}

	/**
	 * @see java.lang.Object#clone()
	 */
	@Override
	@SuppressWarnings("unchecked")
	public SingleConfigElement<T> clone() {
		final SingleConfigElement<T> element = new SingleConfigElement<T>(getClassId());
		element.setValue((T) getValue().clone());
		return element;
	}
}
