/*
 * $Id:ColorChooserDialog.java 456 2008-01-05 21:56:57Z andreamedeghini $
 *
 * JAME is a Java real-time multi-thread fractal graphics platform
 * Copyright (C) 2001, 2008 Andrea Medeghini
 * andreamedeghini@users.sf.net
 * http://jame.sourceforge.net
 * http://sourceforge.net/projects/jame
 * http://jame.dev.java.net
 * http://jugbrescia.dev.java.net
 *
 * This file is part of JAME.
 *
 * JAME is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JAME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JAME.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package net.sf.jame.core.swing.color;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

import net.sf.jame.core.swing.CoreSwingResources;
import net.sf.jame.core.swing.util.GUIFactory;

/**
 * @author Andrea Medeghini
 */
public class ColorChooserDialog extends JDialog {
	private static final String STRING_APPLY_LABEL = "colorChooser.apply.label";
	private static final String STRING_CANCEL_LABEL = "colorChooser.cancel.label";
	private static final String STRING_APPLY_TOOLTIP = "colorChooser.apply.tooltip";
	private static final String STRING_CANCEL_TOOLTIP = "colorChooser.cancel.tooltip";
	private static final long serialVersionUID = 1L;
	private final ColorChooser chooser;
	private Color copy;

	/**
	 * @param c
	 * @param title
	 * @param color
	 */
	public ColorChooserDialog(final JComponent c, final String title, final Color color) {
		chooser = new ColorChooser(color);
		getContentPane().setLayout(new BorderLayout());
		getContentPane().add(chooser, BorderLayout.CENTER);
		getContentPane().add(createButtonsPanel(), BorderLayout.SOUTH);
		addWindowListener(new DialogListener());
		copy = chooser.getColor();
		pack();
		setTitle(title);
		setLocationRelativeTo(c);
		setResizable(false);
		setModal(true);
	}

	/**
	 * @return
	 */
	public Color getColor() {
		return chooser.getColor();
	}

	/**
	 * Creates a new buttons panel.
	 * 
	 * @return the buttons panel.
	 */
	protected JPanel createButtonsPanel() {
		final JPanel panel = new JPanel(new FlowLayout(FlowLayout.CENTER));
		final JButton applyButton = GUIFactory.createButton(new ApplyButtonAction(), CoreSwingResources.getInstance().getString(ColorChooserDialog.STRING_APPLY_TOOLTIP));
		panel.add(applyButton);
		final JButton cancelButton = GUIFactory.createButton(new CancelButtonAction(), CoreSwingResources.getInstance().getString(ColorChooserDialog.STRING_CANCEL_TOOLTIP));
		panel.add(cancelButton);
		return panel;
	}

	private void doApply() {
		copy = chooser.getColor();
	}

	private void doCancel() {
		chooser.setColor(copy);
	}

	private class ApplyButtonAction extends AbstractAction {
		private static final long serialVersionUID = 1L;

		/**
		 * 
		 */
		public ApplyButtonAction() {
			super(CoreSwingResources.getInstance().getString(ColorChooserDialog.STRING_APPLY_LABEL), null);
		}

		/**
		 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
		 */
		public void actionPerformed(final ActionEvent e) {
			doApply();
			SwingUtilities.invokeLater(new DialogClose());
		}
	}

	private class CancelButtonAction extends AbstractAction {
		private static final long serialVersionUID = 1L;

		/**
		 * 
		 */
		public CancelButtonAction() {
			super(CoreSwingResources.getInstance().getString(ColorChooserDialog.STRING_CANCEL_LABEL), null);
		}

		/**
		 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
		 */
		public void actionPerformed(final ActionEvent e) {
			doCancel();
			SwingUtilities.invokeLater(new DialogClose());
		}
	}

	private class DialogListener extends WindowAdapter {
		/**
		 * @see java.awt.event.WindowAdapter#windowClosing(java.awt.event.WindowEvent)
		 */
		@Override
		public void windowClosing(final WindowEvent e) {
			doCancel();
			SwingUtilities.invokeLater(new DialogClose());
		}
	}

	private class DialogClose implements Runnable {
		/**
		 * @see java.lang.Runnable#run()
		 */
		public void run() {
			setVisible(false);
		}
	}
}
