/*
 * $Id:GrayGradientRendererConfig.java 456 2008-01-05 21:56:57Z andreamedeghini $
 *
 * JAME is a Java real-time multi-thread fractal graphics platform
 * Copyright (C) 2001, 2008 Andrea Medeghini
 * andreamedeghini@users.sf.net
 * http://jame.sourceforge.net
 * http://sourceforge.net/projects/jame
 * http://jame.dev.java.net
 * http://jugbrescia.dev.java.net
 *
 * This file is part of JAME.
 *
 * JAME is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JAME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JAME.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package net.sf.jame.mandelbrot.extensions.palette;

import net.sf.jame.core.util.Palette;
import net.sf.jame.mandelbrot.util.DefaultRenderedPalette;
import net.sf.jame.twister.common.PaletteElement;

/**
 * @author Andrea Medeghini
 */
public final class GrayGradientRendererConfig extends AbstractPaletteRendererConfig {
	private static final long serialVersionUID = 1L;
	private final Palette palette = getDefaultPalette();
	private final PaletteElement<Palette> paletteElement = new PaletteElement<Palette>("Palette", palette);

	/**
	 * @return
	 */
	@Override
	public Palette getPalette() {
		return palette;
	}

	/**
	 * @return
	 */
	public final Palette getDefaultPalette() {
		return new DefaultRenderedPalette();
	}

	/**
	 * @see net.sf.jame.mandelbrot.palette.extension.PaletteRendererExtensionConfig#getPaletteElement()
	 */
	@Override
	public PaletteElement<?> getPaletteElement() {
		return paletteElement;
	}

	/**
	 * @return
	 */
	@Override
	public GrayGradientRendererConfig clone() {
		final GrayGradientRendererConfig config = new GrayGradientRendererConfig();
		return config;
	}

	/**
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(final Object obj) {
		if (this == obj) {
			return true;
		}
		if (obj == null) {
			return false;
		}
		return true;
	}
}
