/*
 * $Id:PaletteRendererConfigElement.java 456 2008-01-05 21:56:57Z andreamedeghini $
 *
 * JAME is a Java real-time multi-thread fractal graphics platform
 * Copyright (C) 2001, 2008 Andrea Medeghini
 * andreamedeghini@users.sf.net
 * http://jame.sourceforge.net
 * http://sourceforge.net/projects/jame
 * http://jame.dev.java.net
 * http://jugbrescia.dev.java.net
 *
 * This file is part of JAME.
 *
 * JAME is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JAME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JAME.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package net.sf.jame.mandelbrot.palette;

import net.sf.jame.core.config.AbstractConfigElement;
import net.sf.jame.core.config.ConfigContext;
import net.sf.jame.core.extension.ConfigurableExtensionReference;
import net.sf.jame.core.extension.ConfigurableReferenceElement;
import net.sf.jame.mandelbrot.palette.extension.PaletteRendererExtensionConfig;
import net.sf.jame.twister.util.ConfigurableExtensionConfigElement;

/**
 * @author Andrea Medeghini
 */
public class PaletteRendererConfigElement extends AbstractConfigElement implements ConfigurableReferenceElement<PaletteRendererExtensionConfig> {
	private static final long serialVersionUID = 1L;
	public static final String CLASS_ID = "PaletteRenderer";
	private final ConfigurableExtensionConfigElement<PaletteRendererExtensionConfig> extensionElement = new ConfigurableExtensionConfigElement<PaletteRendererExtensionConfig>();

	/**
	 * Constructs a new element.
	 */
	public PaletteRendererConfigElement() {
		super(PaletteRendererConfigElement.CLASS_ID);
	}

	/**
	 * @see net.sf.jame.twister.util.ConfigurableExtensionConfigElement#setContext(net.sf.jame.core.config.ConfigContext)
	 */
	@Override
	public void setContext(final ConfigContext context) {
		super.setContext(context);
		extensionElement.setContext(context);
	}

	/**
	 * @return
	 */
	@Override
	public PaletteRendererConfigElement clone() {
		final PaletteRendererConfigElement element = new PaletteRendererConfigElement();
		if (getReference() != null) {
			element.setReference(getReference().clone());
		}
		return element;
	}

	/**
	 * @return
	 */
	public ConfigurableExtensionReference<PaletteRendererExtensionConfig> getReference() {
		return extensionElement.getReference();
	}

	/**
	 * @param reference
	 */
	public void setReference(final ConfigurableExtensionReference<PaletteRendererExtensionConfig> reference) {
		extensionElement.setReference(reference);
	}

	/**
	 * @return
	 */
	public ConfigurableExtensionConfigElement<PaletteRendererExtensionConfig> getExtensionElement() {
		return extensionElement;
	}

	/**
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(final Object obj) {
		if (this == obj) {
			return true;
		}
		if (obj == null) {
			return false;
		}
		final PaletteRendererConfigElement other = (PaletteRendererConfigElement) obj;
		if (extensionElement == null) {
			if (other.extensionElement != null) {
				return false;
			}
		}
		else if (!extensionElement.equals(other.extensionElement)) {
			return false;
		}
		return true;
	}

	/**
	 * @see net.sf.jame.core.config.AbstractConfigElement#dispose()
	 */
	@Override
	public void dispose() {
		extensionElement.dispose();
		super.dispose();
	}
}
