/*
 * $Id:View.java 480 2008-01-24 21:15:43Z andreamedeghini $
 *
 * JAME is a Java real-time multi-thread fractal graphics platform
 * Copyright (C) 2001, 2008 Andrea Medeghini
 * andreamedeghini@users.sf.net
 * http://jame.sourceforge.net
 * http://sourceforge.net/projects/jame
 * http://jame.dev.java.net
 * http://jugbrescia.dev.java.net
 *
 * This file is part of JAME.
 *
 * JAME is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JAME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JAME.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package net.sf.jame.twister;

import java.io.Serializable;

/**
 * @author Andrea Medeghini
 */
public class View implements Serializable, Cloneable {
	private static final long serialVersionUID = 1L;
	private final DoubleVector4D position;
	private final DoubleVector4D rotation;
	private final IntegerVector4D status;

	/**
	 * @param status
	 * @param position
	 * @param rotation
	 */
	public View(final IntegerVector4D status, final DoubleVector4D position, final DoubleVector4D rotation) {
		this.status = status;
		this.position = position;
		this.rotation = rotation;
	}

	/**
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		final StringBuilder builder = new StringBuilder();
		builder.append("status = ");
		builder.append(status);
		builder.append(", position = ");
		builder.append(position);
		builder.append(", rotation = ");
		builder.append(rotation);
		return builder.toString();
	}

	/**
	 * @return the dynamic
	 */
	public IntegerVector4D getStatus() {
		return status;
	}

	/**
	 * @return the position
	 */
	public DoubleVector4D getPosition() {
		return position;
	}

	/**
	 * @return the rotation
	 */
	public DoubleVector4D getRotation() {
		return rotation;
	}

	/**
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(final Object obj) {
		if (this == obj) {
			return true;
		}
		if (obj == null) {
			return false;
		}
		final View other = (View) obj;
		if (position == null) {
			if (other.position != null) {
				return false;
			}
		}
		else if (!position.equals(other.position)) {
			return false;
		}
		if (rotation == null) {
			if (other.rotation != null) {
				return false;
			}
		}
		else if (!rotation.equals(other.rotation)) {
			return false;
		}
		if (status == null) {
			if (other.status != null) {
				return false;
			}
		}
		else if (!status.equals(other.status)) {
			return false;
		}
		return true;
	}

	/**
	 * @see java.lang.Object#clone()
	 */
	@Override
	public View clone() {
		return new View(status, position, rotation);
	}
}
