/*
 * $Id:ConfigurableExtensionConfigElement.java 456 2008-01-05 21:56:57Z andreamedeghini $
 *
 * JAME is a Java real-time multi-thread fractal graphics platform
 * Copyright (C) 2001, 2008 Andrea Medeghini
 * andreamedeghini@users.sf.net
 * http://jame.sourceforge.net
 * http://sourceforge.net/projects/jame
 * http://jame.dev.java.net
 * http://jugbrescia.dev.java.net
 *
 * This file is part of JAME.
 *
 * JAME is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JAME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JAME.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package net.sf.jame.twister.util;

import net.sf.jame.core.config.AbstractConfigElement;
import net.sf.jame.core.config.ConfigContext;
import net.sf.jame.core.config.ValueChangeEvent;
import net.sf.jame.core.extension.ConfigurableExtensionReference;
import net.sf.jame.core.extension.ExtensionConfig;

/**
 * @author Andrea Medeghini
 */
public class ConfigurableExtensionConfigElement<T extends ExtensionConfig> extends AbstractConfigElement implements ExtensionConfigElementEvents {
	private static final long serialVersionUID = 1L;
	private ConfigurableExtensionReference<T> reference;
	public static final String CLASS_ID = "ConfigurableExtensionReferenceElement";

	/**
	 * 
	 */
	public ConfigurableExtensionConfigElement() {
		super(ConfigurableExtensionConfigElement.CLASS_ID);
	}

	/**
	 * Returns the image reference.
	 * 
	 * @return the image reference.
	 */
	public ConfigurableExtensionReference<T> getReference() {
		return this.reference;
	}

	/**
	 * Sets the image reference.
	 * 
	 * @param reference the image reference to set.
	 */
	public void setReference(final ConfigurableExtensionReference<T> reference) {
		final ConfigurableExtensionReference<T> prevReference = this.getReference();
		this.reference = reference;
		if (checkContext()) {
			if ((reference != null) && (reference.getExtensionConfig() != null)) {
				reference.getExtensionConfig().setContext(getContext());
			}
			fireConfigChanged(new ValueChangeEvent(ExtensionConfigElementEvents.EXTENSION_REFERENCE_CHANGED, getContext().getTimestamp(), reference, prevReference));
		}
	}

	/**
	 * @see net.sf.jame.core.config.AbstractConfigElement#setContext(net.sf.jame.core.config.ConfigContext)
	 */
	@Override
	public void setContext(final ConfigContext context) {
		super.setContext(context);
		if ((this.reference != null) && (this.reference.getExtensionConfig() != null)) {
			this.reference.getExtensionConfig().setContext(getContext());
		}
	}

	/**
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@SuppressWarnings("unchecked")
	@Override
	public boolean equals(final Object obj) {
		return ((reference == null) && (((ConfigurableExtensionConfigElement<T>) obj).reference == null)) || (reference != null && reference.equals(((ConfigurableExtensionConfigElement<T>) obj).reference));
	}

	/**
	 * @see java.lang.Object#clone()
	 */
	@SuppressWarnings("unchecked")
	@Override
	public ConfigurableExtensionConfigElement<T> clone() {
		final ConfigurableExtensionConfigElement element = new ConfigurableExtensionConfigElement();
		if (getReference() != null) {
			element.setReference(getReference());
		}
		return element;
	}
}
