/*
 * $Id:ExtensionConfigElement.java 456 2008-01-05 21:56:57Z andreamedeghini $
 *
 * JAME is a Java real-time multi-thread fractal graphics platform
 * Copyright (C) 2001, 2008 Andrea Medeghini
 * andreamedeghini@users.sf.net
 * http://jame.sourceforge.net
 * http://sourceforge.net/projects/jame
 * http://jame.dev.java.net
 * http://jugbrescia.dev.java.net
 *
 * This file is part of JAME.
 *
 * JAME is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JAME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JAME.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package net.sf.jame.twister.util;

import net.sf.jame.core.config.AbstractConfigElement;
import net.sf.jame.core.config.ValueChangeEvent;
import net.sf.jame.core.extension.ExtensionReference;

/**
 * @author Andrea Medeghini
 */
public class ExtensionConfigElement extends AbstractConfigElement implements ExtensionConfigElementEvents {
	private static final long serialVersionUID = 1L;
	private ExtensionReference reference;
	public static final String CLASS_ID = "ExtensionReferenceElement";

	/**
	 * 
	 */
	public ExtensionConfigElement() {
		super(ExtensionConfigElement.CLASS_ID);
	}

	/**
	 * Returns the image reference.
	 * 
	 * @return the image reference.
	 */
	public ExtensionReference getReference() {
		return reference;
	}

	/**
	 * Sets the image reference.
	 * 
	 * @param reference the image reference to set.
	 */
	public void setReference(final ExtensionReference reference) {
		final ExtensionReference prevReference = getReference();
		this.reference = reference;
		if (checkContext()) {
			fireConfigChanged(new ValueChangeEvent(ExtensionConfigElementEvents.EXTENSION_REFERENCE_CHANGED, getContext().getTimestamp(), reference, prevReference));
		}
	}

	/**
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(final Object obj) {
		return ((reference == null) && (((ExtensionConfigElement) obj).reference == null)) || reference.equals(((ExtensionConfigElement) obj).reference);
	}

	/**
	 * @see java.lang.Object#clone()
	 */
	@Override
	public ExtensionConfigElement clone() {
		final ExtensionConfigElement element = new ExtensionConfigElement();
		if (getReference() != null) {
			element.setReference(getReference());
		}
		return element;
	}
}
