/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.mbeanserver;

import com.sun.jmx.mbeanserver.ModifiableClassLoaderRepository;
import com.sun.jmx.trace.Trace;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;
import javax.management.ObjectName;
import javax.management.loading.PrivateClassLoader;

public final class ClassLoaderRepositorySupport
implements ModifiableClassLoaderRepository {
    private static final LoaderEntry[] EMPTY_LOADER_ARRAY = new LoaderEntry[0];
    private LoaderEntry[] loaders = EMPTY_LOADER_ARRAY;
    private final Hashtable search = new Hashtable(10);
    private final Hashtable loadersWithNames = new Hashtable(10);
    private static final String dbgTag = "ClassLoaderRepositorySupport";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean add(ObjectName name, ClassLoader cl) {
        ClassLoaderRepositorySupport classLoaderRepositorySupport = this;
        synchronized (classLoaderRepositorySupport) {
            ArrayList<LoaderEntry> l = new ArrayList<LoaderEntry>(Arrays.asList(this.loaders));
            l.add(new LoaderEntry(name, cl));
            this.loaders = l.toArray(EMPTY_LOADER_ARRAY);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean remove(ObjectName name, ClassLoader cl) {
        ClassLoaderRepositorySupport classLoaderRepositorySupport = this;
        synchronized (classLoaderRepositorySupport) {
            int size = this.loaders.length;
            for (int i = 0; i < size; ++i) {
                boolean match;
                LoaderEntry entry = this.loaders[i];
                boolean bl = name == null ? cl == entry.loader : (match = name.equals(entry.name));
                if (!match) continue;
                LoaderEntry[] newloaders = new LoaderEntry[size - 1];
                System.arraycopy(this.loaders, 0, newloaders, 0, i);
                System.arraycopy(this.loaders, i + 1, newloaders, i, size - 1 - i);
                this.loaders = newloaders;
                return true;
            }
            return false;
        }
    }

    public final Class loadClass(String className) throws ClassNotFoundException {
        return this.loadClass(this.loaders, className, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Class loadClassWithout(ClassLoader without, String className) throws ClassNotFoundException {
        if (ClassLoaderRepositorySupport.isTraceOn()) {
            ClassLoaderRepositorySupport.trace("loadClassWithout", className + "\twithout " + without);
        }
        if (without == null) {
            return this.loadClass(this.loaders, className, null, null);
        }
        this.startValidSearch(without, className);
        try {
            Class clazz = this.loadClass(this.loaders, className, without, null);
            return clazz;
        }
        finally {
            this.stopValidSearch(without, className);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Class loadClassBefore(ClassLoader stop, String className) throws ClassNotFoundException {
        if (ClassLoaderRepositorySupport.isTraceOn()) {
            ClassLoaderRepositorySupport.trace("loadClassBefore", className + "\tbefore " + stop);
        }
        if (stop == null) {
            return this.loadClass(this.loaders, className, null, null);
        }
        this.startValidSearch(stop, className);
        try {
            Class clazz = this.loadClass(this.loaders, className, null, stop);
            return clazz;
        }
        finally {
            this.stopValidSearch(stop, className);
        }
    }

    private final Class loadClass(LoaderEntry[] list, String className, ClassLoader without, ClassLoader stop) throws ClassNotFoundException {
        int size = list.length;
        for (int i = 0; i < size; ++i) {
            try {
                ClassLoader cl = list[i].loader;
                if (cl == null) {
                    return Class.forName(className, false, null);
                }
                if (cl == without) continue;
                if (cl == stop) break;
                if (ClassLoaderRepositorySupport.isTraceOn()) {
                    ClassLoaderRepositorySupport.trace("loadClass", "trying loader = " + cl);
                }
                return cl.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        throw new ClassNotFoundException(className);
    }

    private final synchronized void startValidSearch(ClassLoader aloader, String className) throws ClassNotFoundException {
        Vector<ClassLoader> excluded = (Vector<ClassLoader>)this.search.get(className);
        if (excluded != null && excluded.contains(aloader)) {
            if (ClassLoaderRepositorySupport.isTraceOn()) {
                ClassLoaderRepositorySupport.trace("startValidSearch", "already requested loader=" + aloader + " class= " + className);
            }
            throw new ClassNotFoundException(className);
        }
        if (excluded == null) {
            excluded = new Vector<ClassLoader>(1);
            this.search.put(className, excluded);
        }
        excluded.addElement(aloader);
        if (ClassLoaderRepositorySupport.isTraceOn()) {
            ClassLoaderRepositorySupport.trace("startValidSearch", "loader=" + aloader + " class= " + className);
        }
    }

    private final synchronized void stopValidSearch(ClassLoader aloader, String className) {
        Vector excluded = (Vector)this.search.get(className);
        if (excluded != null) {
            excluded.removeElement(aloader);
            if (ClassLoaderRepositorySupport.isTraceOn()) {
                ClassLoaderRepositorySupport.trace("stopValidSearch", "loader=" + aloader + " class= " + className);
            }
        }
    }

    public final void addClassLoader(ClassLoader loader) {
        this.add(null, loader);
    }

    public final void removeClassLoader(ClassLoader loader) {
        this.remove(null, loader);
    }

    public final synchronized void addClassLoader(ObjectName name, ClassLoader loader) {
        this.loadersWithNames.put(name, loader);
        if (!(loader instanceof PrivateClassLoader)) {
            this.add(name, loader);
        }
    }

    public final synchronized void removeClassLoader(ObjectName name) {
        ClassLoader loader = (ClassLoader)this.loadersWithNames.remove(name);
        if (!(loader instanceof PrivateClassLoader)) {
            this.remove(name, loader);
        }
    }

    public final ClassLoader getClassLoader(ObjectName name) {
        return (ClassLoader)this.loadersWithNames.get(name);
    }

    private static boolean isTraceOn() {
        return Trace.isSelected(1, 1);
    }

    private static void trace(String clz, String func, String info) {
        Trace.send(1, 1, clz, func, info);
    }

    private static void trace(String func, String info) {
        ClassLoaderRepositorySupport.trace(dbgTag, func, info);
    }

    private static boolean isDebugOn() {
        return Trace.isSelected(2, 1);
    }

    private static void debug(String clz, String func, String info) {
        Trace.send(2, 1, clz, func, info);
    }

    private static void debug(String func, String info) {
        ClassLoaderRepositorySupport.debug(dbgTag, func, info);
    }

    private static class LoaderEntry {
        ObjectName name;
        ClassLoader loader;

        LoaderEntry(ObjectName name, ClassLoader loader) {
            this.name = name;
            this.loader = loader;
        }
    }
}

