/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import javax.management.BadAttributeValueExpException;
import javax.management.BadBinaryOpValueExpException;
import javax.management.BadStringOperationException;
import javax.management.InvalidApplicationException;
import javax.management.NumericValueExp;
import javax.management.ObjectName;
import javax.management.Query;
import javax.management.QueryEval;
import javax.management.StringValueExp;
import javax.management.ValueExp;

class BinaryOpValueExp
extends QueryEval
implements ValueExp {
    private static final long serialVersionUID = 1216286847881456786L;
    private int op;
    private ValueExp exp1;
    private ValueExp exp2;

    public BinaryOpValueExp() {
    }

    public BinaryOpValueExp(int o, ValueExp v1, ValueExp v2) {
        this.op = o;
        this.exp1 = v1;
        this.exp2 = v2;
    }

    public int getOperator() {
        return this.op;
    }

    public ValueExp getLeftValue() {
        return this.exp1;
    }

    public ValueExp getRightValue() {
        return this.exp2;
    }

    public ValueExp apply(ObjectName name) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
        ValueExp val1 = this.exp1.apply(name);
        ValueExp val2 = this.exp2.apply(name);
        boolean numeric = val1 instanceof NumericValueExp;
        if (numeric) {
            if (((NumericValueExp)val1).isLong()) {
                long lval1 = ((NumericValueExp)val1).longValue();
                long lval2 = ((NumericValueExp)val2).longValue();
                switch (this.op) {
                    case 0: {
                        return Query.value(lval1 + lval2);
                    }
                    case 2: {
                        return Query.value(lval1 * lval2);
                    }
                    case 1: {
                        return Query.value(lval1 - lval2);
                    }
                    case 3: {
                        return Query.value(lval1 / lval2);
                    }
                }
            } else {
                double dval1 = ((NumericValueExp)val1).doubleValue();
                double dval2 = ((NumericValueExp)val2).doubleValue();
                switch (this.op) {
                    case 0: {
                        return Query.value(dval1 + dval2);
                    }
                    case 2: {
                        return Query.value(dval1 * dval2);
                    }
                    case 1: {
                        return Query.value(dval1 - dval2);
                    }
                    case 3: {
                        return Query.value(dval1 / dval2);
                    }
                }
            }
        } else {
            String sval1 = ((StringValueExp)val1).getValue();
            String sval2 = ((StringValueExp)val2).getValue();
            switch (this.op) {
                case 0: {
                    return new StringValueExp(sval1 + sval2);
                }
            }
            throw new BadStringOperationException(this.opString());
        }
        throw new BadBinaryOpValueExpException(this);
    }

    public String toString() {
        try {
            return this.exp1 + " " + this.opString() + " " + this.exp2;
        }
        catch (BadBinaryOpValueExpException ex) {
            return "invalid expression";
        }
    }

    private String opString() throws BadBinaryOpValueExpException {
        switch (this.op) {
            case 0: {
                return "+";
            }
            case 2: {
                return "*";
            }
            case 1: {
                return "-";
            }
            case 3: {
                return "/";
            }
        }
        throw new BadBinaryOpValueExpException(this);
    }
}

