/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import com.sun.jmx.trace.Trace;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Map;
import java.util.WeakHashMap;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;

public class MBeanInfo
implements Cloneable,
Serializable {
    static final long serialVersionUID = -6451021435135161911L;
    private final String description;
    private final String className;
    private final MBeanAttributeInfo[] attributes;
    private final MBeanOperationInfo[] operations;
    private final MBeanConstructorInfo[] constructors;
    private final MBeanNotificationInfo[] notifications;
    private transient int hashCode;
    private final transient boolean immutable;
    private static final Map immutability = new WeakHashMap();
    static /* synthetic */ Class class$javax$management$MBeanInfo;

    public MBeanInfo(String className, String description, MBeanAttributeInfo[] attributes, MBeanConstructorInfo[] constructors, MBeanOperationInfo[] operations, MBeanNotificationInfo[] notifications) throws IllegalArgumentException {
        MBeanInfo.mustBeValidMBeanTypeName(className);
        this.className = className;
        this.description = description;
        if (attributes == null || attributes.length == 0) {
            attributes = MBeanAttributeInfo.NO_ATTRIBUTES;
        }
        this.attributes = attributes;
        if (operations == null || operations.length == 0) {
            operations = MBeanOperationInfo.NO_OPERATIONS;
        }
        this.operations = operations;
        if (constructors == null || constructors.length == 0) {
            constructors = MBeanConstructorInfo.NO_CONSTRUCTORS;
        }
        this.constructors = constructors;
        if (notifications == null || notifications.length == 0) {
            notifications = MBeanNotificationInfo.NO_NOTIFICATIONS;
        }
        this.notifications = notifications;
        this.immutable = MBeanInfo.isImmutableClass(this.getClass(), class$javax$management$MBeanInfo == null ? (class$javax$management$MBeanInfo = MBeanInfo.class$("javax.management.MBeanInfo")) : class$javax$management$MBeanInfo);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public String getClassName() {
        return this.className;
    }

    public String getDescription() {
        return this.description;
    }

    public MBeanAttributeInfo[] getAttributes() {
        if (this.attributes.length == 0) {
            return this.attributes;
        }
        return (MBeanAttributeInfo[])this.attributes.clone();
    }

    private MBeanAttributeInfo[] fastGetAttributes() {
        if (this.immutable) {
            return this.attributes;
        }
        return this.getAttributes();
    }

    public MBeanOperationInfo[] getOperations() {
        if (this.operations.length == 0) {
            return this.operations;
        }
        return (MBeanOperationInfo[])this.operations.clone();
    }

    private MBeanOperationInfo[] fastGetOperations() {
        if (this.immutable) {
            return this.operations;
        }
        return this.getOperations();
    }

    public MBeanConstructorInfo[] getConstructors() {
        if (this.constructors.length == 0) {
            return this.constructors;
        }
        return (MBeanConstructorInfo[])this.constructors.clone();
    }

    private MBeanConstructorInfo[] fastGetConstructors() {
        if (this.immutable) {
            return this.constructors;
        }
        return this.getConstructors();
    }

    public MBeanNotificationInfo[] getNotifications() {
        if (this.notifications.length == 0) {
            return this.notifications;
        }
        return (MBeanNotificationInfo[])this.notifications.clone();
    }

    private MBeanNotificationInfo[] fastGetNotifications() {
        if (this.immutable) {
            return this.notifications;
        }
        return this.getNotifications();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MBeanInfo)) {
            return false;
        }
        MBeanInfo p = (MBeanInfo)o;
        if (!p.getClassName().equals(this.getClassName()) || !p.getDescription().equals(this.getDescription())) {
            return false;
        }
        return Arrays.equals(p.fastGetAttributes(), this.fastGetAttributes()) && Arrays.equals(p.fastGetOperations(), this.fastGetOperations()) && Arrays.equals(p.fastGetConstructors(), this.fastGetConstructors()) && Arrays.equals(p.fastGetNotifications(), this.fastGetNotifications());
    }

    public int hashCode() {
        if (this.hashCode != 0) {
            return this.hashCode;
        }
        this.hashCode = this.getClassName().hashCode() ^ MBeanInfo.arrayHashCode(this.fastGetAttributes()) ^ MBeanInfo.arrayHashCode(this.fastGetOperations()) ^ MBeanInfo.arrayHashCode(this.fastGetConstructors()) ^ MBeanInfo.arrayHashCode(this.fastGetNotifications());
        return this.hashCode;
    }

    private static int arrayHashCode(Object[] array) {
        int hash = 0;
        for (int i = 0; i < array.length; ++i) {
            hash ^= array[i].hashCode();
        }
        return hash;
    }

    static boolean isValidJavaIdentifier(String s) {
        if (s == null) {
            return false;
        }
        int len = s.length();
        if (len == 0 || !Character.isJavaIdentifierStart(s.charAt(0))) {
            return false;
        }
        for (int i = 1; i < len; ++i) {
            if (Character.isJavaIdentifierPart(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    static boolean isValidJavaTypeName(String s) {
        int i;
        if (s == null) {
            return false;
        }
        int len = s.length();
        for (i = 0; i < len && s.charAt(i) == '['; ++i) {
        }
        if (i == len) {
            return false;
        }
        if (i == 0) {
            return MBeanInfo.isValidJavaTypeIdentifier(s);
        }
        char c = s.charAt(i);
        switch (c) {
            case 'L': {
                if (i < len - 1 && s.charAt(len - 1) == ';') {
                    return MBeanInfo.isValidJavaTypeIdentifier(s.substring(i, len - 1));
                }
                return false;
            }
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': {
                return i == len - 1;
            }
        }
        return false;
    }

    static boolean isValidJavaTypeIdentifier(String s) {
        if (s == null) {
            return false;
        }
        int len = s.length();
        boolean needLetter = true;
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (needLetter) {
                if (!Character.isJavaIdentifierStart(c)) {
                    return false;
                }
                needLetter = false;
                continue;
            }
            if (c == '.') {
                needLetter = true;
                continue;
            }
            if (Character.isJavaIdentifierPart(c)) continue;
            return false;
        }
        return !needLetter;
    }

    static void mustBeValidMBeanTypeName(String s) {
        if (!MBeanInfo.isValidJavaTypeIdentifier(s)) {
            Trace.fine("javax.management.misc", "MBeanInfo: Not a valid Java MBean type name: " + s);
        }
    }

    static void mustBeValidJavaTypeName(String s) {
        if (!MBeanInfo.isValidJavaTypeName(s)) {
            Trace.warning("javax.management.misc", "MBeanInfo: Not a valid Java type name: " + s);
        }
    }

    static void mustBeValidJavaIdentifier(String s) {
        if (!MBeanInfo.isValidJavaIdentifier(s)) {
            Trace.fine("javax.management.misc", "MBeanInfo: Not a valid Java identifier: " + s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isImmutableClass(Class subclass, Class immutableClass) {
        if (subclass == immutableClass) {
            return true;
        }
        Map map = immutability;
        synchronized (map) {
            Boolean immutable = (Boolean)immutability.get(subclass);
            if (immutable == null) {
                try {
                    ImmutabilityAction immutabilityAction = new ImmutabilityAction(subclass, immutableClass);
                    immutable = (Boolean)AccessController.doPrivileged(immutabilityAction);
                }
                catch (Exception e) {
                    immutable = Boolean.FALSE;
                }
                immutability.put(subclass, immutable);
            }
            return immutable;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ImmutabilityAction
    implements PrivilegedAction {
        private final Class subclass;
        private final Class immutableClass;

        ImmutabilityAction(Class subclass, Class immutableClass) {
            this.subclass = subclass;
            this.immutableClass = immutableClass;
        }

        public Object run() {
            Method[] methods = this.immutableClass.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                String methodName = method.getName();
                if (!methodName.startsWith("get") && !methodName.startsWith("is")) continue;
                Class<?>[] paramTypes = method.getParameterTypes();
                try {
                    Method submethod = this.subclass.getMethod(methodName, paramTypes);
                    if (submethod.equals(method)) continue;
                    return Boolean.FALSE;
                }
                catch (NoSuchMethodException e) {
                    return Boolean.FALSE;
                }
            }
            return Boolean.TRUE;
        }
    }
}

