/*
 * Decompiled with CFR 0.152.
 */
package javax.management.loading;

import com.sun.jmx.trace.Trace;
import java.util.ArrayList;
import java.util.Iterator;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.loading.ClassLoaderRepository;

public class DefaultLoaderRepository {
    private static final String dbgTag = "DefaultLoaderRepository";

    public static Class loadClass(String className) throws ClassNotFoundException {
        DefaultLoaderRepository.debug("loadClass", className);
        return DefaultLoaderRepository.load(null, className);
    }

    public static Class loadClassWithout(ClassLoader loader, String className) throws ClassNotFoundException {
        DefaultLoaderRepository.debug("loadClassWithout", className);
        return DefaultLoaderRepository.load(loader, className);
    }

    private static Class load(ClassLoader without, String className) throws ClassNotFoundException {
        ArrayList mbsList = MBeanServerFactory.findMBeanServer(null);
        Iterator it = mbsList.iterator();
        while (it.hasNext()) {
            MBeanServer mbs = (MBeanServer)it.next();
            ClassLoaderRepository clr = mbs.getClassLoaderRepository();
            try {
                return clr.loadClassWithout(without, className);
            }
            catch (ClassNotFoundException e) {
            }
        }
        throw new ClassNotFoundException(className);
    }

    private static boolean isTraceOn() {
        return Trace.isSelected(1, 1);
    }

    private static void trace(String clz, String func, String info) {
        Trace.send(1, 1, clz, func, info);
    }

    private static void trace(String func, String info) {
        DefaultLoaderRepository.trace(dbgTag, func, info);
    }

    private static boolean isDebugOn() {
        return Trace.isSelected(2, 1);
    }

    private static void debug(String clz, String func, String info) {
        Trace.send(2, 1, clz, func, info);
    }

    private static void debug(String func, String info) {
        DefaultLoaderRepository.debug(dbgTag, func, info);
    }
}

