/*
 * Decompiled with CFR 0.152.
 */
package javax.management.monitor;

import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.monitor.Monitor;
import javax.management.monitor.MonitorNotification;
import javax.management.monitor.MonitorSettingException;
import javax.management.monitor.StringMonitorMBean;

public class StringMonitor
extends Monitor
implements StringMonitorMBean {
    private static final String[] types = new String[]{MonitorNotification.RUNTIME_ERROR, MonitorNotification.OBSERVED_OBJECT_ERROR, MonitorNotification.OBSERVED_ATTRIBUTE_ERROR, MonitorNotification.OBSERVED_ATTRIBUTE_TYPE_ERROR, MonitorNotification.STRING_TO_COMPARE_VALUE_MATCHED, MonitorNotification.STRING_TO_COMPARE_VALUE_DIFFERED};
    private static final MBeanNotificationInfo[] notifsInfo = new MBeanNotificationInfo[]{new MBeanNotificationInfo(types, "javax.management.monitor.MonitorNotification", "Notifications sent by the StringMonitor MBean")};
    private String stringToCompare = "";
    private boolean notifyMatch = false;
    private boolean notifyDiffer = false;
    private transient String[] derivedGauge = new String[16];
    private transient long[] derivedGaugeTimestamp = new long[16];
    private transient int[] status = new int[16];
    private static final int MATCHING = 0;
    private static final int DIFFERING = 1;
    private static final int MATCHING_OR_DIFFERING = 2;
    private transient Timer timer = null;

    String makeDebugTag() {
        return "StringMonitor";
    }

    public StringMonitor() {
        this.dbgTag = this.makeDebugTag();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (this.isTraceOn()) {
            this.trace("start", "start the string monitor");
        }
        StringMonitor stringMonitor = this;
        synchronized (stringMonitor) {
            if (this.isActive) {
                if (this.isTraceOn()) {
                    this.trace("start", "the string monitor is already activated");
                }
                return;
            }
            this.isActive = true;
            for (int i = 0; i < this.elementCount; ++i) {
                this.status[i] = 2;
            }
            this.timer = new Timer();
            this.timer.schedule((TimerTask)new StringAlarmClock(this), this.getGranularityPeriod(), this.getGranularityPeriod());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.isTraceOn()) {
            this.trace("stop", "stop the string monitor");
        }
        StringMonitor stringMonitor = this;
        synchronized (stringMonitor) {
            if (!this.isActive) {
                if (this.isTraceOn()) {
                    this.trace("stop", "the string monitor is already deactivated");
                }
                return;
            }
            this.isActive = false;
            if (this.timer != null) {
                this.timer.cancel();
                this.timer = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGranularityPeriod(long period) throws IllegalArgumentException {
        StringMonitor stringMonitor = this;
        synchronized (stringMonitor) {
            super.setGranularityPeriod(period);
            if (this.isActive) {
                this.timer.cancel();
                this.timer = new Timer();
                this.timer.schedule((TimerTask)new StringAlarmClock(this), this.getGranularityPeriod(), this.getGranularityPeriod());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDerivedGauge(ObjectName object) {
        StringMonitor stringMonitor = this;
        synchronized (stringMonitor) {
            int index = this.indexOf(object);
            if (index != -1) {
                return this.derivedGauge[index];
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDerivedGaugeTimeStamp(ObjectName object) {
        StringMonitor stringMonitor = this;
        synchronized (stringMonitor) {
            int index = this.indexOf(object);
            if (index != -1) {
                return this.derivedGaugeTimestamp[index];
            }
            return 0L;
        }
    }

    public String getDerivedGauge() {
        return this.derivedGauge[0];
    }

    public long getDerivedGaugeTimeStamp() {
        return this.derivedGaugeTimestamp[0];
    }

    public String getStringToCompare() {
        return this.stringToCompare;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStringToCompare(String value) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException("The string to compare cannot be null.");
        }
        StringMonitor stringMonitor = this;
        synchronized (stringMonitor) {
            this.stringToCompare = value;
            for (int i = 0; i < this.elementCount; ++i) {
                this.status[i] = 2;
            }
        }
    }

    public boolean getNotifyMatch() {
        return this.notifyMatch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNotifyMatch(boolean value) {
        StringMonitor stringMonitor = this;
        synchronized (stringMonitor) {
            this.notifyMatch = value;
        }
    }

    public boolean getNotifyDiffer() {
        return this.notifyDiffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNotifyDiffer(boolean value) {
        StringMonitor stringMonitor = this;
        synchronized (stringMonitor) {
            this.notifyDiffer = value;
        }
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return notifsInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDerivedGauge(Object scanString, int index) {
        StringMonitor stringMonitor = this;
        synchronized (stringMonitor) {
            this.derivedGaugeTimestamp[index] = new Date().getTime();
            this.derivedGauge[index] = (String)scanString;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNotifications(int index) {
        boolean sendNotify = false;
        String type = null;
        long timeStamp = 0L;
        String msg = null;
        String derGauge = null;
        String trigger = null;
        StringMonitor stringMonitor = this;
        synchronized (stringMonitor) {
            if (this.status[index] == 2) {
                if (this.derivedGauge[index].equals(this.stringToCompare)) {
                    if (this.notifyMatch) {
                        sendNotify = true;
                        type = MonitorNotification.STRING_TO_COMPARE_VALUE_MATCHED;
                        timeStamp = this.derivedGaugeTimestamp[index];
                        msg = "";
                        derGauge = this.derivedGauge[index];
                        trigger = this.stringToCompare;
                    }
                    this.status[index] = 1;
                } else {
                    if (this.notifyDiffer) {
                        sendNotify = true;
                        type = MonitorNotification.STRING_TO_COMPARE_VALUE_DIFFERED;
                        timeStamp = this.derivedGaugeTimestamp[index];
                        msg = "";
                        derGauge = this.derivedGauge[index];
                        trigger = this.stringToCompare;
                    }
                    this.status[index] = 0;
                }
            } else if (this.status[index] == 0) {
                if (this.derivedGauge[index].equals(this.stringToCompare)) {
                    if (this.notifyMatch) {
                        sendNotify = true;
                        type = MonitorNotification.STRING_TO_COMPARE_VALUE_MATCHED;
                        timeStamp = this.derivedGaugeTimestamp[index];
                        msg = "";
                        derGauge = this.derivedGauge[index];
                        trigger = this.stringToCompare;
                    }
                    this.status[index] = 1;
                }
            } else if (this.status[index] == 1 && !this.derivedGauge[index].equals(this.stringToCompare)) {
                if (this.notifyDiffer) {
                    sendNotify = true;
                    type = MonitorNotification.STRING_TO_COMPARE_VALUE_DIFFERED;
                    timeStamp = this.derivedGaugeTimestamp[index];
                    msg = "";
                    derGauge = this.derivedGauge[index];
                    trigger = this.stringToCompare;
                }
                this.status[index] = 0;
            }
        }
        if (sendNotify) {
            this.sendNotification(type, timeStamp, msg, derGauge, trigger, index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyAlarmClock(int index) {
        boolean sendNotify = false;
        String type = null;
        long timeStamp = 0L;
        String msg = null;
        String derGauge = null;
        Object trigger = null;
        Object scan_string = null;
        String notif_type = null;
        StringMonitor stringMonitor = this;
        synchronized (stringMonitor) {
            block21: {
                try {
                    if (!this.isActive) break block21;
                    if (this.getObservedObject(index) == null || this.getObservedAttribute() == null) {
                        return;
                    }
                    try {
                        scan_string = this.server.getAttribute(this.getObservedObject(index), this.getObservedAttribute());
                        if (scan_string == null) {
                            return;
                        }
                    }
                    catch (NullPointerException np_ex) {
                        if ((this.alreadyNotifieds[index] & 8) != 0) {
                            return;
                        }
                        notif_type = MonitorNotification.RUNTIME_ERROR;
                        this.setAlreadyNotified(index, 8);
                        throw new MonitorSettingException("The string monitor must be registered in the MBean server.");
                    }
                    catch (InstanceNotFoundException inf_ex) {
                        if ((this.alreadyNotifieds[index] & 1) != 0) {
                            return;
                        }
                        notif_type = MonitorNotification.OBSERVED_OBJECT_ERROR;
                        this.setAlreadyNotified(index, 1);
                        throw new MonitorSettingException("The observed object must be registered in the MBean server.");
                    }
                    catch (AttributeNotFoundException anf_ex) {
                        if ((this.alreadyNotifieds[index] & 2) != 0) {
                            return;
                        }
                        notif_type = MonitorNotification.OBSERVED_ATTRIBUTE_ERROR;
                        this.setAlreadyNotified(index, 2);
                        throw new MonitorSettingException("The observed attribute must be accessible in the observed object.");
                    }
                    catch (MBeanException mb_ex) {
                        if ((this.alreadyNotifieds[index] & 8) != 0) {
                            return;
                        }
                        notif_type = MonitorNotification.RUNTIME_ERROR;
                        this.setAlreadyNotified(index, 8);
                        throw new MonitorSettingException(mb_ex.getMessage());
                    }
                    catch (ReflectionException ref_ex) {
                        if ((this.alreadyNotifieds[index] & 2) != 0) {
                            return;
                        }
                        notif_type = MonitorNotification.OBSERVED_ATTRIBUTE_ERROR;
                        this.setAlreadyNotified(index, 2);
                        throw new MonitorSettingException(ref_ex.getMessage());
                    }
                    if (!(scan_string instanceof String)) {
                        if ((this.alreadyNotifieds[index] & 4) != 0) {
                            return;
                        }
                        notif_type = MonitorNotification.OBSERVED_ATTRIBUTE_TYPE_ERROR;
                        this.setAlreadyNotified(index, 4);
                        throw new MonitorSettingException("The observed attribute type must be a string type.");
                    }
                    this.resetAllAlreadyNotified(index);
                    this.updateDerivedGauge(scan_string, index);
                    this.updateNotifications(index);
                }
                catch (MonitorSettingException ms_ex) {
                    sendNotify = true;
                    type = notif_type;
                    timeStamp = this.derivedGaugeTimestamp[index];
                    msg = ms_ex.getMessage();
                    derGauge = this.derivedGauge[index];
                    trigger = null;
                    this.status[index] = 2;
                }
            }
        }
        if (sendNotify) {
            this.sendNotification(type, timeStamp, msg, derGauge, trigger, index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void insertSpecificElementAt(int index) {
        StringMonitor stringMonitor = this;
        synchronized (stringMonitor) {
            this.insertStringElementAt(this.derivedGauge, "", index);
            this.insertlongElementAt(this.derivedGaugeTimestamp, new Date().getTime(), index);
            this.insertintElementAt(this.status, 2, index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeSpecificElementAt(int index) {
        StringMonitor stringMonitor = this;
        synchronized (stringMonitor) {
            this.removeStringElementAt(this.derivedGauge, index);
            this.removelongElementAt(this.derivedGaugeTimestamp, index);
            this.removeintElementAt(this.status, index);
        }
    }

    private static class StringAlarmClock
    extends TimerTask {
        StringMonitor listener = null;

        public StringAlarmClock(StringMonitor listener) {
            this.listener = listener;
        }

        public void run() {
            if (this.listener.isActive) {
                for (int i = 0; i < this.listener.elementCount; ++i) {
                    this.listener.notifyAlarmClock(i);
                }
            }
        }
    }
}

