/*
 * Decompiled with CFR 0.152.
 */
package junitx.framework;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import junitx.framework.TestAccessException;
import junitx.framework.TestedClass;

public abstract class TestProxy {
    private TestedClass _testedClass;

    public void init(TestedClass aTestedClass) {
        this._testedClass = aTestedClass;
    }

    public TestedClass getProxiedClass() {
        return this._testedClass;
    }

    public String getTestedClassName() {
        return this.getProxiedClass().getTestedClass().getName();
    }

    private Object invokeMethod(Object anObject, Method aMethod, Object[] anArgArray) throws TestAccessException {
        boolean acc = false;
        Object result = null;
        try {
            acc = aMethod.isAccessible();
            aMethod.setAccessible(true);
            result = aMethod.invoke(anObject, anArgArray);
            aMethod.setAccessible(acc);
        }
        catch (Exception e) {
            throw new TestAccessException("could not invoke", anObject, aMethod.getName(), "", e);
        }
        return result;
    }

    private Object invokeConstructor(Constructor aConstructor, Object[] anArgArray) throws TestAccessException {
        boolean acc = false;
        Object result = null;
        try {
            acc = aConstructor.isAccessible();
            aConstructor.setAccessible(true);
            result = aConstructor.newInstance(anArgArray);
            aConstructor.setAccessible(acc);
        }
        catch (Exception e) {
            throw new TestAccessException("could not invoke constructor for " + this.getTestedClassName(), e);
        }
        return result;
    }

    public Object invoke(Object anObject, String aMethodName, Object[] anArgArray) throws TestAccessException {
        return this.invokeMethod(anObject, this.getProxiedClass().getMethod(aMethodName, anArgArray), anArgArray);
    }

    public abstract Object newInstance(Object[] var1) throws TestAccessException;

    public Object invokeWithKey(Object anObject, String aMethodKey, Object[] anArgArray) throws TestAccessException {
        Method method = null;
        method = this.getProxiedClass().getMethod(aMethodKey);
        if (method == null) {
            throw new TestAccessException("could not find method with key " + aMethodKey);
        }
        return this.invokeMethod(anObject, method, anArgArray);
    }

    public abstract Object newInstanceWithKey(String var1, Object[] var2) throws TestAccessException;

    public Object get(Object anObject, String aFieldName) throws TestAccessException {
        try {
            Field field = this.getProxiedClass().getField(aFieldName);
            Object val = null;
            boolean acc = field.isAccessible();
            field.setAccessible(true);
            val = field.get(anObject);
            field.setAccessible(acc);
            return val;
        }
        catch (Exception e) {
            throw new TestAccessException("could not access field", anObject, aFieldName, "", e);
        }
    }

    public boolean getBoolean(Object anObject, String aFieldName) throws TestAccessException {
        try {
            Field field = this.getProxiedClass().getField(aFieldName);
            boolean val = false;
            boolean acc = field.isAccessible();
            field.setAccessible(true);
            val = field.getBoolean(anObject);
            field.setAccessible(acc);
            return val;
        }
        catch (Exception e) {
            throw new TestAccessException("could not access field", anObject, aFieldName, "", e);
        }
    }

    public byte getByte(Object anObject, String aFieldName) throws TestAccessException {
        try {
            Field field = this.getProxiedClass().getField(aFieldName);
            byte val = 0;
            boolean acc = field.isAccessible();
            field.setAccessible(true);
            val = field.getByte(anObject);
            field.setAccessible(acc);
            return val;
        }
        catch (Exception e) {
            throw new TestAccessException("could not access field", anObject, aFieldName, "", e);
        }
    }

    public char getChar(Object anObject, String aFieldName) throws TestAccessException {
        try {
            Field field = this.getProxiedClass().getField(aFieldName);
            char val = ' ';
            boolean acc = field.isAccessible();
            field.setAccessible(true);
            val = field.getChar(anObject);
            field.setAccessible(acc);
            return val;
        }
        catch (Exception e) {
            throw new TestAccessException("could not access field", anObject, aFieldName, "", e);
        }
    }

    public double getDouble(Object anObject, String aFieldName) throws TestAccessException {
        try {
            Field field = this.getProxiedClass().getField(aFieldName);
            double val = 0.0;
            boolean acc = field.isAccessible();
            field.setAccessible(true);
            val = field.getDouble(anObject);
            field.setAccessible(acc);
            return val;
        }
        catch (Exception e) {
            throw new TestAccessException("could not access field", anObject, aFieldName, "", e);
        }
    }

    public float getFloat(Object anObject, String aFieldName) throws TestAccessException {
        try {
            Field field = this.getProxiedClass().getField(aFieldName);
            float val = 0.0f;
            boolean acc = field.isAccessible();
            field.setAccessible(true);
            val = field.getFloat(anObject);
            field.setAccessible(acc);
            return val;
        }
        catch (Exception e) {
            throw new TestAccessException("could not access field", anObject, aFieldName, "", e);
        }
    }

    public int getInt(Object anObject, String aFieldName) throws TestAccessException {
        try {
            Field field = this.getProxiedClass().getField(aFieldName);
            int val = 0;
            boolean acc = field.isAccessible();
            field.setAccessible(true);
            val = field.getInt(anObject);
            field.setAccessible(acc);
            return val;
        }
        catch (Exception e) {
            throw new TestAccessException("could not access field", anObject, aFieldName, "", e);
        }
    }

    public long getLong(Object anObject, String aFieldName) throws TestAccessException {
        try {
            Field field = this.getProxiedClass().getField(aFieldName);
            long val = 0L;
            boolean acc = field.isAccessible();
            field.setAccessible(true);
            val = field.getLong(anObject);
            field.setAccessible(acc);
            return val;
        }
        catch (Exception e) {
            throw new TestAccessException("could not access field", anObject, aFieldName, "", e);
        }
    }

    public short getShort(Object anObject, String aFieldName) throws TestAccessException {
        try {
            Field field = this.getProxiedClass().getField(aFieldName);
            short val = 0;
            boolean acc = field.isAccessible();
            field.setAccessible(true);
            val = field.getShort(anObject);
            field.setAccessible(acc);
            return val;
        }
        catch (Exception e) {
            throw new TestAccessException("could not access field", anObject, aFieldName, "", e);
        }
    }

    public void dumpKeys() {
        this.getProxiedClass().dumpKeys();
    }
}

