/*
 * Decompiled with CFR 0.152.
 */
package junitx.framework;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import junitx.framework.TestAccessException;
import junitx.framework.TestProxy;
import junitx.framework.TestedClass;

class TestProxyFactory {
    private static Map _proxies = new HashMap();

    private TestProxyFactory() {
    }

    private static String getNewInstanceMethodCode() {
        StringBuffer code = new StringBuffer("  public Object newInstance (Object[] anArgList)");
        code.append(" throws junitx.framework.TestAccessException {");
        code.append(" try {");
        code.append("    return getProxiedClass().getConstructor (anArgList).newInstance (anArgList);");
        code.append(" }catch (Exception e){");
        code.append(" throw new junitx.framework.TestAccessException (\"could not instantiate \" + getTestedClassName(), e); }}");
        return code.toString();
    }

    private static String getNewInstanceWithKeyMethodCode() {
        StringBuffer code = new StringBuffer("  public Object newInstanceWithKey (String aConstructorKey, Object[] anArgList)");
        code.append(" throws junitx.framework.TestAccessException {");
        code.append(" try {");
        code.append("    return getProxiedClass().getConstructor (aConstructorKey).newInstance (anArgList);");
        code.append(" }catch (Exception e){");
        code.append(" throw new junitx.framework.TestAccessException (\"could not instantiate \" + getTestedClassName(), e); }}");
        return code.toString();
    }

    private static TestProxy createTestProxyWithName(String fullyQualifiedName) throws NotFoundException, CannotCompileException, IOException, InstantiationException, IllegalAccessException {
        ClassPool pool = ClassPool.getDefault();
        CtClass newTestProxy = pool.makeClass(fullyQualifiedName, pool.get("junitx.framework.TestProxy"));
        CtMethod newInstanceMethod = CtNewMethod.make((String)TestProxyFactory.getNewInstanceMethodCode(), (CtClass)newTestProxy);
        newTestProxy.addMethod(newInstanceMethod);
        CtMethod newInstanceWithKeyMethod = CtNewMethod.make((String)TestProxyFactory.getNewInstanceWithKeyMethodCode(), (CtClass)newTestProxy);
        newTestProxy.addMethod(newInstanceWithKeyMethod);
        TestProxy ntp = (TestProxy)newTestProxy.toClass(TestProxy.class.getClassLoader()).newInstance();
        return ntp;
    }

    /*
     * WARNING - void declaration
     */
    private static TestProxy createProxyFor(Class aClass) throws TestAccessException {
        void var2_3;
        TestProxy proxy;
        TestedClass testedClass = new TestedClass(aClass);
        String fullyQualifiedName = testedClass.getPkgName();
        if (fullyQualifiedName == null) {
            fullyQualifiedName = "";
        }
        if ((fullyQualifiedName = fullyQualifiedName + ".TestProxy").charAt(0) == '.') {
            fullyQualifiedName = fullyQualifiedName.substring(1);
        }
        try {
            proxy = (TestProxy)Class.forName(fullyQualifiedName).newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            try {
                proxy = TestProxyFactory.createTestProxyWithName(fullyQualifiedName);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new TestAccessException("unable to find and create proxy for " + fullyQualifiedName, e);
            }
        }
        catch (Exception e) {
            throw new TestAccessException("no proxy available for " + aClass, e);
        }
        var2_3.init(testedClass);
        _proxies.put(aClass, var2_3);
        return var2_3;
    }

    public static TestProxy getProxyFor(Class aClass) throws TestAccessException {
        TestProxy proxy = (TestProxy)_proxies.get(aClass);
        if (proxy == null) {
            proxy = TestProxyFactory.createProxyFor(aClass);
        }
        return proxy;
    }

    public static TestProxy getProxyFor(String aFQClassName) throws TestAccessException {
        try {
            return TestProxyFactory.getProxyFor(Class.forName(aFQClassName));
        }
        catch (ClassNotFoundException e) {
            throw new TestAccessException("class " + aFQClassName + " not found");
        }
    }
}

