/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.examples;

import com.sun.jna.examples.win32.Shell32;
import java.io.File;

public abstract class FileUtils {
    public abstract boolean moveToTrash(File[] var1);

    public static FileUtils getInstance() {
        return Holder.INSTANCE;
    }

    private static class DefaultFileUtils
    extends FileUtils {
        private DefaultFileUtils() {
        }

        public boolean moveToTrash(File[] files) {
            File desktop;
            File home = new File(System.getProperty("user.home"));
            File trash = new File(home, ".Trash");
            if (!trash.exists() && !(trash = new File(home, "Trash")).exists() && (desktop = new File(home, "Desktop")).exists() && !(trash = new File(desktop, ".Trash")).exists()) {
                trash = new File(desktop, "Trash");
            }
            if (trash.exists()) {
                boolean success = true;
                for (int i = 0; i < files.length; ++i) {
                    File src = files[i];
                    File target = new File(trash, src.getName());
                    if (src.renameTo(target)) continue;
                    success = false;
                }
                return success;
            }
            return false;
        }
    }

    private static class MacFileUtils
    extends FileUtils {
        private MacFileUtils() {
        }

        public boolean moveToTrash(File[] files) {
            File home = new File(System.getProperty("user.home"));
            File trash = new File(home, ".Trash");
            if (trash.exists()) {
                boolean success = true;
                for (int i = 0; i < files.length; ++i) {
                    File src = files[i];
                    File target = new File(trash, src.getName());
                    if (src.renameTo(target)) continue;
                    success = false;
                }
                return success;
            }
            return false;
        }
    }

    private static class W32FileUtils
    extends FileUtils {
        private W32FileUtils() {
        }

        public boolean moveToTrash(File[] files) {
            Shell32 shell = Shell32.INSTANCE;
            Shell32.SHFILEOPSTRUCT fileop = new Shell32.SHFILEOPSTRUCT();
            fileop.wFunc = 3;
            String[] paths = new String[files.length];
            for (int i = 0; i < paths.length; ++i) {
                paths[i] = files[i].getAbsolutePath();
            }
            fileop.pFrom = fileop.encodePaths(paths);
            fileop.fFlags = (short)84;
            return shell.SHFileOperation(fileop) == 0;
        }
    }

    private static class Holder {
        public static final FileUtils INSTANCE;

        private Holder() {
        }

        static {
            String os = System.getProperty("os.name");
            INSTANCE = os.startsWith("Windows") ? new W32FileUtils() : (os.startsWith("Mac") ? new MacFileUtils() : new DefaultFileUtils());
        }
    }
}

