/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.examples;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.examples.WindowUtils;
import com.sun.jna.examples.unix.X11;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class X11AlphaMaskTest {
    private static int alpha = 128;
    private static int color = -2130706433;
    private static AlphaComposite composite = AlphaComposite.Src;

    public static void main(String[] args) {
        GraphicsConfiguration gc = WindowUtils.getAlphaCompatibleGraphicsConfiguration();
        JFrame frame = new JFrame("X11 alpha test", gc){

            public void paint(Graphics g) {
            }
        };
        final JComponent content = new JComponent(){

            public Dimension getPreferredSize() {
                return new Dimension(100, 100);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void paintComponent(Graphics graphics) {
                BufferedImage buf = new BufferedImage(this.getWidth(), this.getHeight(), 3);
                Graphics2D g = buf.createGraphics();
                g.setComposite(AlphaComposite.Clear);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                g.setComposite(AlphaComposite.SrcOver);
                Color c = new Color(color & 0xFFFFFF);
                if ((color & 0xFF000000) != 0) {
                    alpha = color >> 24 & 0xFF;
                }
                c = new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha);
                g.setColor(c);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                g.setColor(new Color(0, 0, 0, 128));
                g.fillRect(0, 0, this.getWidth(), this.getHeight() / 10);
                if (System.getProperty("os.name").startsWith("Windows")) {
                    g = (Graphics2D)graphics.create();
                    g.setComposite(composite);
                    g.drawImage(buf, 0, 0, this.getWidth(), this.getHeight(), null);
                } else {
                    graphics.drawImage(buf, 0, 0, this.getWidth(), this.getHeight(), null);
                    X11 lib = X11.INSTANCE;
                    Pointer dpy = lib.XOpenDisplay(null);
                    if (dpy != null) {
                        try {
                            int pixmap;
                            block14: {
                                int win = (int)Native.getWindowID(SwingUtilities.getWindowAncestor(this));
                                int w = this.getWidth();
                                int h = this.getHeight();
                                Pointer gc = lib.XCreateGC(dpy, win, 0, null);
                                pixmap = lib.XCreatePixmap(dpy, win, w, h, 32);
                                try {
                                    lib.XSetForeground(dpy, gc, 0);
                                    lib.XFillRectangle(dpy, pixmap, gc, 0, 0, w, h);
                                    Raster raster = buf.getData();
                                    int[] pixel = new int[4];
                                    for (int y = 0; y < h; ++y) {
                                        for (int x = 0; x < w; ++x) {
                                            raster.getPixel(x, h - y - 1, pixel);
                                            int alpha = (pixel[3] & 0xFF) << 24;
                                            int red = pixel[2] & 0xFF;
                                            int green = (pixel[1] & 0xFF) << 8;
                                            int blue = (pixel[0] & 0xFF) << 16;
                                            lib.XSetForeground(dpy, gc, alpha | red | green | blue);
                                            lib.XFillRectangle(dpy, pixmap, gc, x, h - y - 1, 1, 1);
                                        }
                                    }
                                    lib.XCopyArea(dpy, pixmap, win, gc, 0, 0, w, h, 0, 0);
                                    Object var21_20 = null;
                                    if (gc == null) break block14;
                                    lib.XFreeGC(dpy, gc);
                                }
                                catch (Throwable throwable) {
                                    Object var21_21 = null;
                                    if (gc != null) {
                                        lib.XFreeGC(dpy, gc);
                                    }
                                    if (pixmap != 0) {
                                        lib.XFreePixmap(dpy, pixmap);
                                    }
                                    throw throwable;
                                }
                            }
                            if (pixmap != 0) {
                                lib.XFreePixmap(dpy, pixmap);
                            }
                        }
                        finally {
                            lib.XCloseDisplay(dpy);
                        }
                    }
                }
                g.dispose();
            }
        };
        final JTextField colorField = new JTextField(Integer.toHexString(color).toUpperCase());
        final JSlider slider = new JSlider(0, 255, 128);
        slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (!slider.getModel().getValueIsAdjusting()) {
                    alpha = slider.getValue();
                    color = color & 0xFFFFFF | alpha << 24;
                    content.repaint();
                    colorField.setText(Integer.toHexString(color).toUpperCase());
                }
            }
        });
        AlphaComposite[] options = new AlphaComposite[]{AlphaComposite.Clear, AlphaComposite.Src, AlphaComposite.SrcOver, AlphaComposite.SrcAtop, AlphaComposite.SrcIn, AlphaComposite.SrcOut, AlphaComposite.Dst, AlphaComposite.DstOver, AlphaComposite.DstAtop, AlphaComposite.DstIn, AlphaComposite.DstOut, AlphaComposite.Xor};
        final JComboBox<AlphaComposite> combo = new JComboBox<AlphaComposite>(options);
        combo.setOpaque(true);
        combo.setSelectedItem(composite);
        combo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                composite = (AlphaComposite)combo.getSelectedItem();
                content.repaint();
            }
        });
        colorField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                color = (int)(Long.parseLong(colorField.getText(), 16) & 0xFFFFFFFFFFFFFFFFL);
                int alpha = color >> 24 & 0xFF;
                content.repaint();
                slider.setValue(alpha);
            }
        });
        frame.getContentPane().add(content);
        frame.getContentPane().add((Component)slider, "South");
        frame.getContentPane().add((Component)colorField, "North");
        frame.setDefaultCloseOperation(3);
        frame.pack();
        if (System.getProperty("os.name").startsWith("Windows")) {
            WindowUtils.setWindowTransparent(frame, true);
        }
        frame.setLocation(100, 100);
        frame.setVisible(true);
    }
}

