/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.generic;

import com.sun.jmx.remote.generic.ClientAdmin;
import com.sun.jmx.remote.generic.ClientSynchroMessageConnection;
import com.sun.jmx.remote.generic.ServerAdmin;
import com.sun.jmx.remote.generic.SynchroMessageConnectionServer;
import com.sun.jmx.remote.opt.security.AdminClient;
import com.sun.jmx.remote.opt.security.AdminServer;
import com.sun.jmx.remote.opt.util.EnvHelp;
import java.util.Map;

public class DefaultConfig {
    public static final String SERVER_MAX_THREADS = "jmx.remote.x.server.max.threads";
    public static final String SERVER_MIN_THREADS = "jmx.remote.x.server.min.threads";
    public static final String REQUEST_WAITING_TIME = "jmx.remote.x.request.timeout";
    public static final String SERVER_ADMIN = "com.sun.jmx.remote.server.admin";
    public static final String CLIENT_ADMIN = "com.sun.jmx.remote.client.admin";
    public static final String SYNCHRO_MESSAGE_CONNECTION_SERVER = "com.sun.jmx.remote.generic.synchro.server";
    public static final String CLIENT_SYNCHRO_MESSAGE_CONNECTION = "com.sun.jmx.remote.generic.synchro.client";
    public static final String TIMEOUT_FOR_CONNECTED_STATE = "jmx.remote.x.client.connected.state.timeout";
    public static final String SERVER_REUSE_ADDRESS = "jmx.remote.x.server.reuse.address";

    public static int getServerMaxThreads(Map env) {
        return (int)EnvHelp.getIntegerAttribute(env, SERVER_MAX_THREADS, 10L, 1L, Integer.MAX_VALUE);
    }

    public static int getServerMinThreads(Map env) {
        return (int)EnvHelp.getIntegerAttribute(env, SERVER_MIN_THREADS, 1L, 1L, Integer.MAX_VALUE);
    }

    public static long getRequestTimeout(Map env) {
        return EnvHelp.getIntegerAttribute(env, REQUEST_WAITING_TIME, Long.MAX_VALUE, 0L, Long.MAX_VALUE);
    }

    /*
     * WARNING - void declaration
     */
    public static ServerAdmin getServerAdmin(Map env) {
        void var1_2;
        ServerAdmin admin;
        Object o = env.get(SERVER_ADMIN);
        if (o == null) {
            admin = new AdminServer(env);
        } else if (o instanceof ServerAdmin) {
            admin = (ServerAdmin)o;
        } else {
            String msg = "The specified attribute \"com.sun.jmx.remote.server.admin\" is not a ServerAdmin object.";
            throw new IllegalArgumentException("The specified attribute \"com.sun.jmx.remote.server.admin\" is not a ServerAdmin object.");
        }
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    public static ClientAdmin getClientAdmin(Map env) {
        void var1_2;
        ClientAdmin admin;
        Object o = env.get(CLIENT_ADMIN);
        if (o == null) {
            admin = new AdminClient(env);
        } else if (o instanceof ClientAdmin) {
            admin = (ClientAdmin)o;
        } else {
            String msg = "The specified attribute \"com.sun.jmx.remote.client.admin\" is not a ClientAdmin object.";
            throw new IllegalArgumentException("The specified attribute \"com.sun.jmx.remote.client.admin\" is not a ClientAdmin object.");
        }
        return var1_2;
    }

    public static SynchroMessageConnectionServer getSynchroMessageConnectionServer(Map env) {
        SynchroMessageConnectionServer ret = null;
        if (env != null) {
            ret = (SynchroMessageConnectionServer)env.get(SYNCHRO_MESSAGE_CONNECTION_SERVER);
        }
        return ret;
    }

    public static ClientSynchroMessageConnection getClientSynchroMessageConnection(Map env) {
        ClientSynchroMessageConnection ret = null;
        if (env != null) {
            ret = (ClientSynchroMessageConnection)env.get(CLIENT_SYNCHRO_MESSAGE_CONNECTION);
        }
        return ret;
    }

    public static long getTimeoutForWaitConnectedState(Map env) {
        return EnvHelp.getIntegerAttribute(env, TIMEOUT_FOR_CONNECTED_STATE, 1000L, 1L, Long.MAX_VALUE);
    }

    public static boolean getServerReuseAddress(Map env) {
        Object o;
        if (env == null || (o = env.get(SERVER_REUSE_ADDRESS)) == null) {
            return true;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof String) {
            return Boolean.valueOf((String)o);
        }
        throw new IllegalArgumentException("Attribute jmx.remote.x.server.reuse.address value must be Boolean or String.");
    }
}

