/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.generic;

import com.sun.jmx.remote.generic.DefaultConfig;
import com.sun.jmx.remote.generic.ServerAdmin;
import com.sun.jmx.remote.generic.ServerSynchroMessageConnection;
import com.sun.jmx.remote.generic.SynchroCallback;
import com.sun.jmx.remote.opt.util.ClassLogger;
import com.sun.jmx.remote.opt.util.ThreadService;
import java.io.IOException;
import java.util.Map;
import javax.management.remote.generic.MessageConnection;
import javax.management.remote.message.CloseMessage;
import javax.management.remote.message.Message;
import javax.security.auth.Subject;

public class ServerSynchroMessageConnectionImpl
implements ServerSynchroMessageConnection {
    private transient int[] connectionLock = new int[0];
    private transient MessageConnection connection;
    private transient ServerAdmin serverAdmin = null;
    private Map env;
    private transient SynchroCallback callback;
    private transient ThreadService threads;
    private transient MessageReader reader;
    private static final int UNCONNECTED = 1;
    private static final int CONNECTING = 2;
    private static final int CONNECTED = 3;
    private static final int FAILED = 4;
    private static final int TERMINATED = 5;
    private int state = 1;
    private int[] stateLock = new int[0];
    private long waitConnectedState;
    private final ClassLogger logger = new ClassLogger("javax.management.remote.misc", "SynchroMessageConnectionImpl");

    public ServerSynchroMessageConnectionImpl(MessageConnection mc, Map env) throws IOException {
        if (mc == null) {
            throw new IllegalArgumentException("Null message connection.");
        }
        this.env = env;
        this.waitConnectedState = DefaultConfig.getTimeoutForWaitConnectedState(env);
        this.serverAdmin = DefaultConfig.getServerAdmin(this.env);
        this.connection = mc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(Map env) throws IOException {
        int[] nArray = this.stateLock;
        synchronized (this.stateLock) {
            if (this.state == 1) {
                this.connection.connect(env);
                this.connection = this.serverAdmin.connectionOpen(this.connection);
                this.state = 3;
                this.stateLock.notifyAll();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendOneWay(Message msg) throws IOException {
        if (this.logger.traceOn()) {
            this.logger.trace("sendOneWay", "Send a message without response.");
        }
        this.checkState();
        int[] nArray = this.connectionLock;
        synchronized (this.connectionLock) {
            this.connection.writeMessage(msg);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void setCallback(SynchroCallback cb) {
        if (this.logger.traceOn()) {
            this.logger.trace("setCallback", "be called.");
        }
        if (this.callback != null) {
            throw new IllegalArgumentException("The callback has been assigned.");
        }
        if (cb == null) {
            throw new IllegalArgumentException("Null callback.");
        }
        this.callback = cb;
        this.threads = new ThreadService(DefaultConfig.getServerMinThreads(this.env), DefaultConfig.getServerMaxThreads(this.env));
        this.reader = new MessageReader();
        this.threads.handoff(this.reader);
    }

    public String getConnectionId() {
        return this.connection.getConnectionId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.logger.traceOn()) {
            this.logger.trace("close", "Closing this SynchroMessageConnection.");
        }
        int[] nArray = this.stateLock;
        synchronized (this.stateLock) {
            if (this.state == 5) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.state = 5;
            if (this.logger.traceOn()) {
                this.logger.trace("close", "Close the callback reader.");
            }
            if (this.reader != null) {
                this.reader.stop();
            }
            if (this.threads != null) {
                this.threads.terminate();
                this.threads = null;
            }
            if (this.logger.traceOn()) {
                this.logger.trace("close", "Closing the underlying connection.");
            }
            if (this.connection != null) {
                this.connection.close();
            }
            this.serverAdmin.connectionClosed(this.connection);
            if (this.logger.traceOn()) {
                this.logger.trace("close", "Clean all threads waiting theire responses.");
            }
            this.stateLock.notify();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public MessageConnection getAsynchroConnection() {
        return this.connection;
    }

    public Subject getSubject() {
        return this.serverAdmin.getSubject(this.connection);
    }

    private void checkState() throws IOException {
        int[] nArray = this.stateLock;
        synchronized (this.stateLock) {
            if (this.state == 3) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            if (this.state == 5) {
                throw new IOException("The connection has been closed.");
            }
            long remainingTime = this.waitConnectedState;
            long startTime = System.currentTimeMillis();
            while (this.state != 3 && this.state != 5 && remainingTime > 0L) {
                try {
                    this.stateLock.wait(remainingTime);
                }
                catch (InterruptedException ire) {
                    break;
                }
                remainingTime = this.waitConnectedState - (System.currentTimeMillis() - startTime);
            }
            if (this.state == 3) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            throw new IOException("The connection is not currently established.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isTerminated() {
        int[] nArray = this.stateLock;
        synchronized (this.stateLock) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.state == 5;
        }
    }

    private class RemoteJob
    implements Runnable {
        private Message msg;

        public RemoteJob(Message msg) {
            this.msg = msg;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block10: {
                if (ServerSynchroMessageConnectionImpl.this.logger.traceOn()) {
                    ServerSynchroMessageConnectionImpl.this.logger.trace("RemoteJob-run", "Receive a new request.");
                }
                try {
                    Message resp = ServerSynchroMessageConnectionImpl.this.callback.execute(this.msg);
                    if (resp == null) break block10;
                    int[] nArray = ServerSynchroMessageConnectionImpl.this.connectionLock;
                    synchronized (nArray) {
                        ServerSynchroMessageConnectionImpl.this.connection.writeMessage(resp);
                    }
                }
                catch (Exception ie) {
                    int[] nArray = ServerSynchroMessageConnectionImpl.this.stateLock;
                    synchronized (nArray) {
                        if (ServerSynchroMessageConnectionImpl.this.state != 3 && ServerSynchroMessageConnectionImpl.this.callback != null) {
                            ServerSynchroMessageConnectionImpl.this.callback.connectionException(ie);
                        }
                    }
                }
            }
        }
    }

    private class MessageReader
    implements Runnable {
        private Thread executingThread;
        private boolean executingThreadInterrupted = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block12: {
                try {
                    this.executingThread = Thread.currentThread();
                    while (!this.stopped()) {
                        if (ServerSynchroMessageConnectionImpl.this.logger.traceOn()) {
                            ServerSynchroMessageConnectionImpl.this.logger.trace("MessageReader-run", "Waiting a coming message...");
                        }
                        Message msg = null;
                        try {
                            msg = ServerSynchroMessageConnectionImpl.this.connection.readMessage();
                        }
                        catch (Exception e) {
                            if (!this.stopped()) {
                                ServerSynchroMessageConnectionImpl.this.callback.connectionException(e);
                            }
                            break;
                        }
                        if (!this.stopped()) {
                            ServerSynchroMessageConnectionImpl.this.threads.handoff(new RemoteJob(msg));
                            if (!(msg instanceof CloseMessage)) continue;
                        }
                        break;
                    }
                }
                catch (Exception eee) {
                    if (!ServerSynchroMessageConnectionImpl.this.logger.traceOn()) break block12;
                    ServerSynchroMessageConnectionImpl.this.logger.trace("MessageReader-run", "stops.");
                }
            }
            int[] nArray = ServerSynchroMessageConnectionImpl.this.stateLock;
            synchronized (nArray) {
                this.executingThreadInterrupted = true;
            }
            if (ServerSynchroMessageConnectionImpl.this.logger.traceOn()) {
                ServerSynchroMessageConnectionImpl.this.logger.trace("MessageReader-run", "ended.");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            if (ServerSynchroMessageConnectionImpl.this.logger.traceOn()) {
                ServerSynchroMessageConnectionImpl.this.logger.trace("MessageReader-terminated", "be called.");
            }
            int[] nArray = ServerSynchroMessageConnectionImpl.this.stateLock;
            synchronized (nArray) {
                if (Thread.currentThread() != this.executingThread && this.executingThread != null && !this.executingThreadInterrupted) {
                    this.executingThreadInterrupted = true;
                    this.executingThread.interrupt();
                }
            }
            if (ServerSynchroMessageConnectionImpl.this.logger.traceOn()) {
                ServerSynchroMessageConnectionImpl.this.logger.trace("MessageReader-terminated", "done.");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean stopped() {
            int[] nArray = ServerSynchroMessageConnectionImpl.this.stateLock;
            synchronized (nArray) {
                return ServerSynchroMessageConnectionImpl.this.state != 3 || this.executingThreadInterrupted;
            }
        }
    }
}

