/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import java.util.Vector;
import org.apache.xerces.dom.AttrImpl;
import org.apache.xerces.dom.AttributeMap;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.apache.xerces.dom.DOMErrorImpl;
import org.apache.xerces.dom.DOMLocatorImpl;
import org.apache.xerces.dom.DocumentTypeImpl;
import org.apache.xerces.dom.ElementImpl;
import org.apache.xerces.dom.EntityReferenceImpl;
import org.apache.xerces.dom.TextImpl;
import org.apache.xerces.impl.RevalidationHandler;
import org.apache.xerces.util.AugmentationsImpl;
import org.apache.xerces.util.NamespaceSupport;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.grammars.Grammar;
import org.apache.xerces.xni.grammars.XMLGrammarDescription;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.parser.XMLComponent;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMError;
import org.w3c.dom.DOMErrorHandler;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class DOMNormalizer
implements XMLGrammarPool {
    protected static final boolean DEBUG_ND = false;
    protected static final boolean DEBUG = false;
    protected static final String PREFIX = "NS";
    protected static final String ERROR_HANDLER = "http://apache.org/xml/properties/internal/error-handler";
    protected static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    protected CoreDocumentImpl fDocument = null;
    protected final XMLAttributesProxy fAttrProxy = new XMLAttributesProxy();
    protected final QName fQName = new QName();
    protected RevalidationHandler fValidationHandler;
    protected SymbolTable fSymbolTable;
    protected DOMErrorHandler fErrorHandler;
    protected String fEmptySymbol;
    protected String fXmlSymbol;
    protected String fXmlnsSymbol;
    protected int fNamespaceCounter = 1;
    protected final NamespaceSupport fNamespaceBinder = new NamespaceSupport();
    protected final NamespaceSupport fLocalNSBinder = new NamespaceSupport();
    protected final Vector fAttributeList = new Vector(5, 10);
    protected final DOMErrorImpl fDOMError = new DOMErrorImpl();
    protected final Grammar[] fGrammarPool = new Grammar[1];

    protected void reset(XMLComponentManager componentManager) {
        if (componentManager == null) {
            this.fSymbolTable = null;
            this.fValidationHandler = null;
            return;
        }
        this.fSymbolTable = (SymbolTable)componentManager.getProperty(SYMBOL_TABLE);
        if (this.fSymbolTable == null) {
            this.fSymbolTable = new SymbolTable();
        }
        this.fNamespaceBinder.reset(this.fSymbolTable);
        this.fNamespaceBinder.declarePrefix(this.fEmptySymbol, this.fEmptySymbol);
        this.fNamespaceCounter = 1;
        this.fXmlSymbol = this.fSymbolTable.addSymbol("xml");
        this.fXmlnsSymbol = this.fSymbolTable.addSymbol("xmlns");
        this.fEmptySymbol = this.fSymbolTable.addSymbol("");
        if (this.fValidationHandler != null) {
            ((XMLComponent)((Object)this.fValidationHandler)).reset(componentManager);
        }
    }

    protected void setValidationHandler(RevalidationHandler validator) {
        this.fValidationHandler = validator;
    }

    protected void normalizeDocument(CoreDocumentImpl document) {
        if (this.fSymbolTable == null) {
            return;
        }
        this.fDocument = document;
        this.fErrorHandler = this.fDocument.getErrorHandler();
        if (this.fValidationHandler != null) {
            this.fValidationHandler.setBaseURI(this.fDocument.fDocumentURI);
            this.fValidationHandler.startDocument(null, this.fDocument.encoding, null);
        }
        Node kid = this.fDocument.getFirstChild();
        while (kid != null) {
            Node next = kid.getNextSibling();
            if ((kid = this.normalizeNode(kid)) != null) {
                next = kid;
            }
            kid = next;
        }
        if (this.fValidationHandler != null) {
            this.fValidationHandler.endDocument(null);
        }
        this.fSymbolTable = null;
    }

    protected Node normalizeNode(Node node) {
        short type = node.getNodeType();
        switch (type) {
            case 10: {
                if ((this.fDocument.features & 4) != 0) break;
                ((DocumentTypeImpl)node).entities.removeAll();
                break;
            }
            case 1: {
                AttributeMap attributes;
                this.fNamespaceBinder.pushContext();
                ElementImpl elem = (ElementImpl)node;
                if (elem.needsSyncChildren()) {
                    elem.synchronizeChildren();
                }
                AttributeMap attributeMap = attributes = elem.hasAttributes() ? (AttributeMap)elem.getAttributes() : null;
                if ((this.fDocument.features & 1) != 0) {
                    this.namespaceFixUp(elem, attributes);
                } else if (attributes != null) {
                    int i = 0;
                    while (i < attributes.getLength()) {
                        Attr attr = (Attr)attributes.item(i);
                        this.removeDefault(attr, attributes);
                        attr.normalize();
                        ++i;
                    }
                }
                if (this.fValidationHandler != null) {
                    this.fAttrProxy.setAttributes(attributes, this.fDocument, elem);
                    this.updateQName(elem, this.fQName);
                    this.fValidationHandler.startElement(this.fQName, this.fAttrProxy, null);
                }
                Node kid = elem.getFirstChild();
                while (kid != null) {
                    Node next = kid.getNextSibling();
                    if ((kid = this.normalizeNode(kid)) != null) {
                        next = kid;
                    }
                    kid = next;
                }
                if (this.fValidationHandler != null) {
                    this.updateQName(elem, this.fQName);
                    this.fValidationHandler.endElement(this.fQName, null);
                    int count = this.fNamespaceBinder.getDeclaredPrefixCount();
                    int i = count - 1;
                    while (i >= 0) {
                        String prefix = this.fNamespaceBinder.getDeclaredPrefixAt(i);
                        this.fValidationHandler.endPrefixMapping(prefix, null);
                        --i;
                    }
                }
                this.fNamespaceBinder.popContext();
                break;
            }
            case 8: {
                Node nextSibling;
                if ((this.fDocument.features & 0x40) != 0) break;
                Node prevSibling = node.getPreviousSibling();
                Node parent = node.getParentNode();
                parent.removeChild(node);
                if (prevSibling == null || prevSibling.getNodeType() != 3 || (nextSibling = prevSibling.getNextSibling()) == null || nextSibling.getNodeType() != 3) break;
                ((TextImpl)nextSibling).insertData(0, prevSibling.getNodeValue());
                parent.removeChild(prevSibling);
                return nextSibling;
            }
            case 5: {
                Node next;
                if ((this.fDocument.features & 4) != 0) break;
                Node prevSibling = node.getPreviousSibling();
                Node parent = node.getParentNode();
                ((EntityReferenceImpl)node).setReadOnly(false, true);
                this.expandEntityRef(node, parent, node);
                parent.removeChild(node);
                Node node2 = next = prevSibling != null ? prevSibling.getNextSibling() : parent.getFirstChild();
                if (prevSibling != null && prevSibling.getNodeType() == 3 && next.getNodeType() == 3) {
                    return prevSibling;
                }
                return next;
            }
            case 4: {
                if ((this.fDocument.features & 8) == 0) {
                    Text text = this.fDocument.createTextNode(node.getNodeValue());
                    Node parent = node.getParentNode();
                    Node prevSibling = node.getPreviousSibling();
                    node = parent.replaceChild(text, node);
                    if (prevSibling != null && prevSibling.getNodeType() == 3) {
                        text.insertData(0, prevSibling.getNodeValue());
                        parent.removeChild(prevSibling);
                    }
                    return text;
                }
                if (this.fValidationHandler != null) {
                    this.fValidationHandler.startCDATA(null);
                    this.fValidationHandler.characterData(node.getNodeValue(), null);
                    this.fValidationHandler.endCDATA(null);
                }
                if ((this.fDocument.features & 0x20) == 0) break;
                String value = node.getNodeValue();
                int index = value.indexOf("]]>");
                if (index >= 0) {
                    // empty if block
                }
                Node parent = node.getParentNode();
                while (index >= 0) {
                    node.setNodeValue(value.substring(0, index + 2));
                    value = value.substring(index + 2);
                    node = this.fDocument.createCDATASection(value);
                    parent.insertBefore(node, node.getNextSibling());
                    index = value.indexOf("]]>");
                }
                break;
            }
            case 3: {
                int nextType;
                Node next = node.getNextSibling();
                if (next != null && next.getNodeType() == 3) {
                    ((Text)node).appendData(next.getNodeValue());
                    node.getParentNode().removeChild(next);
                    return node;
                }
                if (node.getNodeValue().length() == 0) {
                    node.getParentNode().removeChild(node);
                    break;
                }
                if (this.fValidationHandler == null) break;
                int n = nextType = next != null ? (int)next.getNodeType() : -1;
                if ((this.fDocument.features & 4) == 0 && nextType == 6 || (this.fDocument.features & 0x40) == 0 && nextType == 8 || (this.fDocument.features & 8) == 0 && nextType == 4) break;
                this.fValidationHandler.characterData(node.getNodeValue(), null);
                break;
            }
        }
        return null;
    }

    protected void expandEntityRef(Node node, Node parent, Node reference) {
        Node kid = node.getFirstChild();
        while (kid != null) {
            Node next = kid.getNextSibling();
            if (node.getNodeType() == 3) {
                this.expandEntityRef(kid, parent, reference);
            } else {
                parent.insertBefore(kid, reference);
            }
            kid = next;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void namespaceFixUp(ElementImpl element, AttributeMap attributes) {
        block38: {
            uri = element.getNamespaceURI();
            prefix = element.getPrefix();
            if (uri != null) {
                uri = this.fSymbolTable.addSymbol(uri);
                v0 = prefix = prefix == null || prefix.length() == 0 ? this.fEmptySymbol : this.fSymbolTable.addSymbol(prefix);
                if (this.fNamespaceBinder.getURI(prefix) != uri) {
                    this.addNamespaceDecl(prefix, uri, element);
                    this.fLocalNSBinder.declarePrefix(prefix, uri);
                    this.fNamespaceBinder.declarePrefix(prefix, uri);
                    if (this.fValidationHandler != null) {
                        this.fValidationHandler.startPrefixMapping(prefix, uri, null);
                    }
                }
            } else {
                tagName = element.getNodeName();
                colon = tagName.indexOf(58);
                if (colon > -1) {
                    colon2 = tagName.lastIndexOf(58);
                    if (colon != colon2) {
                        if (this.fErrorHandler != null) {
                            this.modifyDOMError("Element's name is not a QName: " + tagName, (short)1, element);
                            continueProcess = this.fErrorHandler.handleError(this.fDOMError);
                        }
                    } else if (this.fErrorHandler != null) {
                        this.modifyDOMError("Element <" + tagName + "> does not belong to any namespace: prefix could be undeclared or bound to some namespace", (short)0, element);
                        continueProcess = this.fErrorHandler.handleError(this.fDOMError);
                    }
                } else {
                    uri = this.fNamespaceBinder.getURI(this.fEmptySymbol);
                    if (uri != null && uri.length() > 0) {
                        this.addNamespaceDecl(this.fEmptySymbol, this.fEmptySymbol, element);
                        this.fLocalNSBinder.declarePrefix(this.fEmptySymbol, this.fEmptySymbol);
                        this.fNamespaceBinder.declarePrefix(this.fEmptySymbol, this.fEmptySymbol);
                        if (this.fValidationHandler != null) {
                            this.fValidationHandler.startPrefixMapping(this.fEmptySymbol, this.fEmptySymbol, null);
                        }
                    }
                }
            }
            if (attributes == null) break block38;
            attributes.cloneMap(this.fAttributeList);
            i = 0;
            while (i < this.fAttributeList.size()) {
                block40: {
                    block39: {
                        attr = (Attr)this.fAttributeList.elementAt(i);
                        attr.normalize();
                        value = attr.getValue();
                        name = attr.getNodeName();
                        uri = attr.getNamespaceURI();
                        if (value == null) {
                            value = this.fEmptySymbol;
                        }
                        if (uri == null) break block39;
                        prefix = attr.getPrefix();
                        prefix = prefix == null || prefix.length() == 0 ? this.fEmptySymbol : this.fSymbolTable.addSymbol(prefix);
                        localpart = this.fSymbolTable.addSymbol(attr.getLocalName());
                        if (prefix == this.fXmlnsSymbol) {
                            uri = this.fNamespaceBinder.getURI(localpart);
                            localUri = this.fLocalNSBinder.getURI(localpart);
                            value = this.fSymbolTable.addSymbol(value);
                            if ((uri == null || localUri == null) && value.length() != 0) {
                                this.fNamespaceBinder.declarePrefix(localpart, value);
                                this.fLocalNSBinder.declarePrefix(localpart, value);
                                if (this.fValidationHandler != null) {
                                    this.fValidationHandler.startPrefixMapping(localpart, value, null);
                                }
                            }
                            this.removeDefault(attr, attributes);
                        } else if (localpart == this.fXmlnsSymbol && prefix == this.fEmptySymbol) {
                            uri = this.fNamespaceBinder.getURI(this.fEmptySymbol);
                            localUri = this.fLocalNSBinder.getURI(this.fEmptySymbol);
                            value = this.fSymbolTable.addSymbol(value);
                            if (localUri == null) {
                                this.fLocalNSBinder.declarePrefix(this.fEmptySymbol, value);
                                this.fNamespaceBinder.declarePrefix(this.fEmptySymbol, value);
                                if (this.fValidationHandler != null) {
                                    this.fValidationHandler.startPrefixMapping(this.fEmptySymbol, value, null);
                                }
                            }
                            this.removeDefault(attr, attributes);
                        } else {
                            this.removeDefault(attr, attributes);
                            uri = this.fSymbolTable.addSymbol(uri);
                            declaredURI = this.fNamespaceBinder.getURI(prefix);
                            if (prefix == this.fEmptySymbol || declaredURI != uri) {
                                name = attr.getNodeName();
                                declaredPrefix = this.fNamespaceBinder.getPrefix(uri);
                                if (declaredPrefix == null || declaredPrefix == this.fEmptySymbol) {
                                    if (prefix == this.fEmptySymbol) {
                                        prefix = "NS" + this.fNamespaceCounter++;
                                    }
                                    this.addNamespaceDecl(prefix, uri, element);
                                    value = this.fSymbolTable.addSymbol(value);
                                    this.fLocalNSBinder.declarePrefix(prefix, value);
                                    this.fNamespaceBinder.declarePrefix(prefix, uri);
                                    if (this.fValidationHandler != null) {
                                        this.fValidationHandler.startPrefixMapping(prefix, uri, null);
                                    }
                                } else {
                                    prefix = declaredPrefix;
                                }
                                attr.setPrefix(prefix);
                            }
                        }
                        break block40;
                    }
                    colon = name.indexOf(58);
                    colon2 = name.lastIndexOf(58);
                    if (!name.startsWith(this.fXmlnsSymbol)) ** GOTO lbl130
                    if (colon < 0) {
                        uri = this.fNamespaceBinder.getURI(this.fEmptySymbol);
                        localUri = this.fLocalNSBinder.getURI(this.fEmptySymbol);
                        if (localUri == null) {
                            value = this.fSymbolTable.addSymbol(value);
                            this.fNamespaceBinder.declarePrefix(this.fEmptySymbol, value);
                            this.fLocalNSBinder.declarePrefix(this.fEmptySymbol, value);
                            this.removeDefault(attr, attributes);
                        }
                    } else {
                        if (colon == colon2) {
                            prefix = name.substring(6);
                            v1 = prefix = prefix.length() == 0 ? this.fEmptySymbol : this.fSymbolTable.addSymbol(prefix);
                            if (prefix.length() == 0 || value.length() == 0) {
                                // empty if block
                            }
                            uri = this.fNamespaceBinder.getURI(prefix);
                            localUri = this.fLocalNSBinder.getURI(prefix);
                            if ((uri == null || localUri == null) && value.length() != 0) {
                                value = this.fSymbolTable.addSymbol(value);
                                this.fNamespaceBinder.declarePrefix(prefix, value);
                                this.fLocalNSBinder.declarePrefix(prefix, value);
                            }
                        }
lbl130:
                        // 6 sources

                        this.removeDefault(attr, attributes);
                        if (colon > -1) {
                            if (colon != colon2) {
                                if (this.fErrorHandler != null) {
                                    this.modifyDOMError("Attribute's name is not a QName: " + name, (short)1, attr);
                                    continueProcess = this.fErrorHandler.handleError(this.fDOMError);
                                }
                            } else if (this.fErrorHandler != null) {
                                this.modifyDOMError("Attribute '" + name + "' does not belong to any namespace: prefix could be undeclared or bound to some namespace", (short)0, attr);
                                continueProcess = this.fErrorHandler.handleError(this.fDOMError);
                            }
                        }
                    }
                }
                ++i;
            }
        }
    }

    protected void addNamespaceDecl(String prefix, String uri, ElementImpl element) {
        if (prefix == this.fEmptySymbol) {
            element.setAttributeNS(NamespaceContext.XMLNS_URI, "xmlns", uri);
        } else {
            element.setAttributeNS(NamespaceContext.XMLNS_URI, "xmlns:" + prefix, uri);
        }
    }

    protected void removeDefault(Attr attribute, AttributeMap attrMap) {
        if ((this.fDocument.features & 0x10) != 0 && !attribute.getSpecified()) {
            attrMap.removeItem(attribute, false);
        }
    }

    protected DOMError modifyDOMError(String message, short severity, Node node) {
        this.fDOMError.reset();
        this.fDOMError.setMessage(message);
        this.fDOMError.setSeverity(severity);
        this.fDOMError.setLocator(new DOMLocatorImpl(-1, -1, -1, node, null));
        return this.fDOMError;
    }

    protected void updateQName(Node node, QName qname) {
        String prefix = node.getPrefix();
        String namespace = node.getNamespaceURI();
        String localName = node.getLocalName();
        qname.prefix = prefix != null && prefix.length() != 0 ? this.fSymbolTable.addSymbol(prefix) : null;
        qname.localpart = localName != null ? this.fSymbolTable.addSymbol(localName) : null;
        qname.rawname = this.fSymbolTable.addSymbol(node.getNodeName());
        qname.uri = namespace != null ? this.fSymbolTable.addSymbol(namespace) : null;
    }

    public Grammar[] retrieveInitialGrammarSet(String grammarType) {
        this.fGrammarPool[0] = this.fDocument.fGrammar;
        return null;
    }

    public void cacheGrammars(String grammarType, Grammar[] grammars) {
    }

    public Grammar retrieveGrammar(XMLGrammarDescription desc) {
        return null;
    }

    public void lockPool() {
    }

    public void unlockPool() {
    }

    public void clear() {
    }

    protected final class XMLAttributesProxy
    implements XMLAttributes {
        protected AttributeMap fAttributes;
        protected CoreDocumentImpl fDocument;
        protected ElementImpl fElement;
        protected final Vector fAugmentations = new Vector(5);

        protected XMLAttributesProxy() {
        }

        public void setAttributes(AttributeMap attributes, CoreDocumentImpl doc, ElementImpl elem) {
            this.fDocument = doc;
            this.fAttributes = attributes;
            this.fElement = elem;
            if (attributes != null) {
                int length = attributes.getLength();
                this.fAugmentations.setSize(length);
                int i = 0;
                while (i < length) {
                    this.fAugmentations.setElementAt(new AugmentationsImpl(), i);
                    ++i;
                }
            } else {
                this.fAugmentations.setSize(0);
            }
        }

        public int addAttribute(QName attrQName, String attrType, String attrValue) {
            Attr attr = this.fDocument.createAttributeNS(attrQName.uri, attrQName.rawname, attrQName.localpart);
            attr.setValue(attrValue);
            if (this.fAttributes == null) {
                this.fAttributes = (AttributeMap)this.fElement.getAttributes();
            }
            int index = this.fElement.setXercesAttributeNode(attr);
            this.fAugmentations.insertElementAt(new AugmentationsImpl(), index);
            return index;
        }

        public void removeAllAttributes() {
        }

        public void removeAttributeAt(int attrIndex) {
        }

        public int getLength() {
            return this.fAttributes != null ? this.fAttributes.getLength() : 0;
        }

        public int getIndex(String qName) {
            return -1;
        }

        public int getIndex(String uri, String localPart) {
            return -1;
        }

        public void setName(int attrIndex, QName attrName) {
        }

        public void getName(int attrIndex, QName attrName) {
            if (this.fAttributes != null) {
                DOMNormalizer.this.updateQName((Node)this.fAttributes.getItem(attrIndex), attrName);
            }
        }

        public String getPrefix(int index) {
            return null;
        }

        public String getURI(int index) {
            return null;
        }

        public String getLocalName(int index) {
            return null;
        }

        public String getQName(int index) {
            return null;
        }

        public void setType(int attrIndex, String attrType) {
        }

        public String getType(int index) {
            return "CDATA";
        }

        public String getType(String qName) {
            return "CDATA";
        }

        public String getType(String uri, String localName) {
            return "CDATA";
        }

        public void setValue(int attrIndex, String attrValue) {
        }

        public String getValue(int index) {
            return this.fAttributes.item(index).getNodeValue();
        }

        public String getValue(String qName) {
            return null;
        }

        public String getValue(String uri, String localName) {
            if (this.fAttributes != null) {
                Node node = this.fAttributes.getNamedItemNS(uri, localName);
                return node != null ? node.getNodeValue() : null;
            }
            return null;
        }

        public void setNonNormalizedValue(int attrIndex, String attrValue) {
        }

        public String getNonNormalizedValue(int attrIndex) {
            return null;
        }

        public void setSpecified(int attrIndex, boolean specified) {
            AttrImpl attr = (AttrImpl)this.fAttributes.getItem(attrIndex);
            attr.setSpecified(specified);
        }

        public boolean isSpecified(int attrIndex) {
            return ((Attr)this.fAttributes.getItem(attrIndex)).getSpecified();
        }

        public Augmentations getAugmentations(int attributeIndex) {
            return (Augmentations)this.fAugmentations.elementAt(attributeIndex);
        }

        public Augmentations getAugmentations(String uri, String localPart) {
            return null;
        }

        public Augmentations getAugmentations(String qName) {
            return null;
        }
    }
}

