/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.xs;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.xs.TypeValidator;
import org.apache.xerces.impl.dv.xs.XDecimal;
import org.apache.xerces.impl.validation.ValidationContext;

public class DecimalDV
extends TypeValidator {
    public short getAllowedFacets() {
        return 8176;
    }

    public Object getActualValue(String content, ValidationContext context) throws InvalidDatatypeValueException {
        int len = content.length();
        if (len == 0) {
            throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{content, "decimal"});
        }
        int intStart = 0;
        int intEnd = 0;
        int fracStart = 0;
        int fracEnd = 0;
        if (content.charAt(0) == '+') {
            intEnd = 1;
            intStart = 1;
        } else if (content.charAt(0) == '-') {
            intEnd = 1;
        }
        while (intEnd < len && TypeValidator.isDigit(content.charAt(intEnd))) {
            ++intEnd;
        }
        if (intEnd < len) {
            if (content.charAt(intEnd) != '.') {
                throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{content, "decimal"});
            }
            fracStart = intEnd + 1;
            fracEnd = len;
        }
        if (intStart == intEnd && fracStart == fracEnd) {
            throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{content, "decimal"});
        }
        int actualIntStart = content.charAt(intStart) == '-' ? intStart + 1 : intStart;
        while (actualIntStart < intEnd && content.charAt(actualIntStart) == '0') {
            ++actualIntStart;
        }
        while (fracEnd > fracStart && content.charAt(fracEnd - 1) == '0') {
            --fracEnd;
        }
        int fracPos = fracStart;
        while (fracPos < fracEnd) {
            if (!TypeValidator.isDigit(content.charAt(fracPos))) {
                throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{content, "decimal"});
            }
            ++fracPos;
        }
        int fracNum = fracEnd - fracStart;
        String intString = null;
        if (intEnd > intStart) {
            intString = content.substring(intStart, intEnd);
            if (fracNum > 0) {
                intString = intString + content.substring(fracStart, fracEnd);
            }
        } else {
            intString = fracNum > 0 ? content.substring(fracStart, fracEnd) : "0";
        }
        try {
            BigInteger intVal = new BigInteger(intString);
            return new XDecimal(intVal, intEnd - actualIntStart, fracNum);
        }
        catch (Exception nfe) {
            throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{content, "decimal"});
        }
    }

    public boolean isEqual(Object value1, Object value2) {
        if (!(value1 instanceof BigDecimal) || !(value2 instanceof BigDecimal)) {
            return false;
        }
        return ((BigDecimal)value1).compareTo((BigDecimal)value2) == 0;
    }

    public int compare(Object value1, Object value2) {
        return ((BigDecimal)value1).compareTo((BigDecimal)value2);
    }

    public int getTotalDigits(Object value) {
        return ((XDecimal)value).totalDigits;
    }

    public int getFractionDigits(Object value) {
        return ((BigDecimal)value).scale();
    }
}

