/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.xs;

import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.xs.AbstractDateTimeDV;
import org.apache.xerces.impl.dv.xs.SchemaDateTimeException;
import org.apache.xerces.impl.validation.ValidationContext;

public class YearDV
extends AbstractDateTimeDV {
    public Object getActualValue(String content, ValidationContext context) throws InvalidDatatypeValueException {
        try {
            return this.parse(content);
        }
        catch (Exception ex) {
            throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{content, "gYear"});
        }
    }

    protected int[] parse(String str) throws SchemaDateTimeException {
        int sign;
        int len = str.length();
        int[] date = new int[8];
        int[] timeZone = new int[2];
        int start = 0;
        if (str.charAt(0) == '-') {
            start = 1;
        }
        if ((sign = this.findUTCSign(str, start, len)) == -1) {
            date[0] = this.parseIntYear(str, len);
        } else {
            date[0] = this.parseIntYear(str, sign);
            this.getTimeZone(str, date, sign, len, timeZone);
        }
        date[1] = 1;
        date[2] = 1;
        this.validateDateTime(date, timeZone);
        if (date[7] != 0 && date[7] != 90) {
            this.normalize(date, timeZone);
        }
        return date;
    }

    protected String dateToString(int[] date) {
        StringBuffer message = new StringBuffer(5);
        message.append(date[0]);
        message.append((char)date[7]);
        return message.toString();
    }
}

