/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs;

import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.SchemaSymbols;
import org.apache.xerces.impl.xs.XSAttributeGroupDecl;
import org.apache.xerces.impl.xs.XSParticleDecl;
import org.apache.xerces.impl.xs.XSTypeDecl;
import org.apache.xerces.impl.xs.models.CMBuilder;
import org.apache.xerces.impl.xs.models.XSCMValidator;
import org.apache.xerces.impl.xs.psvi.XSComplexTypeDefinition;
import org.apache.xerces.impl.xs.psvi.XSObjectList;
import org.apache.xerces.impl.xs.psvi.XSParticle;
import org.apache.xerces.impl.xs.psvi.XSSimpleTypeDefinition;
import org.apache.xerces.impl.xs.psvi.XSTypeDefinition;
import org.apache.xerces.impl.xs.psvi.XSWildcard;

public class XSComplexTypeDecl
implements XSTypeDecl,
XSComplexTypeDefinition {
    public String fName = null;
    public String fTargetNamespace = null;
    public XSTypeDecl fBaseType = null;
    public short fDerivedBy = (short)2;
    public short fFinal = 0;
    public short fBlock = 0;
    public short fMiscFlags = 0;
    public XSAttributeGroupDecl fAttrGrp = new XSAttributeGroupDecl();
    public short fContentType = 0;
    public XSSimpleType fXSSimpleType = null;
    public XSParticleDecl fParticle = null;
    public XSCMValidator fCMValidator = null;
    private static final short CT_IS_ABSTRACT = 1;
    private static final short CT_HAS_TYPE_ID = 2;
    private static final short CT_IS_ANONYMOUS = 4;

    public short getTypeCategory() {
        return 13;
    }

    public String getTypeName() {
        return this.fName;
    }

    public short getFinalSet() {
        return this.fFinal;
    }

    public String getTargetNamespace() {
        return this.fTargetNamespace;
    }

    public boolean containsTypeID() {
        return (this.fMiscFlags & 2) != 0;
    }

    public void setIsAbstractType() {
        this.fMiscFlags = (short)(this.fMiscFlags | 1);
    }

    public void setContainsTypeID() {
        this.fMiscFlags = (short)(this.fMiscFlags | 2);
    }

    public void setIsAnonymous() {
        this.fMiscFlags = (short)(this.fMiscFlags | 4);
    }

    public synchronized XSCMValidator getContentModel(CMBuilder cmBuilder) {
        if (this.fCMValidator == null) {
            this.fCMValidator = cmBuilder.getContentModel(this);
        }
        return this.fCMValidator;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        this.appendTypeInfo(str);
        return str.toString();
    }

    void appendTypeInfo(StringBuffer str) {
        String[] contentType = new String[]{"EMPTY", "SIMPLE", "MIXED", "ELEMENT"};
        String[] derivedBy = new String[]{"EMPTY", "EXTENSION", "RESTRICTION"};
        str.append("Complex type name='" + this.fTargetNamespace + "," + this.getTypeName() + "', ");
        if (this.fBaseType != null) {
            str.append(" base type name='" + this.fBaseType.getName() + "', ");
        }
        str.append(" content type='" + contentType[this.fContentType] + "', ");
        str.append(" isAbstract='" + this.getIsAbstract() + "', ");
        str.append(" hasTypeId='" + this.containsTypeID() + "', ");
        str.append(" final='" + this.fFinal + "', ");
        str.append(" block='" + this.fBlock + "', ");
        if (this.fParticle != null) {
            str.append(" particle='" + this.fParticle.toString() + "', ");
        }
        str.append(" derivedBy='" + derivedBy[this.fDerivedBy] + "'. ");
    }

    public boolean derivedFrom(XSTypeDefinition ancestor) {
        if (ancestor == null) {
            return false;
        }
        if (ancestor == SchemaGrammar.fAnyType) {
            return true;
        }
        XSTypeDefinition type = this;
        while (type != ancestor && type != SchemaGrammar.fAnySimpleType && type != SchemaGrammar.fAnyType) {
            type = type.getBaseType();
        }
        return type == ancestor;
    }

    public boolean derivedFrom(String ancestorNS, String ancestorName) {
        if (ancestorName == null) {
            return false;
        }
        if (ancestorNS != null && ancestorNS.equals(SchemaSymbols.URI_SCHEMAFORSCHEMA) && ancestorName.equals("anyType")) {
            return true;
        }
        XSTypeDecl type = this;
        while (!(ancestorName.equals(type.getName()) && (ancestorNS == null && type.getNamespace() == null || ancestorNS != null && ancestorNS.equals(type.getNamespace())) || type == SchemaGrammar.fAnySimpleType || type == SchemaGrammar.fAnyType)) {
            type = (XSTypeDecl)type.getBaseType();
        }
        return type != SchemaGrammar.fAnySimpleType && type != SchemaGrammar.fAnyType;
    }

    public void reset() {
        this.fName = null;
        this.fTargetNamespace = null;
        this.fBaseType = null;
        this.fDerivedBy = (short)2;
        this.fFinal = 0;
        this.fBlock = 0;
        this.fMiscFlags = 0;
        this.fAttrGrp.reset();
        this.fContentType = 0;
        this.fXSSimpleType = null;
        this.fParticle = null;
        this.fCMValidator = null;
    }

    public short getType() {
        return 3;
    }

    public String getName() {
        return this.getIsAnonymous() ? null : this.fName;
    }

    public boolean getIsAnonymous() {
        return (this.fMiscFlags & 4) != 0;
    }

    public String getNamespace() {
        return this.fTargetNamespace;
    }

    public XSTypeDefinition getBaseType() {
        return this.fBaseType;
    }

    public short getDerivationMethod() {
        return this.fDerivedBy;
    }

    public boolean getIsFinal(short derivation) {
        return (this.fFinal & derivation) != 0;
    }

    public short getFinal() {
        return this.fFinal;
    }

    public boolean getIsAbstract() {
        return (this.fMiscFlags & 1) != 0;
    }

    public XSObjectList getAttributeUses() {
        return this.fAttrGrp.getAttributeUses();
    }

    public XSWildcard getAttributeWildcard() {
        return this.fAttrGrp.getAttributeWildcard();
    }

    public short getContentType() {
        return this.fContentType;
    }

    public XSSimpleTypeDefinition getSimpleType() {
        return this.fXSSimpleType;
    }

    public XSParticle getParticle() {
        return this.fParticle;
    }

    public boolean getIsProhibitedSubstitution(short prohibited) {
        return (this.fBlock & prohibited) != 0;
    }

    public short getProhibitedSubstitutions() {
        return this.fBlock;
    }

    public XSObjectList getAnnotations() {
        return null;
    }
}

