/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.AltCallingConvention;
import com.sun.jna.Function;
import com.sun.jna.FunctionMapper;
import com.sun.jna.NativeLibrary;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public interface Library {
    public static final String OPTION_TYPE_MAPPER = "type-mapper";
    public static final String OPTION_FUNCTION_MAPPER = "function-mapper";
    public static final String OPTION_STRUCTURE_ALIGNMENT = "structure-alignment";

    static class 1 {
        static /* synthetic */ Class class$java$lang$Object;
        static /* synthetic */ Class class$com$sun$jna$Library;
    }

    public static class Handler
    implements InvocationHandler {
        private static final Method OBJECT_TOSTRING;
        private NativeLibrary nativeLibrary;
        private Class interfaceClass;
        private Map options;
        private FunctionMapper functionMapper;
        private Map functions = new WeakHashMap();

        public Handler(String libname, Class interfaceClass, Map options) {
            if (libname == null || libname.trim().length() == 0) {
                throw new IllegalArgumentException("Invalid library name \"" + libname + "\"");
            }
            if (!(1.class$com$sun$jna$Library == null ? (1.class$com$sun$jna$Library = 1.class$("com.sun.jna.Library")) : 1.class$com$sun$jna$Library).isAssignableFrom(interfaceClass)) {
                throw new IllegalArgumentException("Invalid interface class \"" + interfaceClass + "\"");
            }
            this.nativeLibrary = NativeLibrary.getInstance(libname);
            this.interfaceClass = interfaceClass;
            this.options = options;
            this.functionMapper = (FunctionMapper)options.get(Library.OPTION_FUNCTION_MAPPER);
            if (this.functionMapper == null) {
                this.functionMapper = new FunctionNameMap(options);
            }
        }

        public String getLibraryName() {
            return this.nativeLibrary.getName();
        }

        public Class getInterfaceClass() {
            return this.interfaceClass;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(Object proxy, Method method, Object[] inArgs) throws Throwable {
            if (method == OBJECT_TOSTRING) {
                return "Proxy interface to " + this.nativeLibrary.toString();
            }
            Function f = null;
            Map map = this.functions;
            synchronized (map) {
                f = (Function)this.functions.get(method);
                if (f == null) {
                    String methodName = this.functionMapper.getFunctionName(this.nativeLibrary, method);
                    int callingConvention = proxy instanceof AltCallingConvention ? 1 : 0;
                    f = this.nativeLibrary.getFunction(methodName, callingConvention);
                    this.functions.put(method, f);
                }
            }
            return f.invoke(method.getReturnType(), inArgs, this.options);
        }

        static {
            try {
                OBJECT_TOSTRING = (1.class$java$lang$Object == null ? (1.class$java$lang$Object = 1.class$("java.lang.Object")) : 1.class$java$lang$Object).getMethod("toString", null);
            }
            catch (Exception e) {
                throw new Error("Error retrieving Object.toString() method");
            }
        }

        private static class FunctionNameMap
        implements FunctionMapper {
            private final Map map;

            public FunctionNameMap(Map map) {
                this.map = new HashMap(map);
            }

            public String getFunctionName(NativeLibrary library, Method method) {
                String name = method.getName();
                if (this.map.containsKey(name)) {
                    return (String)this.map.get(name);
                }
                return name;
            }
        }
    }
}

