/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Pointer;

public class NativeLong
extends Number {
    public static final int SIZE = Pointer.LONG_SIZE;
    private final Number value;

    public NativeLong(long value) {
        if (SIZE == 4) {
            long masked = value & Integer.MIN_VALUE;
            if (masked != 0L && masked != Integer.MIN_VALUE) {
                throw new IllegalArgumentException("Argument exceeds native long capacity");
            }
            this.value = new Integer((int)(value & 0xFFFFFFFFFFFFFFFFL));
        } else {
            this.value = new Long(value);
        }
    }

    Number asNativeValue() {
        return this.value;
    }

    public int intValue() {
        return this.value.intValue();
    }

    public long longValue() {
        return this.value.longValue();
    }

    public float floatValue() {
        return this.value.floatValue();
    }

    public double doubleValue() {
        return this.value.doubleValue();
    }

    public boolean equals(Object rhs) {
        return rhs instanceof NativeLong && this.value.equals(((NativeLong)rhs).value);
    }

    public String toString() {
        return this.value.toString();
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

