/*
 * This file is part of jDiffChaser.
 *
 *  jDiffChaser is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  jDiffChaser is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with jDiffChaser; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package org.jdiffchaser.scenarihandling;

import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;

public class IgnoredAreaMouseMotionAdapter implements MouseMotionListener, MouseListener{
    
    private Point startPoint;
    private Rectangle ignoredZone;
    private Container container;
    
    private List ignoredZones = new ArrayList();
    
    /** Creates a new instance of IgnoredAreaAdapter */
    public IgnoredAreaMouseMotionAdapter(Container container) {
        this.container = container;
    }
    
    public void reset(){
        if(ignoredZones!=null){
            ignoredZones.clear();
        }
        ignoredZones = null;
        ignoredZone = null;
    }
    
    public Rectangle getCurrentIgnoredZone(){
        return this.ignoredZone;
    }

    public List getIgnoredZones(){
        return this.ignoredZones;
    }
    
    public void mouseDragged(MouseEvent me){
        
        int newX = Math.max(me.getPoint().x, 0);
        newX = Math.min(newX, this.container.getWidth());
        int newY = Math.max(me.getPoint().y, 0);
        newY = Math.min(newY, this.container.getHeight());
        
        ignoredZone = new Rectangle(Math.min(this.startPoint.x, newX), 
                                    Math.min(this.startPoint.y, newY), 
                                    Math.abs(newX - this.startPoint.x), 
                                    Math.abs(newY - this.startPoint.y));
        this.container.repaint();
    }

    public void mouseMoved(MouseEvent me){
    }
    
    public void mousePressed(MouseEvent me){
        this.startPoint = me.getPoint();
    }
    
    public void mouseReleased(MouseEvent me){
        if( JOptionPane.OK_OPTION == JOptionPane.showConfirmDialog(this.container, 
                                                        "Do you really want to ignore\nthis zone during the tests?", 
                                                        "Are you sure?", 
                                                        JOptionPane.OK_CANCEL_OPTION)){
            this.ignoredZones.add(this.ignoredZone);
        }
        
        this.ignoredZone=null;
        this.container.repaint();
    }
    
    public void mouseEntered(MouseEvent me){
    }

    public void mouseExited(MouseEvent me){
    }

    public void mouseClicked(MouseEvent me){
    }
}
