/*
 * This file is part of jDiffChaser.
 *
 *  jDiffChaser is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  jDiffChaser is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with jDiffChaser; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package org.jdiffchaser.scenarihandling.events;

import java.awt.AWTEvent;
import java.awt.Event;
import java.util.List;


public class ComparisonEvent extends AWTEvent{
    //for backward compatibility with scenarios written with previous version of jdiffchaser
    static final long serialVersionUID = -313186075761774392L; 
    
    private boolean fullScreen;
    
    private List ignoredZones; //Rectangles
    
    public ComparisonEvent(Event event) {
        super(event);
    }
    
    public ComparisonEvent(Object source, int id, List ignoredZones) {
        this(source, id, ignoredZones, false);
    }
    
    public ComparisonEvent(Object source, int id, List ignoredZones, boolean fullScreen) {
        super(source, id);
        this.ignoredZones = ignoredZones;
        this.fullScreen = fullScreen;
    }
    
    /**
     * @returns a list of Rectangle to ignore
     */
    public List getIgnoredZones(){
        return this.ignoredZones;
    }
    
    public boolean isFullScreen(){
        return this.fullScreen;
    }
    
}
