/*
 * TestSetTest.java
 * JUnit based test
 *
 * Created on 26. juillet 2007, 08:05
 */

package org.jdiffchaser.scenarihandling;

import junit.framework.*;
import junitx.framework.*;
import java.io.FilenameFilter;
import org.jdiffchaser.imgprocessing.ImageComparator;
import org.jdiffchaser.scenarihandling.events.RecordableEvent;
import org.jdiffchaser.scenarihandling.events.StartEvent;
import org.jdiffchaser.testing.RemoteTestLauncher;
import org.jdiffchaser.utils.ImageUtilities;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import javax.imageio.ImageIO;

/**
 *
 * @author InCH Team
 */
public class TestSetTest extends PrivateTestCase {
    
    public TestSetTest(String testName) {
        super(testName);
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(TestSetTest.class);
        
        return suite;
    }

    public void testGetLastElementFromPath() throws Throwable{
        try{
            String result = (String) invokeStatic(TestSet.class, "getLastElementFromPath", 
                                                  new Object[]{"/user/jl/toto/sketchsamples/scenarios/menus\\"});
            assertNotNull(result);
            assertEquals("menus/", result);
            result = (String) invokeStatic(TestSet.class, "getLastElementFromPath", 
                                                  new Object[]{"/user/jl/toto/sketchsamples/scenarios/menus/"});
            assertNotNull(result);
            assertEquals("menus/", result);            
            result = (String) invokeStatic(TestSet.class, "getLastElementFromPath", 
                                                  new Object[]{"/user/jl/toto/sketchsamples/scenarios/menus"});
            assertNotNull(result);
            assertEquals("menus/", result);            
        }catch(TestAccessException tae){
            if(tae.getReason()!=null){
                throw tae.getReason().getCause();
            }else{
                throw tae;
            }
        }
    }
}
