/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.smalltalk;

import jp.co.sra.smalltalk.SmalltalkException;
import jp.co.sra.smalltalk.StObject;
import jp.co.sra.smalltalk.StReadStream;

public class StNumber
extends StObject {
    public static final int UNKNOWN = 0;
    public static final int INTEGER = 1;
    public static final int FLOAT = 2;
    public static final int DOUBLE = 3;

    private StNumber() {
    }

    public static Number _Negate(Number number) {
        if (number instanceof Integer) {
            return new Integer(-number.intValue());
        }
        if (number instanceof Long) {
            return new Long(-number.longValue());
        }
        if (number instanceof Float) {
            return new Float(-number.floatValue());
        }
        if (number instanceof Double) {
            return new Double(-number.doubleValue());
        }
        return null;
    }

    public static Number ReadFrom_(StReadStream stReadStream) {
        return StNumber.ReadSmalltalkSyntaxFrom_(stReadStream);
    }

    protected static long CheckForOldSyntax_with_on_(int n, long l, StReadStream stReadStream) {
        if (!stReadStream.atEnd() && stReadStream.peekFor_('.')) {
            if (!stReadStream.atEnd() && Character.digit(stReadStream.peek(), n) < 0) {
                throw new SmalltalkException("Non-radix 10 numbers may not contain decimal points");
            }
            stReadStream.skip_(-1);
        }
        if (!stReadStream.atEnd() && Character.toLowerCase(stReadStream.peek()) == 'e') {
            throw new SmalltalkException("Non-radix 10 numbers may not contain decimal points");
        }
        return l;
    }

    protected static int ChooseFloatRepresentationFor_(char c) {
        int n;
        switch (c) {
            case 'e': 
            case 's': {
                n = 2;
                break;
            }
            case 'd': 
            case 'q': {
                n = 3;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    protected static int ReadIntegerFrom_radix_(StReadStream stReadStream, int n) {
        int n2 = 0;
        while (!stReadStream.atEnd()) {
            int n3 = Character.digit(stReadStream.next(), n);
            if (n3 < 0) {
                stReadStream.skip_(-1);
                return n2;
            }
            n2 = n2 * n + n3;
        }
        return n2;
    }

    protected static long ReadLongFrom_radix_(StReadStream stReadStream, int n) {
        long l = 0L;
        while (!stReadStream.atEnd()) {
            int n2 = Character.digit(stReadStream.next(), n);
            if (n2 < 0) {
                stReadStream.skip_(-1);
                return l;
            }
            l = l * (long)n + (long)n2;
        }
        return l;
    }

    protected static Number ReadSmalltalkFloat_from_(long l, StReadStream stReadStream) {
        Number number;
        char c;
        int n;
        int n2 = 1;
        double d = 0.0;
        double d2 = 0.1;
        if (stReadStream.peekFor_('.')) {
            if (!stReadStream.atEnd() && Character.isDigit(stReadStream.peek())) {
                n2 = 2;
                while (true) {
                    boolean bl = stReadStream.atEnd();
                    n = bl ? 1 : 0;
                    if (bl || !Character.isDigit(c = stReadStream.next())) break;
                    d += d2 * (double)(c - 48);
                    d2 /= 10.0;
                }
                if (n == 0) {
                    stReadStream.skip_(-1);
                }
            } else {
                stReadStream.skip_(-1);
            }
        }
        if (stReadStream.peek() == '\u0000') {
            n = 0;
            c = '\u0000';
        } else {
            c = Character.toLowerCase(stReadStream.peek());
            n = StNumber.ChooseFloatRepresentationFor_(c);
            if (n != 0) {
                stReadStream.next();
            }
        }
        int n3 = 0;
        if (n != 0) {
            boolean bl;
            n2 = n;
            int n4 = stReadStream.position();
            boolean bl2 = bl = '-' == stReadStream.peek();
            if (bl) {
                stReadStream.next();
            }
            if (stReadStream.peek() != '\u0000' && Character.isDigit(stReadStream.peek())) {
                n3 = StNumber.ReadIntegerFrom_radix_(stReadStream, 10);
                if (bl) {
                    n3 = -n3;
                }
            } else {
                stReadStream.position_(n4);
            }
        }
        if (n2 == 1) {
            Number number2 = Integer.MIN_VALUE <= l && l <= Integer.MAX_VALUE ? (Number)new Integer((int)l) : (Number)new Long(l);
            return number2;
        }
        double d3 = (double)l + d;
        if (n3 != 0) {
            switch (c) {
                case 'd': 
                case 'q': {
                    if (n3 < 0) {
                        for (int i = 0; i > n3; --i) {
                            d3 /= 10.0;
                        }
                    } else {
                        for (int i = 0; i < n3; ++i) {
                            d3 *= 10.0;
                        }
                    }
                    number = new Double(d3);
                    break;
                }
                case 'e': {
                    if (n3 < 0) {
                        for (int i = 0; i > n3; --i) {
                            d3 /= 10.0;
                        }
                    } else {
                        for (int i = 0; i < n3; ++i) {
                            d3 *= 10.0;
                        }
                    }
                    number = new Float(d3);
                    break;
                }
                case 's': {
                    number = new Float(d3);
                    break;
                }
                default: {
                    number = new Float(d3);
                    break;
                }
            }
        } else {
            number = n2 == 2 ? (Number)new Float((float)d3) : (Number)new Double(d3);
        }
        return number;
    }

    protected static int ReadSmalltalkRadix_from_(int n, StReadStream stReadStream) {
        if (n < 2) {
            throw SmalltalkException.Error("INVALID RADIX");
        }
        if (stReadStream.atEnd() || Character.digit(stReadStream.next(), n) < 0) {
            stReadStream.skip_(-1);
            return n;
        }
        return StNumber.ReadIntegerFrom_radix_(stReadStream, n);
    }

    protected static Number ReadSmalltalkSyntaxFrom_(StReadStream stReadStream) {
        if (stReadStream.atEnd() || Character.isLetter(stReadStream.peek())) {
            return new Integer(0);
        }
        boolean bl = stReadStream.peekFor_('-');
        long l = StNumber.ReadLongFrom_radix_(stReadStream, 10);
        if (stReadStream.peekFor_('r')) {
            int n = (int)l;
            l = StNumber.ReadSmalltalkRadix_from_(n, stReadStream);
            l = StNumber.CheckForOldSyntax_with_on_(n, l, stReadStream);
            if (Integer.MIN_VALUE <= (l *= (long)(bl ? -1 : 1)) && l <= Integer.MAX_VALUE) {
                return new Integer((int)l);
            }
            return new Long(l);
        }
        Number number = StNumber.ReadSmalltalkFloat_from_(l, stReadStream);
        return bl ? (Number)StNumber._Negate(number) : (Number)number;
    }
}

