/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.smalltalk;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.HashMap;
import jp.co.sra.smalltalk.StApplicationModel;
import jp.co.sra.smalltalk.StApplicationWindow;
import jp.co.sra.smalltalk.StObject;
import jp.co.sra.smalltalk.StSymbol;
import jp.co.sra.smalltalk.StView;

public class StUIBuilder
extends StObject
implements WindowListener {
    protected StApplicationModel model;
    protected ArrayList windows;
    protected HashMap views;
    protected HashMap namedComponents;

    public StUIBuilder(StApplicationModel stApplicationModel) {
        this.model = stApplicationModel;
        this.windows = new ArrayList();
        this.views = new HashMap();
        this.namedComponents = new HashMap();
    }

    public Window window() {
        return this.windows.isEmpty() ? null : (Window)this.windows.get(0);
    }

    public Window[] windows() {
        return this.windows.toArray(new Window[this.windows.size()]);
    }

    public Frame[] frames() {
        Window[] windowArray = this.windows();
        ArrayList<Window> arrayList = new ArrayList<Window>(windowArray.length);
        for (int i = 0; i < windowArray.length; ++i) {
            if (!(windowArray[i] instanceof Frame)) continue;
            arrayList.add(windowArray[i]);
        }
        return arrayList.toArray(new Frame[arrayList.size()]);
    }

    protected StApplicationModel myModel() {
        return this.model;
    }

    public void addFrame_(Frame frame) {
        this.addWindow_(frame, null);
    }

    public void addWindow_(Window window, StView stView) {
        window.addWindowListener(this);
        this.windows.add(window);
        this.views.put(window, stView);
    }

    public void addWindow_(StApplicationWindow stApplicationWindow, StView stView) {
        this.addWindow_(stApplicationWindow.toWindow(), stView);
    }

    public void removeFrame_(Frame frame) {
        this.removeWindow_(frame);
    }

    public void removeWindow_(Window window) {
        window.removeWindowListener(this);
        this.windows.remove(window);
        this.views.remove(window);
    }

    public Component componentAt_(StSymbol stSymbol) {
        return (Component)this.namedComponents.get(stSymbol);
    }

    public void componentAt_put_(StSymbol stSymbol, Component component) {
        this.namedComponents.put(stSymbol, component);
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
        this.removeWindow_(windowEvent.getWindow());
        if (this.windows.isEmpty()) {
            this.myModel().allWindowsClosed();
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.myModel().noticeOfWindowClose(windowEvent);
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
        Window window = windowEvent.getWindow();
        if (window == null) {
            return;
        }
        StView stView = (StView)this.views.get(window);
        if (stView == null) {
            return;
        }
        this.myModel().postOpenWith_(stView);
    }
}

