/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.dxf.support;

import jp.co.sra.jun.system.framework.JunAbstractObject;
import jp.co.sra.smalltalk.SmalltalkException;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StReadStream;

public class JunDXFScanner
extends JunAbstractObject {
    protected StReadStream source;
    protected int mark;
    protected String dataKey;
    protected String dataString;
    protected Number dataNumber;
    protected char lineSeparator;
    protected int lines;
    protected StBlockClosure failBlock;
    protected int groupCode;

    public static String ContractTo(String string, int n) {
        int n2 = string.length();
        if (n2 <= n) {
            return string;
        }
        int n3 = n / 2 - 1;
        return string.substring(0, n3) + "..." + string.substring(n2 - n + n3 + 3);
    }

    protected void findSeparator() {
        char c = '\u0000';
        while (c == '\u0000' && !this.source.atEnd()) {
            char c2 = this.source.next();
            if (c2 == '\n') {
                c = c2;
                continue;
            }
            if (c2 != 13) continue;
            c = c2;
            if (this.source.peek() != '\n') continue;
            this.source.next();
        }
        if (c != '\u0000') {
            this.lineSeparator_(c);
        }
        this.source.position_(0);
    }

    protected void initialize() {
        super.initialize();
        this.initScanner();
        this.lineSeparator = (char)13;
    }

    protected void initScanner() {
        this.lines = 0;
        this.failBlock = new StBlockClosure(){

            public Object value_(Object object) {
                String string = (String)object;
                String string2 = string + " near " + JunDXFScanner.ContractTo(JunDXFScanner.this.dataString, 10);
                String string3 = JunDXFScanner.this.source.upToEnd();
                string3 = string3.length() == 0 ? "--> end of file" : "--> " + JunDXFScanner.ContractTo(string3, 30);
                throw SmalltalkException.Error((String)(string2 + "\n" + string3));
            }
        };
    }

    protected char lineSeparator() {
        return this.lineSeparator;
    }

    protected void lineSeparator_(char c) {
        this.lineSeparator = c;
    }

    protected void nextPair() {
        char c;
        int n;
        char c2;
        while (!this.source.atEnd() && Character.isWhitespace(c2 = this.source.peek())) {
            this.source.next();
        }
        this.mark = this.source.position();
        if (this.source.atEnd()) {
            this.dataKey = "eof";
            this.dataString = "EOF";
            return;
        }
        String string = this.source.upTo_(this.lineSeparator());
        ++this.lines;
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < string.length(); ++n) {
            c = string.charAt(n);
            if (!Character.isDigit(c)) continue;
            stringBuffer.append(c);
        }
        this.dataKey = stringBuffer.toString();
        this.groupCode = Integer.parseInt(this.dataKey);
        string = this.source.upTo_(this.lineSeparator());
        ++this.lines;
        stringBuffer = new StringBuffer();
        for (n = 0; n < string.length(); ++n) {
            c = string.charAt(n);
            if (Character.isWhitespace(c)) continue;
            stringBuffer.append(c);
        }
        this.dataString = stringBuffer.toString();
        if (10 <= this.groupCode && this.groupCode <= 59) {
            this.dataNumber = new Double(this.dataString);
        } else if (60 <= this.groupCode && this.groupCode < 100) {
            this.dataNumber = new Long(this.dataString);
        }
    }

    protected void on_(StReadStream stReadStream) {
        this.source = stReadStream;
        this.mark = this.source.position();
    }

    protected void onSmart_(StReadStream stReadStream) {
        this.on_(stReadStream);
        this.findSeparator();
    }

    protected void unNextPair() {
        this.source.position_(this.mark);
        this.lines -= 2;
    }
}

