/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.geometry.boxtree;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashSet;
import jp.co.sra.jun.geometry.abstracts.JunGeometry;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.boundaries.Jun2dBoundingBox;
import jp.co.sra.jun.geometry.boxtree.Jun2dBoundingBoxNode;
import jp.co.sra.jun.geometry.curves.Jun2dLine;
import jp.co.sra.jun.geometry.forms.JunForm2dRegionTestExamples;
import jp.co.sra.jun.geometry.forms.JunFormTriangulation2;
import jp.co.sra.jun.geometry.surfaces.Jun2dTriangle;
import jp.co.sra.jun.geometry.surfaces.Jun3dTriangle;
import jp.co.sra.jun.goodies.cursors.JunCursors;
import jp.co.sra.jun.goodies.utilities.JunControlUtility;
import jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolygon;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolyline;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPrimitiveObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dVertex;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StInterval;

public class Jun2dBoundingBoxNodeTestExamples
extends JunForm2dRegionTestExamples {
    public static boolean Example1() {
        Jun2dBoundingBoxNode jun2dBoundingBoxNode = new Jun2dBoundingBoxNode(Jun2dBoundingBoxNodeTestExamples.ExamplePointCollectionOf2dLine());
        Jun2dBoundingBoxNodeTestExamples.ExampleDisplay_levelInterval_(jun2dBoundingBoxNode, new StInterval(0.0, 15.0));
        return true;
    }

    public static boolean Example2() {
        Jun2dBoundingBoxNode jun2dBoundingBoxNode = new Jun2dBoundingBoxNode(Jun2dBoundingBoxNodeTestExamples.ExamplePointCollectionOf2dSinCurve());
        Jun2dBoundingBoxNodeTestExamples.ExampleDisplay_levelInterval_(jun2dBoundingBoxNode, new StInterval(0.0, 15.0));
        return true;
    }

    public static boolean Example3() {
        Jun2dBoundingBoxNode jun2dBoundingBoxNode = new Jun2dBoundingBoxNode(Jun2dBoundingBoxNodeTestExamples.ExamplePointCollectionOf2dHalfBall());
        Jun2dBoundingBoxNodeTestExamples.ExampleDisplay_levelInterval_(jun2dBoundingBoxNode, new StInterval(0.0, 15.0));
        return true;
    }

    public static boolean Example4() {
        Jun2dBoundingBoxNode jun2dBoundingBoxNode = new Jun2dBoundingBoxNode(Jun2dBoundingBoxNodeTestExamples.ExampleSegmentCollectionOf2dLine());
        Jun2dBoundingBoxNodeTestExamples.ExampleDisplay_levelInterval_(jun2dBoundingBoxNode, new StInterval(0.0, 15.0));
        return true;
    }

    public static boolean Example5() {
        Jun2dBoundingBoxNode jun2dBoundingBoxNode = new Jun2dBoundingBoxNode(Jun2dBoundingBoxNodeTestExamples.ExampleSegmentCollectionOf2dSinCurve());
        Jun2dBoundingBoxNodeTestExamples.ExampleDisplay_levelInterval_(jun2dBoundingBoxNode, new StInterval(2.0, 15.0));
        return true;
    }

    public static boolean Example6() {
        Jun2dBoundingBoxNode jun2dBoundingBoxNode = new Jun2dBoundingBoxNode(Jun2dBoundingBoxNodeTestExamples.ExamplePatchCollectionOf2dHalfBall());
        Jun2dBoundingBoxNodeTestExamples.ExampleDisplay_levelInterval_(jun2dBoundingBoxNode, new StInterval(0.0, 15.0));
        return true;
    }

    public static boolean Example7() {
        Jun2dBoundingBoxNode jun2dBoundingBoxNode = new Jun2dBoundingBoxNode(Jun2dBoundingBoxNodeTestExamples.ExamplePatchCollectionOf2dHalfBall());
        jun2dBoundingBoxNode.messageToSubdivide_(Jun2dBoundingBoxNodeTestExamples.$((String)"subdivide"));
        jun2dBoundingBoxNode.compareWithBlock_(new StBlockClosure(){

            public Object value_value_(Object object, Object object2) {
                int n;
                Jun2dTriangle jun2dTriangle = (Jun2dTriangle)((Object)object);
                Jun2dBoundingBox jun2dBoundingBox = (Jun2dBoundingBox)((Object)object2);
                HashSet<Jun2dPoint> hashSet = new HashSet<Jun2dPoint>();
                Jun2dTriangle[] jun2dTriangleArray = jun2dTriangle.detailedTrianglesLevel_(1);
                for (int i = 0; i < jun2dTriangleArray.length; ++i) {
                    Jun2dPoint[] jun2dPointArray = jun2dTriangleArray[i].points();
                    for (n = 0; n < jun2dPointArray.length; ++n) {
                        hashSet.add(jun2dPointArray[n]);
                    }
                }
                Jun2dPoint[] jun2dPointArray = hashSet.toArray(new Jun2dPoint[hashSet.size()]);
                boolean bl = false;
                for (n = 0; n < jun2dPointArray.length; ++n) {
                    if (!jun2dBoundingBox.containsPoint_(jun2dPointArray[n])) continue;
                    bl = true;
                    break;
                }
                return new Boolean(bl);
            }
        });
        Jun2dBoundingBoxNodeTestExamples.ExampleDisplay_levelInterval_(jun2dBoundingBoxNode, new StInterval(0.0, 5.0));
        return true;
    }

    public static boolean Example8() {
        Jun2dBoundingBoxNode jun2dBoundingBoxNode = new Jun2dBoundingBoxNode(Jun2dBoundingBoxNodeTestExamples.ExamplePatchCollectionOf2dPolyline());
        jun2dBoundingBoxNode.messageToSubdivide_(Jun2dBoundingBoxNodeTestExamples.$((String)"subdivide"));
        Jun2dBoundingBoxNodeTestExamples.ExampleDisplay_levelInterval_(jun2dBoundingBoxNode, new StInterval(0.0, 6.0));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Jun2dBoundingBoxNode ExampleDisplay_levelInterval_(Jun2dBoundingBoxNode jun2dBoundingBoxNode, StInterval stInterval) {
        JunOpenGLDisplayModel junOpenGLDisplayModel = new JunOpenGLDisplayModel();
        junOpenGLDisplayModel.openIn_(new Rectangle(200, 100, 606, 426));
        ((Frame)junOpenGLDisplayModel.getWindow()).setTitle("Bounding Box Node");
        int n = (int)Math.round(stInterval.start());
        while ((double)n <= stInterval.last()) {
            Jun2dBoundingBoxNode[] jun2dBoundingBoxNodeArray;
            JunCursors junCursors = new JunCursors(Cursor.getPredefinedCursor(3));
            try {
                junCursors._show();
                jun2dBoundingBoxNodeArray = jun2dBoundingBoxNode.subdividedNodesLevel_(n);
            }
            finally {
                junCursors._restore();
            }
            Jun2dBoundingBoxNodeTestExamples.ExampleDisplay_with_with_with_(junOpenGLDisplayModel, jun2dBoundingBoxNode, n, jun2dBoundingBoxNodeArray);
            n += (int)stInterval.step();
        }
        return jun2dBoundingBoxNode;
    }

    protected static void ExampleDisplay_with_with_with_(final JunOpenGLDisplayModel junOpenGLDisplayModel, Jun2dBoundingBoxNode jun2dBoundingBoxNode, final int n, final Jun2dBoundingBoxNode[] jun2dBoundingBoxNodeArray) {
        int n2;
        final JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject2 = new JunOpenGL3dCompoundObject();
        JunGeometry[] junGeometryArray = jun2dBoundingBoxNode.containedObjects();
        for (n2 = 0; n2 < junGeometryArray.length; ++n2) {
            JunOpenGL3dPrimitiveObject junOpenGL3dPrimitiveObject;
            Object object;
            Jun2dPoint[] jun2dPointArray;
            JunGeometry junGeometry;
            JunOpenGL3dObject junOpenGL3dObject;
            JunOpenGL3dObject junOpenGL3dObject2 = null;
            if (junGeometryArray[n2].isPoint()) {
                junOpenGL3dObject = (JunOpenGL3dVertex)junGeometryArray[n2].asJunOpenGL3dObjectColor_(Color.gray);
                ((JunOpenGL3dVertex)junOpenGL3dObject).size_(3.0f);
                junOpenGL3dObject2 = junOpenGL3dObject;
            }
            if (junGeometryArray[n2].isLine()) {
                junOpenGL3dObject = new JunOpenGL3dCompoundObject();
                junGeometry = (Jun2dLine)junGeometryArray[n2];
                jun2dPointArray = (Jun2dPoint[])junGeometry.asJunOpenGL3dObjectColor_(Color.black);
                jun2dPointArray.lineWidth_(2.0f);
                junOpenGL3dObject = jun2dPointArray.asCompoundObject();
                object = (JunOpenGL3dVertex)((Jun2dLine)junGeometry).from().asJunOpenGL3dObjectColor_(Color.black);
                ((JunOpenGL3dVertex)((Object)object)).size_(3.0f);
                ((JunOpenGL3dCompoundObject)junOpenGL3dObject).add_((JunOpenGL3dObject)((Object)object));
                junOpenGL3dPrimitiveObject = (JunOpenGL3dVertex)((Jun2dLine)junGeometry).last().asJunOpenGL3dObjectColor_(Color.black);
                ((JunOpenGL3dVertex)junOpenGL3dPrimitiveObject).size_(3.0f);
                ((JunOpenGL3dCompoundObject)junOpenGL3dObject).add_(junOpenGL3dPrimitiveObject);
                junOpenGL3dObject2 = junOpenGL3dObject;
            }
            if (junGeometryArray[n2].isTriangle()) {
                junOpenGL3dObject = new JunOpenGL3dCompoundObject();
                junGeometry = (Jun2dTriangle)junGeometryArray[n2];
                jun2dPointArray = ((Jun2dTriangle)junGeometry).asPointArray();
                object = new Jun3dPoint[jun2dPointArray.length];
                for (int i = 0; i < jun2dPointArray.length; ++i) {
                    object[i] = jun2dPointArray[i].as3dPoint();
                }
                junOpenGL3dPrimitiveObject = new JunOpenGL3dPolyline((Jun3dPoint[])object);
                junOpenGL3dPrimitiveObject.paint_(Color.gray);
                ((JunOpenGL3dPolyline)junOpenGL3dPrimitiveObject).lineWidth_(1.0f);
                ((JunOpenGL3dCompoundObject)junOpenGL3dObject).add_(junOpenGL3dPrimitiveObject);
                JunOpenGL3dVertex junOpenGL3dVertex = (JunOpenGL3dVertex)((Jun2dTriangle)junGeometry).p3().asJunOpenGL3dObjectColor_(Color.black);
                junOpenGL3dVertex.size_(3.0f);
                ((JunOpenGL3dCompoundObject)junOpenGL3dObject).add_(junOpenGL3dVertex);
                JunOpenGL3dVertex junOpenGL3dVertex2 = (JunOpenGL3dVertex)((Jun2dTriangle)junGeometry).p3().asJunOpenGL3dObjectColor_(Color.black);
                junOpenGL3dVertex2.size_(3.0f);
                ((JunOpenGL3dCompoundObject)junOpenGL3dObject).add_(junOpenGL3dVertex2);
                JunOpenGL3dVertex junOpenGL3dVertex3 = (JunOpenGL3dVertex)((Jun2dTriangle)junGeometry).p3().asJunOpenGL3dObjectColor_(Color.black);
                junOpenGL3dVertex3.size_(3.0f);
                ((JunOpenGL3dCompoundObject)junOpenGL3dObject).add_(junOpenGL3dVertex3);
                junOpenGL3dObject2 = junOpenGL3dObject;
            }
            if (junOpenGL3dObject2 == null) continue;
            junOpenGL3dCompoundObject2.add_(junOpenGL3dObject2);
        }
        junOpenGL3dCompoundObject.add_(junOpenGL3dCompoundObject2);
        junOpenGL3dCompoundObject2 = new JunOpenGL3dCompoundObject();
        for (n2 = 0; n2 < jun2dBoundingBoxNodeArray.length; ++n2) {
            junOpenGL3dCompoundObject2.add_(jun2dBoundingBoxNodeArray[n2].asJunOpenGL3dObject());
        }
        junOpenGL3dCompoundObject.add_(junOpenGL3dCompoundObject2);
        Jun3dPoint jun3dPoint = jun2dBoundingBoxNode.boundingBox().extent().as3dPoint();
        jun3dPoint = new Jun3dPoint(jun3dPoint.x(), jun3dPoint.y(), Math.max(jun3dPoint.x(), jun3dPoint.y()));
        junOpenGL3dCompoundObject2 = (JunOpenGL3dCompoundObject)JunOpenGL3dObject.XyUnitArrows().scaledBy_(jun3dPoint);
        junOpenGL3dCompoundObject.add_(junOpenGL3dCompoundObject2);
        JunControlUtility.Do_forMilliseconds_(new StBlockClosure(){

            public Object value() {
                junOpenGLDisplayModel.displayObject_(junOpenGL3dCompoundObject);
                junOpenGLDisplayModel.resetView();
                System.out.print("level ");
                System.out.print(Integer.toString(n));
                System.out.print(" -> ");
                System.out.print(Integer.toString(jun2dBoundingBoxNodeArray.length));
                System.out.println(jun2dBoundingBoxNodeArray.length > 1 ? " boxes" : " box");
                return null;
            }
        }, 2000);
    }

    protected static Jun2dTriangle[] ExamplePatchCollectionOf2dHalfBall() {
        final ArrayList arrayList = new ArrayList();
        JunOpenGL3dObject.Ball_(4).polygonsDo_(new StBlockClosure(){

            public Object value_(Object object) {
                Jun3dPoint jun3dPoint;
                Jun3dPoint jun3dPoint2;
                JunOpenGL3dPolygon junOpenGL3dPolygon = (JunOpenGL3dPolygon)((Object)object);
                Jun3dPoint[] jun3dPointArray = junOpenGL3dPolygon.vertexes();
                Jun3dPoint jun3dPoint3 = jun3dPointArray[0];
                Jun3dTriangle jun3dTriangle = jun3dPoint3.triangle_and_(jun3dPoint2 = jun3dPointArray[1], jun3dPoint = jun3dPointArray[2]);
                if (jun3dTriangle.centerOfIncircle().z() >= 0.0) {
                    Jun2dPoint jun2dPoint = new Jun2dPoint(jun3dPoint3.x(), jun3dPoint3.y()).translatedBy_(new Jun2dPoint(1.0, 1.0));
                    Jun2dPoint jun2dPoint2 = new Jun2dPoint(jun3dPoint2.x(), jun3dPoint2.y()).translatedBy_(new Jun2dPoint(1.0, 1.0));
                    Jun2dPoint jun2dPoint3 = new Jun2dPoint(jun3dPoint.x(), jun3dPoint.y()).translatedBy_(new Jun2dPoint(1.0, 1.0));
                    Jun2dTriangle jun2dTriangle = jun2dPoint.triangle_and_(jun2dPoint2, jun2dPoint3);
                    arrayList.add(jun2dTriangle);
                }
                return null;
            }
        });
        return arrayList.toArray(new Jun2dTriangle[arrayList.size()]);
    }

    protected static Jun2dTriangle[] ExamplePatchCollectionOf2dPolyline() {
        int n;
        ArrayList<Jun2dTriangle> arrayList = new ArrayList<Jun2dTriangle>();
        Jun2dTriangle[] jun2dTriangleArray = new JunFormTriangulation2(JunForm2dRegionTestExamples.ExamplePolyline4()).triangles();
        for (int i = 0; i < jun2dTriangleArray.length; ++i) {
            Jun2dPoint jun2dPoint = jun2dTriangleArray[i].p1();
            Jun2dPoint jun2dPoint2 = jun2dTriangleArray[i].p2();
            Jun2dPoint jun2dPoint3 = jun2dTriangleArray[i].p3();
            Jun2dTriangle jun2dTriangle = new Jun2dPoint(jun2dPoint.x(), jun2dPoint.y()).triangle_and_(new Jun2dPoint(jun2dPoint2.x(), jun2dPoint2.y()), new Jun2dPoint(jun2dPoint3.x(), jun2dPoint3.y()));
            Jun2dTriangle[] jun2dTriangleArray2 = jun2dTriangle.detailedTrianglesLevel_(1);
            for (int j = 0; j < jun2dTriangleArray2.length; ++j) {
                arrayList.add(jun2dTriangleArray2[j]);
            }
        }
        Jun2dBoundingBox jun2dBoundingBox = null;
        jun2dTriangleArray = arrayList.toArray(new Jun2dTriangle[arrayList.size()]);
        for (n = 0; n < jun2dTriangleArray.length; ++n) {
            jun2dBoundingBox = jun2dBoundingBox == null ? jun2dTriangleArray[n].boundingBox() : jun2dBoundingBox.merge_(jun2dTriangleArray[n].boundingBox());
        }
        for (n = 0; n < jun2dTriangleArray.length; ++n) {
            jun2dTriangleArray[n] = jun2dTriangleArray[n].translatedBy_(jun2dBoundingBox.origin().negated());
        }
        return jun2dTriangleArray;
    }

    protected static Jun2dPoint[] ExamplePointCollectionOf2dHalfBall() {
        ArrayList<Jun2dPoint> arrayList = new ArrayList<Jun2dPoint>();
        Jun3dPoint[] jun3dPointArray = JunOpenGL3dObject.Ball_(4).asPointArray();
        for (int i = 0; i < jun3dPointArray.length; ++i) {
            if (!(jun3dPointArray[i].z() >= 0.0)) continue;
            arrayList.add(new Jun2dPoint(jun3dPointArray[i].x(), jun3dPointArray[i].y()).translatedBy_(new Jun2dPoint(1.0, 1.0)));
        }
        return arrayList.toArray(new Jun2dPoint[arrayList.size()]);
    }

    protected static Jun2dPoint[] ExamplePointCollectionOf2dLine() {
        Jun2dLine jun2dLine = new Jun2dPoint(0.0, 0.0).to_(new Jun2dPoint(3.0, 2.0));
        ArrayList<Jun2dPoint> arrayList = new ArrayList<Jun2dPoint>();
        for (int i = 0; i <= 100; ++i) {
            double d = 0.01 * (double)i;
            arrayList.add(jun2dLine.atT_(d));
        }
        return arrayList.toArray(new Jun2dPoint[arrayList.size()]);
    }

    protected static Jun2dPoint[] ExamplePointCollectionOf2dSinCurve() {
        int n = 501;
        ArrayList<Jun3dPoint> arrayList = new ArrayList<Jun3dPoint>(n);
        for (int i = 0; i < n; ++i) {
            double d = (double)i / (double)n;
            double d2 = 0.4 * Math.sin(62.83185307179586 * d);
            arrayList.add(new Jun3dPoint(d, d2, 0.0));
        }
        JunOpenGL3dPolyline junOpenGL3dPolyline = new JunOpenGL3dPolyline(arrayList);
        junOpenGL3dPolyline = (JunOpenGL3dPolyline)JunOpenGL3dObject.From_to_with_(new Jun3dPoint(0.0, 0.0, 0.0), new Jun3dPoint(3.0, 2.0, 1.0), junOpenGL3dPolyline);
        Jun3dPoint[] jun3dPointArray = junOpenGL3dPolyline.vertexes();
        Jun2dPoint[] jun2dPointArray = new Jun2dPoint[jun3dPointArray.length];
        for (int i = 0; i < jun2dPointArray.length; ++i) {
            jun2dPointArray[i] = jun3dPointArray[i].as2dPoint();
        }
        return jun2dPointArray;
    }

    protected static Jun2dLine[] ExampleSegmentCollectionOf2dLine() {
        Jun2dLine jun2dLine = new Jun2dPoint(0.0, 0.0).to_(new Jun2dPoint(3.0, 2.0));
        ArrayList<Jun2dPoint> arrayList = new ArrayList<Jun2dPoint>();
        for (int i = 0; i <= 100; ++i) {
            double d = 0.01 * (double)i;
            arrayList.add(jun2dLine.atT_(d));
        }
        ArrayList<Jun2dLine> arrayList2 = new ArrayList<Jun2dLine>(arrayList.size() - 1);
        Jun2dPoint[] jun2dPointArray = arrayList.toArray(new Jun2dPoint[arrayList.size()]);
        for (int i = 0; i < jun2dPointArray.length - 1; ++i) {
            arrayList2.add(jun2dPointArray[i].to_(jun2dPointArray[i + 1]));
        }
        return arrayList2.toArray(new Jun2dLine[arrayList2.size()]);
    }

    protected static Jun2dLine[] ExampleSegmentCollectionOf2dSinCurve() {
        int n = 501;
        ArrayList<Jun3dPoint> arrayList = new ArrayList<Jun3dPoint>(n);
        for (int i = 0; i < n; ++i) {
            double d = (double)i / (double)n;
            double d2 = 0.4 * Math.sin(62.83185307179586 * d);
            arrayList.add(new Jun3dPoint(d, d2, 0.0));
        }
        JunOpenGL3dPolyline junOpenGL3dPolyline = new JunOpenGL3dPolyline(arrayList);
        junOpenGL3dPolyline = (JunOpenGL3dPolyline)JunOpenGL3dObject.From_to_with_(new Jun3dPoint(0.0, 0.0, 0.0), new Jun3dPoint(3.0, 2.0, 1.0), junOpenGL3dPolyline);
        Jun3dPoint[] jun3dPointArray = junOpenGL3dPolyline.vertexes();
        Jun2dPoint[] jun2dPointArray = new Jun2dPoint[jun3dPointArray.length];
        for (int i = 0; i < jun2dPointArray.length; ++i) {
            jun2dPointArray[i] = jun3dPointArray[i].as2dPoint();
        }
        ArrayList<Jun2dLine> arrayList2 = new ArrayList<Jun2dLine>(arrayList.size() - 1);
        for (int i = 0; i < jun2dPointArray.length - 1; ++i) {
            arrayList2.add(jun2dPointArray[i].to_(jun2dPointArray[i + 1]));
        }
        return arrayList2.toArray(new Jun2dLine[arrayList2.size()]);
    }

    public static void main(String[] stringArray) {
        new Jun2dBoundingBoxNodeTestExamples();
    }
}

