/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.geometry.forms;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.boundaries.Jun2dBoundingBox;
import jp.co.sra.jun.geometry.curves.Jun2dLine;
import jp.co.sra.jun.geometry.forms.JunFormOperation;
import jp.co.sra.jun.geometry.forms.JunFormTriangle;
import jp.co.sra.jun.geometry.forms.JunFormTriangleJunction;
import jp.co.sra.jun.geometry.forms.JunFormTriangleNode;
import jp.co.sra.jun.geometry.forms.JunFormTriangleSleeve;
import jp.co.sra.jun.geometry.forms.JunFormTriangleTerminal;
import jp.co.sra.jun.geometry.forms.JunFormTriangulation;
import jp.co.sra.jun.geometry.surfaces.Jun2dTriangle;
import jp.co.sra.jun.geometry.surfaces.JunPlane;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolygon;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolyline;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolylineLoop;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPrimitiveObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dVertex;
import jp.co.sra.jun.system.framework.JunAbstractObject;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StColorValue;
import jp.co.sra.smalltalk.StSymbol;
import jp.co.sra.smalltalk.StValueHolder;

public class JunFormCreation
extends JunFormOperation {
    protected JunFormTriangulation formTriangulation;
    protected JunFormTriangleNode[] draftTriangleNodes;
    protected JunFormTriangleNode[] triangleNodes;
    protected Map chordalAxesTable;
    protected Jun2dPoint[][][] chordalAxesInformation;
    protected Collection fanTriangles;
    protected Object[][][][] spinePolylineInformation;
    protected JunFormTriangle[] finalTriangles;
    protected Jun2dPoint[][] finalSpines;
    protected JunOpenGL3dCompoundObject finalBody;

    protected JunFormCreation() {
    }

    public JunFormCreation(Jun2dPoint[] jun2dPointArray) {
        this();
        this.points_(jun2dPointArray);
    }

    protected void initialize() {
        super.initialize();
        this.formTriangulation = null;
        this.draftTriangleNodes = null;
        this.triangleNodes = null;
        this.chordalAxesTable = null;
        this.chordalAxesInformation = null;
        this.fanTriangles = null;
        this.spinePolylineInformation = null;
        this.finalTriangles = null;
        this.finalSpines = null;
        this.finalBody = null;
        this.triangulation();
    }

    public JunOpenGL3dCompoundObject body() {
        if (this.finalBody == null) {
            this.finalBody = this.computeFinalBody();
        }
        return this.finalBody;
    }

    public Rectangle bounds() {
        return this.formTriangulation.bounds();
    }

    public Jun2dBoundingBox boundingBox() {
        return this.formTriangulation.boundingBox();
    }

    public Jun2dPoint[] points() {
        return this.formTriangulation.points();
    }

    public void points_(Jun2dPoint[] jun2dPointArray) {
        ArrayList<Jun2dPoint> arrayList = new ArrayList<Jun2dPoint>(jun2dPointArray.length);
        for (int i = 0; i < jun2dPointArray.length; ++i) {
            arrayList.add(jun2dPointArray[i].rounded());
        }
        ArrayList arrayList2 = new ArrayList(arrayList);
        if (!arrayList2.isEmpty() && !arrayList2.get(0).equals(arrayList2.get(arrayList2.size() - 1))) {
            arrayList.add((Jun2dPoint)((Object)arrayList2.get(0)));
        }
        this.formTriangulation = this.triangulation();
        this.formTriangulation.points_(arrayList.toArray(new Jun2dPoint[arrayList.size()]));
        this.draftTriangleNodes = null;
        this.triangleNodes = null;
        this.chordalAxesTable = null;
        this.chordalAxesInformation = null;
        this.fanTriangles = null;
        this.spinePolylineInformation = null;
        this.finalTriangles = null;
        this.finalSpines = null;
        this.finalBody = null;
    }

    public Jun2dPoint[][] spines() {
        if (this.finalSpines == null) {
            this.finalSpines = this.computeFinalSpines();
        }
        return this.finalSpines;
    }

    public JunFormTriangle[] triangles() {
        if (this.finalTriangles == null) {
            this.finalTriangles = this.computeFinalTriangles();
        }
        return this.finalTriangles;
    }

    public Jun2dTriangle[] triangulatedTriangles() {
        return this.triangulation().triangles();
    }

    public JunFormTriangulation triangulation() {
        if (this.formTriangulation == null) {
            this.formTriangulation = new JunFormTriangulation();
        }
        return this.formTriangulation;
    }

    public JunOpenGL3dCompoundObject complexBody() {
        final JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
        this.complexBody1().do_(new StBlockClosure(){

            public Object value_(Object object) {
                junOpenGL3dCompoundObject.add_((JunOpenGL3dObject)((Object)object));
                return null;
            }
        });
        this.complexBody2().do_(new StBlockClosure(){

            public Object value_(Object object) {
                junOpenGL3dCompoundObject.add_((JunOpenGL3dObject)((Object)object));
                return null;
            }
        });
        junOpenGL3dCompoundObject.paint_(this.defaultPaint());
        return junOpenGL3dCompoundObject;
    }

    public JunOpenGL3dCompoundObject complexBody0() {
        return this.simpleBody0();
    }

    public JunOpenGL3dCompoundObject complexBody1() {
        Map map = this.tableForSpinePointToLiftUpAmount();
        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
        JunFormTriangle[] junFormTriangleArray = this.triangles();
        for (int i = 0; i < junFormTriangleArray.length; ++i) {
            Jun3dPoint[] jun3dPointArray;
            Jun3dPoint[] jun3dPointArray2;
            Object object;
            Jun3dPoint jun3dPoint;
            Jun3dPoint jun3dPoint2;
            Jun3dPoint jun3dPoint3;
            Jun2dPoint[] jun2dPointArray = junFormTriangleArray[i].points();
            Jun3dPoint[] jun3dPointArray3 = new Jun3dPoint[jun2dPointArray.length];
            for (int j = 0; j < jun2dPointArray.length; ++j) {
                Number number = (Number)map.get((Object)jun2dPointArray[j]);
                jun3dPointArray3[j] = new Jun3dPoint(jun2dPointArray[j].x(), jun2dPointArray[j].y(), number != null ? 0.0 - number.doubleValue() : 0.0);
            }
            ArrayList<Jun3dPoint> arrayList = new ArrayList<Jun3dPoint>();
            for (int j = 0; j < jun2dPointArray.length; ++j) {
                if (!map.containsKey((Object)jun2dPointArray[j])) continue;
                arrayList.add(new Jun3dPoint(jun2dPointArray[j].x(), jun2dPointArray[j].y(), 0.0));
            }
            if (arrayList.size() < 1 || 2 < arrayList.size()) {
                throw new IllegalStateException("unexpected error");
            }
            if (arrayList.size() == 1) {
                Jun3dPoint jun3dPoint4 = (Jun3dPoint)((Object)arrayList.get(0));
                jun3dPoint3 = null;
                jun3dPoint2 = null;
                jun3dPoint = null;
                for (int j = 0; j < jun3dPointArray3.length; ++j) {
                    if (jun3dPointArray3[j].z() == 0.0) {
                        if (jun3dPoint3 == null) {
                            jun3dPoint3 = jun3dPointArray3[j];
                        }
                        jun3dPoint2 = jun3dPointArray3[j];
                        continue;
                    }
                    if (jun3dPoint != null) continue;
                    jun3dPoint = jun3dPointArray3[j];
                }
                object = this.pointsOval_horizontal_vertical_(jun3dPoint4, jun3dPoint3, jun3dPoint);
                jun3dPointArray2 = this.pointsOval_horizontal_vertical_(jun3dPoint4, jun3dPoint2, jun3dPoint);
                jun3dPointArray = this.sewPoints_withPoints_reverseFlag_((Jun3dPoint[])object, jun3dPointArray2, false);
                junOpenGL3dCompoundObject.add_((JunOpenGL3dObject)jun3dPointArray);
            }
            if (arrayList.size() != 2) continue;
            Jun3dPoint jun3dPoint5 = (Jun3dPoint)((Object)arrayList.get(0));
            jun3dPoint3 = (Jun3dPoint)((Object)arrayList.get(arrayList.size() - 1));
            jun3dPoint2 = null;
            jun3dPoint = null;
            object = null;
            for (int j = 0; j < jun3dPointArray3.length; ++j) {
                if (jun3dPointArray3[j].z() != 0.0) {
                    if (jun3dPoint2 == null) {
                        jun3dPoint2 = jun3dPointArray3[j];
                    }
                    jun3dPoint = jun3dPointArray3[j];
                    continue;
                }
                if (object != null) continue;
                object = jun3dPointArray3[j];
            }
            jun3dPointArray2 = this.pointsOval_horizontal_vertical_(jun3dPoint5, (Jun3dPoint)((Object)object), jun3dPoint2);
            jun3dPointArray = this.pointsOval_horizontal_vertical_(jun3dPoint3, (Jun3dPoint)((Object)object), jun3dPoint);
            JunOpenGL3dCompoundObject junOpenGL3dCompoundObject2 = this.sewPoints_withPoints_reverseFlag_(jun3dPointArray2, jun3dPointArray, false);
            junOpenGL3dCompoundObject.add_(junOpenGL3dCompoundObject2);
        }
        return junOpenGL3dCompoundObject;
    }

    public JunOpenGL3dCompoundObject complexBody2() {
        Map map = this.tableForSpinePointToLiftUpAmount();
        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
        JunFormTriangle[] junFormTriangleArray = this.triangles();
        for (int i = 0; i < junFormTriangleArray.length; ++i) {
            Jun3dPoint[] jun3dPointArray;
            Jun3dPoint[] jun3dPointArray2;
            Object object;
            Jun3dPoint jun3dPoint;
            Jun3dPoint jun3dPoint2;
            Jun3dPoint jun3dPoint3;
            Jun3dPoint jun3dPoint4;
            Jun3dPoint[] jun3dPointArray3;
            Jun2dPoint[] jun2dPointArray = junFormTriangleArray[i].points();
            Jun3dPoint[] jun3dPointArray4 = new Jun3dPoint[jun2dPointArray.length];
            for (int j = 0; j < jun2dPointArray.length; ++j) {
                jun3dPointArray3 = (Jun3dPoint[])map.get((Object)jun2dPointArray[j]);
                jun3dPointArray4[j] = new Jun3dPoint(jun2dPointArray[j].x(), jun2dPointArray[j].y(), jun3dPointArray3 != null ? jun3dPointArray3.doubleValue() : 0.0);
            }
            ArrayList<Jun3dPoint> arrayList = new ArrayList<Jun3dPoint>();
            for (int j = 0; j < jun2dPointArray.length; ++j) {
                if (!map.containsKey((Object)jun2dPointArray[j])) continue;
                arrayList.add(new Jun3dPoint(jun2dPointArray[j].x(), jun2dPointArray[j].y(), 0.0));
            }
            jun3dPointArray3 = arrayList.toArray(new Jun3dPoint[arrayList.size()]);
            if (jun3dPointArray3.length < 1 || 2 < jun3dPointArray3.length) {
                throw new IllegalStateException("unexpected error");
            }
            if (jun3dPointArray3.length == 1) {
                jun3dPoint4 = jun3dPointArray3[0];
                jun3dPoint3 = null;
                jun3dPoint2 = null;
                jun3dPoint = null;
                for (int j = 0; j < jun3dPointArray4.length; ++j) {
                    if (jun3dPointArray4[j].z() == 0.0) {
                        if (jun3dPoint3 == null) {
                            jun3dPoint3 = jun3dPointArray4[j];
                        }
                        jun3dPoint2 = jun3dPointArray4[j];
                        continue;
                    }
                    if (jun3dPoint != null) continue;
                    jun3dPoint = jun3dPointArray4[j];
                }
                object = this.pointsOval_horizontal_vertical_(jun3dPoint4, jun3dPoint3, jun3dPoint);
                jun3dPointArray2 = this.pointsOval_horizontal_vertical_(jun3dPoint4, jun3dPoint2, jun3dPoint);
                jun3dPointArray = this.sewPoints_withPoints_reverseFlag_((Jun3dPoint[])object, jun3dPointArray2, true);
                junOpenGL3dCompoundObject.add_((JunOpenGL3dObject)jun3dPointArray);
            }
            if (jun3dPointArray3.length != 2) continue;
            jun3dPoint4 = jun3dPointArray3[0];
            jun3dPoint3 = jun3dPointArray3[jun3dPointArray3.length - 1];
            jun3dPoint2 = null;
            jun3dPoint = null;
            object = null;
            for (int j = 0; j < jun3dPointArray4.length; ++j) {
                if (jun3dPointArray4[j].z() != 0.0) {
                    if (jun3dPoint2 == null) {
                        jun3dPoint2 = jun3dPointArray4[j];
                    }
                    jun3dPoint = jun3dPointArray4[j];
                    continue;
                }
                if (object != null) continue;
                object = jun3dPointArray4[j];
            }
            jun3dPointArray2 = this.pointsOval_horizontal_vertical_(jun3dPoint4, (Jun3dPoint)((Object)object), jun3dPoint2);
            jun3dPointArray = this.pointsOval_horizontal_vertical_(jun3dPoint3, (Jun3dPoint)((Object)object), jun3dPoint);
            JunOpenGL3dCompoundObject junOpenGL3dCompoundObject2 = this.sewPoints_withPoints_reverseFlag_(jun3dPointArray2, jun3dPointArray, true);
            junOpenGL3dCompoundObject.add_(junOpenGL3dCompoundObject2);
        }
        return junOpenGL3dCompoundObject;
    }

    public double[][] ovalFactors() {
        double[] dArray = this.defaultOvalFactors();
        double[][] dArrayArray = new double[dArray.length][];
        for (int i = 0; i < dArray.length; ++i) {
            double d = dArray[i];
            double d2 = Math.toRadians(d);
            double d3 = Math.cos(d2);
            double d4 = Math.sin(d2);
            if (d3 < 1.0E-12) {
                d3 = 0.0;
            }
            dArrayArray[i] = new double[]{d3, d4};
        }
        return dArrayArray;
    }

    public Jun3dPoint[] pointsOval_horizontal_vertical_(Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2, Jun3dPoint jun3dPoint3) {
        double[][] dArray = this.ovalFactors();
        ArrayList<Jun3dPoint> arrayList = new ArrayList<Jun3dPoint>();
        for (int i = 0; i < dArray.length; ++i) {
            Jun3dPoint jun3dPoint4 = jun3dPoint2.minus_(jun3dPoint).multipliedBy_(dArray[i][0]).plus_(jun3dPoint);
            jun3dPoint4 = new Jun3dPoint(jun3dPoint4.x(), jun3dPoint4.y(), (jun3dPoint3.z() - jun3dPoint.z()) * dArray[i][1]);
            arrayList.add(jun3dPoint4);
        }
        return arrayList.toArray(new Jun3dPoint[arrayList.size() - 1]);
    }

    public JunOpenGL3dCompoundObject sewPoints_withPoints_reverseFlag_(Jun3dPoint[] jun3dPointArray, Jun3dPoint[] jun3dPointArray2, boolean bl) {
        int n;
        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
        Jun3dPoint[] jun3dPointArray3 = null;
        Jun3dPoint[] jun3dPointArray4 = null;
        if (jun3dPointArray[0].equals((Object)jun3dPointArray2[0])) {
            jun3dPointArray3 = new Jun3dPoint[jun3dPointArray.length];
            for (n = 0; n < jun3dPointArray.length; ++n) {
                jun3dPointArray3[n] = jun3dPointArray[jun3dPointArray.length - 1 - n];
            }
            jun3dPointArray4 = new Jun3dPoint[jun3dPointArray2.length];
            for (n = 0; n < jun3dPointArray2.length; ++n) {
                jun3dPointArray4[n] = jun3dPointArray2[jun3dPointArray2.length - 1 - n];
            }
        } else {
            jun3dPointArray3 = jun3dPointArray;
            jun3dPointArray4 = jun3dPointArray2;
        }
        for (n = 0; n < jun3dPointArray3.length - 1; ++n) {
            Object object;
            Jun3dPoint jun3dPoint = jun3dPointArray3[n];
            Jun3dPoint jun3dPoint2 = jun3dPointArray4[n];
            Jun3dPoint jun3dPoint3 = jun3dPointArray3[n + 1];
            Jun3dPoint jun3dPoint4 = jun3dPointArray4[n + 1];
            Jun3dPoint[] jun3dPointArray5 = this.sortTrianglePoints_(new Jun3dPoint[]{jun3dPoint, jun3dPoint2, jun3dPoint3});
            if (bl) {
                object = new Jun3dPoint[jun3dPointArray5.length];
                for (int i = 0; i < jun3dPointArray5.length; ++i) {
                    object[i] = jun3dPointArray5[jun3dPointArray5.length - 1 - i];
                }
                jun3dPointArray5 = object;
            }
            object = new JunOpenGL3dPolygon(jun3dPointArray5);
            junOpenGL3dCompoundObject.add_((JunOpenGL3dObject)((Object)object));
            if (jun3dPoint3.equals((Object)jun3dPoint4)) continue;
            jun3dPointArray5 = this.sortTrianglePoints_(new Jun3dPoint[]{jun3dPoint2, jun3dPoint3, jun3dPoint4});
            if (bl) {
                Jun3dPoint[] jun3dPointArray6 = new Jun3dPoint[jun3dPointArray5.length];
                for (int i = 0; i < jun3dPointArray5.length; ++i) {
                    jun3dPointArray6[i] = jun3dPointArray5[jun3dPointArray5.length - 1 - i];
                }
                jun3dPointArray5 = jun3dPointArray6;
            }
            JunOpenGL3dPolygon junOpenGL3dPolygon = new JunOpenGL3dPolygon(jun3dPointArray5);
            junOpenGL3dCompoundObject.add_(junOpenGL3dPolygon);
        }
        return junOpenGL3dCompoundObject;
    }

    public JunOpenGL3dCompoundObject simpleBody() {
        final JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
        this.simpleBody1().objectsDo_(new StBlockClosure(){

            public Object value_(Object object) {
                if (object instanceof JunOpenGL3dPolygon) {
                    junOpenGL3dCompoundObject.add_((JunOpenGL3dPolygon)((Object)object));
                }
                return null;
            }
        });
        this.simpleBody2().objectsDo_(new StBlockClosure(){

            public Object value_(Object object) {
                if (object instanceof JunOpenGL3dPolygon) {
                    junOpenGL3dCompoundObject.add_((JunOpenGL3dPolygon)((Object)object));
                }
                return null;
            }
        });
        junOpenGL3dCompoundObject.paint_(this.defaultPaint());
        return junOpenGL3dCompoundObject;
    }

    public JunOpenGL3dCompoundObject simpleBody0() {
        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
        JunFormTriangle[] junFormTriangleArray = this.triangles();
        for (int i = 0; i < junFormTriangleArray.length; ++i) {
            Jun2dPoint[] jun2dPointArray = junFormTriangleArray[i].points();
            Jun3dPoint[] jun3dPointArray = new Jun3dPoint[jun2dPointArray.length];
            for (int j = 0; j < jun3dPointArray.length; ++j) {
                jun3dPointArray[j] = new Jun3dPoint(jun2dPointArray[j].x(), jun2dPointArray[j].y(), 0.0);
            }
            JunOpenGL3dPolylineLoop junOpenGL3dPolylineLoop = new JunOpenGL3dPolylineLoop(jun3dPointArray);
            JunOpenGL3dPolygon junOpenGL3dPolygon = new JunOpenGL3dPolygon(jun3dPointArray);
            junOpenGL3dCompoundObject.add_(new JunOpenGL3dCompoundObject(junOpenGL3dPolylineLoop, junOpenGL3dPolygon));
        }
        return junOpenGL3dCompoundObject;
    }

    public JunOpenGL3dCompoundObject simpleBody1() {
        Map map = this.tableForSpinePointToLiftUpAmount();
        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
        JunFormTriangle[] junFormTriangleArray = this.triangles();
        for (int i = 0; i < junFormTriangleArray.length; ++i) {
            Object object;
            Jun2dPoint[] jun2dPointArray = junFormTriangleArray[i].points();
            Jun3dPoint[] jun3dPointArray = new Jun3dPoint[jun2dPointArray.length];
            for (int j = 0; j < jun3dPointArray.length; ++j) {
                object = (Number)map.get((Object)jun2dPointArray[j]);
                double d = object != null ? 0.0 - ((Number)object).doubleValue() : 0.0;
                jun3dPointArray[j] = new Jun3dPoint(jun2dPointArray[j].x(), jun2dPointArray[j].y(), d);
            }
            JunOpenGL3dPolylineLoop junOpenGL3dPolylineLoop = new JunOpenGL3dPolylineLoop(jun3dPointArray);
            object = new JunOpenGL3dPolygon(jun3dPointArray);
            junOpenGL3dCompoundObject.add_(new JunOpenGL3dCompoundObject(junOpenGL3dPolylineLoop, (JunOpenGL3dObject)((Object)object)));
        }
        return junOpenGL3dCompoundObject;
    }

    public JunOpenGL3dCompoundObject simpleBody2() {
        Map map = this.tableForSpinePointToLiftUpAmount();
        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
        JunFormTriangle[] junFormTriangleArray = this.triangles();
        for (int i = 0; i < junFormTriangleArray.length; ++i) {
            Object object;
            Jun2dPoint[] jun2dPointArray = junFormTriangleArray[i].points();
            Jun3dPoint[] jun3dPointArray = new Jun3dPoint[jun2dPointArray.length];
            for (int j = 0; j < jun3dPointArray.length; ++j) {
                object = (Number)map.get((Object)jun2dPointArray[j]);
                double d = object != null ? object.doubleValue() : 0.0;
                jun3dPointArray[jun3dPointArray.length - 1 - j] = new Jun3dPoint(jun2dPointArray[j].x(), jun2dPointArray[j].y(), d);
            }
            JunOpenGL3dPolylineLoop junOpenGL3dPolylineLoop = new JunOpenGL3dPolylineLoop(jun3dPointArray);
            object = new JunOpenGL3dPolygon(jun3dPointArray);
            junOpenGL3dCompoundObject.add_(new JunOpenGL3dCompoundObject(junOpenGL3dPolylineLoop, (JunOpenGL3dObject)((Object)object)));
        }
        return junOpenGL3dCompoundObject;
    }

    public JunOpenGL3dCompoundObject spineBody0() {
        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
        Jun2dPoint[][] jun2dPointArray = this.spines();
        for (int i = 0; i < jun2dPointArray.length; ++i) {
            JunOpenGL3dPrimitiveObject junOpenGL3dPrimitiveObject;
            Jun3dPoint[] jun3dPointArray;
            Jun2dPoint[] jun2dPointArray2 = jun2dPointArray[i];
            if (jun2dPointArray2.length == 1) {
                jun3dPointArray = new Jun3dPoint(jun2dPointArray2[0].x(), jun2dPointArray2[0].y(), 0.0);
                junOpenGL3dPrimitiveObject = new JunOpenGL3dVertex((Jun3dPoint)jun3dPointArray);
                junOpenGL3dCompoundObject.add_(junOpenGL3dPrimitiveObject);
            }
            if (jun2dPointArray2.length <= 1) continue;
            jun3dPointArray = new Jun3dPoint[jun2dPointArray2.length];
            for (int j = 0; j < jun3dPointArray.length; ++j) {
                jun3dPointArray[j] = new Jun3dPoint(jun2dPointArray2[j].x(), jun2dPointArray2[j].y(), 0.0);
            }
            junOpenGL3dPrimitiveObject = new JunOpenGL3dPolyline(jun3dPointArray);
            junOpenGL3dCompoundObject.add_(junOpenGL3dPrimitiveObject);
        }
        return junOpenGL3dCompoundObject;
    }

    public JunOpenGL3dCompoundObject spineBody1() {
        Map map = this.tableForSpinePointToLiftUpAmount();
        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
        Jun2dPoint[][] jun2dPointArray = this.spines();
        for (int i = 0; i < jun2dPointArray.length; ++i) {
            Jun3dPoint[] jun3dPointArray;
            Jun2dPoint[] jun2dPointArray2 = jun2dPointArray[i];
            if (jun2dPointArray2.length == 1) {
                jun3dPointArray = (Jun3dPoint[])map.get((Object)jun2dPointArray2[0]);
                double d = jun3dPointArray != null ? 0.0 - jun3dPointArray.doubleValue() : 0.0;
                Jun3dPoint jun3dPoint = new Jun3dPoint(jun2dPointArray2[0].x(), jun2dPointArray2[0].y(), d);
                JunOpenGL3dVertex junOpenGL3dVertex = new JunOpenGL3dVertex(jun3dPoint);
                junOpenGL3dCompoundObject.add_(junOpenGL3dVertex);
            }
            if (jun2dPointArray2.length <= 1) continue;
            jun3dPointArray = new Jun3dPoint[jun2dPointArray2.length];
            for (int j = 0; j < jun3dPointArray.length; ++j) {
                Number number = (Number)map.get((Object)jun2dPointArray2[j]);
                double d = number != null ? 0.0 - number.doubleValue() : 0.0;
                jun3dPointArray[j] = new Jun3dPoint(jun2dPointArray2[j].x(), jun2dPointArray2[j].y(), d);
            }
            JunOpenGL3dPolyline junOpenGL3dPolyline = new JunOpenGL3dPolyline(jun3dPointArray);
            junOpenGL3dCompoundObject.add_(junOpenGL3dPolyline);
        }
        return junOpenGL3dCompoundObject;
    }

    public JunOpenGL3dCompoundObject spineBody2() {
        Map map = this.tableForSpinePointToLiftUpAmount();
        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
        Jun2dPoint[][] jun2dPointArray = this.spines();
        for (int i = 0; i < jun2dPointArray.length; ++i) {
            Jun3dPoint[] jun3dPointArray;
            Jun2dPoint[] jun2dPointArray2 = jun2dPointArray[i];
            if (jun2dPointArray2.length == 1) {
                jun3dPointArray = (Jun3dPoint[])map.get((Object)jun2dPointArray2[0]);
                double d = jun3dPointArray != null ? jun3dPointArray.doubleValue() : 0.0;
                Jun3dPoint jun3dPoint = new Jun3dPoint(jun2dPointArray2[0].x(), jun2dPointArray2[0].y(), d);
                JunOpenGL3dVertex junOpenGL3dVertex = new JunOpenGL3dVertex(jun3dPoint);
                junOpenGL3dCompoundObject.add_(junOpenGL3dVertex);
            }
            if (jun2dPointArray2.length <= 1) continue;
            jun3dPointArray = new Jun3dPoint[jun2dPointArray2.length];
            for (int j = 0; j < jun3dPointArray.length; ++j) {
                Number number = (Number)map.get((Object)jun2dPointArray2[j]);
                double d = number != null ? number.doubleValue() : 0.0;
                jun3dPointArray[j] = new Jun3dPoint(jun2dPointArray2[j].x(), jun2dPointArray2[j].y(), d);
            }
            JunOpenGL3dPolyline junOpenGL3dPolyline = new JunOpenGL3dPolyline(jun3dPointArray);
            junOpenGL3dCompoundObject.add_(junOpenGL3dPolyline);
        }
        return junOpenGL3dCompoundObject;
    }

    public Map tableForSpinePointToLiftUpAmount() {
        double d;
        Object object;
        Map map = this.tableForSpinePointToTriangles();
        Set set = map.keySet();
        HashMap<Object, Double> hashMap = new HashMap<Object, Double>(set.size());
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            object = (Jun2dPoint)((Object)iterator.next());
            JunFormTriangle[] junFormTriangleArray = (JunFormTriangle[])map.get(object);
            HashSet<Jun2dPoint> hashSet = new HashSet<Jun2dPoint>();
            for (int i = 0; i < junFormTriangleArray.length; ++i) {
                Jun2dPoint[] jun2dPointArray = junFormTriangleArray[i].points();
                for (int j = 0; j < jun2dPointArray.length; ++j) {
                    if (set.contains((Object)jun2dPointArray[j])) continue;
                    hashSet.add(jun2dPointArray[j]);
                }
            }
            d = 0.0;
            Jun2dPoint[] jun2dPointArray = hashSet.toArray(new Jun2dPoint[hashSet.size()]);
            for (int i = 0; i < jun2dPointArray.length; ++i) {
                d += ((Jun2dPoint)((Object)object)).distance_(jun2dPointArray[i]);
            }
            double d2 = d / (double)hashSet.size();
            hashMap.put(object, new Double(d2));
        }
        object = this.spines();
        for (int i = 0; i < ((Jun2dPoint[][])object).length; ++i) {
            for (int j = 1; j < object[i].length - 1; ++j) {
                d = ((Number)hashMap.get((Object)object[i][j - 1])).doubleValue();
                double d3 = ((Number)hashMap.get((Object)object[i][j])).doubleValue();
                double d4 = ((Number)hashMap.get(object[i][j + 1])).doubleValue();
                double d5 = (d + d3 + d4) / 3.0;
                hashMap.put(object[i][j], new Double(d5));
            }
        }
        Iterator iterator2 = hashMap.keySet().iterator();
        while (iterator2.hasNext()) {
            Jun2dPoint jun2dPoint = (Jun2dPoint)((Object)iterator2.next());
            d = ((Number)hashMap.get((Object)jun2dPoint)).doubleValue();
            hashMap.put((Object)jun2dPoint, new Double(d * this.defaultLiftUpFactor()));
        }
        return hashMap;
    }

    public Map tableForSpinePointToTriangles() {
        Collection collection;
        int n;
        Object object;
        int n2;
        Jun2dPoint[][] jun2dPointArray = this.spines();
        JunFormTriangle[] junFormTriangleArray = this.triangles();
        HashMap hashMap = new HashMap();
        for (n2 = 0; n2 < jun2dPointArray.length; ++n2) {
            object = jun2dPointArray[n2];
            for (n = 0; n < ((Jun2dPoint[])object).length; ++n) {
                hashMap.put(object[n], new ArrayList(5));
            }
        }
        for (n2 = 0; n2 < junFormTriangleArray.length; ++n2) {
            object = junFormTriangleArray[n2].points();
            for (n = 0; n < ((Jun2dPoint[])object).length; ++n) {
                collection = (Collection)hashMap.get(object[n]);
                if (collection == null) continue;
                collection.add(junFormTriangleArray[n2]);
            }
        }
        HashMap<Jun2dPoint, JunFormTriangleNode[]> hashMap2 = new HashMap<Jun2dPoint, JunFormTriangleNode[]>();
        object = hashMap.keySet().iterator();
        while (object.hasNext()) {
            Jun2dPoint jun2dPoint = (Jun2dPoint)((Object)object.next());
            collection = (Collection)hashMap.get((Object)jun2dPoint);
            hashMap2.put(jun2dPoint, collection.toArray(new JunFormTriangleNode[collection.size()]));
        }
        hashMap = hashMap2;
        return hashMap;
    }

    public Jun2dPoint[][] chordalAxes() {
        ArrayList<Jun2dPoint[]> arrayList = new ArrayList<Jun2dPoint[]>();
        Jun2dPoint[][] jun2dPointArray = this.chordalAxesTerminalToTerminal();
        for (int i = 0; i < jun2dPointArray.length; ++i) {
            arrayList.add(jun2dPointArray[i]);
        }
        Jun2dPoint[][] jun2dPointArray2 = this.chordalAxesTerminalToJunction();
        for (int i = 0; i < jun2dPointArray2.length; ++i) {
            arrayList.add(jun2dPointArray2[i]);
        }
        Jun2dPoint[][] jun2dPointArray3 = this.chordalAxesJunctionToJunction();
        for (int i = 0; i < jun2dPointArray3.length; ++i) {
            arrayList.add(jun2dPointArray3[i]);
        }
        return (Jun2dPoint[][])arrayList.toArray((T[])new Jun2dPoint[arrayList.size()][]);
    }

    public Jun2dPoint[][] chordalAxesJunctionToJunction() {
        if (this.chordalAxesInformation == null) {
            this.chordalAxesInformation = this.computeChordalAxes();
        }
        return this.chordalAxesInformation[2];
    }

    public Map chordalAxesTable() {
        if (this.chordalAxesTable == null) {
            this.chordalAxesTable = this.computeChordalAxesTable();
        }
        return this.chordalAxesTable;
    }

    public Jun2dPoint[][] chordalAxesTerminalToJunction() {
        if (this.chordalAxesInformation == null) {
            this.chordalAxesInformation = this.computeChordalAxes();
        }
        return this.chordalAxesInformation[1];
    }

    public Jun2dPoint[][] chordalAxesTerminalToTerminal() {
        if (this.chordalAxesInformation == null) {
            this.chordalAxesInformation = this.computeChordalAxes();
        }
        return this.chordalAxesInformation[0];
    }

    public Object chordalAxis_do_(Jun2dPoint[] jun2dPointArray, StBlockClosure stBlockClosure) {
        Object object;
        if (jun2dPointArray.length < 2) {
            return this;
        }
        Jun2dPoint jun2dPoint = jun2dPointArray[0];
        Jun2dPoint jun2dPoint2 = jun2dPointArray[1];
        JunFormTriangleNode[] junFormTriangleNodeArray = (JunFormTriangleNode[])this.chordalAxesTable().get((Object)jun2dPoint2);
        JunFormTriangleNode junFormTriangleNode = null;
        for (int i = 0; i < junFormTriangleNodeArray.length; ++i) {
            if ((!junFormTriangleNodeArray[i].isTerminal() || !((JunFormTriangleTerminal)junFormTriangleNodeArray[i]).tp().equals((Object)jun2dPoint)) && (!junFormTriangleNodeArray[i].isJunction() || !((JunFormTriangleJunction)junFormTriangleNodeArray[i]).jp().equals((Object)jun2dPoint))) continue;
            junFormTriangleNode = junFormTriangleNodeArray[i];
            break;
        }
        if ((object = stBlockClosure.value_value_value_(null, (Object)jun2dPoint, junFormTriangleNode)) != null) {
            return object;
        }
        for (int i = 1; i < jun2dPointArray.length; ++i) {
            jun2dPoint2 = jun2dPointArray[i];
            JunFormTriangleNode junFormTriangleNode2 = null;
            JunFormTriangleNode[] junFormTriangleNodeArray2 = (JunFormTriangleNode[])this.chordalAxesTable().get((Object)jun2dPoint2);
            for (int j = 0; j < junFormTriangleNodeArray2.length; ++j) {
                if (((Object)((Object)junFormTriangleNodeArray2[j])).equals((Object)junFormTriangleNode)) continue;
                junFormTriangleNode2 = junFormTriangleNodeArray2[j];
                break;
            }
            if ((object = stBlockClosure.value_value_value_((Object)junFormTriangleNode, (Object)jun2dPoint2, junFormTriangleNode2)) != null) {
                return object;
            }
            if (junFormTriangleNode2.isTerminal()) {
                return stBlockClosure.value_value_value_((Object)junFormTriangleNode2, (Object)((JunFormTriangleTerminal)junFormTriangleNode2).tp(), null);
            }
            if (junFormTriangleNode2.isJunction()) {
                return stBlockClosure.value_value_value_((Object)junFormTriangleNode2, (Object)((JunFormTriangleJunction)junFormTriangleNode2).jp(), null);
            }
            junFormTriangleNode = junFormTriangleNode2;
        }
        return null;
    }

    public JunOpenGL3dObject compute() {
        this.draftTriangleNodes();
        this.triangleNodes();
        this.chordalAxesTable();
        this.computeChordalAxes();
        this.fanTriangles();
        this.prunChordalAxes();
        this.spines();
        this.triangles();
        return this.body();
    }

    public Jun2dPoint[][][] computeChordalAxes() {
        Jun2dPoint[] jun2dPointArray;
        Object object;
        Object object2;
        JunAbstractObject junAbstractObject;
        Object object3;
        HashSet<Object> hashSet = new HashSet<Object>();
        ArrayList<Jun2dPoint[]> arrayList = new ArrayList<Jun2dPoint[]>();
        ArrayList<Jun2dPoint[]> arrayList2 = new ArrayList<Jun2dPoint[]>();
        JunFormTriangleTerminal[] junFormTriangleTerminalArray = this.terminalTriangleNodes();
        for (int i = 0; i < junFormTriangleTerminalArray.length; ++i) {
            if (hashSet.contains((Object)junFormTriangleTerminalArray[i])) continue;
            object3 = junFormTriangleTerminalArray[i];
            ArrayList<JunAbstractObject> arrayList3 = new ArrayList<JunAbstractObject>();
            arrayList3.add(((JunFormTriangleTerminal)((Object)object3)).tp());
            junAbstractObject = ((JunFormTriangleNode)((Object)object3)).spinePoints()[0];
            arrayList3.add(junAbstractObject);
            hashSet.add(object3);
            object2 = (JunFormTriangleNode[])this.chordalAxesTable().get((Object)junAbstractObject);
            object = new ArrayList();
            for (int j = 0; j < ((JunFormTriangleNode[])object2).length; ++j) {
                if (((Object)((Object)object2[j])).equals(object3)) continue;
                object.add(object2[j]);
            }
            object2 = object.toArray(new JunFormTriangleNode[object.size()]);
            Object object4 = object2[0];
            while (object4.isSleeve()) {
                int n;
                object = new ArrayList();
                jun2dPointArray = object4.spinePoints();
                for (n = 0; n < jun2dPointArray.length; ++n) {
                    if (jun2dPointArray[n].equals((Object)junAbstractObject)) continue;
                    object.add(jun2dPointArray[n]);
                }
                jun2dPointArray = object.toArray(new Jun2dPoint[object.size()]);
                junAbstractObject = jun2dPointArray[0];
                arrayList3.add(junAbstractObject);
                hashSet.add(object4);
                object2 = (JunFormTriangleNode[])this.chordalAxesTable().get((Object)junAbstractObject);
                object = new ArrayList();
                for (n = 0; n < ((Object)object2).length; ++n) {
                    if (object2[n].equals(object4)) continue;
                    object.add(object2[n]);
                }
                object2 = object.toArray(new JunFormTriangleNode[object.size()]);
                object4 = object2[0];
            }
            if (object4.isJunction()) {
                arrayList3.add(((JunFormTriangleJunction)((Object)object4)).jp());
                arrayList2.add(arrayList3.toArray(new Jun2dPoint[arrayList3.size()]));
            }
            if (!object4.isTerminal()) continue;
            arrayList3.add(((JunFormTriangleTerminal)((Object)object4)).tp());
            hashSet.add(object4);
            arrayList.add(arrayList3.toArray(new Jun2dPoint[arrayList3.size()]));
        }
        ArrayList<Jun2dPoint[]> arrayList4 = new ArrayList<Jun2dPoint[]>();
        object3 = this.junctionTriangleNodes();
        for (int i = 0; i < ((JunFormTriangleJunction[])object3).length; ++i) {
            int n;
            junAbstractObject = object3[i];
            object2 = new ArrayList();
            object = ((JunFormTriangleNode)junAbstractObject).triangleNodes();
            for (n = 0; n < ((JunFormTriangleNode[])object).length; ++n) {
                if (hashSet.contains((Object)object[n])) continue;
                object2.add(object[n]);
            }
            object = object2.toArray(new JunFormTriangleNode[object2.size()]);
            for (n = 0; n < ((JunFormTriangleNode[])object).length; ++n) {
                Object object5;
                jun2dPointArray = object[n];
                if (hashSet.contains(jun2dPointArray)) continue;
                ArrayList<Jun2dPoint> arrayList5 = new ArrayList<Jun2dPoint>();
                arrayList5.add(((JunFormTriangleJunction)junAbstractObject).jp());
                Jun2dPoint jun2dPoint = null;
                Jun2dPoint[] jun2dPointArray2 = jun2dPointArray.spinePoints();
                for (int j = 0; j < jun2dPointArray2.length; ++j) {
                    object5 = (JunFormTriangleNode[])this.chordalAxesTable().get((Object)jun2dPointArray2[j]);
                    for (int k = 0; k < ((JunFormTriangleNode[])object5).length; ++k) {
                        if (!((Object)((Object)object5[k])).equals((Object)junAbstractObject)) continue;
                        jun2dPoint = jun2dPointArray2[j];
                        break;
                    }
                    if (jun2dPoint != null) break;
                }
                arrayList5.add(jun2dPoint);
                hashSet.add((Object)junAbstractObject);
                JunFormTriangleNode[] junFormTriangleNodeArray = (JunFormTriangleNode[])this.chordalAxesTable().get((Object)jun2dPoint);
                object2 = new ArrayList();
                for (int j = 0; j < junFormTriangleNodeArray.length; ++j) {
                    if (((Object)((Object)junFormTriangleNodeArray[j])).equals((Object)junAbstractObject)) continue;
                    object2.add(junFormTriangleNodeArray[j]);
                }
                junFormTriangleNodeArray = object2.toArray(new JunFormTriangleNode[object2.size()]);
                object5 = junFormTriangleNodeArray[0];
                while (object5.isSleeve()) {
                    int n2;
                    object2 = new ArrayList();
                    Jun2dPoint[] jun2dPointArray3 = object5.spinePoints();
                    for (n2 = 0; n2 < jun2dPointArray3.length; ++n2) {
                        if (jun2dPointArray3[n2].equals((Object)jun2dPoint)) continue;
                        object2.add(jun2dPointArray3[n2]);
                    }
                    jun2dPointArray3 = object2.toArray(new Jun2dPoint[object2.size()]);
                    jun2dPoint = jun2dPointArray3[0];
                    arrayList5.add(jun2dPoint);
                    hashSet.add(object5);
                    junFormTriangleNodeArray = (JunFormTriangleNode[])this.chordalAxesTable().get((Object)jun2dPoint);
                    object2 = new ArrayList();
                    for (n2 = 0; n2 < junFormTriangleNodeArray.length; ++n2) {
                        if (((Object)((Object)junFormTriangleNodeArray[n2])).equals(object5)) continue;
                        object2.add(junFormTriangleNodeArray[n2]);
                    }
                    junFormTriangleNodeArray = object2.toArray(new JunFormTriangleNode[object2.size()]);
                    object5 = junFormTriangleNodeArray[0];
                }
                if (object5.isJunction()) {
                    arrayList5.add(((JunFormTriangleJunction)((Object)object5)).jp());
                    hashSet.add(object5);
                }
                if (object5.isTerminal()) {
                    throw new IllegalStateException("unexpected error");
                }
                arrayList4.add(arrayList5.toArray(new Jun2dPoint[arrayList5.size()]));
            }
        }
        return new Jun2dPoint[][][]{(Jun2dPoint[][])arrayList.toArray((T[])new Jun2dPoint[arrayList.size()][]), (Jun2dPoint[][])arrayList2.toArray((T[])new Jun2dPoint[arrayList2.size()][]), (Jun2dPoint[][])arrayList4.toArray((T[])new Jun2dPoint[arrayList4.size()][])};
    }

    public Map computeChordalAxesTable() {
        Object object;
        int n;
        if (this.isEmpty()) {
            return new HashMap();
        }
        HashMap hashMap = new HashMap();
        JunFormTriangleNode[] junFormTriangleNodeArray = this.triangleNodes();
        for (n = 0; n < junFormTriangleNodeArray.length; ++n) {
            object = junFormTriangleNodeArray[n].spinePoints();
            for (int i = 0; i < ((Jun2dPoint[])object).length; ++i) {
                if (!hashMap.containsKey((Object)object[i])) {
                    hashMap.put(object[i], new ArrayList());
                }
                Collection collection = (Collection)hashMap.get(object[i]);
                collection.add(junFormTriangleNodeArray[n]);
            }
        }
        for (n = 0; n < junFormTriangleNodeArray.length; ++n) {
            object = new StSymbol[]{JunFormCreation.$((String)"sp1"), JunFormCreation.$((String)"sp2"), JunFormCreation.$((String)"sp3")};
            StSymbol[] stSymbolArray = new StSymbol[]{JunFormCreation.$((String)"tn1_"), JunFormCreation.$((String)"tn2_"), JunFormCreation.$((String)"tn3_")};
            for (int i = 0; i < ((Object)object).length; ++i) {
                Jun2dPoint jun2dPoint = null;
                try {
                    jun2dPoint = (Jun2dPoint)((Object)junFormTriangleNodeArray[n].perform_(object[i].toString()));
                }
                catch (Exception exception) {
                    System.out.println(exception.getMessage());
                    exception.printStackTrace();
                }
                if (jun2dPoint == null) continue;
                Collection collection = (Collection)hashMap.get((Object)jun2dPoint);
                JunFormTriangleNode[] junFormTriangleNodeArray2 = collection.toArray(new JunFormTriangleNode[collection.size()]);
                ArrayList<JunFormTriangleNode> arrayList = new ArrayList<JunFormTriangleNode>();
                for (int j = 0; j < junFormTriangleNodeArray2.length; ++j) {
                    if (((Object)((Object)junFormTriangleNodeArray2[j])).equals((Object)junFormTriangleNodeArray[n])) continue;
                    arrayList.add(junFormTriangleNodeArray2[j]);
                }
                if (arrayList.size() > 1) {
                    throw new IllegalStateException("unexpected error");
                }
                if (arrayList.size() == 1) {
                    try {
                        junFormTriangleNodeArray[n].perform_with_(stSymbolArray[i].toString(), arrayList.get(0));
                    }
                    catch (Exception exception) {
                        System.out.println(exception.getMessage());
                        exception.printStackTrace();
                    }
                    continue;
                }
                throw new IllegalStateException("unexpected error");
            }
        }
        HashMap<Jun2dPoint, JunFormTriangleNode[]> hashMap2 = new HashMap<Jun2dPoint, JunFormTriangleNode[]>();
        object = hashMap.keySet().iterator();
        while (object.hasNext()) {
            Jun2dPoint jun2dPoint = (Jun2dPoint)((Object)object.next());
            Collection collection = (Collection)hashMap.get((Object)jun2dPoint);
            hashMap2.put(jun2dPoint, collection.toArray(new JunFormTriangleNode[collection.size()]));
        }
        hashMap = hashMap2;
        return hashMap;
    }

    public JunFormTriangleNode[] computeDraftTriangleNodes() {
        JunAbstractObject junAbstractObject;
        Jun2dTriangle[] jun2dTriangleArray = this.triangulatedTriangles();
        Jun2dPoint[] jun2dPointArray = this.points();
        int n = jun2dPointArray.length;
        ArrayList<JunAbstractObject> arrayList = new ArrayList<JunAbstractObject>(n);
        for (int i = 0; i < n - 1; ++i) {
            Jun2dPoint jun2dPoint = jun2dPointArray[i];
            junAbstractObject = jun2dPointArray[i + 1];
            arrayList.add(((Jun2dPoint)junAbstractObject).minus_(jun2dPoint).dividedBy_(2.0).plus_(jun2dPoint));
        }
        ArrayList arrayList2 = new ArrayList(arrayList);
        arrayList = new ArrayList(jun2dTriangleArray.length);
        for (int i = 0; i < jun2dTriangleArray.length; ++i) {
            junAbstractObject = new JunFormTriangleNode(jun2dTriangleArray[i]);
            ArrayList<Jun2dPoint> arrayList3 = new ArrayList<Jun2dPoint>();
            if (!arrayList2.contains((Object)((JunFormTriangleNode)junAbstractObject).m1())) {
                arrayList3.add(((JunFormTriangleNode)junAbstractObject).m1());
            }
            if (!arrayList2.contains((Object)((JunFormTriangleNode)junAbstractObject).m2())) {
                arrayList3.add(((JunFormTriangleNode)junAbstractObject).m2());
            }
            if (!arrayList2.contains((Object)((JunFormTriangleNode)junAbstractObject).m3())) {
                arrayList3.add(((JunFormTriangleNode)junAbstractObject).m3());
            }
            junAbstractObject = null;
            if (arrayList3.size() == 1) {
                junAbstractObject = new JunFormTriangleTerminal(jun2dTriangleArray[i].points(), arrayList3.toArray(new Jun2dPoint[arrayList3.size()]));
            }
            if (arrayList3.size() == 2) {
                junAbstractObject = new JunFormTriangleSleeve(jun2dTriangleArray[i].points(), arrayList3.toArray(new Jun2dPoint[arrayList3.size()]));
            }
            if (arrayList3.size() == 3) {
                junAbstractObject = new JunFormTriangleJunction(jun2dTriangleArray[i].points(), arrayList3.toArray(new Jun2dPoint[arrayList3.size()]));
            }
            arrayList.add(junAbstractObject);
        }
        return arrayList.toArray(new JunFormTriangleNode[arrayList.size()]);
    }

    public JunOpenGL3dCompoundObject computeFinalBody() {
        return this.complexBody();
    }

    public Jun2dPoint[][] computeFinalSpines() {
        return this.spinePolylines();
    }

    public JunFormTriangleNode[] computeFinalTriangles() {
        int n;
        JunFormTriangleNode[] junFormTriangleNodeArray;
        Object[] objectArray;
        int n2;
        Object[][] objectArray2;
        int n3;
        ArrayList<JunFormTriangleNode> arrayList = new ArrayList<JunFormTriangleNode>();
        Object[][][] objectArray3 = this.spinePolylineInformationJunctionToJunction();
        for (n3 = 0; n3 < objectArray3.length; ++n3) {
            objectArray2 = objectArray3[n3];
            for (n2 = 0; n2 < objectArray2.length; ++n2) {
                objectArray = objectArray2[n2];
                junFormTriangleNodeArray = (JunFormTriangleNode[])objectArray[1];
                for (n = 0; n < junFormTriangleNodeArray.length; ++n) {
                    arrayList.add(junFormTriangleNodeArray[n]);
                }
            }
        }
        objectArray3 = this.spinePolylineInformationTerminalToJunction();
        for (n3 = 0; n3 < objectArray3.length; ++n3) {
            objectArray2 = objectArray3[n3];
            for (n2 = 0; n2 < objectArray2.length; ++n2) {
                objectArray = objectArray2[n2];
                junFormTriangleNodeArray = (JunFormTriangleNode[])objectArray[1];
                for (n = 0; n < junFormTriangleNodeArray.length; ++n) {
                    arrayList.add(junFormTriangleNodeArray[n]);
                }
            }
        }
        objectArray3 = this.spinePolylineInformationTerminalToTerminal();
        for (n3 = 0; n3 < objectArray3.length; ++n3) {
            objectArray2 = objectArray3[n3];
            for (n2 = 0; n2 < objectArray2.length; ++n2) {
                objectArray = objectArray2[n2];
                junFormTriangleNodeArray = (JunFormTriangleNode[])objectArray[1];
                for (n = 0; n < junFormTriangleNodeArray.length; ++n) {
                    arrayList.add(junFormTriangleNodeArray[n]);
                }
            }
        }
        return arrayList.toArray(new JunFormTriangleNode[arrayList.size()]);
    }

    public JunFormTriangleNode[] computeTriangleNodes() {
        int n;
        Object object;
        ArrayList<JunAbstractObject> arrayList;
        StSymbol[] stSymbolArray;
        if (this.isEmpty()) {
            return new JunFormTriangleNode[0];
        }
        HashMap hashMap = new HashMap();
        JunFormTriangleNode[] junFormTriangleNodeArray = this.draftTriangleNodes();
        for (int i = 0; i < junFormTriangleNodeArray.length; ++i) {
            Jun2dPoint[] jun2dPointArray = junFormTriangleNodeArray[i].spinePoints();
            for (int j = 0; j < jun2dPointArray.length; ++j) {
                if (!hashMap.containsKey((Object)jun2dPointArray[j])) {
                    hashMap.put(jun2dPointArray[j], new ArrayList(2));
                }
                stSymbolArray = (StSymbol[])hashMap.get((Object)jun2dPointArray[j]);
                stSymbolArray.add(junFormTriangleNodeArray[i]);
            }
        }
        final ArrayList<JunFormTriangleNode> arrayList2 = new ArrayList<JunFormTriangleNode>();
        for (int i = 0; i < junFormTriangleNodeArray.length; ++i) {
            StSymbol[] stSymbolArray2 = new StSymbol[]{JunFormCreation.$((String)"sp1"), JunFormCreation.$((String)"sp2"), JunFormCreation.$((String)"sp3")};
            stSymbolArray = new StSymbol[]{JunFormCreation.$((String)"tn1_"), JunFormCreation.$((String)"tn2_"), JunFormCreation.$((String)"tn3_")};
            for (int j = 0; j < stSymbolArray2.length; ++j) {
                StSymbol stSymbol = stSymbolArray2[j];
                StSymbol stSymbol2 = stSymbolArray[j];
                Jun2dPoint jun2dPoint = null;
                try {
                    jun2dPoint = (Jun2dPoint)((Object)junFormTriangleNodeArray[i].perform_(stSymbol.toString()));
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
                if (jun2dPoint == null) continue;
                arrayList = (ArrayList<JunAbstractObject>)hashMap.get((Object)jun2dPoint);
                object = arrayList.toArray(new JunFormTriangleNode[arrayList.size()]);
                arrayList = new ArrayList<JunAbstractObject>();
                for (int k = 0; k < ((JunFormTriangleNode[])object).length; ++k) {
                    if (object[k] == junFormTriangleNodeArray[i]) continue;
                    arrayList.add(object[k]);
                }
                if (arrayList.size() > 1) {
                    throw new IllegalStateException("unexpected error");
                }
                if (arrayList.size() == 1) {
                    try {
                        junFormTriangleNodeArray[i].perform_with_(stSymbol2.toString(), arrayList.get(0));
                        continue;
                    }
                    catch (Exception exception) {
                        throw new RuntimeException(exception);
                    }
                }
                arrayList2.add(junFormTriangleNodeArray[i]);
            }
        }
        JunFormTriangleNode junFormTriangleNode = null;
        for (int i = 0; i < junFormTriangleNodeArray.length; ++i) {
            boolean bl;
            boolean bl2 = bl = !arrayList2.contains((Object)junFormTriangleNodeArray[i]);
            if (!bl) continue;
            JunFormTriangleNode[] junFormTriangleNodeArray2 = junFormTriangleNodeArray[i].triangleNodes();
            boolean bl3 = true;
            for (int j = 0; j < junFormTriangleNodeArray2.length; ++j) {
                if (!arrayList2.contains((Object)junFormTriangleNodeArray2[j])) continue;
                bl3 = false;
                break;
            }
            if (!bl3) continue;
            junFormTriangleNode = junFormTriangleNodeArray[i];
            break;
        }
        if (junFormTriangleNode == null) {
            throw new IllegalStateException("unexpected error");
        }
        final ArrayList arrayList3 = new ArrayList(junFormTriangleNodeArray.length);
        junFormTriangleNode.do_(new StBlockClosure(){

            public Object value_(Object object) {
                if (!arrayList2.contains(object)) {
                    arrayList3.add(object);
                }
                return null;
            }
        });
        if (arrayList3.size() < 2) {
            throw new IllegalStateException("unexpected error");
        }
        junFormTriangleNodeArray = arrayList3.toArray(new JunFormTriangleNode[arrayList3.size()]);
        for (n = 0; n < junFormTriangleNodeArray.length; ++n) {
            junFormTriangleNodeArray[n].flushTriangleNodes();
        }
        hashMap = new HashMap();
        for (n = 0; n < junFormTriangleNodeArray.length; ++n) {
            Jun2dPoint[] jun2dPointArray = junFormTriangleNodeArray[n].spinePoints();
            for (int i = 0; i < jun2dPointArray.length; ++i) {
                if (!hashMap.containsKey((Object)jun2dPointArray[i])) {
                    hashMap.put(jun2dPointArray[i], new ArrayList(2));
                }
                Collection collection = (Collection)hashMap.get((Object)jun2dPointArray[i]);
                collection.add(junFormTriangleNodeArray[n]);
            }
        }
        ArrayList<Object> arrayList4 = new ArrayList<Object>(junFormTriangleNodeArray.length);
        for (int i = 0; i < junFormTriangleNodeArray.length; ++i) {
            Jun2dPoint jun2dPoint = null;
            Jun2dPoint[] jun2dPointArray = junFormTriangleNodeArray[i].spinePoints();
            for (int j = 0; j < jun2dPointArray.length; ++j) {
                if (((Collection)hashMap.get((Object)jun2dPointArray[j])).size() == 2) continue;
                jun2dPoint = jun2dPointArray[j];
                break;
            }
            if (jun2dPoint == null) {
                arrayList4.add((Object)junFormTriangleNodeArray[i]);
                continue;
            }
            Jun2dPoint[] jun2dPointArray2 = junFormTriangleNodeArray[i].points();
            arrayList = new ArrayList();
            for (int j = 0; j < jun2dPointArray.length; ++j) {
                if (jun2dPointArray[j] == jun2dPoint) continue;
                arrayList.add(jun2dPointArray[j]);
            }
            object = new JunFormTriangleTerminal(jun2dPointArray2, arrayList.toArray(new Jun2dPoint[arrayList.size()]));
            arrayList4.add(object);
        }
        junFormTriangleNodeArray = arrayList4.toArray(new JunFormTriangleNode[arrayList4.size()]);
        return junFormTriangleNodeArray;
    }

    public JunOpenGL3dObject asJunOpenGL3dObject() {
        return this.body();
    }

    public GeneralPath toGeneralPath() {
        return this._createGeneralPath_(this.points());
    }

    public double defaultLiftUpFactor() {
        return 0.8;
    }

    public int defaultOvalFactor() {
        return 4;
    }

    public double[] defaultOvalFactors() {
        double d = 90.0 / (double)this.defaultOvalFactor();
        double[] dArray = new double[this.defaultOvalFactor() + 1];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = d * (double)i;
        }
        return dArray;
    }

    public Color defaultPaint() {
        return Color.gray;
    }

    public int defaultSoFar() {
        return 29999;
    }

    public void displayChordalAxesOn_(Graphics graphics) {
        this.displayChordalAxesOn_at_(graphics, new Point(0, 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayChordalAxesOn_at_(Graphics graphics, Point point) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        try {
            GeneralPath generalPath;
            int n;
            Jun2dPoint[] jun2dPointArray;
            Jun2dPoint[] jun2dPointArray2;
            int n2;
            Rectangle rectangle = this.boundingBox().asRectangle();
            Point point2 = new Point(0 - rectangle.x + point.x, 0 - rectangle.y + point.y);
            graphics2D.translate(point2.x, point2.y);
            graphics2D.setColor(Color.white);
            graphics2D.fill(rectangle);
            graphics2D.setStroke(new BasicStroke(1.0f, 0, 2));
            graphics2D.setColor(Color.gray);
            graphics2D.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
            JunFormTriangleNode[] junFormTriangleNodeArray = this.sleeveTriangleNodes();
            for (n2 = 0; n2 < junFormTriangleNodeArray.length; ++n2) {
                jun2dPointArray2 = junFormTriangleNodeArray[n2].asPolylineLoop();
                jun2dPointArray = this._createGeneralPath_(jun2dPointArray2);
                graphics2D.setColor(StColorValue.Blend((Color)Color.green, (Color)Color.white));
                graphics2D.fill((Shape)jun2dPointArray);
                graphics2D.setColor(Color.green);
                graphics2D.draw((Shape)jun2dPointArray);
            }
            junFormTriangleNodeArray = this.terminalTriangleNodes();
            for (n2 = 0; n2 < junFormTriangleNodeArray.length; ++n2) {
                jun2dPointArray2 = junFormTriangleNodeArray[n2].asPolylineLoop();
                jun2dPointArray = this._createGeneralPath_(jun2dPointArray2);
                graphics2D.setColor(StColorValue.Blend((Color)Color.red, (Color)Color.white));
                graphics2D.fill((Shape)jun2dPointArray);
                graphics2D.setColor(Color.red);
                graphics2D.draw((Shape)jun2dPointArray);
            }
            junFormTriangleNodeArray = this.junctionTriangleNodes();
            for (n2 = 0; n2 < junFormTriangleNodeArray.length; ++n2) {
                jun2dPointArray2 = junFormTriangleNodeArray[n2].asPolylineLoop();
                jun2dPointArray = this._createGeneralPath_(jun2dPointArray2);
                graphics2D.setColor(StColorValue.Blend((Color)Color.blue, (Color)Color.white));
                graphics2D.fill((Shape)jun2dPointArray);
                graphics2D.setColor(Color.blue);
                graphics2D.draw((Shape)jun2dPointArray);
            }
            graphics2D.setStroke(new BasicStroke(2.0f, 0, 2));
            Jun2dPoint[][] jun2dPointArray3 = this.chordalAxesTerminalToTerminal();
            for (n = 0; n < jun2dPointArray3.length; ++n) {
                jun2dPointArray = jun2dPointArray3[n];
                generalPath = this._createGeneralPath_(jun2dPointArray);
                graphics2D.setColor(Color.cyan);
                graphics2D.draw(generalPath);
            }
            jun2dPointArray3 = this.chordalAxesTerminalToJunction();
            for (n = 0; n < jun2dPointArray3.length; ++n) {
                jun2dPointArray = jun2dPointArray3[n];
                generalPath = this._createGeneralPath_(jun2dPointArray);
                graphics2D.setColor(Color.magenta);
                graphics2D.draw(generalPath);
            }
            jun2dPointArray3 = this.chordalAxesJunctionToJunction();
            for (n = 0; n < jun2dPointArray3.length; ++n) {
                jun2dPointArray = jun2dPointArray3[n];
                generalPath = this._createGeneralPath_(jun2dPointArray);
                graphics2D.setColor(Color.yellow);
                graphics2D.draw(generalPath);
            }
        }
        finally {
            if (graphics2D != null) {
                graphics2D.dispose();
            }
        }
    }

    public void displayDraftTriangleNodesOn_(Graphics graphics) {
        this.displayDraftTriangleNodesOn_at_(graphics, new Point(0, 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayDraftTriangleNodesOn_at_(Graphics graphics, Point point) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        try {
            GeneralPath generalPath;
            Jun2dPoint[] jun2dPointArray;
            int n;
            Rectangle rectangle = this.boundingBox().asRectangle();
            Point point2 = new Point(0 - rectangle.x + point.x, 0 - rectangle.y + point.y);
            graphics2D.translate(point2.x, point2.y);
            graphics2D.setColor(Color.white);
            graphics2D.fill(rectangle);
            graphics2D.setStroke(new BasicStroke(1.0f, 0, 2));
            graphics2D.setColor(Color.gray);
            graphics2D.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
            JunFormTriangleNode[] junFormTriangleNodeArray = this.draftSleeveTriangleNodes();
            for (n = 0; n < junFormTriangleNodeArray.length; ++n) {
                jun2dPointArray = junFormTriangleNodeArray[n].asPolylineLoop();
                generalPath = this._createGeneralPath_(jun2dPointArray);
                graphics2D.setColor(StColorValue.Blend((Color)Color.green, (Color)Color.white));
                graphics2D.fill(generalPath);
                graphics2D.setColor(Color.green);
                graphics2D.draw(generalPath);
            }
            junFormTriangleNodeArray = this.draftTerminalTriangleNodes();
            for (n = 0; n < junFormTriangleNodeArray.length; ++n) {
                jun2dPointArray = junFormTriangleNodeArray[n].asPolylineLoop();
                generalPath = this._createGeneralPath_(jun2dPointArray);
                graphics2D.setColor(StColorValue.Blend((Color)Color.red, (Color)Color.white));
                graphics2D.fill(generalPath);
                graphics2D.setColor(Color.red);
                graphics2D.draw(generalPath);
            }
            junFormTriangleNodeArray = this.draftJunctionTriangleNodes();
            for (n = 0; n < junFormTriangleNodeArray.length; ++n) {
                jun2dPointArray = junFormTriangleNodeArray[n].asPolylineLoop();
                generalPath = this._createGeneralPath_(jun2dPointArray);
                graphics2D.setColor(StColorValue.Blend((Color)Color.blue, (Color)Color.white));
                graphics2D.fill(generalPath);
                graphics2D.setColor(Color.blue);
                graphics2D.draw(generalPath);
            }
            junFormTriangleNodeArray = this.draftTriangleNodes();
            for (n = 0; n < junFormTriangleNodeArray.length; ++n) {
                jun2dPointArray = junFormTriangleNodeArray[n].spinePoints();
                for (int i = 0; i < jun2dPointArray.length; ++i) {
                    Rectangle rectangle2 = jun2dPointArray[i].asBoundingBox().asRectangle();
                    rectangle2.grow(1, 1);
                    graphics2D.setColor(Color.black);
                    graphics2D.fill(rectangle2);
                }
            }
        }
        finally {
            if (graphics2D != null) {
                graphics2D.dispose();
            }
        }
    }

    public void displayOn_(Graphics graphics) {
        this.displayOn_at_(graphics, new Point(0, 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayOn_at_(Graphics graphics, Point point) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        try {
            Jun2dPoint[] jun2dPointArray;
            Rectangle rectangle = this.boundingBox().asRectangle();
            Point point2 = new Point(0 - rectangle.x + point.x, 0 - rectangle.y + point.y);
            graphics2D.translate(point2.x, point2.y);
            graphics2D.setColor(Color.white);
            graphics2D.fill(rectangle);
            graphics2D.setStroke(new BasicStroke(1.0f, 0, 2));
            graphics2D.setColor(Color.gray);
            graphics2D.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
            JunFormTriangle[] junFormTriangleArray = this.triangles();
            for (int i = 0; i < junFormTriangleArray.length; ++i) {
                Jun2dPoint[] jun2dPointArray2 = junFormTriangleArray[i].asPolylineLoop();
                jun2dPointArray = this._createGeneralPath_(jun2dPointArray2);
                graphics2D.setColor(StColorValue.Blend((Color)Color.cyan, (Color)Color.white));
                graphics2D.fill((Shape)jun2dPointArray);
                graphics2D.setColor(Color.blue);
                graphics2D.draw((Shape)jun2dPointArray);
            }
            Jun2dPoint[][] jun2dPointArray3 = this.spines();
            for (int i = 0; i < jun2dPointArray3.length; ++i) {
                Cloneable cloneable;
                jun2dPointArray = jun2dPointArray3[i];
                graphics2D.setStroke(new BasicStroke(2.0f, 0, 2));
                graphics2D.setColor(Color.red);
                if (jun2dPointArray.length == 1) {
                    cloneable = jun2dPointArray[0].asPoint();
                    graphics2D.drawRect(((Point)cloneable).x - 1, ((Point)cloneable).y - 1, 2, 2);
                    continue;
                }
                cloneable = this._createGeneralPath_(jun2dPointArray);
                graphics2D.draw((Shape)((Object)cloneable));
            }
        }
        finally {
            if (graphics2D != null) {
                graphics2D.dispose();
            }
        }
    }

    public void displayPolylineOn_(Graphics graphics) {
        this.displayPolylineOn_at_(graphics, new Point(0, 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayPolylineOn_at_(Graphics graphics, Point point) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        try {
            Rectangle rectangle = this.boundingBox().asRectangle();
            Point point2 = new Point(0 - rectangle.x + point.x, 0 - rectangle.y + point.y);
            graphics2D.translate(point2.x, point2.y);
            graphics2D.setColor(Color.white);
            graphics2D.fill(rectangle);
            graphics2D.setStroke(new BasicStroke(1.0f, 0, 2));
            graphics2D.setColor(Color.gray);
            graphics2D.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
            GeneralPath generalPath = this.toGeneralPath();
            graphics2D.setColor(Color.black);
            graphics2D.draw(generalPath);
            graphics2D.setColor(Color.green);
            Jun2dPoint[] jun2dPointArray = this.points();
            for (int i = 0; i < jun2dPointArray.length; ++i) {
                Point point3 = jun2dPointArray[i].asPoint();
                graphics2D.drawRect(point3.x - 1, point3.y - 1, 2, 2);
            }
        }
        finally {
            if (graphics2D != null) {
                graphics2D.dispose();
            }
        }
    }

    public void displaySpinePolylinesOn_(Graphics graphics) {
        this.displaySpinePolylinesOn_at_(graphics, new Point(0, 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displaySpinePolylinesOn_at_(Graphics graphics, Point point) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        try {
            Shape shape;
            Jun2dPoint[] jun2dPointArray;
            int n;
            Rectangle rectangle = this.boundingBox().asRectangle();
            Point point2 = new Point(0 - rectangle.x + point.x, 0 - rectangle.y + point.y);
            graphics2D.translate(point2.x, point2.y);
            graphics2D.setColor(Color.white);
            graphics2D.fill(rectangle);
            graphics2D.setStroke(new BasicStroke(1.0f, 0, 2));
            graphics2D.setColor(Color.gray);
            graphics2D.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
            JunFormTriangleNode[] junFormTriangleNodeArray = this.sleeveTriangleNodes();
            for (n = 0; n < junFormTriangleNodeArray.length; ++n) {
                jun2dPointArray = junFormTriangleNodeArray[n].asPolylineLoop();
                shape = this._createGeneralPath_(jun2dPointArray);
                graphics2D.setColor(StColorValue.Blend((Color)Color.green, (Color)Color.white));
                graphics2D.fill(shape);
                graphics2D.setColor(Color.green);
                graphics2D.draw(shape);
            }
            junFormTriangleNodeArray = this.terminalTriangleNodes();
            for (n = 0; n < junFormTriangleNodeArray.length; ++n) {
                jun2dPointArray = junFormTriangleNodeArray[n].asPolylineLoop();
                shape = this._createGeneralPath_(jun2dPointArray);
                graphics2D.setColor(StColorValue.Blend((Color)Color.red, (Color)Color.white));
                graphics2D.fill(shape);
                graphics2D.setColor(Color.red);
                graphics2D.draw(shape);
            }
            junFormTriangleNodeArray = this.junctionTriangleNodes();
            for (n = 0; n < junFormTriangleNodeArray.length; ++n) {
                jun2dPointArray = junFormTriangleNodeArray[n].asPolylineLoop();
                shape = this._createGeneralPath_(jun2dPointArray);
                graphics2D.setColor(StColorValue.Blend((Color)Color.blue, (Color)Color.white));
                graphics2D.fill(shape);
                graphics2D.setColor(Color.blue);
                graphics2D.draw(shape);
            }
            junFormTriangleNodeArray = this.fanTriangles();
            for (n = 0; n < junFormTriangleNodeArray.length; ++n) {
                jun2dPointArray = junFormTriangleNodeArray[n].asPolylineLoop();
                shape = this._createGeneralPath_(jun2dPointArray);
                graphics2D.setColor(StColorValue.Blend((Color)Color.magenta, (Color)Color.white));
                graphics2D.fill(shape);
                graphics2D.setColor(Color.magenta);
                graphics2D.draw(shape);
            }
            graphics2D.setStroke(new BasicStroke(2.0f, 0, 2));
            Jun2dPoint[][] jun2dPointArray2 = this.spinePolylines();
            for (int i = 0; i < jun2dPointArray2.length; ++i) {
                graphics2D.setColor(Color.yellow);
                if (jun2dPointArray2[i].length == 1) {
                    shape = jun2dPointArray2[i][0].boundingBox().asRectangle();
                    ((Rectangle)shape).grow(1, 1);
                    graphics2D.fill(shape);
                    continue;
                }
                shape = this._createGeneralPath_(jun2dPointArray2[i]);
                graphics2D.draw(shape);
            }
        }
        finally {
            if (graphics2D != null) {
                graphics2D.dispose();
            }
        }
    }

    public void displayTriangleNodesOn_(Graphics graphics) {
        this.displayTriangleNodesOn_at_(graphics, new Point(0, 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayTriangleNodesOn_at_(Graphics graphics, Point point) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        try {
            GeneralPath generalPath;
            Jun2dPoint[] jun2dPointArray;
            int n;
            Rectangle rectangle = this.boundingBox().asRectangle();
            Point point2 = new Point(0 - rectangle.x + point.x, 0 - rectangle.y + point.y);
            graphics2D.translate(point2.x, point2.y);
            graphics2D.setColor(Color.white);
            graphics2D.fill(rectangle);
            graphics2D.setStroke(new BasicStroke(1.0f, 0, 2));
            graphics2D.setColor(Color.gray);
            graphics2D.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
            JunFormTriangleNode[] junFormTriangleNodeArray = this.sleeveTriangleNodes();
            for (n = 0; n < junFormTriangleNodeArray.length; ++n) {
                jun2dPointArray = junFormTriangleNodeArray[n].asPolylineLoop();
                generalPath = this._createGeneralPath_(jun2dPointArray);
                graphics2D.setColor(StColorValue.Blend((Color)Color.green, (Color)Color.white));
                graphics2D.fill(generalPath);
                graphics2D.setColor(Color.green);
                graphics2D.draw(generalPath);
            }
            junFormTriangleNodeArray = this.terminalTriangleNodes();
            for (n = 0; n < junFormTriangleNodeArray.length; ++n) {
                jun2dPointArray = junFormTriangleNodeArray[n].asPolylineLoop();
                generalPath = this._createGeneralPath_(jun2dPointArray);
                graphics2D.setColor(StColorValue.Blend((Color)Color.red, (Color)Color.white));
                graphics2D.fill(generalPath);
                graphics2D.setColor(Color.red);
                graphics2D.draw(generalPath);
            }
            junFormTriangleNodeArray = this.junctionTriangleNodes();
            for (n = 0; n < junFormTriangleNodeArray.length; ++n) {
                jun2dPointArray = junFormTriangleNodeArray[n].asPolylineLoop();
                generalPath = this._createGeneralPath_(jun2dPointArray);
                graphics2D.setColor(StColorValue.Blend((Color)Color.blue, (Color)Color.white));
                graphics2D.fill(generalPath);
                graphics2D.setColor(Color.blue);
                graphics2D.draw(generalPath);
            }
            junFormTriangleNodeArray = this.triangleNodes();
            for (n = 0; n < junFormTriangleNodeArray.length; ++n) {
                jun2dPointArray = junFormTriangleNodeArray[n].spinePoints();
                for (int i = 0; i < jun2dPointArray.length; ++i) {
                    Rectangle rectangle2 = jun2dPointArray[i].asBoundingBox().asRectangle();
                    rectangle2.grow(1, 1);
                    graphics2D.setColor(Color.black);
                    graphics2D.fill(rectangle2);
                }
            }
        }
        finally {
            if (graphics2D != null) {
                graphics2D.dispose();
            }
        }
    }

    public void displayTriangulatedTrianglesOn_(Graphics graphics) {
        this.displayTriangulatedTrianglesOn_at_(graphics, new Point(0, 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayTriangulatedTrianglesOn_at_(Graphics graphics, Point point) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        try {
            Rectangle rectangle = this.boundingBox().asRectangle();
            Point point2 = new Point(0 - rectangle.x + point.x, 0 - rectangle.y + point.y);
            graphics2D.translate(point2.x, point2.y);
            graphics2D.setColor(Color.white);
            graphics2D.fill(rectangle);
            graphics2D.setStroke(new BasicStroke(1.0f, 0, 2));
            graphics2D.setColor(Color.gray);
            graphics2D.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
            Jun2dTriangle[] jun2dTriangleArray = this.triangulation().triangles();
            for (int i = 0; i < jun2dTriangleArray.length; ++i) {
                Jun2dTriangle jun2dTriangle = jun2dTriangleArray[i];
                Jun2dPoint[] jun2dPointArray = jun2dTriangle.first().equals((Object)jun2dTriangle.last()) ? jun2dTriangle.asArrayOfPoints() : jun2dTriangle.asPointArray();
                GeneralPath generalPath = this._createGeneralPath_(jun2dPointArray);
                graphics2D.setColor(StColorValue.Blend((Color)Color.red, (Color)Color.white));
                graphics2D.fill(generalPath);
                graphics2D.setColor(Color.red);
                graphics2D.draw(generalPath);
            }
            GeneralPath generalPath = this.toGeneralPath();
            graphics2D.setColor(Color.black);
            graphics2D.draw(generalPath);
        }
        finally {
            if (graphics2D != null) {
                graphics2D.dispose();
            }
        }
    }

    public Object[] fanCenterAndPoints_(Jun2dPoint[] jun2dPointArray) {
        final HashSet hashSet = new HashSet();
        Object object = this.chordalAxis_do_(jun2dPointArray, new StBlockClosure(){

            public Object value_value_value_(Object object, Object object2, Object object3) {
                JunFormTriangleNode junFormTriangleNode = (JunFormTriangleNode)((Object)object);
                Jun2dPoint jun2dPoint = (Jun2dPoint)((Object)object2);
                JunFormTriangleNode junFormTriangleNode2 = (JunFormTriangleNode)((Object)object3);
                if (junFormTriangleNode == null) {
                    hashSet.add(((JunFormTriangleTerminal)junFormTriangleNode2).tp());
                }
                if (junFormTriangleNode != null && junFormTriangleNode2 != null) {
                    boolean bl = JunFormCreation.this.insideFan_from_to_(hashSet.toArray(new Jun2dPoint[hashSet.size()]), jun2dPoint, junFormTriangleNode2.pointsAtMidPoint_(jun2dPoint)[0]);
                    Jun2dPoint[] jun2dPointArray = junFormTriangleNode.points();
                    for (int i = 0; i < jun2dPointArray.length; ++i) {
                        hashSet.add(jun2dPointArray[i]);
                    }
                    if (!bl) {
                        return new Object[]{jun2dPoint, hashSet.toArray(new Jun2dPoint[hashSet.size()])};
                    }
                }
                if (junFormTriangleNode2 == null) {
                    return new Object[]{jun2dPoint, hashSet.toArray(new Jun2dPoint[hashSet.size()])};
                }
                return null;
            }
        });
        if (object != null) {
            return (Object[])object;
        }
        throw new IllegalStateException("unexpected error");
    }

    public JunFormTriangleNode[] fanTriangles() {
        if (this.fanTriangles == null) {
            this.prunChordalAxes();
        }
        return this.fanTriangles.toArray(new JunFormTriangleNode[this.fanTriangles.size()]);
    }

    public JunFormTriangleNode[] fanTriangles_centerPoint_(Jun2dPoint[] jun2dPointArray, Jun2dPoint jun2dPoint) {
        ArrayList<JunFormTriangleNode> arrayList = new ArrayList<JunFormTriangleNode>(jun2dPointArray.length);
        for (int i = 0; i < jun2dPointArray.length - 1; ++i) {
            Jun2dPoint[] jun2dPointArray2 = new Jun2dPoint[]{jun2dPointArray[i], jun2dPointArray[i + 1], jun2dPoint};
            arrayList.add(this.createTriangle_(jun2dPointArray2));
        }
        return arrayList.toArray(new JunFormTriangleNode[arrayList.size()]);
    }

    public boolean insideFan_from_to_(Jun2dPoint[] jun2dPointArray, Jun2dPoint jun2dPoint, Jun2dPoint jun2dPoint2) {
        double d = jun2dPoint2.distance_(jun2dPoint);
        for (int i = 0; i < jun2dPointArray.length; ++i) {
            double d2 = jun2dPointArray[i].distance_(jun2dPoint);
            if (!(d2 > d)) continue;
            return false;
        }
        return true;
    }

    public Object[][][][] prunChordalAxes() {
        this.fanTriangles = new ArrayList();
        ArrayList<Object[][][]> arrayList = new ArrayList<Object[][][]>();
        arrayList.add(this.prunChordalAxesTerminalToTerminal());
        arrayList.add(this.prunChordalAxesTerminalToJunction());
        arrayList.add(this.prunChordalAxesJunctionToJunction());
        return (Object[][][][])arrayList.toArray((T[])new Object[arrayList.size()][][][]);
    }

    public Object[][][] prunChordalAxesJunctionToJunction() {
        Jun2dPoint[][] jun2dPointArray = this.chordalAxesJunctionToJunction();
        ArrayList<Object[][]> arrayList = new ArrayList<Object[][]>(jun2dPointArray.length);
        for (int i = 0; i < jun2dPointArray.length; ++i) {
            Object[][] objectArray = this.prunChordalAxisJunctionToJunction_(jun2dPointArray[i]);
            arrayList.add(objectArray);
        }
        return (Object[][][])arrayList.toArray((T[])new Object[arrayList.size()][][]);
    }

    public Object[][][] prunChordalAxesTerminalToJunction() {
        Jun2dPoint[][] jun2dPointArray = this.chordalAxesTerminalToJunction();
        ArrayList<Object[][]> arrayList = new ArrayList<Object[][]>(jun2dPointArray.length);
        for (int i = 0; i < jun2dPointArray.length; ++i) {
            Object[][] objectArray = this.prunChordalAxisTerminalToJunction_(jun2dPointArray[i]);
            arrayList.add(objectArray);
        }
        return (Object[][][])arrayList.toArray((T[])new Object[arrayList.size()][][]);
    }

    public Object[][][] prunChordalAxesTerminalToTerminal() {
        Jun2dPoint[][] jun2dPointArray = this.chordalAxesTerminalToTerminal();
        ArrayList<Object[][]> arrayList = new ArrayList<Object[][]>(jun2dPointArray.length);
        for (int i = 0; i < jun2dPointArray.length; ++i) {
            Object[][] objectArray = this.prunChordalAxisTerminalToTerminal_(jun2dPointArray[i]);
            arrayList.add(objectArray);
        }
        return (Object[][][])arrayList.toArray((T[])new Object[arrayList.size()][][]);
    }

    public Object[][] prunChordalAxisJunctionToJunction_(Jun2dPoint[] jun2dPointArray) {
        final ArrayList arrayList = new ArrayList(jun2dPointArray.length);
        final StValueHolder stValueHolder = new StValueHolder(null);
        this.chordalAxis_do_(jun2dPointArray, new StBlockClosure(){

            public Object value_value_value_(Object object, Object object2, Object object3) {
                Object object4;
                JunFormTriangleNode junFormTriangleNode = (JunFormTriangleNode)((Object)object);
                Jun2dPoint jun2dPoint = (Jun2dPoint)((Object)object2);
                JunFormTriangleNode junFormTriangleNode2 = (JunFormTriangleNode)((Object)object3);
                Jun2dPoint jun2dPoint2 = (Jun2dPoint)((Object)stValueHolder.value());
                if (junFormTriangleNode == null) {
                    jun2dPoint2 = jun2dPoint;
                    object4 = new JunFormTriangleNode[]{};
                    arrayList.add(new Object[]{jun2dPoint, object4});
                }
                if (junFormTriangleNode != null && junFormTriangleNode2 != null) {
                    int n;
                    Jun2dPoint[] jun2dPointArray;
                    if (junFormTriangleNode.isJunction()) {
                        object4 = new JunFormTriangleNode[2];
                        jun2dPointArray = junFormTriangleNode.pointsAtMidPoint_(jun2dPoint);
                        object4[0] = JunFormCreation.this.createTriangle_(new Jun2dPoint[]{jun2dPoint2, jun2dPoint, jun2dPointArray[0]});
                        object4[1] = JunFormCreation.this.createTriangle_(new Jun2dPoint[]{jun2dPoint2, jun2dPoint, jun2dPointArray[jun2dPointArray.length - 1]});
                        arrayList.add(new Object[]{jun2dPoint, object4});
                    }
                    if (!junFormTriangleNode.isJunction() && !junFormTriangleNode2.isJunction()) {
                        object4 = new JunFormTriangleNode[3];
                        jun2dPointArray = junFormTriangleNode.threeTriangles_with_(jun2dPoint, jun2dPoint2);
                        for (n = 0; n < jun2dPointArray.length; ++n) {
                            object4[n] = JunFormCreation.this.createTriangle_((Jun2dPoint[])jun2dPointArray[n]);
                        }
                        arrayList.add(new Object[]{jun2dPoint, object4});
                    }
                    if (junFormTriangleNode2.isJunction()) {
                        object4 = new ArrayList(5);
                        if (!junFormTriangleNode.isJunction()) {
                            jun2dPointArray = junFormTriangleNode.threeTriangles_with_(jun2dPoint, jun2dPoint2);
                            for (n = 0; n < jun2dPointArray.length; ++n) {
                                object4.add(JunFormCreation.this.createTriangle_((Jun2dPoint[])jun2dPointArray[n]));
                            }
                        }
                        jun2dPointArray = junFormTriangleNode2.pointsAtMidPoint_(jun2dPoint);
                        object4.add(JunFormCreation.this.createTriangle_(new Jun2dPoint[]{jun2dPoint, ((JunFormTriangleJunction)junFormTriangleNode2).jp(), jun2dPointArray[0]}));
                        object4.add(JunFormCreation.this.createTriangle_(new Jun2dPoint[]{jun2dPoint, ((JunFormTriangleJunction)junFormTriangleNode2).jp(), jun2dPointArray[jun2dPointArray.length - 1]}));
                        arrayList.add(new Object[]{jun2dPoint, object4.toArray(new JunFormTriangleNode[object4.size()])});
                    }
                }
                if (junFormTriangleNode2 == null) {
                    object4 = new JunFormTriangleNode[]{};
                    arrayList.add(new Object[]{jun2dPoint, object4});
                }
                stValueHolder.value_((Object)jun2dPoint);
                return null;
            }
        });
        return (Object[][])arrayList.toArray((T[])new Object[arrayList.size()][]);
    }

    public Object[][] prunChordalAxisTerminalToJunction_(Jun2dPoint[] jun2dPointArray) {
        final ArrayList<Object[]> arrayList = new ArrayList<Object[]>(jun2dPointArray.length);
        Object[] objectArray = this.fanCenterAndPoints_(jun2dPointArray);
        Jun2dPoint jun2dPoint = (Jun2dPoint)((Object)objectArray[0]);
        Jun2dPoint[] jun2dPointArray2 = (Jun2dPoint[])objectArray[1];
        final StValueHolder stValueHolder = new StValueHolder(this._indexOf_within_(jun2dPoint, jun2dPointArray));
        jun2dPointArray2 = this.sortWedgePoints_centerPoint_terminalPoint_(jun2dPointArray2, jun2dPoint, jun2dPointArray[0]);
        JunFormTriangleNode[] junFormTriangleNodeArray = this.fanTriangles_centerPoint_(jun2dPointArray2, jun2dPoint);
        for (int i = 0; i < junFormTriangleNodeArray.length; ++i) {
            this.fanTriangles.add(junFormTriangleNodeArray[i]);
        }
        arrayList.add(new Object[]{jun2dPoint, junFormTriangleNodeArray});
        final StValueHolder stValueHolder2 = new StValueHolder(0);
        final StValueHolder stValueHolder3 = new StValueHolder(null);
        this.chordalAxis_do_(jun2dPointArray, new StBlockClosure(){

            public Object value_value_value_(Object object, Object object2, Object object3) {
                Jun2dPoint[][] jun2dPointArray;
                Object object4;
                int n;
                JunFormTriangleNode junFormTriangleNode = (JunFormTriangleNode)((Object)object);
                Jun2dPoint jun2dPoint = (Jun2dPoint)((Object)object2);
                JunFormTriangleNode junFormTriangleNode2 = (JunFormTriangleNode)((Object)object3);
                Jun2dPoint jun2dPoint2 = (Jun2dPoint)((Object)stValueHolder3.value());
                int n2 = stValueHolder2._intValue();
                if (n2 > (n = stValueHolder._intValue())) {
                    if (junFormTriangleNode != null && junFormTriangleNode2 != null) {
                        int n3;
                        if (!junFormTriangleNode2.isJunction()) {
                            object4 = new JunFormTriangleNode[3];
                            jun2dPointArray = junFormTriangleNode.threeTriangles_with_(jun2dPoint, jun2dPoint2);
                            for (n3 = 0; n3 < jun2dPointArray.length; ++n3) {
                                object4[n3] = JunFormCreation.this.createTriangle_(jun2dPointArray[n3]);
                            }
                            arrayList.add(new Object[]{jun2dPoint, object4});
                        }
                        if (junFormTriangleNode2.isJunction()) {
                            object4 = new ArrayList(5);
                            if (!junFormTriangleNode.isJunction()) {
                                jun2dPointArray = junFormTriangleNode.threeTriangles_with_(jun2dPoint, jun2dPoint2);
                                for (n3 = 0; n3 < jun2dPointArray.length; ++n3) {
                                    object4.add(JunFormCreation.this.createTriangle_(jun2dPointArray[n3]));
                                }
                            }
                            jun2dPointArray = junFormTriangleNode2.pointsAtMidPoint_(jun2dPoint);
                            object4.add(JunFormCreation.this.createTriangle_(new Jun2dPoint[]{jun2dPoint, ((JunFormTriangleJunction)junFormTriangleNode2).jp(), jun2dPointArray[0]}));
                            object4.add(JunFormCreation.this.createTriangle_(new Jun2dPoint[]{jun2dPoint, ((JunFormTriangleJunction)junFormTriangleNode2).jp(), jun2dPointArray[jun2dPointArray.length - 1]}));
                            arrayList.add(new Object[]{jun2dPoint, object4.toArray(new JunFormTriangleNode[object4.size()])});
                        }
                    }
                    if (junFormTriangleNode2 == null) {
                        object4 = new JunFormTriangleNode[]{};
                        arrayList.add(new Object[]{jun2dPoint, object4});
                    }
                }
                if (n2 == n + 1 && junFormTriangleNode.isJunction() && junFormTriangleNode2 == null) {
                    object4 = new JunFormTriangleNode[2];
                    jun2dPointArray = junFormTriangleNode.pointsAtMidPoint_(jun2dPoint2);
                    object4[0] = JunFormCreation.this.createTriangle_(new Jun2dPoint[]{jun2dPoint2, ((JunFormTriangleJunction)junFormTriangleNode).jp(), jun2dPointArray[0]});
                    object4[1] = JunFormCreation.this.createTriangle_(new Jun2dPoint[]{jun2dPoint2, ((JunFormTriangleJunction)junFormTriangleNode).jp(), jun2dPointArray[jun2dPointArray.length - 1]});
                    arrayList.add(new Object[]{jun2dPoint, object4});
                }
                stValueHolder2.value_(n2 + 1);
                stValueHolder3.value_((Object)jun2dPoint);
                return null;
            }
        });
        return (Object[][])arrayList.toArray((T[])new Object[arrayList.size()][]);
    }

    public Object[][] prunChordalAxisTerminalToTerminal_(Jun2dPoint[] jun2dPointArray) {
        final ArrayList<Object[]> arrayList = new ArrayList<Object[]>(jun2dPointArray.length);
        if (jun2dPointArray.length == 3) {
            Jun2dPoint jun2dPoint = jun2dPointArray[1];
            final HashSet hashSet = new HashSet();
            this.chordalAxis_do_(jun2dPointArray, new StBlockClosure(){

                public Object value_value_value_(Object object, Object object2, Object object3) {
                    int n;
                    Jun2dPoint[] jun2dPointArray;
                    JunFormTriangleNode junFormTriangleNode = (JunFormTriangleNode)((Object)object);
                    JunFormTriangleNode junFormTriangleNode2 = (JunFormTriangleNode)((Object)object3);
                    if (junFormTriangleNode == null) {
                        jun2dPointArray = junFormTriangleNode2.points();
                        for (n = 0; n < jun2dPointArray.length; ++n) {
                            hashSet.add(jun2dPointArray[n]);
                        }
                    }
                    if (junFormTriangleNode2 == null) {
                        jun2dPointArray = junFormTriangleNode.points();
                        for (n = 0; n < jun2dPointArray.length; ++n) {
                            hashSet.add(jun2dPointArray[n]);
                        }
                    }
                    return null;
                }
            });
            Jun2dPoint[] jun2dPointArray2 = hashSet.toArray(new Jun2dPoint[hashSet.size()]);
            jun2dPointArray2 = this.sortWedgePoints_centerPoint_terminalPoint_(jun2dPointArray2, jun2dPoint, jun2dPointArray[0]);
            Jun2dPoint[] jun2dPointArray3 = new Jun2dPoint[jun2dPointArray2.length];
            for (int i = 0; i < jun2dPointArray2.length; ++i) {
                jun2dPointArray3[i] = jun2dPointArray2[i];
            }
            jun2dPointArray3[jun2dPointArray3.length - 1] = jun2dPointArray2[0];
            jun2dPointArray2 = jun2dPointArray3;
            JunFormTriangleNode[] junFormTriangleNodeArray = this.fanTriangles_centerPoint_(jun2dPointArray2, jun2dPoint);
            for (int i = 0; i < junFormTriangleNodeArray.length; ++i) {
                this.fanTriangles.add(junFormTriangleNodeArray[i]);
            }
            arrayList.add(new Object[]{jun2dPoint, junFormTriangleNodeArray});
            return (Object[][])arrayList.toArray((T[])new Object[arrayList.size()][]);
        }
        Object[] objectArray = this.fanCenterAndPoints_(jun2dPointArray);
        Jun2dPoint jun2dPoint = (Jun2dPoint)((Object)objectArray[0]);
        Jun2dPoint[] jun2dPointArray4 = (Jun2dPoint[])objectArray[1];
        final int n = this._indexOf_within_(jun2dPoint, jun2dPointArray);
        jun2dPointArray4 = this.sortWedgePoints_centerPoint_terminalPoint_(jun2dPointArray4, jun2dPoint, jun2dPointArray[0]);
        JunFormTriangleNode[] junFormTriangleNodeArray = this.fanTriangles_centerPoint_(jun2dPointArray4, jun2dPoint);
        for (int i = 0; i < junFormTriangleNodeArray.length; ++i) {
            this.fanTriangles.add(junFormTriangleNodeArray[i]);
        }
        arrayList.add(new Object[]{jun2dPoint, junFormTriangleNodeArray});
        Jun2dPoint[] jun2dPointArray5 = new Jun2dPoint[jun2dPointArray.length];
        for (int i = 0; i < jun2dPointArray5.length; ++i) {
            jun2dPointArray5[i] = jun2dPointArray[jun2dPointArray.length - 1 - i];
        }
        objectArray = this.fanCenterAndPoints_(jun2dPointArray5);
        Jun2dPoint jun2dPoint2 = (Jun2dPoint)((Object)objectArray[0]);
        Jun2dPoint[] jun2dPointArray6 = (Jun2dPoint[])objectArray[1];
        final int n2 = jun2dPointArray.length - this._indexOf_within_(jun2dPoint2, jun2dPointArray5) - 1;
        jun2dPointArray6 = this.sortWedgePoints_centerPoint_terminalPoint_(jun2dPointArray6, jun2dPoint2, jun2dPointArray[jun2dPointArray.length - 1]);
        JunFormTriangleNode[] junFormTriangleNodeArray2 = this.fanTriangles_centerPoint_(jun2dPointArray4, jun2dPoint2);
        for (int i = 0; i < junFormTriangleNodeArray2.length; ++i) {
            this.fanTriangles.add(junFormTriangleNodeArray2[i]);
        }
        final StValueHolder stValueHolder = new StValueHolder(0);
        final StValueHolder stValueHolder2 = new StValueHolder(null);
        this.chordalAxis_do_(jun2dPointArray, new StBlockClosure(){

            public Object value_value_value_(Object object, Object object2, Object object3) {
                JunFormTriangleNode junFormTriangleNode = (JunFormTriangleNode)((Object)object);
                Jun2dPoint jun2dPoint = (Jun2dPoint)((Object)object2);
                JunFormTriangleNode junFormTriangleNode2 = (JunFormTriangleNode)((Object)object3);
                Jun2dPoint jun2dPoint2 = (Jun2dPoint)((Object)stValueHolder2.value());
                int n3 = stValueHolder._intValue();
                if (n3 > n && n3 <= n2 && junFormTriangleNode != null && junFormTriangleNode2 != null) {
                    JunFormTriangleNode[] junFormTriangleNodeArray = new JunFormTriangleNode[3];
                    Jun2dPoint[][] jun2dPointArray = junFormTriangleNode.threeTriangles_with_(jun2dPoint, jun2dPoint2);
                    for (int i = 0; i < jun2dPointArray.length; ++i) {
                        junFormTriangleNodeArray[i] = JunFormCreation.this.createTriangle_(jun2dPointArray[i]);
                    }
                    arrayList.add(new Object[]{jun2dPoint, junFormTriangleNodeArray});
                }
                stValueHolder.value_(n3 + 1);
                stValueHolder2.value_((Object)jun2dPoint);
                return null;
            }
        });
        arrayList.add(new Object[]{jun2dPoint2, junFormTriangleNodeArray2});
        return (Object[][])arrayList.toArray((T[])new Object[arrayList.size()][]);
    }

    protected Jun2dPoint[] sortWedgePoints_centerPoint_terminalPoint_(Jun2dPoint[] jun2dPointArray, Jun2dPoint jun2dPoint, Jun2dPoint jun2dPoint2) {
        int n;
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        ArrayList<Object[]> arrayList2 = new ArrayList<Object[]>();
        JunPlane junPlane = new JunPlane(new Jun3dPoint(jun2dPoint2.x(), jun2dPoint2.y(), 0.0), new Jun3dPoint(jun2dPoint.x(), jun2dPoint.y(), 0.0), new Jun3dPoint(jun2dPoint.x(), jun2dPoint.y(), 1.0));
        for (int i = 0; i < jun2dPointArray.length; ++i) {
            double d = junPlane.valueF_(new Jun3dPoint(jun2dPointArray[i].x(), jun2dPointArray[i].y(), 0.0));
            JunAngle junAngle = new Jun2dLine(jun2dPoint, jun2dPoint2).angleWithLine_(new Jun2dLine(jun2dPoint, jun2dPointArray[i]));
            if (d >= 0.0) {
                arrayList.add(new Object[]{junAngle, jun2dPointArray[i]});
                continue;
            }
            arrayList2.add(new Object[]{junAngle, jun2dPointArray[i]});
        }
        Object[][] objectArray = (Object[][])arrayList.toArray((T[])new Object[arrayList.size()][]);
        Arrays.sort(objectArray, new Comparator(){

            public int compare(Object object, Object object2) {
                JunAngle junAngle = (JunAngle)((Object[])object)[0];
                JunAngle junAngle2 = (JunAngle)((Object[])object2)[0];
                return junAngle.rad() == junAngle2.rad() ? 0 : (junAngle.rad() < junAngle2.rad() ? -1 : 1);
            }
        });
        Object[][] objectArray2 = (Object[][])arrayList2.toArray((T[])new Object[arrayList2.size()][]);
        Arrays.sort(objectArray2, new Comparator(){

            public int compare(Object object, Object object2) {
                JunAngle junAngle = (JunAngle)((Object[])object)[0];
                JunAngle junAngle2 = (JunAngle)((Object[])object2)[0];
                return junAngle.rad() == junAngle2.rad() ? 0 : (junAngle.rad() > junAngle2.rad() ? -1 : 1);
            }
        });
        ArrayList<Object> arrayList3 = new ArrayList<Object>(objectArray.length * 2);
        for (n = 0; n < objectArray2.length; ++n) {
            arrayList3.add(objectArray2[n][1]);
        }
        for (n = 0; n < objectArray.length; ++n) {
            arrayList3.add(objectArray[n][1]);
        }
        return arrayList3.toArray(new Jun2dPoint[arrayList3.size()]);
    }

    public Object spinePolylineInformation() {
        int n;
        ArrayList<Object[][]> arrayList = new ArrayList<Object[][]>();
        Object[][][] objectArray = this.spinePolylineInformationTerminalToTerminal();
        for (n = 0; n < objectArray.length; ++n) {
            arrayList.add(objectArray[n]);
        }
        objectArray = this.spinePolylineInformationTerminalToJunction();
        for (n = 0; n < objectArray.length; ++n) {
            arrayList.add(objectArray[n]);
        }
        objectArray = this.spinePolylineInformationJunctionToJunction();
        for (n = 0; n < objectArray.length; ++n) {
            arrayList.add(objectArray[n]);
        }
        return (Object[][])arrayList.toArray((T[])new Object[arrayList.size()][]);
    }

    public Object[][][] spinePolylineInformationJunctionToJunction() {
        if (this.spinePolylineInformation == null) {
            this.spinePolylineInformation = this.prunChordalAxes();
        }
        return this.spinePolylineInformation[2];
    }

    public Object[][][] spinePolylineInformationTerminalToJunction() {
        if (this.spinePolylineInformation == null) {
            this.spinePolylineInformation = this.prunChordalAxes();
        }
        return this.spinePolylineInformation[1];
    }

    public Object[][][] spinePolylineInformationTerminalToTerminal() {
        if (this.spinePolylineInformation == null) {
            this.spinePolylineInformation = this.prunChordalAxes();
        }
        return this.spinePolylineInformation[0];
    }

    public Jun2dPoint[][] spinePolylines() {
        int n;
        ArrayList<Jun2dPoint[]> arrayList = new ArrayList<Jun2dPoint[]>();
        Jun2dPoint[][] jun2dPointArray = this.spinePolylinesTerminalToTerminal();
        for (n = 0; n < jun2dPointArray.length; ++n) {
            arrayList.add(jun2dPointArray[n]);
        }
        jun2dPointArray = this.spinePolylinesTerminalToJunction();
        for (n = 0; n < jun2dPointArray.length; ++n) {
            arrayList.add(jun2dPointArray[n]);
        }
        jun2dPointArray = this.spinePolylinesJunctionToJunction();
        for (n = 0; n < jun2dPointArray.length; ++n) {
            arrayList.add(jun2dPointArray[n]);
        }
        return (Jun2dPoint[][])arrayList.toArray((T[])new Jun2dPoint[arrayList.size()][]);
    }

    public Jun2dPoint[][] spinePolylinesJunctionToJunction() {
        Object[][][] objectArray = this.spinePolylineInformationJunctionToJunction();
        ArrayList<Jun2dPoint[]> arrayList = new ArrayList<Jun2dPoint[]>();
        for (int i = 0; i < objectArray.length; ++i) {
            Object[][] objectArray2 = objectArray[i];
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            for (int j = 0; j < objectArray2.length; ++j) {
                arrayList2.add(objectArray2[j][0]);
            }
            Jun2dPoint[] jun2dPointArray = arrayList2.toArray(new Jun2dPoint[arrayList2.size()]);
            arrayList.add(jun2dPointArray);
        }
        return (Jun2dPoint[][])arrayList.toArray((T[])new Jun2dPoint[arrayList.size()][]);
    }

    public Jun2dPoint[][] spinePolylinesTerminalToJunction() {
        Object[][][] objectArray = this.spinePolylineInformationTerminalToJunction();
        ArrayList<Jun2dPoint[]> arrayList = new ArrayList<Jun2dPoint[]>();
        for (int i = 0; i < objectArray.length; ++i) {
            Object[][] objectArray2 = objectArray[i];
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            for (int j = 0; j < objectArray2.length; ++j) {
                arrayList2.add(objectArray2[j][0]);
            }
            Jun2dPoint[] jun2dPointArray = arrayList2.toArray(new Jun2dPoint[arrayList2.size()]);
            arrayList.add(jun2dPointArray);
        }
        return (Jun2dPoint[][])arrayList.toArray((T[])new Jun2dPoint[arrayList.size()][]);
    }

    public Jun2dPoint[][] spinePolylinesTerminalToTerminal() {
        Object[][][] objectArray = this.spinePolylineInformationTerminalToTerminal();
        ArrayList<Jun2dPoint[]> arrayList = new ArrayList<Jun2dPoint[]>();
        for (int i = 0; i < objectArray.length; ++i) {
            Object[][] objectArray2 = objectArray[i];
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            for (int j = 0; j < objectArray2.length; ++j) {
                arrayList2.add(objectArray2[j][0]);
            }
            Jun2dPoint[] jun2dPointArray = arrayList2.toArray(new Jun2dPoint[arrayList2.size()]);
            arrayList.add(jun2dPointArray);
        }
        return (Jun2dPoint[][])arrayList.toArray((T[])new Jun2dPoint[arrayList.size()][]);
    }

    public boolean isEmpty() {
        return this.points().length == 0 || this.points().length < 5;
    }

    public JunFormTriangleJunction[] draftJunctionTriangleNodes() {
        ArrayList<JunFormTriangleNode> arrayList = new ArrayList<JunFormTriangleNode>();
        JunFormTriangleNode[] junFormTriangleNodeArray = this.draftTriangleNodes();
        for (int i = 0; i < junFormTriangleNodeArray.length; ++i) {
            if (!junFormTriangleNodeArray[i].isJunction()) continue;
            arrayList.add(junFormTriangleNodeArray[i]);
        }
        return arrayList.toArray(new JunFormTriangleJunction[arrayList.size()]);
    }

    public JunFormTriangleSleeve[] draftSleeveTriangleNodes() {
        ArrayList<JunFormTriangleNode> arrayList = new ArrayList<JunFormTriangleNode>();
        JunFormTriangleNode[] junFormTriangleNodeArray = this.draftTriangleNodes();
        for (int i = 0; i < junFormTriangleNodeArray.length; ++i) {
            if (!junFormTriangleNodeArray[i].isSleeve()) continue;
            arrayList.add(junFormTriangleNodeArray[i]);
        }
        return arrayList.toArray(new JunFormTriangleSleeve[arrayList.size()]);
    }

    public JunFormTriangleTerminal[] draftTerminalTriangleNodes() {
        ArrayList<JunFormTriangleNode> arrayList = new ArrayList<JunFormTriangleNode>();
        JunFormTriangleNode[] junFormTriangleNodeArray = this.draftTriangleNodes();
        for (int i = 0; i < junFormTriangleNodeArray.length; ++i) {
            if (!junFormTriangleNodeArray[i].isTerminal()) continue;
            arrayList.add(junFormTriangleNodeArray[i]);
        }
        return arrayList.toArray(new JunFormTriangleTerminal[arrayList.size()]);
    }

    public JunFormTriangleNode[] draftTriangleNodes() {
        if (this.draftTriangleNodes == null) {
            this.draftTriangleNodes = this.computeDraftTriangleNodes();
        }
        return this.draftTriangleNodes;
    }

    public JunFormTriangleJunction[] junctionTriangleNodes() {
        ArrayList<JunFormTriangleNode> arrayList = new ArrayList<JunFormTriangleNode>();
        JunFormTriangleNode[] junFormTriangleNodeArray = this.triangleNodes();
        for (int i = 0; i < junFormTriangleNodeArray.length; ++i) {
            if (!junFormTriangleNodeArray[i].isJunction()) continue;
            arrayList.add(junFormTriangleNodeArray[i]);
        }
        return arrayList.toArray(new JunFormTriangleJunction[arrayList.size()]);
    }

    public JunFormTriangleSleeve[] sleeveTriangleNodes() {
        ArrayList<JunFormTriangleNode> arrayList = new ArrayList<JunFormTriangleNode>();
        JunFormTriangleNode[] junFormTriangleNodeArray = this.triangleNodes();
        for (int i = 0; i < junFormTriangleNodeArray.length; ++i) {
            if (!junFormTriangleNodeArray[i].isSleeve()) continue;
            arrayList.add(junFormTriangleNodeArray[i]);
        }
        return arrayList.toArray(new JunFormTriangleSleeve[arrayList.size()]);
    }

    public JunFormTriangleTerminal[] terminalTriangleNodes() {
        ArrayList<JunFormTriangleNode> arrayList = new ArrayList<JunFormTriangleNode>();
        JunFormTriangleNode[] junFormTriangleNodeArray = this.triangleNodes();
        for (int i = 0; i < junFormTriangleNodeArray.length; ++i) {
            if (!junFormTriangleNodeArray[i].isTerminal()) continue;
            arrayList.add(junFormTriangleNodeArray[i]);
        }
        return arrayList.toArray(new JunFormTriangleTerminal[arrayList.size()]);
    }

    public JunFormTriangleNode[] triangleNodes() {
        if (this.triangleNodes == null) {
            this.triangleNodes = this.computeTriangleNodes();
        }
        return this.triangleNodes;
    }

    protected GeneralPath _createGeneralPath_(Jun2dPoint[] jun2dPointArray) {
        if (jun2dPointArray == null || jun2dPointArray.length == 0) {
            return null;
        }
        GeneralPath generalPath = new GeneralPath(0, jun2dPointArray.length);
        generalPath.moveTo((float)jun2dPointArray[0].x(), (float)jun2dPointArray[0].y());
        for (int i = 1; i < jun2dPointArray.length; ++i) {
            generalPath.lineTo((float)jun2dPointArray[i].x(), (float)jun2dPointArray[i].y());
        }
        return generalPath;
    }

    protected int _indexOf_within_(Jun2dPoint jun2dPoint, Jun2dPoint[] jun2dPointArray) {
        for (int i = 0; i < jun2dPointArray.length; ++i) {
            if (jun2dPointArray[i] != jun2dPoint) continue;
            return i;
        }
        return -1;
    }

    protected JunFormTriangleNode createTriangle_(Jun2dPoint[] jun2dPointArray) {
        JunFormTriangleNode junFormTriangleNode;
        Jun3dPoint[] jun3dPointArray = new Jun3dPoint[3];
        for (int i = 0; i < jun3dPointArray.length; ++i) {
            jun3dPointArray[i] = new Jun3dPoint(jun2dPointArray[i].x(), jun2dPointArray[i].y(), 0.0);
        }
        JunPlane junPlane = new JunPlane(jun3dPointArray[0], jun3dPointArray[1], jun3dPointArray[2]);
        Jun3dPoint jun3dPoint = new Jun3dPoint(0.0, 0.0, this.defaultSoFar());
        if (0.0 > junPlane.valueF_(jun3dPoint)) {
            junFormTriangleNode = new JunFormTriangleNode(jun2dPointArray);
        } else {
            Jun2dPoint[] jun2dPointArray2 = new Jun2dPoint[jun2dPointArray.length];
            for (int i = 0; i < jun2dPointArray.length; ++i) {
                jun2dPointArray2[i] = jun2dPointArray[jun2dPointArray.length - 1 - i];
            }
            junFormTriangleNode = new JunFormTriangleNode(jun2dPointArray2);
        }
        return junFormTriangleNode;
    }

    protected Jun3dPoint[] sortTrianglePoints_(Jun3dPoint[] jun3dPointArray) {
        JunPlane junPlane = new JunPlane(jun3dPointArray[0], jun3dPointArray[1], jun3dPointArray[2]);
        Jun3dPoint jun3dPoint = new Jun3dPoint(0.0, 0.0, this.defaultSoFar());
        if (0.0 > junPlane.valueF_(jun3dPoint)) {
            return jun3dPointArray;
        }
        Jun3dPoint[] jun3dPointArray2 = new Jun3dPoint[jun3dPointArray.length];
        for (int i = 0; i < jun3dPointArray.length; ++i) {
            jun3dPointArray2[i] = jun3dPointArray[jun3dPointArray.length - 1 - i];
        }
        return jun3dPointArray2;
    }
}

