/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.geometry.forms;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.forms.JunFormTriangle;
import jp.co.sra.jun.geometry.surfaces.Jun2dTriangle;
import jp.co.sra.smalltalk.StBlockClosure;

public class JunFormTriangleNode
extends JunFormTriangle {
    protected Jun2dPoint m1;
    protected Jun2dPoint m2;
    protected Jun2dPoint m3;
    protected Jun2dPoint sp1;
    protected Jun2dPoint sp2;
    protected Jun2dPoint sp3;
    protected JunFormTriangleNode tn1;
    protected JunFormTriangleNode tn2;
    protected JunFormTriangleNode tn3;

    public JunFormTriangleNode(Jun2dPoint jun2dPoint, Jun2dPoint jun2dPoint2, Jun2dPoint jun2dPoint3) {
        super(jun2dPoint, jun2dPoint2, jun2dPoint3);
    }

    public JunFormTriangleNode(Jun2dPoint[] jun2dPointArray) {
        super(jun2dPointArray);
    }

    public JunFormTriangleNode(Jun2dPoint[] jun2dPointArray, Jun2dPoint[] jun2dPointArray2) {
        super(jun2dPointArray);
        for (int i = 0; i < jun2dPointArray2.length; ++i) {
            if (jun2dPointArray2[i].equals((Object)this.m1())) {
                this.setSp1_(jun2dPointArray2[i]);
                if (this.sp2() != null && this.sp3() != null) break;
            }
            if (jun2dPointArray2[i].equals((Object)this.m2())) {
                this.setSp2_(jun2dPointArray2[i]);
                if (this.sp1() != null && this.sp3() != null) break;
            }
            if (!jun2dPointArray2[i].equals((Object)this.m3())) continue;
            this.setSp3_(jun2dPointArray2[i]);
            if (this.sp1() != null && this.sp2() != null) break;
        }
    }

    public JunFormTriangleNode(Jun2dTriangle jun2dTriangle) {
        super(jun2dTriangle);
    }

    public Jun2dPoint againstPointAtMidPoint_(Jun2dPoint jun2dPoint) {
        if (this.m1().equals((Object)jun2dPoint)) {
            return this.p3;
        }
        if (this.m2().equals((Object)jun2dPoint)) {
            return this.p1;
        }
        if (this.m3().equals((Object)jun2dPoint)) {
            return this.p2;
        }
        return null;
    }

    public Jun2dPoint m1() {
        if (this.m1 == null) {
            this.m1 = this.p1().plus_(this.p2().minus_(this.p1()).dividedBy_(2.0));
        }
        return this.m1;
    }

    public Jun2dPoint m2() {
        if (this.m2 == null) {
            this.m2 = this.p2().plus_(this.p3().minus_(this.p2()).dividedBy_(2.0));
        }
        return this.m2;
    }

    public Jun2dPoint m3() {
        if (this.m3 == null) {
            this.m3 = this.p3().plus_(this.p1().minus_(this.p3()).dividedBy_(2.0));
        }
        return this.m3;
    }

    public Jun2dPoint[] pointsAtMidPoint_(Jun2dPoint jun2dPoint) {
        if (this.m1().equals((Object)jun2dPoint)) {
            return new Jun2dPoint[]{this.p1(), this.p2()};
        }
        if (this.m2().equals((Object)jun2dPoint)) {
            return new Jun2dPoint[]{this.p2(), this.p3()};
        }
        if (this.m3().equals((Object)jun2dPoint)) {
            return new Jun2dPoint[]{this.p3(), this.p1()};
        }
        return null;
    }

    public Jun2dPoint sp1() {
        return this.sp1;
    }

    public Jun2dPoint sp2() {
        return this.sp2;
    }

    public Jun2dPoint sp3() {
        return this.sp3;
    }

    public Jun2dPoint[] spinePoints() {
        ArrayList<Jun2dPoint> arrayList = new ArrayList<Jun2dPoint>();
        if (this.sp1() != null) {
            arrayList.add(this.sp1());
        }
        if (this.sp2() != null) {
            arrayList.add(this.sp2());
        }
        if (this.sp3() != null) {
            arrayList.add(this.sp3());
        }
        return arrayList.toArray(new Jun2dPoint[arrayList.size()]);
    }

    public Object do_(StBlockClosure stBlockClosure) {
        return this.do_visited_(stBlockClosure, new HashSet());
    }

    public Object do_visited_(StBlockClosure stBlockClosure, Set set) {
        set.add(this);
        stBlockClosure.value_((Object)this);
        if (this.tn1() != null && !set.contains((Object)this.tn1)) {
            this.tn1().do_visited_(stBlockClosure, set);
        }
        if (this.tn2() != null && !set.contains((Object)this.tn2)) {
            this.tn2().do_visited_(stBlockClosure, set);
        }
        if (this.tn3() != null && !set.contains((Object)this.tn3)) {
            this.tn3().do_visited_(stBlockClosure, set);
        }
        return null;
    }

    public void printOn_(Writer writer) throws IOException {
        if (this.isTerminal()) {
            writer.write("terminal");
        }
        if (this.isSleeve()) {
            writer.write("sleeve");
        }
        if (this.isJunction()) {
            writer.write("junction");
        }
        writer.write("Triangle (");
        Jun2dPoint[] jun2dPointArray = this.points();
        for (int i = 0; i < jun2dPointArray.length; ++i) {
            jun2dPointArray[i].printOn_(writer);
            if (i >= jun2dPointArray.length - 1) continue;
            writer.write(", ");
        }
        writer.write(")");
    }

    public boolean isJunction() {
        return false;
    }

    public boolean isSleeve() {
        return false;
    }

    public boolean isTerminal() {
        return false;
    }

    public void flushTriangleNodes() {
        this.tn1_(null);
        this.tn2_(null);
        this.tn3_(null);
    }

    public Jun2dPoint[][] threeTriangles_with_(Jun2dPoint jun2dPoint, Jun2dPoint jun2dPoint2) {
        Jun2dPoint jun2dPoint3 = this.againstPointAtMidPoint_(jun2dPoint);
        Jun2dPoint jun2dPoint4 = this.againstPointAtMidPoint_(jun2dPoint2);
        Jun2dPoint[] jun2dPointArray = this.points();
        Jun2dPoint jun2dPoint5 = null;
        for (int i = 0; i < jun2dPointArray.length; ++i) {
            if (jun2dPointArray[i].equals((Object)jun2dPoint3) || jun2dPointArray[i].equals((Object)jun2dPoint4)) continue;
            jun2dPoint5 = jun2dPointArray[i];
            break;
        }
        Jun2dPoint[][] jun2dPointArray2 = new Jun2dPoint[3][];
        Jun2dPoint[] jun2dPointArray3 = new Jun2dPoint[]{jun2dPoint, jun2dPoint2, jun2dPoint5};
        jun2dPointArray2[0] = jun2dPointArray3;
        if (jun2dPoint.distance_(jun2dPoint3) < jun2dPoint2.distance_(jun2dPoint4)) {
            jun2dPointArray3 = new Jun2dPoint[]{jun2dPoint, jun2dPoint2, jun2dPoint3};
            jun2dPointArray2[1] = jun2dPointArray3;
            jun2dPointArray3 = new Jun2dPoint[]{jun2dPoint, jun2dPoint3, jun2dPoint4};
            jun2dPointArray2[2] = jun2dPointArray3;
        } else {
            jun2dPointArray3 = new Jun2dPoint[]{jun2dPoint, jun2dPoint2, jun2dPoint4};
            jun2dPointArray2[1] = jun2dPointArray3;
            jun2dPointArray3 = new Jun2dPoint[]{jun2dPoint2, jun2dPoint4, jun2dPoint3};
            jun2dPointArray2[2] = jun2dPointArray3;
        }
        return jun2dPointArray2;
    }

    public JunFormTriangleNode tn1() {
        return this.tn1;
    }

    public void tn1_(JunFormTriangleNode junFormTriangleNode) {
        this.tn1 = junFormTriangleNode;
    }

    public JunFormTriangleNode tn2() {
        return this.tn2;
    }

    public void tn2_(JunFormTriangleNode junFormTriangleNode) {
        this.tn2 = junFormTriangleNode;
    }

    public JunFormTriangleNode tn3() {
        return this.tn3;
    }

    public void tn3_(JunFormTriangleNode junFormTriangleNode) {
        this.tn3 = junFormTriangleNode;
    }

    public JunFormTriangleNode[] triangleNodes() {
        ArrayList<JunFormTriangleNode> arrayList = new ArrayList<JunFormTriangleNode>();
        if (this.tn1() != null) {
            arrayList.add(this.tn1());
        }
        if (this.tn2() != null) {
            arrayList.add(this.tn2());
        }
        if (this.tn3() != null) {
            arrayList.add(this.tn3());
        }
        return arrayList.toArray(new JunFormTriangleNode[arrayList.size()]);
    }

    protected void setP1_(Jun2dPoint jun2dPoint) {
        super.setP1_(jun2dPoint);
        this.m3 = null;
        this.m1 = null;
    }

    protected void setP2_(Jun2dPoint jun2dPoint) {
        super.setP2_(jun2dPoint);
        this.m1 = null;
        this.m2 = null;
    }

    protected void setP3_(Jun2dPoint jun2dPoint) {
        super.setP3_(jun2dPoint);
        this.m2 = null;
        this.m3 = null;
    }

    protected void setSp1_(Jun2dPoint jun2dPoint) {
        this.sp1 = jun2dPoint;
    }

    protected void setSp2_(Jun2dPoint jun2dPoint) {
        this.sp2 = jun2dPoint;
    }

    protected void setSp3_(Jun2dPoint jun2dPoint) {
        this.sp3 = jun2dPoint;
    }
}

